/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;

public class NavigatorHandlerConnectionFilter
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DatabaseNavigatorTree navigatorTree = NavigatorUtils.getNavigatorTree(event);
        if (navigatorTree != null) {
            navigatorTree.setFilterShowConnected(!navigatorTree.isFilterShowConnected());
            navigatorTree.getViewer().getControl().setRedraw(false);
            try {
                navigatorTree.getViewer().refresh();
            }
            finally {
                navigatorTree.getViewer().getControl().setRedraw(true);
            }
        }
        ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.navigator.filter.connected"});
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DatabaseNavigatorTree navigatorTree = NavigatorUtils.getNavigatorTree(element.getServiceLocator());
        if (navigatorTree != null) {
            DBIcon actionIcon = navigatorTree.isFilterShowConnected() ? UIIcon.FILTER_CONNECTED : UIIcon.FILTER_ALL;
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)actionIcon));
            String actionName = navigatorTree.isFilterShowConnected() ? UINavigatorMessages.navigator_handler_connections_filter_show_connected_text : UINavigatorMessages.navigator_handler_connections_filter_show_all_text;
            element.setText(actionName);
            element.setTooltip(actionName);
        }
    }
}

