/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.DirectedEdgeStar;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;

public class Node
extends GraphComponent {
    protected Coordinate pt;
    protected DirectedEdgeStar deStar;

    public static Collection getEdgesBetween(Node node0, Node node1) {
        List edges0 = DirectedEdge.toEdges(node0.getOutEdges().getEdges());
        HashSet commonEdges = new HashSet(edges0);
        List edges1 = DirectedEdge.toEdges(node1.getOutEdges().getEdges());
        commonEdges.retainAll(edges1);
        return commonEdges;
    }

    public Node(Coordinate pt) {
        this(pt, new DirectedEdgeStar());
    }

    public Node(Coordinate pt, DirectedEdgeStar deStar) {
        this.pt = pt;
        this.deStar = deStar;
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public void addOutEdge(DirectedEdge de) {
        this.deStar.add(de);
    }

    public DirectedEdgeStar getOutEdges() {
        return this.deStar;
    }

    public int getDegree() {
        return this.deStar.getDegree();
    }

    public int getIndex(Edge edge) {
        return this.deStar.getIndex(edge);
    }

    public void remove(DirectedEdge de) {
        this.deStar.remove(de);
    }

    void remove() {
        this.pt = null;
    }

    @Override
    public boolean isRemoved() {
        return this.pt == null;
    }
}

