/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Obstacle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.Segment;

class Vertex
extends Point {
    static final int NOT_SET = 0;
    static final int INNIE = 1;
    static final int OUTIE = 2;
    List<Vertex> neighbors;
    boolean isPermanent = false;
    Vertex label;
    double cost = 0.0;
    int nearestObstacle = 0;
    double offset = 0.0;
    int type = 0;
    int count = 0;
    int totalCount = 0;
    Obstacle obs;
    List<Path> paths;
    boolean nearestObstacleChecked = false;
    Map<Path, Double> cachedCosines;
    int positionOnObstacle = -1;
    private final int origX;
    private final int origY;

    Vertex(int x, int y, Obstacle obs) {
        super(x, y);
        this.origX = x;
        this.origY = y;
        this.obs = obs;
    }

    Vertex(Point p, Obstacle obs) {
        this(p.x, p.y, obs);
    }

    void addPath(Path path, Segment start, Segment end) {
        if (this.paths == null) {
            this.paths = new ArrayList<Path>();
            this.cachedCosines = new HashMap<Path, Double>();
        }
        if (!this.paths.contains(path)) {
            this.paths.add(path);
        }
        this.cachedCosines.put(path, start.cosine(end));
    }

    Point bend(int modifier) {
        Point point = new Point(this.x, this.y);
        point.y = (this.positionOnObstacle & 1) > 0 ? (int)((double)point.y - (double)modifier * this.offset) : (int)((double)point.y + (double)modifier * this.offset);
        point.x = (this.positionOnObstacle & 0x10) > 0 ? (int)((double)point.x + (double)modifier * this.offset) : (int)((double)point.x - (double)modifier * this.offset);
        return point;
    }

    void fullReset() {
        this.totalCount = 0;
        this.type = 0;
        this.count = 0;
        this.cost = 0.0;
        this.offset = this.getSpacing();
        this.nearestObstacle = 0;
        this.label = null;
        this.nearestObstacleChecked = false;
        this.isPermanent = false;
        if (this.neighbors != null) {
            this.neighbors.clear();
        }
        if (this.cachedCosines != null) {
            this.cachedCosines.clear();
        }
        if (this.paths != null) {
            this.paths.clear();
        }
    }

    Rectangle getDeformedRectangle(int extraOffset) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if ((this.positionOnObstacle & 1) > 0) {
            rect.y = this.y - extraOffset;
            rect.height = this.origY - this.y + extraOffset;
        } else {
            rect.y = this.origY;
            rect.height = this.y - this.origY + extraOffset;
        }
        if ((this.positionOnObstacle & 0x10) > 0) {
            rect.x = this.origX;
            rect.width = this.x - this.origX + extraOffset;
        } else {
            rect.x = this.x - extraOffset;
            rect.width = this.origX - this.x + extraOffset;
        }
        return rect;
    }

    private int getSpacing() {
        if (this.obs == null) {
            return 0;
        }
        return this.obs.getSpacing();
    }

    void grow() {
        int modifier = this.nearestObstacle == 0 ? this.totalCount * this.getSpacing() : this.nearestObstacle / 2 - 1;
        this.y = (this.positionOnObstacle & 1) > 0 ? (this.y -= modifier) : (this.y += modifier);
        this.x = (this.positionOnObstacle & 0x10) > 0 ? (this.x += modifier) : (this.x -= modifier);
    }

    void shrink() {
        this.x = this.origX;
        this.y = this.origY;
    }

    void updateOffset() {
        if (this.nearestObstacle != 0) {
            this.offset = (this.nearestObstacle / 2 - 1) / this.totalCount;
        }
    }

    @Override
    public String toString() {
        return "V(" + this.origX + ", " + this.origY + ")";
    }
}

