/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProjectDesktop;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNResource
extends DBNNode
implements DBNStreamData,
DBNNodeWithCache,
DBNLazyNode {
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final NumberFormat numberFormat = new DecimalFormat();
    private IResource resource;
    private DBPResourceHandler handler;
    private DBNNode[] children;

    public DBNResource(DBNNode parentNode, IResource resource, DBPResourceHandler handler) {
        super(parentNode);
        this.resource = resource;
        this.handler = handler;
    }

    public DBPResourceHandler getHandler() {
        return this.handler;
    }

    public void setHandler(DBPResourceHandler handler) {
        this.handler = handler;
    }

    public int getFeatures() {
        return this.handler == null ? 0 : this.handler.getFeatures(this.resource);
    }

    public String getNodeType() {
        return this.handler == null ? this.getResourceNodeType() : this.handler.getTypeName(this.resource);
    }

    protected String getResourceNodeType() {
        return "resource";
    }

    @Property(id="name", viewable=true, order=1)
    public String getNodeDisplayName() {
        if (this.resource == null || this.handler == null) {
            return null;
        }
        return this.resource.getName();
    }

    public String getNodeDescription() {
        if (this.getOwnerProject().isVirtual()) {
            return null;
        }
        return this.handler == null || this.resource == null ? null : this.handler.getResourceDescription(this.resource);
    }

    @NotNull
    public DBPImage getNodeIcon() {
        DBPImage iconImage = this.getResourceNodeIcon();
        DBPProject project = this.getOwnerProject();
        if (!project.hasRealmPermission("project-resource-edit")) {
            iconImage = new DBIconComposite(iconImage, false, null, null, null, (DBPImage)DBIcon.OVER_LOCK);
        }
        return iconImage;
    }

    @NotNull
    protected DBPImage getResourceNodeIcon() {
        if (this.resource == null) {
            if (this.hasChildren(false)) {
                return DBIcon.TREE_FOLDER;
            }
            return DBIcon.TREE_PAGE;
        }
        DBPImage resourceImage = this.handler.getResourceIcon(this.resource);
        if (resourceImage != null) {
            return resourceImage;
        }
        return switch (this.resource.getType()) {
            case 2 -> {
                if (this.resource.isLinked()) {
                    yield DBIcon.TREE_FOLDER_LINK;
                }
                yield DBIcon.TREE_FOLDER;
            }
            case 4 -> DBIcon.PROJECT;
            default -> DBIcon.TREE_PAGE;
        };
    }

    public String getNodeTargetName() {
        Path localFile;
        IResource resource = this.getResource();
        IPath location = resource.getLocation();
        if (location != null && (localFile = location.toPath()) != null) {
            return localFile.toString();
        }
        return super.getNodeTargetName();
    }

    public boolean allowsChildren() {
        return this.resource instanceof IContainer;
    }

    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = DBNResource.readChildResourceNodes(monitor, this);
        }
        return this.children;
    }

    public DBNNode[] getCachedChildren() {
        return this.children;
    }

    public void setCachedChildren(DBNNode[] children) {
        this.children = children;
    }

    public static DBNNode[] readChildResourceNodes(DBRProgressMonitor monitor, DBNNode node) throws DBException {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        try {
            IResource contentLocation;
            if (node instanceof DBNProjectDesktop) {
                DBNProjectDesktop projectDesktop = (DBNProjectDesktop)node;
                v0 = projectDesktop.getProject().getRootResource();
            } else {
                v0 = contentLocation = (IResource)node.getAdapter(IResource.class);
            }
            if (contentLocation instanceof IContainer) {
                IContainer container = (IContainer)contentLocation;
                if (contentLocation.exists()) {
                    IResource[] members = container.members(false);
                    IResource[] iResourceArray = members = DBNResource.addImplicitMembers(node, members);
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        DBNNode newChild = NavigatorResources.makeNode(node, member);
                        if (newChild != null) {
                            result.add(newChild);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't read container's members", (Throwable)e);
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        DBNResource.sortChildren(childNodes);
        return childNodes;
    }

    static IResource[] addImplicitMembers(DBNNode node, IResource[] members) {
        IResource resource = (IResource)node.getAdapter(IResource.class);
        if (resource instanceof IProject) {
            DBPProject project = node.getOwnerProject();
            DBPWorkspace workspace = project.getWorkspace();
            if (workspace instanceof DBPWorkspaceDesktop) {
                DBPWorkspaceDesktop workspaceDesktop = (DBPWorkspaceDesktop)workspace;
                DBPResourceHandlerDescriptor[] dBPResourceHandlerDescriptorArray = workspaceDesktop.getAllResourceHandlers();
                int n = dBPResourceHandlerDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPResourceHandlerDescriptor rh = dBPResourceHandlerDescriptorArray[n2];
                    IFolder rhDefaultRoot = workspaceDesktop.getResourceDefaultRoot(project, rh, false);
                    if (rhDefaultRoot != null && !rhDefaultRoot.exists()) {
                        members = (IResource[])ArrayUtils.add(IResource.class, (Object[])members, (Object)rhDefaultRoot);
                    }
                    ++n2;
                }
            }
            return members;
        }
        return members;
    }

    public boolean isManagable() {
        return true;
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.children != null) {
            this.children = null;
        }
        NavigatorResources.refreshThisResource(monitor, this);
        return this;
    }

    @Deprecated
    public String getNodeItemPath() {
        String projectPath = this.getRawNodeItemPath();
        return DBNNode.NodePathType.resource.getPrefix() + projectPath;
    }

    @NotNull
    public String getRawNodeItemPath() {
        StringBuilder pathName = new StringBuilder();
        DBNResource node = this;
        while (node instanceof DBNResource) {
            DBNResource dbnResource = node;
            if (!pathName.isEmpty()) {
                pathName.insert(0, '/');
            }
            IResource resource = dbnResource.getResource();
            pathName.insert(0, resource.getName());
            node = node.getParentNode();
        }
        return pathName.toString();
    }

    public boolean supportsRename() {
        return (this.getFeatures() & 8) != 0;
    }

    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        try {
            String ext;
            if (((String)newName).indexOf(46) == -1 && this.resource instanceof IFile && !CommonUtils.isEmpty((String)(ext = this.resource.getFileExtension()))) {
                newName = (String)newName + "." + ext;
            }
            if (!((String)newName).equals(this.resource.getName())) {
                if (this.resource.isLinked()) {
                    this.resource.move(this.resource.getFullPath().removeLastSegments(1).append((String)newName), 32, monitor.getNestedMonitor());
                } else {
                    this.resource.move(this.resource.getFullPath().removeLastSegments(1).append((String)newName), true, monitor.getNestedMonitor());
                }
            }
        }
        catch (CoreException e) {
            throw new DBException("Cannot rename resource : " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean supportsDrop(DBNNode otherNode) {
        if (!(this.resource instanceof IFolder) || (this.getFeatures() & 0x10) == 0) {
            return false;
        }
        if (otherNode == null) {
            return true;
        }
        return otherNode.getAdapter(IResource.class) != null && otherNode != this && otherNode.getParentNode() != this;
    }

    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        monitor.beginTask("Copy files", nodes.size());
        try {
            IResource iResource;
            if (!this.resource.exists() && (iResource = this.resource) instanceof IFolder) {
                IFolder folder = (IFolder)iResource;
                try {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new DBException("Error creating folder " + this.resource.getName(), (Throwable)e);
                }
            }
            for (DBNNode node : nodes) {
                IResource otherResource = (IResource)node.getAdapter(IResource.class);
                if (otherResource != null) {
                    try {
                        if (otherResource instanceof EFSNIOResource) {
                            if (DBWorkbench.isDistributed() && this.resource.getRawLocation() == null) {
                                throw new DBException("Paste is not supported for " + String.valueOf(this.resource));
                            }
                            otherResource.copy(this.resource.getRawLocation().append(otherResource.getName()), true, monitor.getNestedMonitor());
                        } else {
                            if (DBWorkbench.isDistributed() && !CommonUtils.equalObjects((Object)otherResource.getProject(), (Object)this.resource.getProject())) {
                                throw new DBException("Cross-project resource move is not supported in distributed workspaces");
                            }
                            otherResource.move(this.resource.getFullPath().append(otherResource.getName()), true, monitor.getNestedMonitor());
                        }
                        NavigatorResources.refreshFileStore(monitor, this.resource);
                        this.resource.refreshLocal(1, monitor.getNestedMonitor());
                    }
                    catch (CoreException e) {
                        throw new DBException("Can't copy " + otherResource.getName() + " to " + this.resource.getName(), (Throwable)e);
                    }
                } else {
                    throw new DBException("Can't get resource from node " + node.getName());
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean supportsPaste(@NotNull DBNNode other) {
        return false;
    }

    public void pasteNodes(@NotNull Collection<DBNNode> nodes) throws DBException {
        throw new DBException("Paste is not supported");
    }

    @NotNull
    public IResource getResource() {
        return this.resource;
    }

    protected static void sortChildren(DBNNode[] list) {
        Arrays.sort(list, NavigatorResources.COMPARATOR);
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return this.handler == null ? null : this.handler.getAssociatedDataSources(this);
    }

    public void refreshResourceState(Object source) {
        DBPResourceHandler newHandler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(this.resource);
        if (newHandler != this.handler) {
            this.handler = newHandler;
        }
        this.getModel().fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, (DBNNode)this));
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.resource == null ? "" : this.resource.getFullPath().toOSString();
    }

    @Property(order=11)
    public String getResourceLocation() {
        if (this.resource == null) {
            return null;
        }
        IPath location = this.resource.getLocation();
        return location == null ? null : location.toString();
    }

    @Property(viewable=true, order=11)
    public String getResourceSize() {
        if (this.resource instanceof IFile) {
            return numberFormat.format(ResourceUtils.getFileLength(this.resource));
        }
        return null;
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() {
        if (this.resource instanceof IFile) {
            long lastModified = ResourceUtils.getResourceLastModified(this.resource);
            return lastModified <= 0L ? "" : DATE_FORMAT.format(lastModified);
        }
        return null;
    }

    protected boolean isResourceExists() {
        return this.resource != null && this.resource.exists();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.resource != null) {
            IResource iResource;
            if (adapter.isAssignableFrom(this.resource.getClass())) {
                return adapter.cast(this.resource);
            }
            if (adapter == Path.class) {
                IPath location = this.resource.getLocation();
                return location == null ? null : (T)adapter.cast(location.toPath());
            }
            if (adapter == InputStream.class && (iResource = this.resource) instanceof IFile) {
                IFile file = (IFile)iResource;
                try {
                    return adapter.cast(file.getContents());
                }
                catch (CoreException e) {
                    log.error((Object)"Error getting file contents", (Throwable)e);
                }
            }
        }
        return (T)super.getAdapter(adapter);
    }

    public String toString() {
        return this.resource == null ? super.toString() : this.resource.toString();
    }

    public boolean supportsStreamData() {
        return this.resource instanceof IFile && this.resource.getLocation() == null;
    }

    public long getStreamSize() {
        return ResourceUtils.getFileLength(this.resource);
    }

    public InputStream openInputStream() throws DBException, IOException {
        IResource iResource = this.resource;
        if (iResource instanceof IFile) {
            IFile file = (IFile)iResource;
            try {
                return file.getContents();
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        throw new DBException("Resource '" + this.getNodeTargetName() + "' doesn't support streaming");
    }

    public boolean needsInitialization() {
        return this.children == null;
    }

    public boolean isDisposed() {
        return this.resource == null || super.isDisposed();
    }

    protected void dispose(boolean reflect) {
        if (this.children != null) {
            DBNNode[] dBNNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode child = dBNNodeArray[n2];
                DBNUtils.disposeNode((DBNNode)child, (boolean)reflect);
                ++n2;
            }
            this.children = null;
        }
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent((Object)this, DBNEvent.Action.REMOVE, (DBNNode)this));
        }
        this.resource = null;
        this.handler = null;
        super.dispose(reflect);
    }
}

