/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.lang.runtime.SwitchBootstraps;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreContentJSON;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCContentValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreJSONValueHandler
extends JDBCContentValueHandler {
    public static final PostgreJSONValueHandler INSTANCE = new PostgreJSONValueHandler();

    protected DBDContent fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        String json = resultSet.getString(index);
        return new PostgreContentJSON(session.getExecutionContext(), json);
    }

    public DBDContent getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
        PostgreDataSource dataSource = (PostgreDataSource)session.getDataSource();
        boolean isPgObject = PostgreUtils.isPgObject((DBPDataSource)dataSource, object);
        if (isPgObject) {
            object = PostgreUtils.extractPGObjectValue(object, (DBPDataSource)dataSource);
        }
        Object object2 = object;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PostgreContentJSON.class, String.class}, (Object)object2, 0)) {
            case -1 -> new PostgreContentJSON(session.getExecutionContext(), null);
            case 0 -> {
                PostgreContentJSON contentJSON = (PostgreContentJSON)((Object)object2);
                if (copy) {
                    yield contentJSON.cloneValue(session.getProgressMonitor());
                }
                yield contentJSON;
            }
            case 1 -> {
                String stringValue = (String)object2;
                yield new PostgreContentJSON(session.getExecutionContext(), stringValue);
            }
            default -> super.getValueFromObject(session, type, object, copy, validateValue);
        };
    }
}

