/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionExtraTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    public static SQLQueryCompletionExtraTextProvider INSTANCE = new SQLQueryCompletionExtraTextProvider();

    private SQLQueryCompletionExtraTextProvider() {
    }

    @Override
    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem rowsSourceAlias) {
        return (rowsSourceAlias.sourceInfo.tableOrNull != null ? " - Table alias" : " - Subquery alias") + (rowsSourceAlias.isRelated ? " (related)" : "");
    }

    @Nullable
    public static String prepareTypeNameString(@NotNull SQLQueryExprType type) {
        return type == null || type == SQLQueryExprType.UNKNOWN ? null : type.getDisplayName();
    }

    @Override
    @NotNull
    public String visitCompositeField(@NotNull SQLQueryCompletionItem.SQLCompositeFieldCompletionItem compositeField) {
        String typeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(compositeField.memberInfo.type());
        return typeName == null ? " - Composite attribute" : " : " + typeName;
    }

    @Override
    @Nullable
    public String visitSpecialCompositeField(@NotNull SQLQueryCompletionItem.SQLSpecialCompositeFieldCompletionItem compositeField) {
        String typeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(compositeField.memberInfo.type());
        return typeName == null ? " - Pseudo composite attribute" : " : " + typeName;
    }

    @Override
    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        String typeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(columnName.columnInfo.type);
        return typeName == null ? " - Column" : " : " + typeName;
    }

    @Override
    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        Object tail;
        if (tableName.isRelated || tableName.isUsed) {
            ArrayList<String> tags = new ArrayList<String>();
            if (tableName.isRelated) {
                tags.add("related");
            }
            if (tableName.isUsed) {
                tags.add("used");
            }
            tail = "(" + String.join((CharSequence)", ", tags) + ")";
        } else {
            tail = "";
        }
        return (DBUtils.isView((DBSEntity)((DBSEntity)tableName.object)) ? " - View " : " - Table ") + (String)tail;
    }

    @Override
    @Nullable
    public String visitReservedWord(@Nullable SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return null;
    }

    @Override
    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        String typeName = SQLQuerySemanticUtils.getObjectTypeName(namedObject.object);
        return CommonUtils.isEmpty((String)typeName) ? "" : " - " + typeName;
    }

    @Override
    @NotNull
    public String visitJoinCondition(@NotNull SQLQueryCompletionItem.SQLJoinConditionCompletionItem joinCondition) {
        return " - Known foreign key relation";
    }

    @Override
    @NotNull
    public String visitProcedure(@NotNull SQLQueryCompletionItem.SQLProcedureCompletionItem procedure) {
        return switch (((DBSProcedure)procedure.getObject()).getProcedureType()) {
            case DBSProcedureType.FUNCTION -> " - Function";
            case DBSProcedureType.PROCEDURE -> " - Procedure";
            default -> " - Stored routine";
        };
    }

    @Override
    @Nullable
    public String visitBuiltinFunction(@NotNull SQLQueryCompletionItem.SQLBuiltinFunctionCompletionItem function) {
        return " - Builtin function";
    }

    @Override
    @Nullable
    public String visitSpecialText(@NotNull SQLQueryCompletionItem.SQLSpecialTextCompletionItem specialText) {
        return " - Special substitution";
    }
}

