# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class PolicyVariableColumn(_serialization.Model):
    """The variable column.

    All required parameters must be populated in order to send to server.

    :ivar column_name: The name of this policy variable column. Required.
    :vartype column_name: str
    """

    _validation = {
        "column_name": {"required": True},
    }

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
    }

    def __init__(self, *, column_name: str, **kwargs: Any) -> None:
        """
        :keyword column_name: The name of this policy variable column. Required.
        :paramtype column_name: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name


class PolicyVariableValueColumnValue(_serialization.Model):
    """The name value tuple for this variable value column.

    All required parameters must be populated in order to send to server.

    :ivar column_name: Column name for the variable value. Required.
    :vartype column_name: str
    :ivar column_value: Column value for the variable value; this can be an integer, double,
     boolean, null or a string. Required.
    :vartype column_value: JSON
    """

    _validation = {
        "column_name": {"required": True},
        "column_value": {"required": True},
    }

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "column_value": {"key": "columnValue", "type": "object"},
    }

    def __init__(self, *, column_name: str, column_value: JSON, **kwargs: Any) -> None:
        """
        :keyword column_name: Column name for the variable value. Required.
        :paramtype column_name: str
        :keyword column_value: Column value for the variable value; this can be an integer, double,
         boolean, null or a string. Required.
        :paramtype column_value: JSON
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.column_value = column_value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.resource.policy.v2022_08_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.policy.v2022_08_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.resource.policy.v2022_08_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.policy.v2022_08_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Variable(_serialization.Model):
    """The variable.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.v2022_08_01_preview.models.SystemData
    :ivar id: The ID of the variable.
    :vartype id: str
    :ivar name: The name of the variable.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/variables).
    :vartype type: str
    :ivar columns: Variable column definitions. Required.
    :vartype columns:
     list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.PolicyVariableColumn]
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "columns": {"required": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "columns": {"key": "properties.columns", "type": "[PolicyVariableColumn]"},
    }

    def __init__(self, *, columns: List["_models.PolicyVariableColumn"], **kwargs: Any) -> None:
        """
        :keyword columns: Variable column definitions. Required.
        :paramtype columns:
         list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.PolicyVariableColumn]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.id = None
        self.name = None
        self.type = None
        self.columns = columns


class VariableListResult(_serialization.Model):
    """List of variables.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of variables.
    :vartype value: list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.Variable]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Variable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Variable"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of variables.
        :paramtype value: list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.Variable]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class VariableValue(_serialization.Model):
    """The variable value.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.v2022_08_01_preview.models.SystemData
    :ivar id: The ID of the variable.
    :vartype id: str
    :ivar name: The name of the variable.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/variables/values).
    :vartype type: str
    :ivar values: Variable value column value array. Required.
    :vartype values:
     list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.PolicyVariableValueColumnValue]
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "values": {"key": "properties.values", "type": "[PolicyVariableValueColumnValue]"},
    }

    def __init__(self, *, values: List["_models.PolicyVariableValueColumnValue"], **kwargs: Any) -> None:
        """
        :keyword values: Variable value column value array. Required.
        :paramtype values:
         list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.PolicyVariableValueColumnValue]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.id = None
        self.name = None
        self.type = None
        self.values = values


class VariableValueListResult(_serialization.Model):
    """List of variable values.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of variable values.
    :vartype value: list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.VariableValue]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VariableValue]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.VariableValue"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of variable values.
        :paramtype value: list[~azure.mgmt.resource.policy.v2022_08_01_preview.models.VariableValue]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None
