# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CheckNameAvailabilityParametersType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resource type. Note: This should not be set by the user, as the constant value is
    Microsoft.DataLakeStore/accounts.
    """

    MICROSOFT_DATA_LAKE_STORE_ACCOUNTS = "Microsoft.DataLakeStore/accounts"


class DataLakeStoreAccountState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the Data Lake Store account."""

    ACTIVE = "Active"
    SUSPENDED = "Suspended"


class DataLakeStoreAccountStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning status of the Data Lake Store account."""

    FAILED = "Failed"
    CREATING = "Creating"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    PATCHING = "Patching"
    SUSPENDING = "Suspending"
    RESUMING = "Resuming"
    DELETING = "Deleting"
    DELETED = "Deleted"
    UNDELETING = "Undeleting"
    CANCELED = "Canceled"


class EncryptionConfigType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of encryption configuration being used. Currently the only supported types are
    'UserManaged' and 'ServiceManaged'.
    """

    USER_MANAGED = "UserManaged"
    SERVICE_MANAGED = "ServiceManaged"


class EncryptionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of encryption provisioning for this Data Lake Store account."""

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"


class EncryptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of encryption for this Data Lake Store account."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class FirewallAllowAzureIpsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of allowing or disallowing IPs originating within Azure through the firewall.
    If the firewall is disabled, this is not enforced.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class FirewallState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the IP address firewall for this Data Lake Store account."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation."""

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class SubscriptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The subscription state."""

    REGISTERED = "Registered"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"
    UNREGISTERED = "Unregistered"
    WARNED = "Warned"


class TierType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The commitment tier to use for next month."""

    CONSUMPTION = "Consumption"
    COMMITMENT1_TB = "Commitment_1TB"
    COMMITMENT10_TB = "Commitment_10TB"
    COMMITMENT100_TB = "Commitment_100TB"
    COMMITMENT500_TB = "Commitment_500TB"
    COMMITMENT1_PB = "Commitment_1PB"
    COMMITMENT5_PB = "Commitment_5PB"


class TrustedIdProviderState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current state of the trusted identity provider feature for this Data Lake Store account."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the unit of measurement."""

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNTS_PER_SECOND = "CountsPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"
