# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: disable=too-many-lines

from knack.help_files import helps


helps['synapse'] = '''
    type: group
    short-summary: Manage Synapse
'''

helps['synapse kusto-operation'] = """
    type: group
    short-summary: Manage kusto operation with synapse
"""

helps['synapse kusto-operation list'] = """
    type: command
    short-summary: "Lists available operations for the Kusto sub-resources inside Microsoft.Synapse provider."
    examples:
      - name: KustoOperationsList
        text: |-
               az synapse kusto-operation list
"""

helps['synapse kusto pool'] = """
    type: group
    short-summary: Manage kusto pool with synapse
"""

helps['synapse kusto pool list-sku'] = """
    type: command
    short-summary: "Lists eligible SKUs for Kusto Pool resource."
    examples:
      - name: KustoPoolsListSkus
        text: |-
               az synapse kusto pool list-sku
"""

helps['synapse kusto pool'] = """
    type: group
    short-summary: Manage kusto pool with synapse
"""

helps['synapse kusto pool list'] = """
    type: command
    short-summary: "List all Kusto pools."
    examples:
      - name: List Kusto pools in a workspace
        text: |-
               az synapse kusto pool list --resource-group "kustorptest" --workspace-name "kustorptest"
"""

helps['synapse kusto pool show'] = """
    type: command
    short-summary: "Gets a Kusto pool."
    examples:
      - name: kustoPoolsGet
        text: |-
               az synapse kusto pool show --name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName"
"""

helps['synapse kusto pool delete'] = """
    type: command
    short-summary: "Deletes a Kusto pool."
    examples:
      - name: kustoPoolsDelete
        text: |-
               az synapse kusto pool delete --name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest"
"""

helps['synapse kusto pool list-follower-database'] = """
    type: command
    short-summary: "Returns a list of databases that are owned by this Kusto Pool and were followed by another Kusto \
Pool."
    examples:
      - name: KustoPoolListFollowerDatabases
        text: |-
               az synapse kusto pool list-follower-database --name "kustoclusterrptest4" --resource-group \
"kustorptest" --workspace-name "kustorptest"
"""

helps['synapse kusto pool list-language-extension'] = """
    type: command
    short-summary: "Returns a list of language extensions that can run within KQL queries."
    examples:
      - name: KustoPoolListLanguageExtensions
        text: |-
               az synapse kusto pool list-language-extension --name "kustoclusterrptest4" --resource-group \
"kustorptest" --workspace-name "kustorptest"
"""

helps['synapse kusto pool list-sku'] = """
    type: command
    short-summary: "Returns the SKUs available for the provided resource."
    examples:
      - name: KustoPoolsListResourceSkus
        text: |-
               az synapse kusto pool list-sku --name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto pool start'] = """
    type: command
    short-summary: "Starts a Kusto pool."
    examples:
      - name: kustoPoolsStop
        text: |-
               az synapse kusto pool start --name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest"
"""

helps['synapse kusto pool stop'] = """
    type: command
    short-summary: "Stops a Kusto pool."
    examples:
      - name: kustoPoolsStop
        text: |-
               az synapse kusto pool stop --name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"kustorptest"
"""

helps['synapse kusto pool wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto pool is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto pool is successfully deleted.
        text: |-
               az synapse kusto pool wait --name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --deleted
      - name: Pause executing next line of CLI script until the synapse kusto pool is successfully created.
        text: |-
               az synapse kusto pool wait --name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --created
"""

helps['synapse kusto attached-database-configuration'] = """
    type: group
    short-summary: Manage kusto pool attached database configuration with synapse
"""

helps['synapse kusto attached-database-configuration list'] = """
    type: command
    short-summary: "Returns the list of attached database configurations of the given Kusto Pool."
    examples:
      - name: KustoPoolAttachedDatabaseConfigurationsListByKustoPool
        text: |-
               az synapse kusto attached-database-configuration list --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "kustorptest"
"""

helps['synapse kusto attached-database-configuration show'] = """
    type: command
    short-summary: "Returns an attached database configuration."
    examples:
      - name: KustoPoolAttachedDatabaseConfigurationsGet
        text: |-
               az synapse kusto attached-database-configuration show --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest"
"""

helps['synapse kusto attached-database-configuration create'] = """
    type: command
    short-summary: "Create an attached database configuration."
    parameters:
      - name: --table-level-sharing-properties
        short-summary: "Table level sharing specifications"
        long-summary: |
            Usage: --table-level-sharing-properties tables-to-include=XX tables-to-exclude=XX \
external-tables-to-include=XX external-tables-to-exclude=XX materialized-views-to-include=XX \
materialized-views-to-exclude=XX

            tables-to-include: List of tables to include in the follower database
            tables-to-exclude: List of tables to exclude from the follower database
            external-tables-to-include: List of external tables to include in the follower database
            external-tables-to-exclude: List of external tables exclude from the follower database
            materialized-views-to-include: List of materialized views to include in the follower database
            materialized-views-to-exclude: List of materialized views exclude from the follower database
    examples:
      - name: KustoPoolAttachedDatabaseConfigurationsCreateOrUpdate
        text: |-
               az synapse kusto attached-database-configuration create --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --location "westus" --kusto-pool-resource-id \
"/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/\
kustorptest/KustoPools/kustoclusterrptest4" --database-name "kustodatabase" --default-principals-modification-kind \
"Union" --table-level-sharing-properties external-tables-to-exclude="ExternalTable2" external-tables-to-include="Extern\
alTable1" materialized-views-to-exclude="MaterializedViewTable2" materialized-views-to-include="MaterializedViewTable1"\
 tables-to-exclude="Table2" tables-to-include="Table1" --resource-group "kustorptest" --workspace-name "kustorptest"
"""

helps['synapse kusto attached-database-configuration update'] = """
    type: command
    short-summary: "Update an attached database configuration."
    parameters:
      - name: --table-level-sharing-properties
        short-summary: "Table level sharing specifications"
        long-summary: |
            Usage: --table-level-sharing-properties tables-to-include=XX tables-to-exclude=XX \
external-tables-to-include=XX external-tables-to-exclude=XX materialized-views-to-include=XX \
materialized-views-to-exclude=XX

            tables-to-include: List of tables to include in the follower database
            tables-to-exclude: List of tables to exclude from the follower database
            external-tables-to-include: List of external tables to include in the follower database
            external-tables-to-exclude: List of external tables exclude from the follower database
            materialized-views-to-include: List of materialized views to include in the follower database
            materialized-views-to-exclude: List of materialized views exclude from the follower database
"""

helps['synapse kusto attached-database-configuration delete'] = """
    type: command
    short-summary: "Deletes the attached database configuration with the given name."
    examples:
      - name: KustoPoolAttachedDatabaseConfigurationsDelete
        text: |-
               az synapse kusto attached-database-configuration delete --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest"
"""

helps['synapse kusto attached-database-configuration wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto \
attached-database-configuration is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto attached-database-configuration is \
successfully created.
        text: |-
               az synapse kusto attached-database-configuration wait --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest" --created
      - name: Pause executing next line of CLI script until the synapse kusto attached-database-configuration is \
successfully updated.
        text: |-
               az synapse kusto attached-database-configuration wait --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest" --updated
      - name: Pause executing next line of CLI script until the synapse kusto attached-database-configuration is \
successfully deleted.
        text: |-
               az synapse kusto attached-database-configuration wait --attached-database-configuration-name \
"attachedDatabaseConfigurations1" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "kustorptest" --deleted
"""

helps['synapse kusto database'] = """
    type: group
    short-summary: Manage kusto pool database with synapse
"""

helps['synapse kusto database list'] = """
    type: command
    short-summary: "Returns the list of databases of the given Kusto pool."
    examples:
      - name: KustoDatabasesListByKustoPool
        text: |-
               az synapse kusto database list --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database show'] = """
    type: command
    short-summary: "Returns a database."
    examples:
      - name: KustoPoolDatabasesGet
        text: |-
               az synapse kusto database show --database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database create'] = """
    type: command
    short-summary: "Create a database."
    parameters:
      - name: --read-write-database
        short-summary: "Class representing a read write database."
        long-summary: |
            Usage: --read-write-database soft-delete-period=XX hot-cache-period=XX location=XX kind=XX

            soft-delete-period: The time the data should be kept before it stops being accessible to queries in \
TimeSpan.
            hot-cache-period: The time the data should be kept in cache for fast queries in TimeSpan.
            location: Resource location.
            kind: Required. Kind of the database
    examples:
      - name: KustoPoolDatabasesCreateOrUpdate
        text: |-
               az synapse kusto database create --database-name "KustoDatabase8" --kusto-pool-name \
"kustoclusterrptest4" --read-write-database location="westus" soft-delete-period="P1D" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database update'] = """
    type: command
    short-summary: "Updates a database."
    parameters:
      - name: --read-write-database
        short-summary: "Class representing a read write database."
        long-summary: |
            Usage: --read-write-database soft-delete-period=XX hot-cache-period=XX location=XX kind=XX

            soft-delete-period: The time the data should be kept before it stops being accessible to queries in \
TimeSpan.
            hot-cache-period: The time the data should be kept in cache for fast queries in TimeSpan.
            location: Resource location.
            kind: Required. Kind of the database
    examples:
      - name: KustoPoolDatabasesUpdate
        text: |-
               az synapse kusto database update --database-name "KustoDatabase8" --kusto-pool-name \
"kustoclusterrptest4" --read-write-database soft-delete-period="P1D" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName"
"""

helps['synapse kusto database delete'] = """
    type: command
    short-summary: "Deletes the database with the given name."
    examples:
      - name: KustoPoolDatabasesDelete
        text: |-
               az synapse kusto database delete --database-name "KustoDatabase8" --kusto-pool-name \
"kustoclusterrptest4" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto database is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto database is successfully created.
        text: |-
               az synapse kusto database wait --database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName" --created
      - name: Pause executing next line of CLI script until the synapse kusto database is successfully updated.
        text: |-
               az synapse kusto database wait --database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName" --updated
      - name: Pause executing next line of CLI script until the synapse kusto database is successfully deleted.
        text: |-
               az synapse kusto database wait --database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName" --deleted
"""

helps['synapse kusto data-connection'] = """
    type: group
    short-summary: Manage kusto pool data connection with synapse
"""

helps['synapse kusto data-connection list'] = """
    type: command
    short-summary: "Returns the list of data connections of the given Kusto pool database."
    examples:
      - name: KustoPoolDataConnectionsListByDatabase
        text: |-
               az synapse kusto data-connection list --database-name "KustoDatabase8" --kusto-pool-name \
"kustoclusterrptest4" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto data-connection show'] = """
    type: command
    short-summary: "Returns a data connection."
    examples:
      - name: KustoPoolDataConnectionsGet
        text: |-
               az synapse kusto data-connection show --data-connection-name "DataConnections8" --database-name \
"KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName"
"""

helps['synapse kusto data-connection event-grid'] = """
    type: group
    short-summary: Manage kusto pool data connection with synapse sub group event-grid
"""

helps['synapse kusto data-connection event-grid create'] = """
    type: command
    short-summary: "Create a data connection."
"""

helps['synapse kusto data-connection event-hub'] = """
    type: group
    short-summary: Manage kusto pool data connection with synapse sub group event-hub
"""

helps['synapse kusto data-connection event-hub create'] = """
    type: command
    short-summary: "Create a data connection."
    examples:
      - name: KustoPoolDataConnectionsCreateOrUpdate.json
        text: |-
               az synapse kusto data-connection event-hub create --data-connection-name "DataConnections8" \
--database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --location "westus" --consumer-group \
"testConsumerGroup1" --event-hub-resource-id "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustor\
ptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto data-connection iot-hub'] = """
    type: group
    short-summary: Manage kusto pool data connection with synapse sub group iot-hub
"""

helps['synapse kusto data-connection iot-hub create'] = """
    type: command
    short-summary: "Create a data connection."
"""

helps['synapse kusto data-connection event-grid update'] = """
    type: command
    short-summary: "Updates a data connection."
"""

helps['synapse kusto data-connection event-hub update'] = """
    type: command
    short-summary: "Updates a data connection."
    examples:
      - name: KustoPoolDataConnectionsUpdate
        text: |-
               az synapse kusto data-connection event-hub update --data-connection-name "DataConnections8" \
--database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --location "westus" --consumer-group \
"testConsumerGroup1" --event-hub-resource-id "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustor\
ptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto data-connection iot-hub update'] = """
    type: command
    short-summary: "Updates a data connection."
"""

helps['synapse kusto data-connection delete'] = """
    type: command
    short-summary: "Deletes the data connection with the given name."
    examples:
      - name: KustoPoolDataConnectionsDelete
        text: |-
               az synapse kusto data-connection delete --data-connection-name "kustoeventhubconnection1" \
--database-name "KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto data-connection wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto data-connection is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto data-connection is successfully created.
        text: |-
               az synapse kusto data-connection wait --data-connection-name "DataConnections8" --database-name \
"KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --created
      - name: Pause executing next line of CLI script until the synapse kusto data-connection is successfully deleted.
        text: |-
               az synapse kusto data-connection wait --data-connection-name "DataConnections8" --database-name \
"KustoDatabase8" --kusto-pool-name "kustoclusterrptest4" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --deleted
"""

helps['synapse kusto pool-principal-assignment'] = """
    type: group
    short-summary: Manage kusto pool principal assignment with synapse
"""

helps['synapse kusto pool-principal-assignment list'] = """
    type: command
    short-summary: "Lists all Kusto pool principalAssignments."
    examples:
      - name: KustoPoolPrincipalAssignmentsList
        text: |-
               az synapse kusto pool-principal-assignment list --kusto-pool-name "kustoclusterrptest4" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto pool-principal-assignment show'] = """
    type: command
    short-summary: "Gets a Kusto pool principalAssignment."
    examples:
      - name: KustoPoolPrincipalAssignmentsGet
        text: |-
               az synapse kusto pool-principal-assignment show --kusto-pool-name "kustoclusterrptest4" \
--principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto pool-principal-assignment create'] = """
    type: command
    short-summary: "Create a Kusto pool principalAssignment."
    examples:
      - name: KustoPoolPrincipalAssignmentsCreateOrUpdate
        text: |-
               az synapse kusto pool-principal-assignment create --kusto-pool-name "kustoclusterrptest4" \
--principal-id "87654321-1234-1234-1234-123456789123" --principal-type "App" --role "AllDatabasesAdmin" --tenant-id \
"12345678-1234-1234-1234-123456789123" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto pool-principal-assignment update'] = """
    type: command
    short-summary: "Update a Kusto pool principalAssignment."
"""

helps['synapse kusto pool-principal-assignment delete'] = """
    type: command
    short-summary: "Deletes a Kusto pool principalAssignment."
    examples:
      - name: KustoPoolPrincipalAssignmentsDelete
        text: |-
               az synapse kusto pool-principal-assignment delete --kusto-pool-name "kustoclusterrptest4" \
--principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto pool-principal-assignment wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto pool-principal-assignment \
is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto pool-principal-assignment is \
successfully created.
        text: |-
               az synapse kusto pool-principal-assignment wait --kusto-pool-name "kustoclusterrptest4" \
--principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName" \
--created
      - name: Pause executing next line of CLI script until the synapse kusto pool-principal-assignment is \
successfully updated.
        text: |-
               az synapse kusto pool-principal-assignment wait --kusto-pool-name "kustoclusterrptest4" \
--principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName" \
--updated
      - name: Pause executing next line of CLI script until the synapse kusto pool-principal-assignment is \
successfully deleted.
        text: |-
               az synapse kusto pool-principal-assignment wait --kusto-pool-name "kustoclusterrptest4" \
--principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName" \
--deleted
"""

helps['synapse kusto database-principal-assignment'] = """
    type: group
    short-summary: Manage kusto pool database principal assignment with synapse
"""

helps['synapse kusto database-principal-assignment list'] = """
    type: command
    short-summary: "Lists all Kusto pool database principalAssignments."
    examples:
      - name: KustoPoolDatabasePrincipalAssignmentsList
        text: |-
               az synapse kusto database-principal-assignment list --database-name "Kustodatabase8" --kusto-pool-name \
"kustoclusterrptest4" --resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database-principal-assignment show'] = """
    type: command
    short-summary: "Gets a Kusto pool database principalAssignment."
    examples:
      - name: KustoPoolDatabasePrincipalAssignmentsGet
        text: |-
               az synapse kusto database-principal-assignment show --database-name "Kustodatabase8" --kusto-pool-name \
"kustoclusterrptest4" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName"
"""

helps['synapse kusto database-principal-assignment create'] = """
    type: command
    short-summary: "Creates a Kusto pool database principalAssignment."
    examples:
      - name: KustoPoolDatabasePrincipalAssignmentsCreateOrUpdate
        text: |-
               az synapse kusto database-principal-assignment create --database-name "Kustodatabase8" \
--kusto-pool-name "kustoclusterrptest4" --principal-id "87654321-1234-1234-1234-123456789123" --principal-type "App" \
--role "Admin" --tenant-id "12345678-1234-1234-1234-123456789123" --principal-assignment-name "kustoprincipal1" \
--resource-group "kustorptest" --workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database-principal-assignment update'] = """
    type: command
    short-summary: "Update a Kusto pool database principalAssignment."
"""

helps['synapse kusto database-principal-assignment delete'] = """
    type: command
    short-summary: "Deletes a Kusto pool principalAssignment."
    examples:
      - name: KustoPoolDatabasePrincipalAssignmentsDelete
        text: |-
               az synapse kusto database-principal-assignment delete --database-name "Kustodatabase8" \
--kusto-pool-name "kustoclusterrptest4" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" \
--workspace-name "synapseWorkspaceName"
"""

helps['synapse kusto database-principal-assignment wait'] = """
    type: command
    short-summary: Place the CLI in a waiting state until a condition of the synapse kusto \
database-principal-assignment is met.
    examples:
      - name: Pause executing next line of CLI script until the synapse kusto database-principal-assignment is \
successfully created.
        text: |-
               az synapse kusto database-principal-assignment wait --database-name "Kustodatabase8" --kusto-pool-name \
"kustoclusterrptest4" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --created
      - name: Pause executing next line of CLI script until the synapse kusto database-principal-assignment is \
successfully updated.
        text: |-
               az synapse kusto database-principal-assignment wait --database-name "Kustodatabase8" --kusto-pool-name \
"kustoclusterrptest4" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --updated
      - name: Pause executing next line of CLI script until the synapse kusto database-principal-assignment is \
successfully deleted.
        text: |-
               az synapse kusto database-principal-assignment wait --database-name "Kustodatabase8" --kusto-pool-name \
"kustoclusterrptest4" --principal-assignment-name "kustoprincipal1" --resource-group "kustorptest" --workspace-name \
"synapseWorkspaceName" --deleted
"""
