/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;

class UninstallationProgressDialogue
extends AbstractDialog {
    private static final long serialVersionUID = 6544278337930125848L;
    private static final int MS_TO_WAIT_BEFORE_SHOW = 500;
    private static final int EXTENSION_UNINSTALL_WEIGHT = 10;
    private static final int MINIMUM_TO_IMMEDIATELY_SHOW_DIALOGUE = 50;
    private JLabel statusLabel;
    private JProgressBar progressBar;
    private JLabel customLabel;
    private UninstallationProgressEvent.Type currentType;
    private String keyBaseStatusMessage = "";
    private AddOn currentAddOn;
    private boolean update;
    private boolean failedUninstallations;
    private long startTime;
    private boolean done;
    private boolean setVisibleInvoked;
    private List<AddOnUninstallListener> listeners = Collections.emptyList();
    private boolean synchronous;

    public UninstallationProgressDialogue(Window parent, Set<AddOn> addOns) {
        super(parent, true);
        this.setTitle(Constant.messages.getString("cfu.uninstallation.progress.dialogue.title"));
        this.setDefaultCloseOperation(0);
        int max = 0;
        for (AddOn addOn : addOns) {
            max += addOn.getFiles().size();
            max += addOn.getAscanrules().size();
            max += addOn.getPscanrules().size();
            max += addOn.getLoadedExtensions().size() * 10;
        }
        this.getProgressBar().setValue(0);
        this.getProgressBar().setMaximum(max);
        this.getStatusLabel().setText(" ");
        this.getCustomLabel().setText(" ");
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHonorsVisibility(false);
        JLabel messageLabel = new JLabel(Constant.messages.getString("cfu.uninstallation.progress.dialogue.uninstalling"));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(messageLabel).addComponent(this.getStatusLabel()).addComponent(this.getProgressBar(), 200, -1, -1).addComponent(this.getCustomLabel()));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(messageLabel).addComponent(this.getStatusLabel()).addComponent(this.getProgressBar()).addComponent(this.getCustomLabel()));
        this.setContentPane(panel);
        this.pack();
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
        }
        return this.statusLabel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        return this.progressBar;
    }

    private JLabel getCustomLabel() {
        if (this.customLabel == null) {
            this.customLabel = new JLabel();
        }
        return this.customLabel;
    }

    private void incrementProgress(int amount) {
        int currentValue = this.getProgressBar().getValue() + amount;
        this.getProgressBar().setValue(currentValue);
    }

    private void setCurrentAddOn(AddOn addOn) {
        this.currentAddOn = addOn;
        this.getStatusLabel().setText(Constant.messages.getString("cfu.uninstallation.progress.dialogue.currentAddOn", addOn.getName(), addOn.getVersion()));
    }

    private void setCustomMessage(String message) {
        this.getCustomLabel().setText(message);
    }

    public void addAddOnUninstallListener(AddOnUninstallListener listener) {
        if (this.listeners.isEmpty()) {
            this.listeners = new ArrayList<AddOnUninstallListener>(1);
        }
        this.listeners.add(listener);
    }

    public void bind(SwingWorker<?, UninstallationProgressEvent> worker) {
        worker.addPropertyChangeListener(new WaitForDoneWorkerCloseListener());
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public void setVisible(boolean show) {
        if (show && !this.synchronous) {
            this.startTime = System.currentTimeMillis();
            this.done = false;
            if (50 > this.getProgressBar().getMaximum()) {
                return;
            }
        }
        super.setVisible(show);
    }

    public void update(List<UninstallationProgressEvent> events) {
        if (!(this.isVisible() || System.currentTimeMillis() - this.startTime < 500L || this.done || this.setVisibleInvoked)) {
            this.setVisibleInvoked = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!UninstallationProgressDialogue.this.done) {
                        UninstallationProgressDialogue.super.setVisible(true);
                    }
                }
            });
        }
        int totalAmount = 0;
        AddOn addOn = null;
        for (UninstallationProgressEvent event : events) {
            totalAmount += event.getAmount();
            if (UninstallationProgressEvent.Type.FINISHED_ADD_ON == event.getType()) {
                for (AddOnUninstallListener listener : this.listeners) {
                    this.failedUninstallations = !event.isUninstalled();
                    listener.addOnUninstalled(this.currentAddOn, this.update, event.isUninstalled());
                }
                continue;
            }
            if (UninstallationProgressEvent.Type.ADD_ON != event.getType()) continue;
            this.currentAddOn = addOn = event.getAddOn();
            this.update = event.isUpdate();
            for (AddOnUninstallListener listener : this.listeners) {
                listener.uninstallingAddOn(addOn, this.update);
            }
        }
        UninstallationProgressEvent last = events.get(events.size() - 1);
        if (addOn != null) {
            this.setCurrentAddOn(addOn);
        }
        if (totalAmount != 0) {
            this.incrementProgress(totalAmount);
        }
        if (this.currentType != last.getType()) {
            String keyMessage = switch (last.getType()) {
                case UninstallationProgressEvent.Type.FILE -> "cfu.uninstallation.progress.dialogue.uninstallingFile";
                case UninstallationProgressEvent.Type.ACTIVE_RULE -> "cfu.uninstallation.progress.dialogue.uninstallingActiveScanner";
                case UninstallationProgressEvent.Type.PASSIVE_RULE -> "cfu.uninstallation.progress.dialogue.uninstallingPassiveScanner";
                case UninstallationProgressEvent.Type.EXTENSION -> "cfu.uninstallation.progress.dialogue.uninstallingExtension";
                default -> "";
            };
            this.currentType = last.getType();
            this.keyBaseStatusMessage = keyMessage;
        }
        if (this.keyBaseStatusMessage.isEmpty()) {
            this.setCustomMessage("");
        } else {
            this.setCustomMessage(Constant.messages.getString(this.keyBaseStatusMessage, last.getValue(), last.getMax()));
        }
    }

    private class WaitForDoneWorkerCloseListener
    implements PropertyChangeListener {
        private WaitForDoneWorkerCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                UninstallationProgressDialogue.this.setVisible(false);
                UninstallationProgressDialogue.this.dispose();
                UninstallationProgressDialogue.this.done = true;
                if (UninstallationProgressDialogue.this.failedUninstallations) {
                    View.getSingleton().showWarningDialog(UninstallationProgressDialogue.this.getOwner(), Constant.messages.getString("cfu.uninstall.failed"));
                }
            }
        }
    }

    static final class UninstallationProgressEvent {
        private final AddOn addOn;
        private final boolean update;
        private final boolean uninstalled;
        private final Type type;
        private final int amount;
        private final int value;
        private final int max;

        public UninstallationProgressEvent(AddOn addOn, boolean update) {
            this.addOn = addOn;
            this.update = update;
            this.uninstalled = false;
            this.amount = 0;
            this.type = Type.ADD_ON;
            this.value = 0;
            this.max = 0;
        }

        public UninstallationProgressEvent(Type type, int value, int max) {
            this.addOn = null;
            this.update = false;
            this.uninstalled = false;
            this.type = type;
            this.amount = type == Type.EXTENSION ? 10 : 1;
            this.value = value;
            this.max = max;
        }

        public UninstallationProgressEvent(boolean uninstalled) {
            this.uninstalled = uninstalled;
            this.type = Type.FINISHED_ADD_ON;
            this.addOn = null;
            this.update = false;
            this.amount = 0;
            this.value = 0;
            this.max = 0;
        }

        public AddOn getAddOn() {
            return this.addOn;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isUninstalled() {
            return this.uninstalled;
        }

        public int getAmount() {
            return this.amount;
        }

        private Type getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }

        public int getMax() {
            return this.max;
        }

        private static enum Type {
            ADD_ON,
            FILE,
            ACTIVE_RULE,
            PASSIVE_RULE,
            EXTENSION,
            FINISHED_ADD_ON;

        }
    }

    public static interface AddOnUninstallListener {
        public void uninstallingAddOn(AddOn var1, boolean var2);

        public void addOnUninstalled(AddOn var1, boolean var2, boolean var3);
    }

    public static abstract class UninstallationProgressHandler
    implements AddOnUninstallationProgressCallback {
        private UninstallationProgressEvent.Type type = null;
        private int currentValue = 0;
        private int currentMax = 0;

        protected abstract void publishEvent(UninstallationProgressEvent var1);

        @Override
        public void uninstallingAddOn(AddOn addOn, boolean update) {
            this.publishEvent(new UninstallationProgressEvent(addOn, update));
        }

        @Override
        public void activeScanRulesWillBeRemoved(int numberOfRules) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.ACTIVE_RULE, numberOfRules);
        }

        private void resetTypeAndValues(UninstallationProgressEvent.Type type, int max) {
            this.type = type;
            this.currentValue = 0;
            this.currentMax = max;
            this.publishEvent(new UninstallationProgressEvent(type, this.currentValue, this.currentMax));
        }

        @Override
        public void activeScanRuleRemoved(String name) {
            this.publish();
        }

        private void publish() {
            ++this.currentValue;
            this.publishEvent(new UninstallationProgressEvent(this.type, this.currentValue, this.currentMax));
        }

        @Override
        public void passiveScanRulesWillBeRemoved(int numberOfRules) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.PASSIVE_RULE, numberOfRules);
        }

        @Override
        public void passiveScanRuleRemoved(String name) {
            this.publish();
        }

        @Override
        public void filesWillBeRemoved(int numberOfFiles) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.FILE, numberOfFiles);
        }

        @Override
        public void fileRemoved() {
            this.publish();
        }

        @Override
        public void extensionsWillBeRemoved(int numberOfExtensions) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.EXTENSION, numberOfExtensions);
        }

        @Override
        public void extensionRemoved(String name) {
            this.publish();
        }

        @Override
        public void addOnUninstalled(boolean uninstalled) {
            this.publishEvent(new UninstallationProgressEvent(uninstalled));
        }
    }
}

