/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.graalvm.visualvm.lib.ui.components.AnimatedContainer;

public class Animator
implements ActionListener {
    private static final int STEPS = 5;
    private static final int DURATION = 100;
    AnimatedContainer cont1;
    AnimatedContainer cont2;
    Timer timer;
    private int stepsCounter;

    public Animator(AnimatedContainer cont1, AnimatedContainer cont2) {
        this.cont1 = cont1;
        this.cont2 = cont2;
        this.timer = new Timer(20, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAnimationStep();
    }

    public void startAnimation() {
        this.stepsCounter = 0;
        this.timer.addActionListener(this);
        this.timer.start();
    }

    private void performAnimationStep() {
        int percIncrement = 20;
        ++this.stepsCounter;
        if (this.stepsCounter == 5) {
            this.cont1.setFinishState();
            if (this.cont2 != null) {
                this.cont2.setFinishState();
            }
            this.cont1.revalidate();
            if (this.cont2 != null) {
                this.cont2.revalidate();
            }
            this.timer.stop();
            this.timer.removeActionListener(this);
        } else {
            this.cont1.setState(this.stepsCounter * percIncrement);
            if (this.cont2 != null) {
                this.cont2.setState(this.stepsCounter * percIncrement);
            }
            this.cont1.revalidate();
            if (this.cont2 != null) {
                this.cont2.revalidate();
            }
        }
    }
}

