/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.SplitSubModel;

final class EditorSplitSubModel
extends SplitSubModel {
    private final EditorNode editorNode;

    public EditorSplitSubModel(Model model, SplitSubModel splitSubModel) {
        super(model);
        this.editorNode = new EditorNode(splitSubModel);
        this.addNodeToTree(this.editorNode, new SplitConstraint[0]);
    }

    @Override
    protected boolean removeNodeFromTree(SplitSubModel.Node node) {
        if (node == this.editorNode) {
            return false;
        }
        return super.removeNodeFromTree(node);
    }

    public boolean setEditorNodeConstraints(SplitConstraint[] splitConstraintArray) {
        super.removeNodeFromTree(this.editorNode);
        return this.addNodeToTree(this.editorNode, splitConstraintArray);
    }

    public SplitConstraint[] getEditorNodeConstraints() {
        return this.editorNode.getNodeConstraints();
    }

    public SplitSubModel getEditorArea() {
        return this.editorNode.getEditorArea();
    }

    @Override
    public boolean setSplitWeights(ModelElement[] modelElementArray, double[] dArray) {
        if (super.setSplitWeights(modelElementArray, dArray)) {
            return true;
        }
        return this.getEditorArea().setSplitWeights(modelElementArray, dArray);
    }

    @Override
    protected boolean addNodeToTreeAroundEditor(SplitSubModel.Node node, String string) {
        double d = 0.25;
        EditorNode editorNode = this.editorNode;
        if (editorNode == this.root) {
            int n = string == "top" || string == "left" ? 0 : -1;
            int n2 = n == 0 ? -1 : 0;
            int n3 = string == "top" || string == "bottom" ? 0 : 1;
            SplitSubModel.SplitNode splitNode = new SplitSubModel.SplitNode(n3);
            splitNode.setChildAt(n, d, node);
            splitNode.setChildAt(n2, 1.0 - d, editorNode);
            this.root = splitNode;
        } else {
            int n;
            SplitSubModel.SplitNode splitNode = editorNode.getParent();
            if (splitNode == null) {
                return false;
            }
            int n4 = splitNode.getChildIndex(editorNode);
            double d2 = splitNode.getChildSplitWeight(editorNode);
            int n5 = n = string == "top" || string == "bottom" ? 0 : 1;
            if (n == splitNode.getOrientation()) {
                if (string == "bottom" || string == "right") {
                    ++n4;
                }
                splitNode.setChildAt(n4, d, node);
            } else {
                SplitSubModel.SplitNode splitNode2 = new SplitSubModel.SplitNode(n);
                splitNode.removeChild(editorNode);
                int n6 = string == "top" || string == "left" ? 0 : -1;
                int n7 = n6 == 0 ? -1 : 0;
                splitNode2.setChildAt(n6, d, node);
                splitNode2.setChildAt(n7, 1.0 - d, editorNode);
                splitNode.setChildAt(n4, d2, splitNode2);
            }
        }
        return true;
    }

    static class EditorNode
    extends SplitSubModel.Node {
        private final SplitSubModel editorArea;

        public EditorNode(SplitSubModel splitSubModel) {
            this.editorArea = splitSubModel;
        }

        @Override
        public boolean isVisibleInSplit() {
            return true;
        }

        public SplitSubModel getEditorArea() {
            return this.editorArea;
        }

        @Override
        public double getResizeWeight() {
            return 1.0;
        }

        @Override
        public ModeStructureSnapshot.ElementSnapshot createSnapshot() {
            return new ModeStructureSnapshot.EditorSnapshot(this, null, this.editorArea.createSplitSnapshot(), this.getResizeWeight());
        }
    }
}

