/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.MultiRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

public class StackFrameNodeRenderer
extends MultiRenderer
implements HeapViewerRenderer {
    private final LabelRenderer atRenderer = new LabelRenderer(){

        public String toString() {
            return this.getText() + " ";
        }
    };
    private final JavaNameRenderer methodRenderer;
    private final ProfilerRenderer[] renderers;

    public StackFrameNodeRenderer() {
        this.atRenderer.setText("at");
        this.atRenderer.setMargin(3, 3, 3, 0);
        this.methodRenderer = new JavaNameRenderer();
        this.renderers = new ProfilerRenderer[]{this.atRenderer, this.methodRenderer};
    }

    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    public void setValue(Object value, int row) {
        this.methodRenderer.setValue(value, row);
    }

    @Override
    public String getShortName() {
        String name = this.methodRenderer.toString();
        int nameIdx = name.indexOf(40);
        if (nameIdx == -1) {
            return this.atRenderer + " " + name;
        }
        String method = name.substring(0, nameIdx);
        int dotIdx = method.lastIndexOf(46);
        if (dotIdx == -1) {
            return this.atRenderer + " " + name;
        }
        String cls = method.substring(0, dotIdx);
        dotIdx = cls.lastIndexOf(46);
        return this.atRenderer + " " + method.substring(dotIdx + 1) + name.substring(nameIdx);
    }
}

