/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.jfr.model.JFRMethod;
import org.graalvm.visualvm.jfr.model.JFRStackFrame;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;

final class JFRThreadInfoSupport {
    static final String THREAD_ID = "tid";
    static final String THREAD_STACK = "stack";
    private final Map<StackTraceElement, StackTraceElement> cache = new HashMap<StackTraceElement, StackTraceElement>();

    JFRThreadInfoSupport() {
    }

    Map<String, Object> getThreadInfo(JFRThread thread, JFRStackTrace stack, String state) {
        return this.getThreadInfo(thread, stack, JFRThreadInfoSupport.state(state));
    }

    Map<String, Object> getThreadInfo(JFRThread thread, JFRStackTrace stack, Thread.State state) {
        HashMap<String, Object> threadInfo = new HashMap<String, Object>();
        Long id = thread.getId();
        threadInfo.put(THREAD_ID, id);
        if (stack != null) {
            threadInfo.put(THREAD_STACK, this.stackTrace(stack));
            threadInfo.put("name", thread.getName());
            threadInfo.put("state", (Object)state);
        }
        return threadInfo;
    }

    private StackTraceElement[] stackTrace(JFRStackTrace stack) {
        List<JFRStackFrame> frames = stack.getFrames();
        StackTraceElement[] elements = new StackTraceElement[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            elements[i] = this.stackTraceElement(frames.get(i));
        }
        return elements;
    }

    private StackTraceElement stackTraceElement(JFRStackFrame frame) {
        String methodName;
        JFRMethod method = frame.getMethod();
        String className = method == null ? null : method.getType().getName();
        String string = methodName = method == null ? null : method.getName();
        if (className == null) {
            className = "<unknown class>";
        }
        if (methodName == null) {
            methodName = "<unknown method>";
        }
        int lineNumber = "Native".equals(frame.getType()) ? -2 : frame.getLine();
        StackTraceElement el = new StackTraceElement(className, methodName, null, lineNumber);
        return this.cache.computeIfAbsent(el, v -> el);
    }

    private static Thread.State state(String state) {
        if ("STATE_RUNNABLE".equals(state)) {
            return Thread.State.RUNNABLE;
        }
        return Thread.State.WAITING;
    }
}

