/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class JFRParameters {
    private static final Logger LOGGER = Logger.getLogger(JFRParameters.class.getName());
    private static final String FILE = "settings-file";
    static final String NAME = "name";
    static final String SETTINGS = "settings";
    private final Map<String, String> parameters;

    private JFRParameters(String parametersS) {
        if (parametersS == null || parametersS.isEmpty()) {
            this.parameters = null;
        } else {
            this.parameters = new HashMap<String, String>();
            JFRParameters.parseParameters(parametersS, this.parameters);
        }
    }

    static JFRParameters parse(String parameters) {
        return new JFRParameters(parameters);
    }

    String get(String key) {
        return this.parameters == null ? null : this.parameters.get(key);
    }

    public String toString() {
        return this.parameters == null ? "[no parameters]" : this.parameters.toString();
    }

    private static void parseParameters(String parametersS, Map<String, String> parameters) {
        if (parametersS.startsWith("settings-file=")) {
            JFRParameters.parseParametersFile(JFRParameters.decode(parametersS.substring(FILE.length() + 1)), parameters);
        } else {
            for (String parameter : parametersS.split(",")) {
                int idx = parameter.indexOf("name=");
                if (idx == 0) {
                    parameters.put(NAME, JFRParameters.decode(parameter.substring(NAME.length() + 1)));
                }
                if ((idx = parameter.indexOf("settings=")) != 0) continue;
                parameters.put(SETTINGS, JFRParameters.decode(parameter.substring(SETTINGS.length() + 1)));
            }
        }
    }

    private static void parseParametersFile(String file, Map<String, String> parameters) {
        Properties properties = JFRParameters.loadProperties(file);
        String prop = properties.getProperty(NAME);
        if (prop != null) {
            parameters.put(NAME, JFRParameters.decode(prop));
        }
        if ((prop = properties.getProperty(SETTINGS)) != null) {
            parameters.put(SETTINGS, JFRParameters.decode(prop));
        }
    }

    protected static Properties loadProperties(String file) {
        Properties properties = new Properties();
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            properties.load(isr);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read JFR parameters", e);
        }
        return properties;
    }

    private static String decode(String value) {
        value = value.replace("%27", "'");
        value = value.replace("%22", "\"");
        value = value.replace("%20", " ");
        value = value.replace("%2C", ",");
        return value;
    }
}

