/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.lang.reflect.Method;
import javax.swing.UIManager;
import org.graalvm.visualvm.lib.charts.swing.LongRect;

public final class Utils {
    private static boolean FORCE_SPEED = Boolean.getBoolean("graphs.forceSpeed");
    private static boolean forceSpeed = FORCE_SPEED || !Utils.isLocalDisplay();
    public static final int VALUE_OUT_OF_RANGE_NEG = Integer.MIN_VALUE;
    public static final int VALUE_OUT_OF_RANGE_POS = Integer.MAX_VALUE;

    public static boolean forceSpeed() {
        return forceSpeed;
    }

    public static Color checkedColor(Color color) {
        if (color == null) {
            return null;
        }
        if (!forceSpeed || color.getAlpha() == 255) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static RenderingHints checkedRenderingHints(RenderingHints rHints) {
        if (!forceSpeed) {
            return rHints;
        }
        RenderingHints hints = (RenderingHints)rHints.clone();
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return hints;
    }

    public static float getStrokeWidth(Stroke stroke) {
        if (stroke == null) {
            return 0.0f;
        }
        if (!(stroke instanceof BasicStroke)) {
            return 1.0f;
        }
        return ((BasicStroke)stroke).getLineWidth();
    }

    public static Color getSystemSelection() {
        Color sel = UIManager.getColor("List.selectionBackground");
        if (sel == null) {
            sel = UIManager.getColor("nimbusSelectionBackground");
        }
        if (sel == null) {
            sel = new Color(0, 0, 200);
        }
        return sel;
    }

    private static boolean isLocalDisplay() {
        try {
            Class<?> x11Class = Class.forName("sun.swing.SwingUtilities2");
            Method isDisplayLocalMethod = x11Class.getMethod("isLocalDisplay", new Class[0]);
            return (Boolean)isDisplayLocalMethod.invoke(null, (Object[])null);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static final int checkedInt(double value) {
        if (value < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (value > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static final Rectangle checkedRectangle(LongRect rect) {
        return new Rectangle(Utils.checkedInt(rect.x), Utils.checkedInt(rect.y), Utils.checkedInt(rect.width), Utils.checkedInt(rect.height));
    }
}

