/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu.marking;

import java.util.ArrayDeque;
import java.util.Deque;
import org.graalvm.visualvm.lib.jfluid.global.TransactionalSupport;
import org.graalvm.visualvm.lib.jfluid.marker.Mark;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNodeProcessor;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.marking.MarkingEngine;

public class MarkAwareNodeProcessorPlugin
extends RuntimeCCTNodeProcessor.PluginAdapter
implements MarkingEngine.StateObserver {
    volatile boolean resetFlag = false;
    private Mark parentMark = null;
    private Deque<Mark> markStack = new ArrayDeque<Mark>();
    private final TransactionalSupport transaction = new TransactionalSupport();

    @Override
    public void onBackout(MarkedCPUCCTNode node) {
        this.markStack.pop();
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
    }

    @Override
    public void onNode(MarkedCPUCCTNode node) {
        this.parentMark = this.markStack.isEmpty() ? null : this.markStack.peek();
        this.markStack.push(node.getMark());
    }

    @Override
    public void onStart() {
        this.transaction.beginTrans(true);
        this.parentMark = null;
        this.resetFlag = false;
    }

    @Override
    public void onStop() {
        this.markStack.clear();
        this.parentMark = null;
        this.transaction.endTrans();
    }

    public void beginTrans(boolean mutable) {
        this.transaction.beginTrans(mutable);
    }

    public void endTrans() {
        if (this.resetFlag) {
            this.markStack.clear();
            this.resetFlag = false;
        }
        this.transaction.endTrans();
    }

    public synchronized void onReset() {
        this.resetFlag = true;
        this.transaction.endTrans();
    }

    @Override
    public void stateChanged(MarkingEngine instance) {
        this.reset();
    }

    protected final Mark getCurrentMark() {
        return this.markStack.isEmpty() ? Mark.DEFAULT : this.markStack.peek();
    }

    protected final Mark getParentMark() {
        return this.parentMark != null ? this.parentMark : Mark.DEFAULT;
    }

    protected synchronized boolean isReset() {
        return this.resetFlag;
    }

    private void reset() {
        this.resetFlag = true;
    }
}

