/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public final class NbMarshalledObject
implements Serializable {
    private static final long serialVersionUID = 7842398740921434354L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] objBytes = null;
    private int hash;

    public NbMarshalledObject(Object object) throws IOException {
        if (object == null) {
            this.hash = 17;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        NbObjectOutputStream nbObjectOutputStream = new NbObjectOutputStream(byteArrayOutputStream);
        nbObjectOutputStream.writeObject(object);
        nbObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        int n = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            n = 37 * n + this.objBytes[i];
        }
        this.hash = n;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        try (NbObjectInputStream nbObjectInputStream = new NbObjectInputStream(byteArrayInputStream);){
            Object object = nbObjectInputStream.readObject();
            return object;
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NbMarshalledObject) {
            NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
            return Arrays.equals(this.objBytes, nbMarshalledObject.objBytes);
        }
        return false;
    }
}

