/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.AbsoluteOrder;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NonBlockingCoordinator
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(NonBlockingCoordinator.class);
    protected static final StringManager sm = StringManager.getManager(NonBlockingCoordinator.class);
    protected static final byte[] COORD_HEADER = new byte[]{-86, 38, -34, -29, -98, 90, 65, 63, -81, -122, -6, -110, 99, -54, 13, 63};
    protected static final byte[] COORD_REQUEST = new byte[]{104, -95, -92, -42, 114, -36, 71, -19, -79, 20, 122, 101, -1, -48, -49, 30};
    protected static final byte[] COORD_CONF = new byte[]{67, 88, 107, -86, 69, 23, 76, -70, -91, -23, -87, -25, -125, 86, 75, 20};
    protected static final byte[] COORD_ALIVE = new byte[]{79, -121, -25, -15, -59, 5, 64, 94, -77, 113, -119, -88, 52, 114, -56, -46, -18, 102, 10, 34, -127, -9, 71, 115, -70, 72, -101, 88, 72, -124, 127, 111, 74, 76, -116, 50, 111, 103, 65, 3, -77, 51, -35, 0, 119, 117, 9, -26, 119, 50, -75, -105, -102, 36, 79, 37, -68, -84, -123, 15, -22, -109, 106, -55};
    protected final long waitForCoordMsgTimeout = 15000L;
    protected volatile Membership view = null;
    protected UniqueId viewId;
    protected Membership membership = null;
    protected UniqueId suggestedviewId;
    protected volatile Membership suggestedView;
    protected volatile boolean started = false;
    protected final int startsvc = 65535;
    protected final Object electionMutex = new Object();
    protected final AtomicBoolean coordMsgReceived = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElection(boolean bl) throws ChannelException {
        Object object = this.electionMutex;
        synchronized (object) {
            Member member;
            Member member2 = this.getLocalMember(false);
            Member[] memberArray = this.membership.getMembers();
            this.fireInterceptorEvent(new CoordinationEvent(4, this, "Election initiated"));
            if (memberArray.length == 0) {
                this.viewId = new UniqueId(UUIDGenerator.randomUUID(false));
                this.view = new Membership(member2, AbsoluteOrder.comp, true);
                this.handleViewConf(this.createElectionMsg(member2, memberArray, member2), this.view);
                return;
            }
            if (this.suggestedviewId != null) {
                if (this.view != null && Arrays.diff(this.view, this.suggestedView, member2).length == 0 && Arrays.diff(this.suggestedView, this.view, member2).length == 0) {
                    this.suggestedviewId = null;
                    this.suggestedView = null;
                    this.fireInterceptorEvent(new CoordinationEvent(13, this, "Election abandoned, running election matches view"));
                } else {
                    this.fireInterceptorEvent(new CoordinationEvent(13, this, "Election abandoned, election running"));
                }
                return;
            }
            if (this.view != null && Arrays.diff(this.view, this.membership, member2).length == 0 && Arrays.diff(this.membership, this.view, member2).length == 0) {
                this.fireInterceptorEvent(new CoordinationEvent(13, this, "Election abandoned, view matches membership"));
                return;
            }
            int n = AbsoluteOrder.comp.compare(member2, memberArray[0]);
            Member member3 = member = n < 0 ? member2 : memberArray[0];
            if (member2.equals(member) || bl) {
                CoordinationMessage coordinationMessage = this.createElectionMsg(member2, memberArray, member);
                this.suggestedviewId = coordinationMessage.getId();
                this.suggestedView = new Membership(member2, AbsoluteOrder.comp, true);
                Arrays.fill(this.suggestedView, coordinationMessage.getMembers());
                this.fireInterceptorEvent(new CoordinationEvent(5, this, "Election, sending request"));
                this.sendElectionMsg(member2, memberArray[0], coordinationMessage);
            } else {
                try {
                    this.coordMsgReceived.set(false);
                    this.fireInterceptorEvent(new CoordinationEvent(9, this, "Election, waiting for request"));
                    this.electionMutex.wait(15000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                String string = this.suggestedviewId == null && !this.coordMsgReceived.get() ? (Thread.interrupted() ? "Election abandoned, waiting interrupted." : "Election abandoned, waiting timed out.") : "Election abandoned, received a message";
                this.fireInterceptorEvent(new CoordinationEvent(13, this, string));
            }
        }
    }

    private CoordinationMessage createElectionMsg(Member member, Member[] memberArray, Member member2) {
        Membership membership = new Membership(member, AbsoluteOrder.comp, true);
        Arrays.fill(membership, memberArray);
        Member[] memberArray2 = membership.getMembers();
        membership.reset();
        return new CoordinationMessage(member2, member, memberArray2, new UniqueId(UUIDGenerator.randomUUID(true)), COORD_REQUEST);
    }

    protected void sendElectionMsg(Member member, Member member2, CoordinationMessage coordinationMessage) throws ChannelException {
        this.fireInterceptorEvent(new CoordinationEvent(10, this, "Sending election message to(" + member2.getName() + ")"));
        super.sendMessage(new Member[]{member2}, this.createData(coordinationMessage, member), null);
    }

    protected void sendElectionMsgToNextInline(Member member, CoordinationMessage coordinationMessage) throws ChannelException {
        int n;
        int n2 = n = Arrays.nextIndex(member, coordinationMessage.getMembers());
        coordinationMessage.leader = coordinationMessage.getMembers()[0];
        boolean bl = false;
        while (!bl && n2 >= 0) {
            try {
                this.sendElectionMsg(member, coordinationMessage.getMembers()[n2], coordinationMessage);
                bl = true;
            }
            catch (ChannelException channelException) {
                log.warn((Object)sm.getString("nonBlockingCoordinator.electionMessage.sendfailed", coordinationMessage.getMembers()[n2]));
                n2 = Arrays.nextIndex(coordinationMessage.getMembers()[n2], coordinationMessage.getMembers());
                if (n2 != n) continue;
                throw channelException;
            }
        }
    }

    public ChannelData createData(CoordinationMessage coordinationMessage, Member member) {
        coordinationMessage.write();
        ChannelData channelData = new ChannelData(true);
        channelData.setAddress(member);
        channelData.setMessage(coordinationMessage.getBuffer());
        channelData.setOptions(2);
        channelData.setTimestamp(System.currentTimeMillis());
        return channelData;
    }

    protected boolean alive(Member member) {
        return this.memberAlive(member, 15000L);
    }

    protected boolean memberAlive(Member member, long l) {
        block9: {
            boolean bl;
            if (Arrays.equals(member.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
                return false;
            }
            Socket socket = new Socket();
            try {
                InetAddress inetAddress = InetAddress.getByAddress(member.getHost());
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, member.getPort());
                socket.connect(inetSocketAddress, (int)l);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ConnectException | SocketTimeoutException iOException) {
                    break block9;
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("nonBlockingCoordinator.memberAlive.failed"), (Throwable)exception);
                }
            }
            socket.close();
            return bl;
        }
        return false;
    }

    protected Membership mergeOnArrive(CoordinationMessage coordinationMessage) {
        Member[] memberArray;
        this.fireInterceptorEvent(new CoordinationEvent(7, this, "Pre merge"));
        Member member = this.getLocalMember(false);
        Membership membership = new Membership(member, AbsoluteOrder.comp, true);
        Arrays.fill(membership, coordinationMessage.getMembers());
        Arrays.fill(membership, this.getMembers());
        for (Member member2 : memberArray = Arrays.diff(membership, this.membership, member)) {
            if (!this.alive(member2)) {
                membership.removeMember(member2);
                continue;
            }
            this.memberAdded(member2, false);
        }
        this.fireInterceptorEvent(new CoordinationEvent(8, this, "Post merge"));
        return membership;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCoordMessage(CoordinationMessage coordinationMessage) throws ChannelException {
        Object object;
        if (!this.coordMsgReceived.get()) {
            this.coordMsgReceived.set(true);
            object = this.electionMutex;
            synchronized (object) {
                this.electionMutex.notifyAll();
            }
        }
        object = this.mergeOnArrive(coordinationMessage);
        if (this.isViewConf(coordinationMessage)) {
            this.handleViewConf(coordinationMessage, (Membership)object);
        } else {
            this.handleToken(coordinationMessage, (Membership)object);
        }
    }

    protected void handleToken(CoordinationMessage coordinationMessage, Membership membership) throws ChannelException {
        Member member = this.getLocalMember(false);
        if (member.equals(coordinationMessage.getSource())) {
            this.handleMyToken(member, coordinationMessage, membership);
        } else {
            this.handleOtherToken(member, coordinationMessage, membership);
        }
    }

    protected void handleMyToken(Member member, CoordinationMessage coordinationMessage, Membership membership) throws ChannelException {
        if (member.equals(coordinationMessage.getLeader())) {
            if (Arrays.sameMembers(coordinationMessage.getMembers(), membership.getMembers())) {
                coordinationMessage.type = COORD_CONF;
                super.sendMessage(Arrays.remove(coordinationMessage.getMembers(), member), this.createData(coordinationMessage, member), null);
                this.handleViewConf(coordinationMessage, membership);
            } else {
                this.suggestedView = new Membership(member, AbsoluteOrder.comp, true);
                this.suggestedviewId = coordinationMessage.getId();
                Arrays.fill(this.suggestedView, membership.getMembers());
                coordinationMessage.view = membership.getMembers();
                this.sendElectionMsgToNextInline(member, coordinationMessage);
            }
        } else {
            this.suggestedView = null;
            this.suggestedviewId = null;
            coordinationMessage.view = membership.getMembers();
            this.sendElectionMsgToNextInline(member, coordinationMessage);
        }
    }

    protected void handleOtherToken(Member member, CoordinationMessage coordinationMessage, Membership membership) throws ChannelException {
        if (!member.equals(coordinationMessage.getLeader())) {
            coordinationMessage.view = membership.getMembers();
            this.sendElectionMsgToNextInline(member, coordinationMessage);
        }
    }

    protected void handleViewConf(CoordinationMessage coordinationMessage, Membership membership) throws ChannelException {
        if (this.viewId != null && coordinationMessage.getId().equals(this.viewId)) {
            return;
        }
        this.view = new Membership(this.getLocalMember(false), AbsoluteOrder.comp, true);
        Arrays.fill(this.view, coordinationMessage.getMembers());
        this.viewId = coordinationMessage.getId();
        if (this.viewId.equals(this.suggestedviewId)) {
            this.suggestedView = null;
            this.suggestedviewId = null;
        }
        if (this.suggestedView != null && AbsoluteOrder.comp.compare(this.suggestedView.getMembers()[0], membership.getMembers()[0]) < 0) {
            this.suggestedView = null;
            this.suggestedviewId = null;
        }
        this.fireInterceptorEvent(new CoordinationEvent(12, this, "Accepted View"));
        if (this.suggestedviewId == null && this.hasHigherPriority(membership.getMembers(), this.membership.getMembers())) {
            this.startElection(false);
        }
    }

    protected boolean isViewConf(CoordinationMessage coordinationMessage) {
        return Arrays.contains(coordinationMessage.getType(), 0, COORD_CONF, 0, COORD_CONF.length);
    }

    protected boolean hasHigherPriority(Member[] memberArray, Member[] memberArray2) {
        if (memberArray2 == null || memberArray2.length == 0) {
            return false;
        }
        if (memberArray == null || memberArray.length == 0) {
            return true;
        }
        AbsoluteOrder.absoluteOrder(memberArray);
        AbsoluteOrder.absoluteOrder(memberArray2);
        return AbsoluteOrder.comp.compare(memberArray[0], memberArray2[0]) > 0;
    }

    public Member getCoordinator() {
        return this.view != null && this.view.hasMembers() ? this.view.getMembers()[0] : null;
    }

    public Member[] getView() {
        return this.view != null && this.view.hasMembers() ? this.view.getMembers() : new Member[]{};
    }

    public UniqueId getViewId() {
        return this.viewId;
    }

    protected void halt() {
    }

    protected void release() {
    }

    protected void waitForRelease() {
    }

    @Override
    public void start(int n) throws ChannelException {
        if (this.membership == null) {
            this.setupMembership();
        }
        if (this.started) {
            return;
        }
        this.fireInterceptorEvent(new CoordinationEvent(1, this, "Before start"));
        super.start(65535);
        this.started = true;
        if (this.view == null) {
            this.view = new Membership(super.getLocalMember(true), AbsoluteOrder.comp, true);
        }
        this.fireInterceptorEvent(new CoordinationEvent(1, this, "After start"));
        this.startElection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int n) throws ChannelException {
        try {
            this.halt();
            Object object = this.electionMutex;
            synchronized (object) {
                block8: {
                    if (this.started) break block8;
                    return;
                }
                this.started = false;
                this.fireInterceptorEvent(new CoordinationEvent(11, this, "Before stop"));
                super.stop(65535);
                this.view = null;
                this.viewId = null;
                this.suggestedView = null;
                this.suggestedviewId = null;
                this.membership.reset();
                this.fireInterceptorEvent(new CoordinationEvent(11, this, "After stop"));
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        this.waitForRelease();
        super.sendMessage(memberArray, channelMessage, interceptorPayload);
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (Arrays.contains(channelMessage.getMessage().getBytesDirect(), 0, COORD_ALIVE, 0, COORD_ALIVE.length)) {
            this.fireInterceptorEvent(new CoordinationEvent(6, this, "Alive Message"));
        } else if (Arrays.contains(channelMessage.getMessage().getBytesDirect(), 0, COORD_HEADER, 0, COORD_HEADER.length)) {
            try {
                CoordinationMessage coordinationMessage = new CoordinationMessage(channelMessage.getMessage());
                Member[] memberArray = coordinationMessage.getMembers();
                this.fireInterceptorEvent(new CoordinationEvent(6, this, "Coord Msg Arrived(" + Arrays.toNameString(memberArray) + ")"));
                this.processCoordMessage(coordinationMessage);
            }
            catch (ChannelException channelException) {
                log.error((Object)sm.getString("nonBlockingCoordinator.processCoordinationMessage.failed"), (Throwable)channelException);
            }
        } else {
            super.messageReceived(channelMessage);
        }
    }

    @Override
    public void memberAdded(Member member) {
        this.memberAdded(member, true);
    }

    public void memberAdded(Member member, boolean bl) {
        if (this.membership == null) {
            this.setupMembership();
        }
        if (this.membership.memberAlive(member)) {
            super.memberAdded(member);
        }
        try {
            this.fireInterceptorEvent(new CoordinationEvent(2, this, "Member add(" + member.getName() + ")"));
            if (this.started && bl) {
                this.startElection(false);
            }
        }
        catch (ChannelException channelException) {
            log.error((Object)sm.getString("nonBlockingCoordinator.memberAdded.failed"), (Throwable)channelException);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        this.membership.removeMember(member);
        super.memberDisappeared(member);
        try {
            this.fireInterceptorEvent(new CoordinationEvent(3, this, "Member remove(" + member.getName() + ")"));
            if (this.started && (this.isCoordinator() || this.isHighest())) {
                this.startElection(true);
            }
        }
        catch (ChannelException channelException) {
            log.error((Object)sm.getString("nonBlockingCoordinator.memberDisappeared.failed"), (Throwable)channelException);
        }
    }

    public boolean isHighest() {
        Member member = this.getLocalMember(false);
        if (this.membership.getMembers().length == 0) {
            return true;
        }
        return AbsoluteOrder.comp.compare(member, this.membership.getMembers()[0]) <= 0;
    }

    public boolean isCoordinator() {
        Member member = this.getCoordinator();
        return member != null && this.getLocalMember(false).equals(member);
    }

    @Override
    public void heartbeat() {
        try {
            Member member = this.getLocalMember(false);
            if (this.view != null && (Arrays.diff(this.view, this.membership, member).length != 0 || Arrays.diff(this.membership, this.view, member).length != 0) && this.isHighest()) {
                this.fireInterceptorEvent(new CoordinationEvent(4, this, sm.getString("nonBlockingCoordinator.heartbeat.inconsistency")));
                this.startElection(true);
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("nonBlockingCoordinator.heartbeat.failed"), (Throwable)exception);
        }
        finally {
            super.heartbeat();
        }
    }

    @Override
    public boolean hasMembers() {
        return this.membership.hasMembers();
    }

    @Override
    public Member[] getMembers() {
        return this.membership.getMembers();
    }

    @Override
    public Member getMember(Member member) {
        return this.membership.getMember(member);
    }

    @Override
    public Member getLocalMember(boolean bl) {
        Member member = super.getLocalMember(bl);
        if (this.view == null && member != null) {
            this.setupMembership();
        }
        return member;
    }

    protected synchronized void setupMembership() {
        if (this.membership == null) {
            this.membership = new Membership(super.getLocalMember(true), AbsoluteOrder.comp, false);
        }
    }

    @Override
    public void fireInterceptorEvent(ChannelInterceptor.InterceptorEvent interceptorEvent) {
        if (interceptorEvent instanceof CoordinationEvent) {
            if (((CoordinationEvent)interceptorEvent).type == 12) {
                log.info((Object)interceptorEvent);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)interceptorEvent);
            }
        }
    }

    public static class CoordinationEvent
    implements ChannelInterceptor.InterceptorEvent {
        public static final int EVT_START = 1;
        public static final int EVT_MBR_ADD = 2;
        public static final int EVT_MBR_DEL = 3;
        public static final int EVT_START_ELECT = 4;
        public static final int EVT_PROCESS_ELECT = 5;
        public static final int EVT_MSG_ARRIVE = 6;
        public static final int EVT_PRE_MERGE = 7;
        public static final int EVT_POST_MERGE = 8;
        public static final int EVT_WAIT_FOR_MSG = 9;
        public static final int EVT_SEND_MSG = 10;
        public static final int EVT_STOP = 11;
        public static final int EVT_CONF_RX = 12;
        public static final int EVT_ELECT_ABANDONED = 13;
        final int type;
        final ChannelInterceptor interceptor;
        final Member coord;
        final Member[] mbrs;
        final String info;
        final Membership view;
        final Membership suggestedView;

        public CoordinationEvent(int n, ChannelInterceptor channelInterceptor, String string) {
            this.type = n;
            this.interceptor = channelInterceptor;
            this.coord = ((NonBlockingCoordinator)channelInterceptor).getCoordinator();
            this.mbrs = ((NonBlockingCoordinator)channelInterceptor).membership.getMembers();
            this.info = string;
            this.view = ((NonBlockingCoordinator)channelInterceptor).view;
            this.suggestedView = ((NonBlockingCoordinator)channelInterceptor).suggestedView;
        }

        @Override
        public int getEventType() {
            return this.type;
        }

        @Override
        public String getEventTypeDesc() {
            switch (this.type) {
                case 1: {
                    return "EVT_START:" + this.info;
                }
                case 2: {
                    return "EVT_MBR_ADD:" + this.info;
                }
                case 3: {
                    return "EVT_MBR_DEL:" + this.info;
                }
                case 4: {
                    return "EVT_START_ELECT:" + this.info;
                }
                case 5: {
                    return "EVT_PROCESS_ELECT:" + this.info;
                }
                case 6: {
                    return "EVT_MSG_ARRIVE:" + this.info;
                }
                case 7: {
                    return "EVT_PRE_MERGE:" + this.info;
                }
                case 8: {
                    return "EVT_POST_MERGE:" + this.info;
                }
                case 9: {
                    return "EVT_WAIT_FOR_MSG:" + this.info;
                }
                case 10: {
                    return "EVT_SEND_MSG:" + this.info;
                }
                case 11: {
                    return "EVT_STOP:" + this.info;
                }
                case 12: {
                    return "EVT_CONF_RX:" + this.info;
                }
                case 13: {
                    return "EVT_ELECT_ABANDONED:" + this.info;
                }
            }
            return "Unknown";
        }

        @Override
        public ChannelInterceptor getInterceptor() {
            return this.interceptor;
        }

        public String toString() {
            Member member = this.interceptor.getLocalMember(false);
            return sm.getString("nonBlockingCoordinator.report", this.type, member != null ? member.getName() : "", this.coord != null ? this.coord.getName() : "", Arrays.toNameString(this.view != null ? this.view.getMembers() : null), Arrays.toNameString(this.suggestedView != null ? this.suggestedView.getMembers() : null), Arrays.toNameString(this.mbrs), this.info);
        }
    }

    public static class CoordinationMessage {
        protected final XByteBuffer buf;
        protected Member leader;
        protected Member source;
        protected Member[] view;
        protected UniqueId id;
        protected byte[] type;

        public CoordinationMessage(XByteBuffer xByteBuffer) {
            this.buf = xByteBuffer;
            this.parse();
        }

        public CoordinationMessage(Member member, Member member2, Member[] memberArray, UniqueId uniqueId, byte[] byArray) {
            this.buf = new XByteBuffer(4096, false);
            this.leader = member;
            this.source = member2;
            this.view = memberArray;
            this.id = uniqueId;
            this.type = byArray;
            this.write();
        }

        public byte[] getHeader() {
            return COORD_HEADER;
        }

        public Member getLeader() {
            if (this.leader == null) {
                this.parse();
            }
            return this.leader;
        }

        public Member getSource() {
            if (this.source == null) {
                this.parse();
            }
            return this.source;
        }

        public UniqueId getId() {
            if (this.id == null) {
                this.parse();
            }
            return this.id;
        }

        public Member[] getMembers() {
            if (this.view == null) {
                this.parse();
            }
            return this.view;
        }

        public byte[] getType() {
            if (this.type == null) {
                this.parse();
            }
            return this.type;
        }

        public XByteBuffer getBuffer() {
            return this.buf;
        }

        public void parse() {
            int n = 16;
            int n2 = XByteBuffer.toInt(this.buf.getBytesDirect(), n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf.getBytesDirect(), n += 4, byArray, 0, n2);
            this.leader = MemberImpl.getMember(byArray);
            int n3 = XByteBuffer.toInt(this.buf.getBytesDirect(), n += n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.buf.getBytesDirect(), n += 4, byArray2, 0, n3);
            this.source = MemberImpl.getMember(byArray2);
            int n4 = XByteBuffer.toInt(this.buf.getBytesDirect(), n += n3);
            n += 4;
            this.view = new Member[n4];
            for (int i = 0; i < this.view.length; ++i) {
                int n5 = XByteBuffer.toInt(this.buf.getBytesDirect(), n);
                byte[] byArray3 = new byte[n5];
                System.arraycopy(this.buf.getBytesDirect(), n += 4, byArray3, 0, n5);
                this.view[i] = MemberImpl.getMember(byArray3);
                n += n5;
            }
            this.id = new UniqueId(this.buf.getBytesDirect(), n, 16);
            this.type = new byte[16];
            System.arraycopy(this.buf.getBytesDirect(), n += 16, this.type, 0, this.type.length);
            n += 16;
        }

        public void write() {
            this.buf.reset();
            this.buf.append(COORD_HEADER, 0, COORD_HEADER.length);
            byte[] byArray = this.leader.getData(false, false);
            this.buf.append(byArray.length);
            this.buf.append(byArray, 0, byArray.length);
            byte[] byArray2 = this.source.getData(false, false);
            this.buf.append(byArray2.length);
            this.buf.append(byArray2, 0, byArray2.length);
            this.buf.append(this.view.length);
            for (Member member : this.view) {
                byte[] byArray3 = member.getData(false, false);
                this.buf.append(byArray3.length);
                this.buf.append(byArray3, 0, byArray3.length);
            }
            this.buf.append(this.id.getBytes(), 0, this.id.getBytes().length);
            this.buf.append(this.type, 0, this.type.length);
        }
    }
}

