/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.Constants;
import org.apache.tomcat.util.descriptor.web.ContextEjb;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextHandler;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomcat.util.descriptor.web.JspConfigDescriptorImpl;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroup;
import org.apache.tomcat.util.descriptor.web.JspPropertyGroupDescriptorImpl;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.MessageDestination;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.descriptor.web.MultipartDef;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.descriptor.web.SecurityRoleRef;
import org.apache.tomcat.util.descriptor.web.ServletDef;
import org.apache.tomcat.util.descriptor.web.SessionConfig;
import org.apache.tomcat.util.descriptor.web.TaglibDescriptorImpl;
import org.apache.tomcat.util.descriptor.web.XmlEncodingBase;
import org.apache.tomcat.util.digester.DocumentProperties;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.Escape;

public class WebXml
extends XmlEncodingBase
implements DocumentProperties.Charset {
    protected static final String ORDER_OTHERS = "org.apache.catalina.order.others";
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final Log log = LogFactory.getLog(WebXml.class);
    private boolean overridable = false;
    private final List<String> duplicates = new ArrayList<String>();
    private Set<String> absoluteOrdering = null;
    private final Set<String> after = new LinkedHashSet<String>();
    private final Set<String> before = new LinkedHashSet<String>();
    private String publicId = null;
    private boolean metadataComplete = false;
    private String name = null;
    private int majorVersion = 4;
    private int minorVersion = 0;
    private String displayName = null;
    private boolean distributable = false;
    private boolean denyUncoveredHttpMethods = false;
    private final Map<String, String> contextParams = new HashMap<String, String>();
    private final Map<String, FilterDef> filters = new LinkedHashMap<String, FilterDef>();
    private final Set<FilterMap> filterMaps = new LinkedHashSet<FilterMap>();
    private final Set<String> filterMappingNames = new HashSet<String>();
    private final Set<String> listeners = new LinkedHashSet<String>();
    private final Map<String, ServletDef> servlets = new HashMap<String, ServletDef>();
    private final Map<String, String> servletMappings = new HashMap<String, String>();
    private final Set<String> servletMappingNames = new HashSet<String>();
    private SessionConfig sessionConfig = new SessionConfig();
    private final Map<String, String> mimeMappings = new HashMap<String, String>();
    private boolean replaceWelcomeFiles = false;
    private boolean alwaysAddWelcomeFiles = true;
    private final Set<String> welcomeFiles = new LinkedHashSet<String>();
    private final Map<String, ErrorPage> errorPages = new HashMap<String, ErrorPage>();
    private final Map<String, String> taglibs = new HashMap<String, String>();
    private final Set<JspPropertyGroup> jspPropertyGroups = new LinkedHashSet<JspPropertyGroup>();
    private final Set<SecurityConstraint> securityConstraints = new HashSet<SecurityConstraint>();
    private LoginConfig loginConfig = null;
    private final Set<String> securityRoles = new HashSet<String>();
    private final Map<String, ContextEnvironment> envEntries = new HashMap<String, ContextEnvironment>();
    private final Map<String, ContextEjb> ejbRefs = new HashMap<String, ContextEjb>();
    private final Map<String, ContextLocalEjb> ejbLocalRefs = new HashMap<String, ContextLocalEjb>();
    private final Map<String, ContextService> serviceRefs = new HashMap<String, ContextService>();
    private final Map<String, ContextResource> resourceRefs = new HashMap<String, ContextResource>();
    private final Map<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap<String, ContextResourceEnvRef>();
    private final Map<String, MessageDestinationRef> messageDestinationRefs = new HashMap<String, MessageDestinationRef>();
    private final Map<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>();
    private final Map<String, String> localeEncodingMappings = new HashMap<String, String>();
    private final Map<String, String> postConstructMethods = new HashMap<String, String>();
    private final Map<String, String> preDestroyMethods = new HashMap<String, String>();
    private String requestCharacterEncoding;
    private String responseCharacterEncoding;
    private URL uRL = null;
    private String jarName = null;
    private boolean webappJar = true;
    private boolean delegate = false;
    private static final String INDENT2 = "  ";
    private static final String INDENT4 = "    ";
    private static final String INDENT6 = "      ";

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean bl) {
        this.overridable = bl;
    }

    public boolean isDuplicated() {
        return !this.duplicates.isEmpty();
    }

    @Deprecated
    public void setDuplicated(boolean bl) {
        if (bl) {
            this.duplicates.add("unknown");
        } else {
            this.duplicates.clear();
        }
    }

    public void addDuplicate(String string) {
        this.duplicates.add(string);
    }

    public List<String> getDuplicates() {
        return new ArrayList<String>(this.duplicates);
    }

    public void createAbsoluteOrdering() {
        if (this.absoluteOrdering == null) {
            this.absoluteOrdering = new LinkedHashSet<String>();
        }
    }

    public void addAbsoluteOrdering(String string) {
        this.createAbsoluteOrdering();
        this.absoluteOrdering.add(string);
    }

    public void addAbsoluteOrderingOthers() {
        this.createAbsoluteOrdering();
        this.absoluteOrdering.add(ORDER_OTHERS);
    }

    public Set<String> getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    public void addAfterOrdering(String string) {
        this.after.add(string);
    }

    public void addAfterOrderingOthers() {
        if (this.before.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.after.add(ORDER_OTHERS);
    }

    public Set<String> getAfterOrdering() {
        return this.after;
    }

    public void addBeforeOrdering(String string) {
        this.before.add(string);
    }

    public void addBeforeOrderingOthers() {
        if (this.after.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.before.add(ORDER_OTHERS);
    }

    public Set<String> getBeforeOrdering() {
        return this.before;
    }

    public String getVersion() {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(this.majorVersion);
        stringBuilder.append('.');
        stringBuilder.append(this.minorVersion);
        return stringBuilder.toString();
    }

    public void setVersion(String string) {
        if (string == null) {
            return;
        }
        switch (string) {
            case "2.4": {
                this.majorVersion = 2;
                this.minorVersion = 4;
                break;
            }
            case "2.5": {
                this.majorVersion = 2;
                this.minorVersion = 5;
                break;
            }
            case "3.0": {
                this.majorVersion = 3;
                this.minorVersion = 0;
                break;
            }
            case "3.1": {
                this.majorVersion = 3;
                this.minorVersion = 1;
                break;
            }
            case "4.0": {
                this.majorVersion = 4;
                this.minorVersion = 0;
                break;
            }
            default: {
                this.log.warn((Object)sm.getString("webXml.version.unknown", new Object[]{string}));
            }
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String string) {
        if (string == null) {
            return;
        }
        switch (string) {
            case "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN": {
                this.majorVersion = 2;
                this.minorVersion = 2;
                this.publicId = string;
                break;
            }
            case "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN": {
                this.majorVersion = 2;
                this.minorVersion = 3;
                this.publicId = string;
                break;
            }
            default: {
                this.log.warn((Object)sm.getString("webXml.unrecognisedPublicId", new Object[]{string}));
            }
        }
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean bl) {
        this.metadataComplete = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (ORDER_OTHERS.equalsIgnoreCase(string)) {
            this.log.warn((Object)sm.getString("webXml.reservedName", new Object[]{string}));
        } else {
            this.name = string;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean bl) {
        this.distributable = bl;
    }

    public boolean getDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }

    public void setDenyUncoveredHttpMethods(boolean bl) {
        this.denyUncoveredHttpMethods = bl;
    }

    public void addContextParam(String string, String string2) {
        this.contextParams.put(string, string2);
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public void addFilter(FilterDef filterDef) {
        if (this.filters.containsKey(filterDef.getFilterName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateFilter", new Object[]{filterDef.getFilterName()}));
        }
        this.filters.put(filterDef.getFilterName(), filterDef);
    }

    public Map<String, FilterDef> getFilters() {
        return this.filters;
    }

    public void addFilterMapping(FilterMap filterMap) {
        filterMap.setCharset(this.getCharset());
        this.filterMaps.add(filterMap);
        this.filterMappingNames.add(filterMap.getFilterName());
    }

    public Set<FilterMap> getFilterMappings() {
        return this.filterMaps;
    }

    public void addListener(String string) {
        this.listeners.add(string);
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void addServlet(ServletDef servletDef) {
        this.servlets.put(servletDef.getServletName(), servletDef);
        if (this.overridable) {
            servletDef.setOverridable(true);
        }
    }

    public Map<String, ServletDef> getServlets() {
        return this.servlets;
    }

    public void addServletMapping(String string, String string2) {
        this.addServletMappingDecoded(UDecoder.URLDecode((String)string, (Charset)this.getCharset()), string2);
    }

    public void addServletMappingDecoded(String string, String string2) {
        String string3 = this.servletMappings.put(string, string2);
        if (string3 != null) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateServletMapping", new Object[]{string3, string2, string}));
        }
        this.servletMappingNames.add(string2);
    }

    public Map<String, String> getServletMappings() {
        return this.servletMappings;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void addMimeMapping(String string, String string2) {
        this.mimeMappings.put(string, string2);
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public void setReplaceWelcomeFiles(boolean bl) {
        this.replaceWelcomeFiles = bl;
    }

    public void setAlwaysAddWelcomeFiles(boolean bl) {
        this.alwaysAddWelcomeFiles = bl;
    }

    public void addWelcomeFile(String string) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles.clear();
            this.replaceWelcomeFiles = false;
        }
        this.welcomeFiles.add(string);
    }

    public Set<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addErrorPage(ErrorPage errorPage) {
        errorPage.setCharset(this.getCharset());
        this.errorPages.put(errorPage.getName(), errorPage);
    }

    public Map<String, ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void addTaglib(String string, String string2) {
        if (this.taglibs.containsKey(string)) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateTaglibUri", new Object[]{string}));
        }
        this.taglibs.put(string, string2);
    }

    public Map<String, String> getTaglibs() {
        return this.taglibs;
    }

    public void addJspPropertyGroup(JspPropertyGroup jspPropertyGroup) {
        jspPropertyGroup.setCharset(this.getCharset());
        this.jspPropertyGroups.add(jspPropertyGroup);
    }

    public Set<JspPropertyGroup> getJspPropertyGroups() {
        return this.jspPropertyGroups;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        securityConstraint.setCharset(this.getCharset());
        this.securityConstraints.add(securityConstraint);
    }

    public Set<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        loginConfig.setCharset(this.getCharset());
        this.loginConfig = loginConfig;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void addSecurityRole(String string) {
        this.securityRoles.add(string);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void addEnvEntry(ContextEnvironment contextEnvironment) {
        if (this.envEntries.containsKey(contextEnvironment.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateEnvEntry", new Object[]{contextEnvironment.getName()}));
        }
        this.envEntries.put(contextEnvironment.getName(), contextEnvironment);
    }

    public Map<String, ContextEnvironment> getEnvEntries() {
        return this.envEntries;
    }

    public void addEjbRef(ContextEjb contextEjb) {
        this.ejbRefs.put(contextEjb.getName(), contextEjb);
    }

    public Map<String, ContextEjb> getEjbRefs() {
        return this.ejbRefs;
    }

    public void addEjbLocalRef(ContextLocalEjb contextLocalEjb) {
        this.ejbLocalRefs.put(contextLocalEjb.getName(), contextLocalEjb);
    }

    public Map<String, ContextLocalEjb> getEjbLocalRefs() {
        return this.ejbLocalRefs;
    }

    public void addServiceRef(ContextService contextService) {
        this.serviceRefs.put(contextService.getName(), contextService);
    }

    public Map<String, ContextService> getServiceRefs() {
        return this.serviceRefs;
    }

    public void addResourceRef(ContextResource contextResource) {
        if (this.resourceRefs.containsKey(contextResource.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceRef", new Object[]{contextResource.getName()}));
        }
        this.resourceRefs.put(contextResource.getName(), contextResource);
    }

    public Map<String, ContextResource> getResourceRefs() {
        return this.resourceRefs;
    }

    public void addResourceEnvRef(ContextResourceEnvRef contextResourceEnvRef) {
        if (this.resourceEnvRefs.containsKey(contextResourceEnvRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceEnvRef", new Object[]{contextResourceEnvRef.getName()}));
        }
        this.resourceEnvRefs.put(contextResourceEnvRef.getName(), contextResourceEnvRef);
    }

    public Map<String, ContextResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        if (this.messageDestinationRefs.containsKey(messageDestinationRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestinationRef", new Object[]{messageDestinationRef.getName()}));
        }
        this.messageDestinationRefs.put(messageDestinationRef.getName(), messageDestinationRef);
    }

    public Map<String, MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs;
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        if (this.messageDestinations.containsKey(messageDestination.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestination", new Object[]{messageDestination.getName()}));
        }
        this.messageDestinations.put(messageDestination.getName(), messageDestination);
    }

    public Map<String, MessageDestination> getMessageDestinations() {
        return this.messageDestinations;
    }

    public void addLocaleEncodingMapping(String string, String string2) {
        this.localeEncodingMappings.put(string, string2);
    }

    public Map<String, String> getLocaleEncodingMappings() {
        return this.localeEncodingMappings;
    }

    public void addPostConstructMethods(String string, String string2) {
        if (!this.postConstructMethods.containsKey(string)) {
            this.postConstructMethods.put(string, string2);
        }
    }

    public Map<String, String> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    public void addPreDestroyMethods(String string, String string2) {
        if (!this.preDestroyMethods.containsKey(string)) {
            this.preDestroyMethods.put(string, string2);
        }
    }

    public Map<String, String> getPreDestroyMethods() {
        return this.preDestroyMethods;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        if (this.jspPropertyGroups.isEmpty() && this.taglibs.isEmpty()) {
            return null;
        }
        ArrayList<JspPropertyGroupDescriptor> arrayList = new ArrayList<JspPropertyGroupDescriptor>(this.jspPropertyGroups.size());
        for (JspPropertyGroup object : this.jspPropertyGroups) {
            JspPropertyGroupDescriptorImpl jspPropertyGroupDescriptorImpl = new JspPropertyGroupDescriptorImpl(object);
            arrayList.add(jspPropertyGroupDescriptorImpl);
        }
        HashSet hashSet = new HashSet(this.taglibs.size());
        for (Map.Entry<String, String> entry : this.taglibs.entrySet()) {
            TaglibDescriptorImpl taglibDescriptorImpl = new TaglibDescriptorImpl(entry.getValue(), entry.getKey());
            hashSet.add(taglibDescriptorImpl);
        }
        return new JspConfigDescriptorImpl(arrayList, hashSet);
    }

    public String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String string) {
        if (string != null) {
            try {
                B2CConverter.getCharset((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(unsupportedEncodingException);
            }
        }
        this.requestCharacterEncoding = string;
    }

    public String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding;
    }

    public void setResponseCharacterEncoding(String string) {
        if (string != null) {
            try {
                B2CConverter.getCharset((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(unsupportedEncodingException);
            }
        }
        this.responseCharacterEncoding = string;
    }

    public void setURL(URL uRL) {
        this.uRL = uRL;
    }

    public URL getURL() {
        return this.uRL;
    }

    public void setJarName(String string) {
        this.jarName = string;
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setWebappJar(boolean bl) {
        this.webappJar = bl;
    }

    public boolean getWebappJar() {
        return this.webappJar;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        this.delegate = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("Name: ");
        stringBuilder.append(this.getName());
        stringBuilder.append(", URL: ");
        stringBuilder.append(this.getURL());
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toXml() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.publicId != null) {
            stringBuilder.append("<!DOCTYPE web-app PUBLIC\n");
            stringBuilder.append("  \"");
            stringBuilder.append(this.publicId);
            stringBuilder.append("\"\n");
            stringBuilder.append("  \"");
            if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(this.publicId)) {
                stringBuilder.append("http://java.sun.com/dtd/web-app_2_2.dtd");
            } else {
                stringBuilder.append("http://java.sun.com/dtd/web-app_2_3.dtd");
            }
            stringBuilder.append("\">\n");
            stringBuilder.append("<web-app>");
        } else {
            void var3_9;
            Iterator<Object> iterator = null;
            Object object2 = null;
            object = this.getVersion();
            if ("2.4".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/j2ee";
                String string = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
            } else if ("2.5".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/javaee";
                String string = "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd";
            } else if ("3.0".equals(object)) {
                iterator = "http://java.sun.com/xml/ns/javaee";
                String string = "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd";
            } else if ("3.1".equals(object)) {
                iterator = "http://xmlns.jcp.org/xml/ns/javaee";
                String string = "http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd";
            } else if ("4.0".equals(object)) {
                iterator = "http://xmlns.jcp.org/xml/ns/javaee";
                String string = "http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd";
            }
            stringBuilder.append("<web-app xmlns=\"");
            stringBuilder.append((String)((Object)iterator));
            stringBuilder.append("\"\n");
            stringBuilder.append("         xmlns:xsi=");
            stringBuilder.append("\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            stringBuilder.append("         xsi:schemaLocation=\"");
            stringBuilder.append((String)((Object)iterator));
            stringBuilder.append(' ');
            stringBuilder.append((String)var3_9);
            stringBuilder.append("\"\n");
            stringBuilder.append("         version=\"");
            stringBuilder.append(this.getVersion());
            stringBuilder.append("\"");
            if ("2.4".equals(object)) {
                stringBuilder.append(">\n\n");
            } else {
                stringBuilder.append("\n         metadata-complete=\"true\">\n\n");
            }
        }
        WebXml.appendElement(stringBuilder, INDENT2, "display-name", this.displayName);
        if (this.isDistributable()) {
            stringBuilder.append("  <distributable/>\n\n");
        }
        for (Map.Entry entry : this.contextParams.entrySet()) {
            stringBuilder.append("  <context-param>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "param-name", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "param-value", (String)entry.getValue());
            stringBuilder.append("  </context-param>\n");
        }
        stringBuilder.append('\n');
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (Map.Entry<String, FilterDef> entry : this.filters.entrySet()) {
                object = entry.getValue();
                stringBuilder.append("  <filter>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", ((FilterDef)object).getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", ((FilterDef)object).getDisplayName());
                WebXml.appendElement(stringBuilder, INDENT4, "filter-name", ((FilterDef)object).getFilterName());
                WebXml.appendElement(stringBuilder, INDENT4, "filter-class", ((FilterDef)object).getFilterClass());
                if (this.getMajorVersion() != 2) {
                    WebXml.appendElement(stringBuilder, INDENT4, "async-supported", ((FilterDef)object).getAsyncSupported());
                }
                for (Map.Entry<String, String> entry2 : ((FilterDef)object).getParameterMap().entrySet()) {
                    stringBuilder.append("    <init-param>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "param-name", entry2.getKey());
                    WebXml.appendElement(stringBuilder, INDENT6, "param-value", entry2.getValue());
                    stringBuilder.append("    </init-param>\n");
                }
                stringBuilder.append("  </filter>\n");
            }
            stringBuilder.append('\n');
            for (FilterMap filterMap : this.filterMaps) {
                stringBuilder.append("  <filter-mapping>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "filter-name", filterMap.getFilterName());
                if (filterMap.getMatchAllServletNames()) {
                    stringBuilder.append("    <servlet-name>*</servlet-name>\n");
                } else {
                    int n;
                    object = filterMap.getServletNames();
                    int n2 = ((String[])object).length;
                    boolean bl = false;
                    while (n < n2) {
                        String string = object[n];
                        WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", string);
                        ++n;
                    }
                }
                if (filterMap.getMatchAllUrlPatterns()) {
                    stringBuilder.append("    <url-pattern>*</url-pattern>\n");
                } else {
                    for (String string : filterMap.getURLPatterns()) {
                        WebXml.appendElement(stringBuilder, INDENT4, "url-pattern", this.encodeUrl(string));
                    }
                }
                if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                    for (String string : filterMap.getDispatcherNames()) {
                        if (this.getMajorVersion() == 2 && DispatcherType.ASYNC.name().equals(string)) continue;
                        WebXml.appendElement(stringBuilder, INDENT4, "dispatcher", string);
                    }
                }
                stringBuilder.append("  </filter-mapping>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (String string : this.listeners) {
                stringBuilder.append("  <listener>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "listener-class", string);
                stringBuilder.append("  </listener>\n");
            }
            stringBuilder.append('\n');
        }
        for (Map.Entry entry : this.servlets.entrySet()) {
            object = (ServletDef)entry.getValue();
            stringBuilder.append("  <servlet>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", ((ServletDef)object).getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "display-name", ((ServletDef)object).getDisplayName());
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-class", ((ServletDef)object).getServletClass());
            WebXml.appendElement(stringBuilder, INDENT4, "jsp-file", ((ServletDef)object).getJspFile());
            for (Map.Entry<String, String> entry3 : ((ServletDef)object).getParameterMap().entrySet()) {
                stringBuilder.append("    <init-param>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "param-name", entry3.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "param-value", entry3.getValue());
                stringBuilder.append("    </init-param>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "load-on-startup", ((ServletDef)object).getLoadOnStartup());
            WebXml.appendElement(stringBuilder, INDENT4, "enabled", ((ServletDef)object).getEnabled());
            if (this.getMajorVersion() != 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "async-supported", ((ServletDef)object).getAsyncSupported());
            }
            if ((this.getMajorVersion() > 2 || this.getMinorVersion() > 2) && ((ServletDef)object).getRunAs() != null) {
                stringBuilder.append("    <run-as>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "role-name", ((ServletDef)object).getRunAs());
                stringBuilder.append("    </run-as>\n");
            }
            Object object2 = ((ServletDef)object).getSecurityRoleRefs().iterator();
            while (object2.hasNext()) {
                SecurityRoleRef securityRoleRef = (SecurityRoleRef)object2.next();
                stringBuilder.append("    <security-role-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "role-name", securityRoleRef.getName());
                WebXml.appendElement(stringBuilder, INDENT6, "role-link", securityRoleRef.getLink());
                stringBuilder.append("    </security-role-ref>\n");
            }
            if (this.getMajorVersion() != 2 && (object2 = ((ServletDef)object).getMultipartDef()) != null) {
                stringBuilder.append("    <multipart-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "location", ((MultipartDef)object2).getLocation());
                WebXml.appendElement(stringBuilder, INDENT6, "max-file-size", ((MultipartDef)object2).getMaxFileSize());
                WebXml.appendElement(stringBuilder, INDENT6, "max-request-size", ((MultipartDef)object2).getMaxRequestSize());
                WebXml.appendElement(stringBuilder, INDENT6, "file-size-threshold", ((MultipartDef)object2).getFileSizeThreshold());
                stringBuilder.append("    </multipart-config>\n");
            }
            stringBuilder.append("  </servlet>\n");
        }
        stringBuilder.append('\n');
        for (Map.Entry entry : this.servletMappings.entrySet()) {
            stringBuilder.append("  <servlet-mapping>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "servlet-name", (String)entry.getValue());
            WebXml.appendElement(stringBuilder, INDENT4, "url-pattern", this.encodeUrl((String)entry.getKey()));
            stringBuilder.append("  </servlet-mapping>\n");
        }
        stringBuilder.append('\n');
        if (this.sessionConfig != null) {
            stringBuilder.append("  <session-config>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "session-timeout", this.sessionConfig.getSessionTimeout());
            if (this.majorVersion >= 3) {
                stringBuilder.append("    <cookie-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "name", this.sessionConfig.getCookieName());
                WebXml.appendElement(stringBuilder, INDENT6, "domain", this.sessionConfig.getCookieDomain());
                WebXml.appendElement(stringBuilder, INDENT6, "path", this.sessionConfig.getCookiePath());
                WebXml.appendElement(stringBuilder, INDENT6, "comment", this.sessionConfig.getCookieComment());
                WebXml.appendElement(stringBuilder, INDENT6, "http-only", this.sessionConfig.getCookieHttpOnly());
                WebXml.appendElement(stringBuilder, INDENT6, "secure", this.sessionConfig.getCookieSecure());
                WebXml.appendElement(stringBuilder, INDENT6, "max-age", this.sessionConfig.getCookieMaxAge());
                stringBuilder.append("    </cookie-config>\n");
                for (SessionTrackingMode sessionTrackingMode : this.sessionConfig.getSessionTrackingModes()) {
                    WebXml.appendElement(stringBuilder, INDENT4, "tracking-mode", sessionTrackingMode.name());
                }
            }
            stringBuilder.append("  </session-config>\n\n");
        }
        for (Map.Entry entry : this.mimeMappings.entrySet()) {
            stringBuilder.append("  <mime-mapping>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "extension", (String)entry.getKey());
            WebXml.appendElement(stringBuilder, INDENT4, "mime-type", (String)entry.getValue());
            stringBuilder.append("  </mime-mapping>\n");
        }
        stringBuilder.append('\n');
        if (!this.welcomeFiles.isEmpty()) {
            stringBuilder.append("  <welcome-file-list>\n");
            for (String string : this.welcomeFiles) {
                WebXml.appendElement(stringBuilder, INDENT4, "welcome-file", string);
            }
            stringBuilder.append("  </welcome-file-list>\n\n");
        }
        for (ErrorPage errorPage : this.errorPages.values()) {
            object = errorPage.getExceptionType();
            int n = errorPage.getErrorCode();
            if (object == null && n == 0 && this.getMajorVersion() == 2) continue;
            stringBuilder.append("  <error-page>\n");
            if (errorPage.getExceptionType() != null) {
                WebXml.appendElement(stringBuilder, INDENT4, "exception-type", (String)object);
            } else if (errorPage.getErrorCode() > 0) {
                WebXml.appendElement(stringBuilder, INDENT4, "error-code", Integer.toString(n));
            }
            WebXml.appendElement(stringBuilder, INDENT4, "location", errorPage.getLocation());
            stringBuilder.append("  </error-page>\n");
        }
        stringBuilder.append('\n');
        if (!this.taglibs.isEmpty() || !this.jspPropertyGroups.isEmpty()) {
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                stringBuilder.append("  <jsp-config>\n");
            }
            for (Map.Entry entry : this.taglibs.entrySet()) {
                stringBuilder.append("    <taglib>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "taglib-uri", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "taglib-location", (String)entry.getValue());
                stringBuilder.append("    </taglib>\n");
            }
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
                for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
                    stringBuilder.append("    <jsp-property-group>\n");
                    for (String string : jspPropertyGroup.getUrlPatterns()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "url-pattern", this.encodeUrl(string));
                    }
                    WebXml.appendElement(stringBuilder, INDENT6, "el-ignored", jspPropertyGroup.getElIgnored());
                    WebXml.appendElement(stringBuilder, INDENT6, "page-encoding", jspPropertyGroup.getPageEncoding());
                    WebXml.appendElement(stringBuilder, INDENT6, "scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                    WebXml.appendElement(stringBuilder, INDENT6, "is-xml", jspPropertyGroup.getIsXml());
                    for (String string : jspPropertyGroup.getIncludePreludes()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "include-prelude", string);
                    }
                    for (String string : jspPropertyGroup.getIncludeCodas()) {
                        WebXml.appendElement(stringBuilder, INDENT6, "include-coda", string);
                    }
                    WebXml.appendElement(stringBuilder, INDENT6, "deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntax());
                    WebXml.appendElement(stringBuilder, INDENT6, "trim-directive-whitespaces", jspPropertyGroup.getTrimWhitespace());
                    WebXml.appendElement(stringBuilder, INDENT6, "default-content-type", jspPropertyGroup.getDefaultContentType());
                    WebXml.appendElement(stringBuilder, INDENT6, "buffer", jspPropertyGroup.getBuffer());
                    WebXml.appendElement(stringBuilder, INDENT6, "error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                    stringBuilder.append("    </jsp-property-group>\n");
                }
                stringBuilder.append("  </jsp-config>\n\n");
            }
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (ContextResourceEnvRef contextResourceEnvRef : this.resourceEnvRefs.values()) {
                stringBuilder.append("  <resource-env-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextResourceEnvRef.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "resource-env-ref-name", contextResourceEnvRef.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "resource-env-ref-type", contextResourceEnvRef.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextResourceEnvRef.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextResourceEnvRef.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextResourceEnvRef.getLookupName());
                stringBuilder.append("  </resource-env-ref>\n");
            }
            stringBuilder.append('\n');
        }
        for (ContextResource contextResource : this.resourceRefs.values()) {
            stringBuilder.append("  <resource-ref>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextResource.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "res-ref-name", contextResource.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "res-type", contextResource.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "res-auth", contextResource.getAuth());
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "res-sharing-scope", contextResource.getScope());
            }
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextResource.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextResource.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextResource.getLookupName());
            stringBuilder.append("  </resource-ref>\n");
        }
        stringBuilder.append('\n');
        for (SecurityConstraint securityConstraint : this.securityConstraints) {
            stringBuilder.append("  <security-constraint>\n");
            if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", securityConstraint.getDisplayName());
            }
            for (SecurityCollection securityCollection : securityConstraint.findCollections()) {
                stringBuilder.append("    <web-resource-collection>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "web-resource-name", securityCollection.getName());
                WebXml.appendElement(stringBuilder, INDENT6, "description", securityCollection.getDescription());
                for (String string : securityCollection.findPatterns()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "url-pattern", this.encodeUrl(string));
                }
                for (String string : securityCollection.findMethods()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "http-method", string);
                }
                for (String string : securityCollection.findOmittedMethods()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "http-method-omission", string);
                }
                stringBuilder.append("    </web-resource-collection>\n");
            }
            if (securityConstraint.findAuthRoles().length > 0) {
                stringBuilder.append("    <auth-constraint>\n");
                for (String string : securityConstraint.findAuthRoles()) {
                    WebXml.appendElement(stringBuilder, INDENT6, "role-name", string);
                }
                stringBuilder.append("    </auth-constraint>\n");
            }
            if (securityConstraint.getUserConstraint() != null) {
                stringBuilder.append("    <user-data-constraint>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "transport-guarantee", securityConstraint.getUserConstraint());
                stringBuilder.append("    </user-data-constraint>\n");
            }
            stringBuilder.append("  </security-constraint>\n");
        }
        stringBuilder.append('\n');
        if (this.loginConfig != null) {
            stringBuilder.append("  <login-config>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "auth-method", this.loginConfig.getAuthMethod());
            WebXml.appendElement(stringBuilder, INDENT4, "realm-name", this.loginConfig.getRealmName());
            if (this.loginConfig.getErrorPage() != null || this.loginConfig.getLoginPage() != null) {
                stringBuilder.append("    <form-login-config>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "form-login-page", this.loginConfig.getLoginPage());
                WebXml.appendElement(stringBuilder, INDENT6, "form-error-page", this.loginConfig.getErrorPage());
                stringBuilder.append("    </form-login-config>\n");
            }
            stringBuilder.append("  </login-config>\n\n");
        }
        for (String string : this.securityRoles) {
            stringBuilder.append("  <security-role>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "role-name", string);
            stringBuilder.append("  </security-role>\n");
        }
        for (ContextEnvironment contextEnvironment : this.envEntries.values()) {
            stringBuilder.append("  <env-entry>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextEnvironment.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-name", contextEnvironment.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-type", contextEnvironment.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "env-entry-value", contextEnvironment.getValue());
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextEnvironment.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextEnvironment.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextEnvironment.getLookupName());
            stringBuilder.append("  </env-entry>\n");
        }
        stringBuilder.append('\n');
        for (ContextEjb contextEjb : this.ejbRefs.values()) {
            stringBuilder.append("  <ejb-ref>\n");
            WebXml.appendElement(stringBuilder, INDENT4, "description", contextEjb.getDescription());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-name", contextEjb.getName());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-type", contextEjb.getType());
            WebXml.appendElement(stringBuilder, INDENT4, "home", contextEjb.getHome());
            WebXml.appendElement(stringBuilder, INDENT4, "remote", contextEjb.getRemote());
            WebXml.appendElement(stringBuilder, INDENT4, "ejb-link", contextEjb.getLink());
            WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextEjb.getProperty("mappedName"));
            for (InjectionTarget injectionTarget : contextEjb.getInjectionTargets()) {
                stringBuilder.append("    <injection-target>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                stringBuilder.append("    </injection-target>\n");
            }
            WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextEjb.getLookupName());
            stringBuilder.append("  </ejb-ref>\n");
        }
        stringBuilder.append('\n');
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 2) {
            for (ContextLocalEjb contextLocalEjb : this.ejbLocalRefs.values()) {
                stringBuilder.append("  <ejb-local-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextLocalEjb.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-name", contextLocalEjb.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-ref-type", contextLocalEjb.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "local-home", contextLocalEjb.getHome());
                WebXml.appendElement(stringBuilder, INDENT4, "local", contextLocalEjb.getLocal());
                WebXml.appendElement(stringBuilder, INDENT4, "ejb-link", contextLocalEjb.getLink());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextLocalEjb.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextLocalEjb.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextLocalEjb.getLookupName());
                stringBuilder.append("  </ejb-local-ref>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
            for (ContextService contextService : this.serviceRefs.values()) {
                stringBuilder.append("  <service-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", contextService.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", contextService.getDisplayname());
                WebXml.appendElement(stringBuilder, INDENT4, "service-ref-name", contextService.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "service-interface", contextService.getInterface());
                WebXml.appendElement(stringBuilder, INDENT4, "service-ref-type", contextService.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "wsdl-file", contextService.getWsdlfile());
                WebXml.appendElement(stringBuilder, INDENT4, "jaxrpc-mapping-file", contextService.getJaxrpcmappingfile());
                object = contextService.getServiceqnameNamespaceURI();
                if (object != null) {
                    object = (String)object + ":";
                }
                object = (String)object + contextService.getServiceqnameLocalpart();
                WebXml.appendElement(stringBuilder, INDENT4, "service-qname", (String)object);
                Iterator<String> iterator = contextService.getServiceendpoints();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    stringBuilder.append("    <port-component-ref>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "service-endpoint-interface", string);
                    WebXml.appendElement(stringBuilder, INDENT6, "port-component-link", contextService.getProperty(string));
                    stringBuilder.append("    </port-component-ref>\n");
                }
                Iterator<String> iterator2 = contextService.getHandlers();
                while (iterator2.hasNext()) {
                    String string = iterator2.next();
                    stringBuilder.append("    <handler>\n");
                    ContextHandler contextHandler = contextService.getHandler(string);
                    WebXml.appendElement(stringBuilder, INDENT6, "handler-name", contextHandler.getName());
                    WebXml.appendElement(stringBuilder, INDENT6, "handler-class", contextHandler.getHandlerclass());
                    stringBuilder.append("    </handler>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", contextService.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : contextService.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", contextService.getLookupName());
                stringBuilder.append("  </service-ref>\n");
            }
            stringBuilder.append('\n');
        }
        if (!this.postConstructMethods.isEmpty()) {
            for (Map.Entry entry : this.postConstructMethods.entrySet()) {
                stringBuilder.append("  <post-construct>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-class", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-method", (String)entry.getValue());
                stringBuilder.append("  </post-construct>\n");
            }
            stringBuilder.append('\n');
        }
        if (!this.preDestroyMethods.isEmpty()) {
            for (Map.Entry entry : this.preDestroyMethods.entrySet()) {
                stringBuilder.append("  <pre-destroy>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-class", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT4, "lifecycle-callback-method", (String)entry.getValue());
                stringBuilder.append("  </pre-destroy>\n");
            }
            stringBuilder.append('\n');
        }
        if (this.getMajorVersion() > 2 || this.getMinorVersion() > 3) {
            for (MessageDestinationRef messageDestinationRef : this.messageDestinationRefs.values()) {
                stringBuilder.append("  <message-destination-ref>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", messageDestinationRef.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-ref-name", messageDestinationRef.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-type", messageDestinationRef.getType());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-usage", messageDestinationRef.getUsage());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-link", messageDestinationRef.getLink());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", messageDestinationRef.getProperty("mappedName"));
                for (InjectionTarget injectionTarget : messageDestinationRef.getInjectionTargets()) {
                    stringBuilder.append("    <injection-target>\n");
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-class", injectionTarget.getTargetClass());
                    WebXml.appendElement(stringBuilder, INDENT6, "injection-target-name", injectionTarget.getTargetName());
                    stringBuilder.append("    </injection-target>\n");
                }
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", messageDestinationRef.getLookupName());
                stringBuilder.append("  </message-destination-ref>\n");
            }
            stringBuilder.append('\n');
            for (MessageDestination messageDestination : this.messageDestinations.values()) {
                stringBuilder.append("  <message-destination>\n");
                WebXml.appendElement(stringBuilder, INDENT4, "description", messageDestination.getDescription());
                WebXml.appendElement(stringBuilder, INDENT4, "display-name", messageDestination.getDisplayName());
                WebXml.appendElement(stringBuilder, INDENT4, "message-destination-name", messageDestination.getName());
                WebXml.appendElement(stringBuilder, INDENT4, "mapped-name", messageDestination.getProperty("mappedName"));
                WebXml.appendElement(stringBuilder, INDENT4, "lookup-name", messageDestination.getLookupName());
                stringBuilder.append("  </message-destination>\n");
            }
            stringBuilder.append('\n');
        }
        if (!(this.getMajorVersion() <= 2 && this.getMinorVersion() <= 3 || this.localeEncodingMappings.isEmpty())) {
            stringBuilder.append("  <locale-encoding-mapping-list>\n");
            for (Map.Entry entry : this.localeEncodingMappings.entrySet()) {
                stringBuilder.append("    <locale-encoding-mapping>\n");
                WebXml.appendElement(stringBuilder, INDENT6, "locale", (String)entry.getKey());
                WebXml.appendElement(stringBuilder, INDENT6, "encoding", (String)entry.getValue());
                stringBuilder.append("    </locale-encoding-mapping>\n");
            }
            stringBuilder.append("  </locale-encoding-mapping-list>\n");
            stringBuilder.append("\n");
        }
        if ((this.getMajorVersion() > 3 || this.getMajorVersion() == 3 && this.getMinorVersion() > 0) && this.denyUncoveredHttpMethods) {
            stringBuilder.append("  <deny-uncovered-http-methods/>");
            stringBuilder.append("\n");
        }
        if (this.getMajorVersion() >= 4) {
            WebXml.appendElement(stringBuilder, INDENT2, "request-character-encoding", this.requestCharacterEncoding);
            WebXml.appendElement(stringBuilder, INDENT2, "response-character-encoding", this.responseCharacterEncoding);
        }
        stringBuilder.append("</web-app>");
        return stringBuilder.toString();
    }

    private String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static void appendElement(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        if (string3.isEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append('<');
            stringBuilder.append(string2);
            stringBuilder.append("/>\n");
        } else {
            stringBuilder.append(string);
            stringBuilder.append('<');
            stringBuilder.append(string2);
            stringBuilder.append('>');
            stringBuilder.append(Escape.xml((String)string3));
            stringBuilder.append("</");
            stringBuilder.append(string2);
            stringBuilder.append(">\n");
        }
    }

    private static void appendElement(StringBuilder stringBuilder, String string, String string2, Object object) {
        if (object == null) {
            return;
        }
        WebXml.appendElement(stringBuilder, string, string2, object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean merge(Set<WebXml> set) {
        WebXml webXml = new WebXml();
        for (WebXml object22 : set) {
            if (this.mergeMap(object22.getContextParams(), this.contextParams, webXml.getContextParams(), object22, "Context Parameter")) continue;
            return false;
        }
        this.contextParams.putAll(webXml.getContextParams());
        if (this.displayName == null) {
            for (WebXml webXml2 : set) {
                String string = webXml2.getDisplayName();
                if (string == null) continue;
                if (webXml.getDisplayName() == null) {
                    webXml.setDisplayName(string);
                    continue;
                }
                this.log.error((Object)sm.getString("webXml.mergeConflictDisplayName", new Object[]{webXml2.getName(), webXml2.getURL()}));
                return false;
            }
            this.displayName = webXml.getDisplayName();
        }
        if (!this.denyUncoveredHttpMethods) {
            for (WebXml webXml3 : set) {
                if (!webXml3.getDenyUncoveredHttpMethods()) continue;
                this.denyUncoveredHttpMethods = true;
                break;
            }
        }
        if (this.requestCharacterEncoding == null) {
            for (WebXml webXml4 : set) {
                if (webXml4.getRequestCharacterEncoding() == null) continue;
                this.requestCharacterEncoding = webXml4.getRequestCharacterEncoding();
            }
        }
        if (this.responseCharacterEncoding == null) {
            for (WebXml webXml5 : set) {
                if (webXml5.getResponseCharacterEncoding() == null) continue;
                this.responseCharacterEncoding = webXml5.getResponseCharacterEncoding();
            }
        }
        if (this.distributable) {
            for (WebXml webXml6 : set) {
                if (webXml6.isDistributable()) continue;
                this.distributable = false;
                break;
            }
        }
        for (WebXml webXml7 : set) {
            if (this.mergeResourceMap(webXml7.getEjbLocalRefs(), this.ejbLocalRefs, webXml.getEjbLocalRefs(), webXml7)) continue;
            return false;
        }
        this.ejbLocalRefs.putAll(webXml.getEjbLocalRefs());
        for (WebXml webXml8 : set) {
            if (this.mergeResourceMap(webXml8.getEjbRefs(), this.ejbRefs, webXml.getEjbRefs(), webXml8)) continue;
            return false;
        }
        this.ejbRefs.putAll(webXml.getEjbRefs());
        for (WebXml webXml9 : set) {
            if (this.mergeResourceMap(webXml9.getEnvEntries(), this.envEntries, webXml.getEnvEntries(), webXml9)) continue;
            return false;
        }
        this.envEntries.putAll(webXml.getEnvEntries());
        for (WebXml webXml10 : set) {
            if (this.mergeMap(webXml10.getErrorPages(), this.errorPages, webXml.getErrorPages(), webXml10, "Error Page")) continue;
            return false;
        }
        this.errorPages.putAll(webXml.getErrorPages());
        ArrayList arrayList = new ArrayList();
        for (WebXml webXml11 : set) {
            for (FilterMap filterMap : webXml11.getFilterMappings()) {
                if (this.filterMappingNames.contains(filterMap.getFilterName())) continue;
                arrayList.add(filterMap);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FilterMap filterMap = (FilterMap)iterator.next();
            this.addFilterMapping(filterMap);
        }
        for (WebXml webXml12 : set) {
            for (Map.Entry<String, FilterDef> entry : webXml12.getFilters().entrySet()) {
                if (this.filters.containsKey(entry.getKey())) {
                    WebXml.mergeFilter(entry.getValue(), this.filters.get(entry.getKey()), false);
                    continue;
                }
                if (webXml.getFilters().containsKey(entry.getKey())) {
                    if (WebXml.mergeFilter(entry.getValue(), webXml.getFilters().get(entry.getKey()), true)) continue;
                    this.log.error((Object)sm.getString("webXml.mergeConflictFilter", new Object[]{entry.getKey(), webXml12.getName(), webXml12.getURL()}));
                    return false;
                }
                webXml.getFilters().put(entry.getKey(), entry.getValue());
            }
        }
        this.filters.putAll(webXml.getFilters());
        for (WebXml webXml13 : set) {
            for (JspPropertyGroup jspPropertyGroup : webXml13.getJspPropertyGroups()) {
                this.addJspPropertyGroup(jspPropertyGroup);
            }
        }
        for (WebXml webXml14 : set) {
            for (String string : webXml14.getListeners()) {
                this.addListener(string);
            }
        }
        for (WebXml webXml15 : set) {
            if (this.mergeMap(webXml15.getLocaleEncodingMappings(), this.localeEncodingMappings, webXml.getLocaleEncodingMappings(), webXml15, "Locale Encoding Mapping")) continue;
            return false;
        }
        this.localeEncodingMappings.putAll(webXml.getLocaleEncodingMappings());
        if (this.getLoginConfig() == null) {
            void var4_30;
            Object var4_29 = null;
            for (WebXml webXml16 : set) {
                LoginConfig loginConfig = webXml16.loginConfig;
                if (loginConfig == null) continue;
                if (var4_30 == null || loginConfig.equals(var4_30)) {
                    LoginConfig loginConfig2 = loginConfig;
                    continue;
                }
                this.log.error((Object)sm.getString("webXml.mergeConflictLoginConfig", new Object[]{webXml16.getName(), webXml16.getURL()}));
            }
            this.loginConfig = var4_30;
        }
        for (WebXml webXml17 : set) {
            if (this.mergeResourceMap(webXml17.getMessageDestinationRefs(), this.messageDestinationRefs, webXml.getMessageDestinationRefs(), webXml17)) continue;
            return false;
        }
        this.messageDestinationRefs.putAll(webXml.getMessageDestinationRefs());
        for (WebXml webXml18 : set) {
            if (this.mergeResourceMap(webXml18.getMessageDestinations(), this.messageDestinations, webXml.getMessageDestinations(), webXml18)) continue;
            return false;
        }
        this.messageDestinations.putAll(webXml.getMessageDestinations());
        for (WebXml webXml19 : set) {
            if (this.mergeMap(webXml19.getMimeMappings(), this.mimeMappings, webXml.getMimeMappings(), webXml19, "Mime Mapping")) continue;
            return false;
        }
        this.mimeMappings.putAll(webXml.getMimeMappings());
        for (WebXml webXml20 : set) {
            if (this.mergeResourceMap(webXml20.getResourceEnvRefs(), this.resourceEnvRefs, webXml.getResourceEnvRefs(), webXml20)) continue;
            return false;
        }
        this.resourceEnvRefs.putAll(webXml.getResourceEnvRefs());
        for (WebXml webXml21 : set) {
            if (this.mergeResourceMap(webXml21.getResourceRefs(), this.resourceRefs, webXml.getResourceRefs(), webXml21)) continue;
            return false;
        }
        this.resourceRefs.putAll(webXml.getResourceRefs());
        for (WebXml webXml22 : set) {
            for (SecurityConstraint securityConstraint : webXml22.getSecurityConstraints()) {
                this.addSecurityConstraint(securityConstraint);
            }
        }
        for (WebXml webXml23 : set) {
            for (String string : webXml23.getSecurityRoles()) {
                this.addSecurityRole(string);
            }
        }
        for (WebXml webXml24 : set) {
            if (this.mergeResourceMap(webXml24.getServiceRefs(), this.serviceRefs, webXml.getServiceRefs(), webXml24)) continue;
            return false;
        }
        this.serviceRefs.putAll(webXml.getServiceRefs());
        ArrayList<Map.Entry<String, String>> arrayList2 = new ArrayList<Map.Entry<String, String>>();
        for (WebXml webXml25 : set) {
            for (Map.Entry<String, String> entry : webXml25.getServletMappings().entrySet()) {
                if (this.servletMappingNames.contains(entry.getValue()) || this.servletMappings.containsKey(entry.getKey())) continue;
                arrayList2.add(entry);
            }
        }
        for (Map.Entry entry : arrayList2) {
            this.addServletMappingDecoded((String)entry.getKey(), (String)entry.getValue());
        }
        for (WebXml webXml26 : set) {
            for (Map.Entry<String, ServletDef> entry : webXml26.getServlets().entrySet()) {
                if (this.servlets.containsKey(entry.getKey())) {
                    WebXml.mergeServlet(entry.getValue(), this.servlets.get(entry.getKey()), false);
                    continue;
                }
                if (webXml.getServlets().containsKey(entry.getKey())) {
                    if (WebXml.mergeServlet(entry.getValue(), webXml.getServlets().get(entry.getKey()), true)) continue;
                    this.log.error((Object)sm.getString("webXml.mergeConflictServlet", new Object[]{entry.getKey(), webXml26.getName(), webXml26.getURL()}));
                    return false;
                }
                webXml.getServlets().put(entry.getKey(), entry.getValue());
            }
        }
        this.servlets.putAll(webXml.getServlets());
        if (this.sessionConfig.getSessionTimeout() == null) {
            for (WebXml webXml27 : set) {
                Integer n = webXml27.getSessionConfig().getSessionTimeout();
                if (n == null) continue;
                if (webXml.getSessionConfig().getSessionTimeout() == null) {
                    webXml.getSessionConfig().setSessionTimeout(n.toString());
                    continue;
                }
                if (n.equals(webXml.getSessionConfig().getSessionTimeout())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionTimeout", new Object[]{webXml27.getName(), webXml27.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getSessionTimeout() != null) {
                this.sessionConfig.setSessionTimeout(webXml.getSessionConfig().getSessionTimeout().toString());
            }
        }
        if (this.sessionConfig.getCookieName() == null) {
            for (WebXml webXml28 : set) {
                String string = webXml28.getSessionConfig().getCookieName();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieName() == null) {
                    webXml.getSessionConfig().setCookieName(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieName())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieName", new Object[]{webXml28.getName(), webXml28.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieName(webXml.getSessionConfig().getCookieName());
        }
        if (this.sessionConfig.getCookieDomain() == null) {
            for (WebXml webXml29 : set) {
                String string = webXml29.getSessionConfig().getCookieDomain();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieDomain() == null) {
                    webXml.getSessionConfig().setCookieDomain(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieDomain())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieDomain", new Object[]{webXml29.getName(), webXml29.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieDomain(webXml.getSessionConfig().getCookieDomain());
        }
        if (this.sessionConfig.getCookiePath() == null) {
            for (WebXml webXml30 : set) {
                String string = webXml30.getSessionConfig().getCookiePath();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookiePath() == null) {
                    webXml.getSessionConfig().setCookiePath(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookiePath())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookiePath", new Object[]{webXml30.getName(), webXml30.getURL()}));
                return false;
            }
            this.sessionConfig.setCookiePath(webXml.getSessionConfig().getCookiePath());
        }
        if (this.sessionConfig.getCookieComment() == null) {
            for (WebXml webXml31 : set) {
                String string = webXml31.getSessionConfig().getCookieComment();
                if (string == null) continue;
                if (webXml.getSessionConfig().getCookieComment() == null) {
                    webXml.getSessionConfig().setCookieComment(string);
                    continue;
                }
                if (string.equals(webXml.getSessionConfig().getCookieComment())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieComment", new Object[]{webXml31.getName(), webXml31.getURL()}));
                return false;
            }
            this.sessionConfig.setCookieComment(webXml.getSessionConfig().getCookieComment());
        }
        if (this.sessionConfig.getCookieHttpOnly() == null) {
            for (WebXml webXml32 : set) {
                Boolean bl = webXml32.getSessionConfig().getCookieHttpOnly();
                if (bl == null) continue;
                if (webXml.getSessionConfig().getCookieHttpOnly() == null) {
                    webXml.getSessionConfig().setCookieHttpOnly(bl.toString());
                    continue;
                }
                if (bl.equals(webXml.getSessionConfig().getCookieHttpOnly())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieHttpOnly", new Object[]{webXml32.getName(), webXml32.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieHttpOnly() != null) {
                this.sessionConfig.setCookieHttpOnly(webXml.getSessionConfig().getCookieHttpOnly().toString());
            }
        }
        if (this.sessionConfig.getCookieSecure() == null) {
            for (WebXml webXml33 : set) {
                Boolean bl = webXml33.getSessionConfig().getCookieSecure();
                if (bl == null) continue;
                if (webXml.getSessionConfig().getCookieSecure() == null) {
                    webXml.getSessionConfig().setCookieSecure(bl.toString());
                    continue;
                }
                if (bl.equals(webXml.getSessionConfig().getCookieSecure())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieSecure", new Object[]{webXml33.getName(), webXml33.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieSecure() != null) {
                this.sessionConfig.setCookieSecure(webXml.getSessionConfig().getCookieSecure().toString());
            }
        }
        if (this.sessionConfig.getCookieMaxAge() == null) {
            for (WebXml webXml34 : set) {
                Integer n = webXml34.getSessionConfig().getCookieMaxAge();
                if (n == null) continue;
                if (webXml.getSessionConfig().getCookieMaxAge() == null) {
                    webXml.getSessionConfig().setCookieMaxAge(n.toString());
                    continue;
                }
                if (n.equals(webXml.getSessionConfig().getCookieMaxAge())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionCookieMaxAge", new Object[]{webXml34.getName(), webXml34.getURL()}));
                return false;
            }
            if (webXml.getSessionConfig().getCookieMaxAge() != null) {
                this.sessionConfig.setCookieMaxAge(webXml.getSessionConfig().getCookieMaxAge().toString());
            }
        }
        if (this.sessionConfig.getSessionTrackingModes().isEmpty()) {
            for (WebXml webXml35 : set) {
                EnumSet<SessionTrackingMode> enumSet = webXml35.getSessionConfig().getSessionTrackingModes();
                if (enumSet.isEmpty()) continue;
                if (webXml.getSessionConfig().getSessionTrackingModes().isEmpty()) {
                    webXml.getSessionConfig().getSessionTrackingModes().addAll(enumSet);
                    continue;
                }
                if (enumSet.equals(webXml.getSessionConfig().getSessionTrackingModes())) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictSessionTrackingMode", new Object[]{webXml35.getName(), webXml35.getURL()}));
                return false;
            }
            this.sessionConfig.getSessionTrackingModes().addAll(webXml.getSessionConfig().getSessionTrackingModes());
        }
        for (WebXml webXml36 : set) {
            if (this.mergeMap(webXml36.getTaglibs(), this.taglibs, webXml.getTaglibs(), webXml36, "Taglibs")) continue;
            return false;
        }
        this.taglibs.putAll(webXml.getTaglibs());
        for (WebXml webXml37 : set) {
            if (!webXml37.alwaysAddWelcomeFiles && !this.welcomeFiles.isEmpty()) continue;
            for (String string : webXml37.getWelcomeFiles()) {
                this.addWelcomeFile(string);
            }
        }
        if (this.postConstructMethods.isEmpty()) {
            for (WebXml webXml38 : set) {
                if (this.mergeLifecycleCallback(webXml38.getPostConstructMethods(), webXml.getPostConstructMethods(), webXml38, "Post Construct Methods")) continue;
                return false;
            }
            this.postConstructMethods.putAll(webXml.getPostConstructMethods());
        }
        if (this.preDestroyMethods.isEmpty()) {
            for (WebXml webXml39 : set) {
                if (this.mergeLifecycleCallback(webXml39.getPreDestroyMethods(), webXml.getPreDestroyMethods(), webXml39, "Pre Destroy Methods")) continue;
                return false;
            }
            this.preDestroyMethods.putAll(webXml.getPreDestroyMethods());
        }
        return true;
    }

    private <T extends ResourceBase> boolean mergeResourceMap(Map<String, T> map, Map<String, T> map2, Map<String, T> map3, WebXml webXml) {
        for (ResourceBase resourceBase : map.values()) {
            String string = resourceBase.getName();
            if (map2.containsKey(string)) {
                ((ResourceBase)map2.get(string)).getInjectionTargets().addAll(resourceBase.getInjectionTargets());
                continue;
            }
            ResourceBase resourceBase2 = (ResourceBase)map3.get(string);
            if (resourceBase2 != null) {
                if (resourceBase2.equals(resourceBase)) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictResource", new Object[]{string, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map3.put(string, resourceBase);
        }
        return true;
    }

    private <T> boolean mergeMap(Map<String, T> map, Map<String, T> map2, Map<String, T> map3, WebXml webXml, String string) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (map2.containsKey(string2)) continue;
            T t = entry.getValue();
            if (map3.containsKey(string2)) {
                if (t == null || t.equals(map3.get(string2))) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictString", new Object[]{string, string2, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map3.put(string2, t);
        }
        return true;
    }

    private static boolean mergeFilter(FilterDef filterDef, FilterDef filterDef2, boolean bl) {
        if (filterDef2.getAsyncSupported() == null) {
            filterDef2.setAsyncSupported(filterDef.getAsyncSupported());
        } else if (filterDef.getAsyncSupported() != null && bl && !filterDef.getAsyncSupported().equals(filterDef2.getAsyncSupported())) {
            return false;
        }
        if (filterDef2.getFilterClass() == null) {
            filterDef2.setFilterClass(filterDef.getFilterClass());
        } else if (filterDef.getFilterClass() != null && bl && !filterDef.getFilterClass().equals(filterDef2.getFilterClass())) {
            return false;
        }
        for (Map.Entry<String, String> entry : filterDef.getParameterMap().entrySet()) {
            if (filterDef2.getParameterMap().containsKey(entry.getKey())) {
                if (!bl || filterDef2.getParameterMap().get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            filterDef2.addInitParameter(entry.getKey(), entry.getValue());
        }
        return true;
    }

    private static boolean mergeServlet(ServletDef servletDef, ServletDef servletDef2, boolean bl) {
        if (servletDef2.getServletClass() != null && servletDef2.getJspFile() != null) {
            return false;
        }
        if (servletDef.getServletClass() != null && servletDef.getJspFile() != null) {
            return false;
        }
        if (servletDef2.getServletClass() == null && servletDef2.getJspFile() == null) {
            servletDef2.setServletClass(servletDef.getServletClass());
            servletDef2.setJspFile(servletDef.getJspFile());
        } else if (bl) {
            if (!(servletDef.getServletClass() == null || servletDef2.getJspFile() == null && servletDef.getServletClass().equals(servletDef2.getServletClass()))) {
                return false;
            }
            if (!(servletDef.getJspFile() == null || servletDef2.getServletClass() == null && servletDef.getJspFile().equals(servletDef2.getJspFile()))) {
                return false;
            }
        }
        for (SecurityRoleRef object : servletDef.getSecurityRoleRefs()) {
            servletDef2.addSecurityRoleRef(object);
        }
        if (servletDef2.getLoadOnStartup() == null) {
            if (servletDef.getLoadOnStartup() != null) {
                servletDef2.setLoadOnStartup(servletDef.getLoadOnStartup().toString());
            }
        } else if (servletDef.getLoadOnStartup() != null && bl && !servletDef.getLoadOnStartup().equals(servletDef2.getLoadOnStartup())) {
            return false;
        }
        if (servletDef2.getEnabled() == null) {
            if (servletDef.getEnabled() != null) {
                servletDef2.setEnabled(servletDef.getEnabled().toString());
            }
        } else if (servletDef.getEnabled() != null && bl && !servletDef.getEnabled().equals(servletDef2.getEnabled())) {
            return false;
        }
        for (Map.Entry entry : servletDef.getParameterMap().entrySet()) {
            if (servletDef2.getParameterMap().containsKey(entry.getKey())) {
                if (!bl || servletDef2.getParameterMap().get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            servletDef2.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (servletDef2.getMultipartDef() == null) {
            servletDef2.setMultipartDef(servletDef.getMultipartDef());
        } else if (servletDef.getMultipartDef() != null) {
            return WebXml.mergeMultipartDef(servletDef.getMultipartDef(), servletDef2.getMultipartDef(), bl);
        }
        if (servletDef2.getAsyncSupported() == null) {
            if (servletDef.getAsyncSupported() != null) {
                servletDef2.setAsyncSupported(servletDef.getAsyncSupported().toString());
            }
        } else if (servletDef.getAsyncSupported() != null) {
            return !bl || servletDef.getAsyncSupported().equals(servletDef2.getAsyncSupported());
        }
        return true;
    }

    private static boolean mergeMultipartDef(MultipartDef multipartDef, MultipartDef multipartDef2, boolean bl) {
        if (multipartDef2.getLocation() == null) {
            multipartDef2.setLocation(multipartDef.getLocation());
        } else if (multipartDef.getLocation() != null && bl && !multipartDef.getLocation().equals(multipartDef2.getLocation())) {
            return false;
        }
        if (multipartDef2.getFileSizeThreshold() == null) {
            multipartDef2.setFileSizeThreshold(multipartDef.getFileSizeThreshold());
        } else if (multipartDef.getFileSizeThreshold() != null && bl && !multipartDef.getFileSizeThreshold().equals(multipartDef2.getFileSizeThreshold())) {
            return false;
        }
        if (multipartDef2.getMaxFileSize() == null) {
            multipartDef2.setMaxFileSize(multipartDef.getMaxFileSize());
        } else if (multipartDef.getMaxFileSize() != null && bl && !multipartDef.getMaxFileSize().equals(multipartDef2.getMaxFileSize())) {
            return false;
        }
        if (multipartDef2.getMaxRequestSize() == null) {
            multipartDef2.setMaxRequestSize(multipartDef.getMaxRequestSize());
        } else if (multipartDef.getMaxRequestSize() != null) {
            return !bl || multipartDef.getMaxRequestSize().equals(multipartDef2.getMaxRequestSize());
        }
        return true;
    }

    private boolean mergeLifecycleCallback(Map<String, String> map, Map<String, String> map2, WebXml webXml, String string) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if (map2.containsKey(string2)) {
                if (string3 == null || string3.equals(map2.get(string2))) continue;
                this.log.error((Object)sm.getString("webXml.mergeConflictString", new Object[]{string, string2, webXml.getName(), webXml.getURL()}));
                return false;
            }
            map2.put(string2, string3);
        }
        return true;
    }

    public static Set<WebXml> orderWebFragments(WebXml webXml, Map<String, WebXml> map, ServletContext servletContext) {
        return webXml.orderWebFragments(map, servletContext);
    }

    /*
     * WARNING - void declaration
     */
    private Set<WebXml> orderWebFragments(Map<String, WebXml> map, ServletContext servletContext) {
        WebXml webXml;
        Object object4;
        LinkedHashSet<WebXml> linkedHashSet = new LinkedHashSet<WebXml>();
        boolean bl = this.getAbsoluteOrdering() != null;
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
            object4 = this.getAbsoluteOrdering();
            Iterator object32 = object4.iterator();
            while (object32.hasNext()) {
                String string = (String)object32.next();
                if (ORDER_OTHERS.equals(string)) {
                    for (Map.Entry<String, WebXml> entry : map.entrySet()) {
                        if (object4.contains(entry.getKey()) || (webXml = entry.getValue()) == null) continue;
                        linkedHashSet.add(webXml);
                    }
                    continue;
                }
                WebXml webXml2 = map.get(string);
                if (webXml2 != null) {
                    linkedHashSet.add(webXml2);
                    continue;
                }
                this.log.warn((Object)sm.getString("webXml.wrongFragmentName", new Object[]{string}));
            }
        } else {
            for (WebXml webXml3 : map.values()) {
                if (!webXml3.isDuplicated()) continue;
                List<String> list = webXml3.getDuplicates();
                list.add(0, webXml3.getURL().toString());
                throw new IllegalArgumentException(sm.getString("webXml.duplicateFragment", new Object[]{webXml3.getName(), list}));
            }
            for (WebXml webXml4 : map.values()) {
                Iterator<String> iterator = webXml4.getBeforeOrdering().iterator();
                while (iterator.hasNext()) {
                    bl2 = true;
                    String string = iterator.next();
                    if (string.equals(ORDER_OTHERS)) continue;
                    WebXml webXml5 = map.get(string);
                    if (webXml5 == null) {
                        iterator.remove();
                        continue;
                    }
                    webXml5.addAfterOrdering(webXml4.getName());
                }
                Iterator<String> iterator2 = webXml4.getAfterOrdering().iterator();
                while (iterator2.hasNext()) {
                    bl2 = true;
                    String string = iterator2.next();
                    if (string.equals(ORDER_OTHERS)) continue;
                    webXml = map.get(string);
                    if (webXml == null) {
                        iterator2.remove();
                        continue;
                    }
                    webXml.addBeforeOrdering(webXml4.getName());
                }
            }
            for (WebXml webXml6 : map.values()) {
                if (webXml6.getBeforeOrdering().contains(ORDER_OTHERS)) {
                    WebXml.makeBeforeOthersExplicit(webXml6.getAfterOrdering(), map);
                }
                if (!webXml6.getAfterOrdering().contains(ORDER_OTHERS)) continue;
                WebXml.makeAfterOthersExplicit(webXml6.getBeforeOrdering(), map);
            }
            object4 = new HashSet();
            HashSet<WebXml> hashSet = new HashSet<WebXml>();
            HashSet<WebXml> hashSet2 = new HashSet<WebXml>();
            for (WebXml webXml7 : map.values()) {
                if (webXml7.getBeforeOrdering().contains(ORDER_OTHERS)) {
                    object4.add(webXml7);
                    webXml7.getBeforeOrdering().remove(ORDER_OTHERS);
                    continue;
                }
                if (webXml7.getAfterOrdering().contains(ORDER_OTHERS)) {
                    hashSet2.add(webXml7);
                    webXml7.getAfterOrdering().remove(ORDER_OTHERS);
                    continue;
                }
                hashSet.add(webXml7);
            }
            WebXml.decoupleOtherGroups((Set<WebXml>)object4);
            WebXml.decoupleOtherGroups(hashSet);
            WebXml.decoupleOtherGroups(hashSet2);
            WebXml.orderFragments(linkedHashSet, (Set<WebXml>)object4);
            WebXml.orderFragments(linkedHashSet, hashSet);
            WebXml.orderFragments(linkedHashSet, hashSet2);
        }
        object4 = new LinkedHashSet();
        for (WebXml webXml8 : map.values()) {
            if (webXml8.getWebappJar()) continue;
            object4.add(webXml8);
            linkedHashSet.remove(webXml8);
        }
        if (servletContext != null) {
            void var7_18;
            Object var7_16 = null;
            if (bl2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (WebXml webXml9 : linkedHashSet) {
                    arrayList.add(webXml9.getJarName());
                }
            }
            servletContext.setAttribute("javax.servlet.context.orderedLibs", (Object)var7_18);
        }
        if (!object4.isEmpty()) {
            LinkedHashSet<WebXml> linkedHashSet2 = new LinkedHashSet<WebXml>();
            if (((WebXml)object4.iterator().next()).getDelegate()) {
                linkedHashSet2.addAll((Collection<WebXml>)object4);
                linkedHashSet2.addAll(linkedHashSet);
            } else {
                linkedHashSet2.addAll(linkedHashSet);
                linkedHashSet2.addAll((Collection<WebXml>)object4);
            }
            return linkedHashSet2;
        }
        return linkedHashSet;
    }

    private static void decoupleOtherGroups(Set<WebXml> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (WebXml webXml : set) {
            hashSet.add(webXml.getName());
        }
        for (WebXml webXml : set) {
            webXml.getAfterOrdering().removeIf(string -> !hashSet.contains(string));
        }
    }

    private static void orderFragments(Set<WebXml> set, Set<WebXml> set2) {
        HashSet<WebXml> hashSet = new HashSet<WebXml>();
        HashSet<WebXml> hashSet2 = new HashSet<WebXml>();
        while (!set2.isEmpty()) {
            Iterator<WebXml> iterator = set2.iterator();
            while (iterator.hasNext()) {
                WebXml webXml = iterator.next();
                for (WebXml webXml2 : hashSet2) {
                    webXml.getAfterOrdering().remove(webXml2.getName());
                }
                if (!webXml.getAfterOrdering().isEmpty()) continue;
                hashSet.add(webXml);
                set.add(webXml);
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("webXml.mergeConflictOrder"));
            }
            hashSet2.clear();
            hashSet2.addAll(hashSet);
            hashSet.clear();
        }
    }

    private static void makeBeforeOthersExplicit(Set<String> set, Map<String, WebXml> map) {
        for (String string : set) {
            WebXml webXml;
            if (string.equals(ORDER_OTHERS) || (webXml = map.get(string)).getBeforeOrdering().contains(ORDER_OTHERS)) continue;
            webXml.addBeforeOrderingOthers();
            WebXml.makeBeforeOthersExplicit(webXml.getAfterOrdering(), map);
        }
    }

    private static void makeAfterOthersExplicit(Set<String> set, Map<String, WebXml> map) {
        for (String string : set) {
            WebXml webXml;
            if (string.equals(ORDER_OTHERS) || (webXml = map.get(string)).getAfterOrdering().contains(ORDER_OTHERS)) continue;
            webXml.addAfterOrderingOthers();
            WebXml.makeAfterOthersExplicit(webXml.getBeforeOrdering(), map);
        }
    }
}

