/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ResourceRef;
import org.apache.naming.StringManager;

public class BeanFactory
implements ObjectFactory {
    private static final StringManager sm = StringManager.getManager(BeanFactory.class);
    private final Log log = LogFactory.getLog(BeanFactory.class);

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws NamingException {
        if (object instanceof ResourceRef) {
            try {
                Class<?> clazz;
                Reference reference = (Reference)object;
                String string = reference.getClassName();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NamingException namingException = new NamingException(sm.getString("beanFactory.classNotFound", string));
                    namingException.initCause(classNotFoundException);
                    throw namingException;
                }
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                RefAddr refAddr = reference.get("forceString");
                if (refAddr != null) {
                    this.log.warn((Object)sm.getString("beanFactory.noForceString"));
                }
                Enumeration<RefAddr> enumeration = reference.getAll();
                while (enumeration.hasMoreElements()) {
                    int n;
                    refAddr = enumeration.nextElement();
                    String string2 = refAddr.getType();
                    if (string2.equals("factory") || string2.equals("scope") || string2.equals("auth") || string2.equals("forceString") || string2.equals("singleton")) continue;
                    String string3 = (String)refAddr.getContent();
                    Object[] objectArray = new Object[1];
                    for (n = 0; n < propertyDescriptorArray.length; ++n) {
                        if (!propertyDescriptorArray[n].getName().equals(string2)) continue;
                        Class<?> clazz2 = propertyDescriptorArray[n].getPropertyType();
                        Method method = propertyDescriptorArray[n].getWriteMethod();
                        if (clazz2.equals(String.class)) {
                            objectArray[0] = string3;
                        } else if (clazz2.equals(Character.class) || clazz2.equals(Character.TYPE)) {
                            objectArray[0] = Character.valueOf(string3.charAt(0));
                        } else if (clazz2.equals(Byte.class) || clazz2.equals(Byte.TYPE)) {
                            objectArray[0] = Byte.valueOf(string3);
                        } else if (clazz2.equals(Short.class) || clazz2.equals(Short.TYPE)) {
                            objectArray[0] = Short.valueOf(string3);
                        } else if (clazz2.equals(Integer.class) || clazz2.equals(Integer.TYPE)) {
                            objectArray[0] = Integer.valueOf(string3);
                        } else if (clazz2.equals(Long.class) || clazz2.equals(Long.TYPE)) {
                            objectArray[0] = Long.valueOf(string3);
                        } else if (clazz2.equals(Float.class) || clazz2.equals(Float.TYPE)) {
                            objectArray[0] = Float.valueOf(string3);
                        } else if (clazz2.equals(Double.class) || clazz2.equals(Double.TYPE)) {
                            objectArray[0] = Double.valueOf(string3);
                        } else if (clazz2.equals(Boolean.class) || clazz2.equals(Boolean.TYPE)) {
                            objectArray[0] = Boolean.valueOf(string3);
                        } else if (method != null) {
                            String string4 = method.getName();
                            try {
                                method = obj.getClass().getMethod(string4, String.class);
                                objectArray[0] = string3;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                throw new NamingException(sm.getString("beanFactory.noStringConversion", string2, clazz2.getName()));
                            }
                        } else {
                            throw new NamingException(sm.getString("beanFactory.noStringConversion", string2, clazz2.getName()));
                        }
                        if (method != null) {
                            method.invoke(obj, objectArray);
                            break;
                        }
                        throw new NamingException(sm.getString("beanFactory.readOnlyProperty", string2));
                    }
                    if (n != propertyDescriptorArray.length) continue;
                    throw new NamingException(sm.getString("beanFactory.noSetMethod", string2));
                }
                return obj;
            }
            catch (IntrospectionException introspectionException) {
                NamingException namingException = new NamingException(introspectionException.getMessage());
                namingException.setRootCause(introspectionException);
                throw namingException;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Throwable throwable = reflectiveOperationException.getCause();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof VirtualMachineError) {
                    throw (VirtualMachineError)throwable;
                }
                NamingException namingException = new NamingException(reflectiveOperationException.getMessage());
                namingException.setRootCause(reflectiveOperationException);
                throw namingException;
            }
        }
        return null;
    }
}

