/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.catalina.util.Extension;

public class ManifestResource {
    public static final int SYSTEM = 1;
    public static final int WAR = 2;
    public static final int APPLICATION = 3;
    private ArrayList<Extension> availableExtensions = null;
    private ArrayList<Extension> requiredExtensions = null;
    private final String resourceName;
    private final int resourceType;

    public ManifestResource(String string, Manifest manifest, int n) {
        this.resourceName = string;
        this.resourceType = n;
        this.processManifest(manifest);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ArrayList<Extension> getAvailableExtensions() {
        return this.availableExtensions;
    }

    public ArrayList<Extension> getRequiredExtensions() {
        return this.requiredExtensions;
    }

    public int getAvailableExtensionCount() {
        return this.availableExtensions != null ? this.availableExtensions.size() : 0;
    }

    public int getRequiredExtensionCount() {
        return this.requiredExtensions != null ? this.requiredExtensions.size() : 0;
    }

    public boolean isFulfilled() {
        if (this.requiredExtensions == null) {
            return true;
        }
        for (Extension extension : this.requiredExtensions) {
            if (extension.isFulfilled()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ManifestResource[");
        stringBuilder.append(this.resourceName);
        stringBuilder.append(", isFulfilled=");
        stringBuilder.append(this.isFulfilled() + "");
        stringBuilder.append(", requiredExtensionCount =");
        stringBuilder.append(this.getRequiredExtensionCount());
        stringBuilder.append(", availableExtensionCount=");
        stringBuilder.append(this.getAvailableExtensionCount());
        switch (this.resourceType) {
            case 1: {
                stringBuilder.append(", resourceType=SYSTEM");
                break;
            }
            case 2: {
                stringBuilder.append(", resourceType=WAR");
                break;
            }
            case 3: {
                stringBuilder.append(", resourceType=APPLICATION");
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void processManifest(Manifest manifest) {
        this.availableExtensions = this.getAvailableExtensions(manifest);
        this.requiredExtensions = this.getRequiredExtensions(manifest);
    }

    private ArrayList<Extension> getRequiredExtensions(Manifest manifest) {
        int n;
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue("Extension-List");
        if (string == null) {
            return null;
        }
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        string = string + " ";
        while ((n = string.indexOf(32)) >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1);
            String string3 = attributes.getValue(string2 + "-Extension-Name");
            if (string3 == null) continue;
            Extension extension = new Extension();
            extension.setExtensionName(string3);
            extension.setImplementationURL(attributes.getValue(string2 + "-Implementation-URL"));
            extension.setImplementationVendorId(attributes.getValue(string2 + "-Implementation-Vendor-Id"));
            String string4 = attributes.getValue(string2 + "-Implementation-Version");
            extension.setImplementationVersion(string4);
            extension.setSpecificationVersion(attributes.getValue(string2 + "-Specification-Version"));
            arrayList.add(extension);
        }
        return arrayList;
    }

    private ArrayList<Extension> getAvailableExtensions(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String string = attributes.getValue("Extension-Name");
        if (string == null) {
            return null;
        }
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        Extension extension = new Extension();
        extension.setExtensionName(string);
        extension.setImplementationURL(attributes.getValue("Implementation-URL"));
        extension.setImplementationVendor(attributes.getValue("Implementation-Vendor"));
        extension.setImplementationVendorId(attributes.getValue("Implementation-Vendor-Id"));
        extension.setImplementationVersion(attributes.getValue("Implementation-Version"));
        extension.setSpecificationVersion(attributes.getValue("Specification-Version"));
        arrayList.add(extension);
        return arrayList;
    }
}

