/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.valves.ValveBase;

public class LoadBalancerDrainingValve
extends ValveBase {
    public static final String ATTRIBUTE_KEY_JK_LB_ACTIVATION = "JK_LB_ACTIVATION";
    private int _redirectStatusCode = 307;
    private String _ignoreCookieName;
    private String _ignoreCookieValue;

    public LoadBalancerDrainingValve() {
        super(true);
    }

    public void setRedirectStatusCode(int n) {
        this._redirectStatusCode = n;
    }

    public String getIgnoreCookieName() {
        return this._ignoreCookieName;
    }

    public void setIgnoreCookieName(String string) {
        this._ignoreCookieName = string;
    }

    public String getIgnoreCookieValue() {
        return this._ignoreCookieValue;
    }

    public void setIgnoreCookieValue(String string) {
        this._ignoreCookieValue = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if ("DIS".equals(request.getAttribute(ATTRIBUTE_KEY_JK_LB_ACTIVATION)) && !request.isRequestedSessionIdValid()) {
            void var7_14;
            String string;
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)sm.getString("loadBalancerDrainingValve.draining"));
            }
            boolean bl = false;
            Cookie cookie = null;
            Cookie[] cookieArray = request.getCookies();
            String string2 = SessionConfig.getSessionCookieName(request.getContext());
            if (null != cookieArray) {
                for (Cookie cookie2 : cookieArray) {
                    String string3 = cookie2.getName();
                    if (this.containerLog.isTraceEnabled()) {
                        this.containerLog.trace((Object)("Checking cookie " + string3 + "=" + cookie2.getValue()));
                    }
                    if (string2.equals(string3) && request.getRequestedSessionId().equals(cookie2.getValue())) {
                        cookie = cookie2;
                        continue;
                    }
                    if (null == this._ignoreCookieName || !this._ignoreCookieName.equals(string3) || null == this._ignoreCookieValue || !this._ignoreCookieValue.equals(cookie2.getValue())) continue;
                    bl = true;
                }
            }
            if (bl) {
                if (this.containerLog.isDebugEnabled()) {
                    this.containerLog.debug((Object)sm.getString("loadBalancerDrainingValve.skip", new Object[]{this._ignoreCookieName}));
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (null != cookie) {
                cookie.setPath(SessionConfig.getSessionCookiePath(request.getContext()));
                cookie.setMaxAge(0);
                cookie.setValue("");
                SessionCookieConfig sessionCookieConfig = request.getContext().getServletContext().getSessionCookieConfig();
                cookie.setSecure(request.isSecure() || sessionCookieConfig.isSecure());
                response.addCookie(cookie);
            }
            String string4 = request.getRequestURI();
            String string5 = SessionConfig.getSessionUriParamName(request.getContext());
            if (string4.contains(";" + string5 + "=")) {
                String string6 = string4.replaceFirst(";" + string5 + "=[^&?]*", "");
            }
            if (null != (string = request.getQueryString())) {
                void var7_12;
                String string7 = (String)var7_12 + "?" + string;
            }
            response.setHeader("Location", (String)var7_14);
            response.setStatus(this._redirectStatusCode);
        } else {
            this.getNext().invoke(request, response);
        }
    }
}

