/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.catalina.valves.rewrite.RewriteCond;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.catalina.valves.rewrite.Substitution;

public class RewriteRule {
    protected RewriteCond[] conditions = new RewriteCond[0];
    protected ThreadLocal<Pattern> pattern = new ThreadLocal();
    protected Substitution substitution = null;
    protected String patternString = null;
    protected String substitutionString = null;
    protected String flagsString = null;
    protected boolean positive = true;
    private boolean escapeBackReferences = false;
    protected boolean chain = false;
    protected boolean cookie = false;
    protected String cookieName = null;
    protected String cookieValue = null;
    protected String cookieDomain = null;
    protected int cookieLifetime = -1;
    protected String cookiePath = null;
    protected boolean cookieSecure = false;
    protected boolean cookieHttpOnly = false;
    protected Substitution cookieSubstitution = null;
    protected ThreadLocal<String> cookieResult = new ThreadLocal();
    protected boolean env = false;
    protected ArrayList<String> envName = new ArrayList();
    protected ArrayList<String> envValue = new ArrayList();
    protected ArrayList<Substitution> envSubstitution = new ArrayList();
    protected ArrayList<ThreadLocal<String>> envResult = new ArrayList();
    protected boolean forbidden = false;
    protected boolean gone = false;
    protected boolean host = false;
    protected boolean last = false;
    protected boolean next = false;
    protected boolean nocase = false;
    protected boolean noescape = false;
    protected boolean nosubreq = false;
    protected boolean qsappend = false;
    protected boolean qsdiscard = false;
    protected boolean redirect = false;
    protected int redirectCode = 0;
    protected int skip = 0;
    protected boolean type = false;
    protected String typeValue = null;
    protected boolean valveSkip = false;

    public void parse(Map<String, RewriteMap> map) {
        if (!"-".equals(this.substitutionString)) {
            this.substitution = new Substitution();
            this.substitution.setSub(this.substitutionString);
            this.substitution.parse(map);
            this.substitution.setEscapeBackReferences(this.isEscapeBackReferences());
        }
        if (this.patternString.startsWith("!")) {
            this.positive = false;
            this.patternString = this.patternString.substring(1);
        }
        int n = 32;
        if (this.isNocase()) {
            n |= 2;
        }
        Pattern.compile(this.patternString, n);
        for (RewriteCond rewriteCond : this.conditions) {
            rewriteCond.parse(map);
        }
        if (this.isEnv()) {
            for (String string : this.envValue) {
                Substitution substitution = new Substitution();
                substitution.setSub(string);
                substitution.parse(map);
                this.envSubstitution.add(substitution);
                this.envResult.add(new ThreadLocal());
            }
        }
        if (this.isCookie()) {
            this.cookieSubstitution = new Substitution();
            this.cookieSubstitution.setSub(this.cookieValue);
            this.cookieSubstitution.parse(map);
        }
    }

    public void addCondition(RewriteCond rewriteCond) {
        RewriteCond[] rewriteCondArray = Arrays.copyOf(this.conditions, this.conditions.length + 1);
        rewriteCondArray[this.conditions.length] = rewriteCond;
        this.conditions = rewriteCondArray;
    }

    public CharSequence evaluate(CharSequence charSequence, Resolver resolver) {
        Matcher matcher;
        Pattern pattern = this.pattern.get();
        if (pattern == null) {
            int n = 32;
            if (this.isNocase()) {
                n |= 2;
            }
            pattern = Pattern.compile(this.patternString, n);
            this.pattern.set(pattern);
        }
        if (this.positive ^ (matcher = pattern.matcher(charSequence)).matches()) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = true;
        Matcher matcher2 = null;
        int n = 0;
        while (!bl) {
            if (n < this.conditions.length) {
                bl2 = this.conditions[n].evaluate(matcher, matcher2, resolver);
                if (bl2) {
                    Matcher matcher3 = this.conditions[n].getMatcher();
                    if (matcher3 != null) {
                        matcher2 = matcher3;
                    }
                    while (n < this.conditions.length && this.conditions[n].isOrnext()) {
                        ++n;
                    }
                } else if (!this.conditions[n].isOrnext()) {
                    bl = true;
                }
                ++n;
                continue;
            }
            bl = true;
        }
        if (bl2) {
            if (this.isEnv()) {
                for (int i = 0; i < this.envSubstitution.size(); ++i) {
                    this.envResult.get(i).set(this.envSubstitution.get(i).evaluate(matcher, matcher2, resolver));
                }
            }
            if (this.isCookie()) {
                this.cookieResult.set(this.cookieSubstitution.evaluate(matcher, matcher2, resolver));
            }
            if (this.substitution != null) {
                return this.substitution.evaluate(matcher, matcher2, resolver);
            }
            return charSequence;
        }
        return null;
    }

    public String toString() {
        return "RewriteRule " + this.patternString + " " + this.substitutionString + (String)(this.flagsString != null ? " " + this.flagsString : "");
    }

    public boolean isEscapeBackReferences() {
        return this.escapeBackReferences;
    }

    public void setEscapeBackReferences(boolean bl) {
        this.escapeBackReferences = bl;
    }

    public boolean isChain() {
        return this.chain;
    }

    public void setChain(boolean bl) {
        this.chain = bl;
    }

    public RewriteCond[] getConditions() {
        return this.conditions;
    }

    public void setConditions(RewriteCond[] rewriteCondArray) {
        this.conditions = rewriteCondArray;
    }

    public boolean isCookie() {
        return this.cookie;
    }

    public void setCookie(boolean bl) {
        this.cookie = bl;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String string) {
        this.cookieName = string;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public void setCookieValue(String string) {
        this.cookieValue = string;
    }

    public String getCookieResult() {
        return this.cookieResult.get();
    }

    public boolean isEnv() {
        return this.env;
    }

    public int getEnvSize() {
        return this.envName.size();
    }

    public void setEnv(boolean bl) {
        this.env = bl;
    }

    public String getEnvName(int n) {
        return this.envName.get(n);
    }

    public void addEnvName(String string) {
        this.envName.add(string);
    }

    public String getEnvValue(int n) {
        return this.envValue.get(n);
    }

    public void addEnvValue(String string) {
        this.envValue.add(string);
    }

    public String getEnvResult(int n) {
        return this.envResult.get(n).get();
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public void setForbidden(boolean bl) {
        this.forbidden = bl;
    }

    public boolean isGone() {
        return this.gone;
    }

    public void setGone(boolean bl) {
        this.gone = bl;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean bl) {
        this.last = bl;
    }

    public boolean isNext() {
        return this.next;
    }

    public void setNext(boolean bl) {
        this.next = bl;
    }

    public boolean isNocase() {
        return this.nocase;
    }

    public void setNocase(boolean bl) {
        this.nocase = bl;
    }

    public boolean isNoescape() {
        return this.noescape;
    }

    public void setNoescape(boolean bl) {
        this.noescape = bl;
    }

    public boolean isNosubreq() {
        return this.nosubreq;
    }

    public void setNosubreq(boolean bl) {
        this.nosubreq = bl;
    }

    public boolean isQsappend() {
        return this.qsappend;
    }

    public void setQsappend(boolean bl) {
        this.qsappend = bl;
    }

    public final boolean isQsdiscard() {
        return this.qsdiscard;
    }

    public final void setQsdiscard(boolean bl) {
        this.qsdiscard = bl;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean bl) {
        this.redirect = bl;
    }

    public int getRedirectCode() {
        return this.redirectCode;
    }

    public void setRedirectCode(int n) {
        this.redirectCode = n;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int n) {
        this.skip = n;
    }

    public Substitution getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(Substitution substitution) {
        this.substitution = substitution;
    }

    public boolean isType() {
        return this.type;
    }

    public void setType(boolean bl) {
        this.type = bl;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public void setTypeValue(String string) {
        this.typeValue = string;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public void setPatternString(String string) {
        this.patternString = string;
    }

    public String getSubstitutionString() {
        return this.substitutionString;
    }

    public void setSubstitutionString(String string) {
        this.substitutionString = string;
    }

    public final String getFlagsString() {
        return this.flagsString;
    }

    public final void setFlagsString(String string) {
        this.flagsString = string;
    }

    public boolean isHost() {
        return this.host;
    }

    public void setHost(boolean bl) {
        this.host = bl;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String string) {
        this.cookieDomain = string;
    }

    public int getCookieLifetime() {
        return this.cookieLifetime;
    }

    public void setCookieLifetime(int n) {
        this.cookieLifetime = n;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String string) {
        this.cookiePath = string;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieSecure(boolean bl) {
        this.cookieSecure = bl;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void setCookieHttpOnly(boolean bl) {
        this.cookieHttpOnly = bl;
    }

    public boolean isValveSkip() {
        return this.valveSkip;
    }

    public void setValveSkip(boolean bl) {
        this.valveSkip = bl;
    }
}

