/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public abstract class TimeBucketCounterBase {
    private static final Log log = LogFactory.getLog(TimeBucketCounterBase.class);
    private static final StringManager sm = StringManager.getManager(TimeBucketCounterBase.class);
    private static final String BUCKET_KEY_DELIMITER = "-";
    private final ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();
    private ScheduledFuture<?> maintenanceFuture;
    private ScheduledFuture<?> monitorFuture;
    private final ScheduledExecutorService executorService;
    private final long sleeptime;
    private final int bucketDuration;

    public TimeBucketCounterBase(int n, ScheduledExecutorService scheduledExecutorService) {
        Objects.requireNonNull(scheduledExecutorService);
        this.executorService = scheduledExecutorService;
        this.bucketDuration = n;
        int n2 = n >= 60 ? 6 : 3;
        this.sleeptime = (long)n * 1000L / (long)n2;
        if (this.sleeptime > 0L) {
            this.monitorFuture = scheduledExecutorService.scheduleWithFixedDelay(new MaintenanceMonitor(), 0L, 60L, TimeUnit.SECONDS);
        }
    }

    public int getBucketDuration() {
        return this.bucketDuration;
    }

    public abstract double getRatio();

    public final int increment(String string2) {
        String string3 = this.genKey(string2);
        AtomicInteger atomicInteger = this.map.computeIfAbsent(string3, string -> new AtomicInteger());
        return atomicInteger.incrementAndGet();
    }

    protected final String genKey(String string) {
        return this.genKey(string, System.currentTimeMillis());
    }

    protected final String genKey(String string, long l) {
        return this.getBucketIndex(l) + BUCKET_KEY_DELIMITER + string;
    }

    protected abstract long getBucketIndex(long var1);

    public int getCurrentBucketPrefix() {
        return (int)this.getBucketIndex(System.currentTimeMillis());
    }

    public abstract long getMillisUntilNextBucket();

    public void destroy() {
        this.map.clear();
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
            this.monitorFuture = null;
        }
        if (this.maintenanceFuture != null) {
            this.maintenanceFuture.cancel(true);
            this.maintenanceFuture = null;
        }
    }

    public void periodicEvict() {
        long l = this.getCurrentBucketPrefix();
        String string = String.valueOf(l);
        String string2 = String.valueOf(l + 1L);
        Set set = this.map.keySet();
        set.removeIf(string3 -> !string3.startsWith(string) && !string3.startsWith(string2));
    }

    private class MaintenanceMonitor
    implements Runnable {
        private MaintenanceMonitor() {
        }

        @Override
        public void run() {
            if (TimeBucketCounterBase.this.sleeptime > 0L && (TimeBucketCounterBase.this.maintenanceFuture == null || TimeBucketCounterBase.this.maintenanceFuture.isDone())) {
                if (TimeBucketCounterBase.this.maintenanceFuture != null && TimeBucketCounterBase.this.maintenanceFuture.isDone()) {
                    try {
                        TimeBucketCounterBase.this.maintenanceFuture.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        log.error((Object)sm.getString("timebucket.maintenance.error"), (Throwable)exception);
                    }
                }
                TimeBucketCounterBase.this.maintenanceFuture = TimeBucketCounterBase.this.executorService.scheduleWithFixedDelay(new Maintenance(), TimeBucketCounterBase.this.sleeptime, TimeBucketCounterBase.this.sleeptime, TimeUnit.MILLISECONDS);
            }
        }
    }

    private class Maintenance
    implements Runnable {
        private Maintenance() {
        }

        @Override
        public void run() {
            TimeBucketCounterBase.this.periodicEvict();
        }
    }
}

