/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.catalina.tribes.util.Arrays;

public class RpcMessage
implements Externalizable {
    protected Serializable message;
    protected byte[] uuid;
    protected byte[] rpcId;
    protected boolean reply = false;

    public RpcMessage() {
    }

    public RpcMessage(byte[] byArray, byte[] byArray2, Serializable serializable) {
        this.rpcId = byArray;
        this.uuid = byArray2;
        this.message = serializable;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.reply = objectInput.readBoolean();
        int n = objectInput.readInt();
        this.uuid = new byte[n];
        objectInput.readFully(this.uuid);
        n = objectInput.readInt();
        this.rpcId = new byte[n];
        objectInput.readFully(this.rpcId);
        this.message = (Serializable)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.reply);
        objectOutput.writeInt(this.uuid.length);
        objectOutput.write(this.uuid, 0, this.uuid.length);
        objectOutput.writeInt(this.rpcId.length);
        objectOutput.write(this.rpcId, 0, this.rpcId.length);
        objectOutput.writeObject(this.message);
    }

    public String toString() {
        return "RpcMessage[" + super.toString() + "] rpcId=" + Arrays.toString(this.rpcId) + "; uuid=" + Arrays.toString(this.uuid) + "; msg=" + String.valueOf(this.message);
    }

    public static class NoRpcChannelReply
    extends RpcMessage {
        public NoRpcChannelReply() {
        }

        public NoRpcChannelReply(byte[] byArray, byte[] byArray2) {
            super(byArray, byArray2, null);
            this.reply = true;
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.reply = true;
            int n = objectInput.readInt();
            this.uuid = new byte[n];
            objectInput.readFully(this.uuid);
            n = objectInput.readInt();
            this.rpcId = new byte[n];
            objectInput.readFully(this.rpcId);
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.uuid.length);
            objectOutput.write(this.uuid, 0, this.uuid.length);
            objectOutput.writeInt(this.rpcId.length);
            objectOutput.write(this.rpcId, 0, this.rpcId.length);
        }
    }
}

