/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class Upgrade {
    private final String protocolName;
    private final String protocolVersion;

    private Upgrade(String string, String string2) {
        this.protocolName = string;
        this.protocolVersion = string2;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String toString() {
        if (this.protocolVersion == null) {
            return this.protocolName;
        }
        return this.protocolName + "/" + this.protocolVersion;
    }

    public static List<Upgrade> parse(Enumeration<String> enumeration) {
        try {
            ArrayList<Upgrade> arrayList = new ArrayList<Upgrade>();
            while (enumeration.hasMoreElements()) {
                SkipResult skipResult;
                String string = enumeration.nextElement();
                if (string == null) {
                    return null;
                }
                StringReader stringReader = new StringReader(string);
                do {
                    HttpParser.skipLws(stringReader);
                    String string2 = HttpParser.readToken(stringReader);
                    if (string2 == null || string2.isEmpty()) {
                        return null;
                    }
                    String string3 = null;
                    if (HttpParser.skipConstant(stringReader, "/") == SkipResult.FOUND && ((string3 = HttpParser.readToken(stringReader)) == null || string3.isEmpty())) {
                        return null;
                    }
                    HttpParser.skipLws(stringReader);
                    skipResult = HttpParser.skipConstant(stringReader, ",");
                    if (skipResult == SkipResult.NOT_FOUND) {
                        return null;
                    }
                    arrayList.add(new Upgrade(string2, string3));
                } while (skipResult == SkipResult.FOUND);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

