// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAMS70J19.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsams70j19

/*
// Microchip ATSAMS70J19 Microcontroller
*/

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAMS70J19"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Supply Controller
	IRQ_SUPC = 0

	// Reset Controller
	IRQ_RSTC = 1

	// Real-time Clock
	IRQ_RTC = 2

	// Real-time Timer
	IRQ_RTT = 3

	// Watchdog Timer
	IRQ_WDT = 4

	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller
	IRQ_EFC = 6

	// Universal Asynchronous Receiver Transmitter
	IRQ_UART0 = 7

	IRQ_UART1 = 8

	// Parallel Input/Output Controller
	IRQ_PIOA = 10

	IRQ_PIOB = 11

	// Universal Synchronous Asynchronous Receiver Transmitter
	IRQ_USART0 = 13

	IRQ_USART1 = 14

	IRQ_PIOD = 16

	// Two-wire Interface High Speed
	IRQ_TWIHS0 = 19

	IRQ_TWIHS1 = 20

	// Synchronous Serial Controller
	IRQ_SSC = 22

	// Timer Counter
	IRQ_TC0 = 23

	// Timer Counter
	IRQ_TC1 = 24

	// Timer Counter
	IRQ_TC2 = 25

	IRQ_TC3 = 26

	IRQ_TC4 = 27

	IRQ_TC5 = 28

	// Analog Front-End Controller
	IRQ_AFEC0 = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM0 = 31

	// Integrity Check Monitor
	IRQ_ICM = 32

	// Analog Comparator Controller
	IRQ_ACC = 33

	// USB High-Speed Interface
	IRQ_USBHS = 34

	IRQ_AFEC1 = 40

	// Quad Serial Peripheral Interface
	IRQ_QSPI = 43

	IRQ_UART2 = 44

	IRQ_TC6 = 47

	IRQ_TC7 = 48

	IRQ_TC8 = 49

	IRQ_TC9 = 50

	IRQ_TC10 = 51

	IRQ_TC11 = 52

	// Advanced Encryption Standard
	IRQ_AES = 56

	// True Random Number Generator
	IRQ_TRNG = 57

	// Extensible DMA Controller
	IRQ_XDMAC = 58

	// Image Sensor Interface
	IRQ_ISI = 59

	IRQ_PWM1 = 60

	// Floating Point Unit
	IRQ_FPU = 61

	// Reinforced Safety Watchdog Timer
	IRQ_RSWDT = 63

	// Floating Point Unit
	IRQ_IXC = 68

	// Highest interrupt number on this device.
	IRQ_max = 68
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SUPC_IRQHandler
func interruptSUPC() {
	callHandlers(IRQ_SUPC)
}

//export RSTC_IRQHandler
func interruptRSTC() {
	callHandlers(IRQ_RSTC)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export RTT_IRQHandler
func interruptRTT() {
	callHandlers(IRQ_RTT)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC_IRQHandler
func interruptEFC() {
	callHandlers(IRQ_EFC)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export PIOD_IRQHandler
func interruptPIOD() {
	callHandlers(IRQ_PIOD)
}

//export TWIHS0_IRQHandler
func interruptTWIHS0() {
	callHandlers(IRQ_TWIHS0)
}

//export TWIHS1_IRQHandler
func interruptTWIHS1() {
	callHandlers(IRQ_TWIHS1)
}

//export SSC_IRQHandler
func interruptSSC() {
	callHandlers(IRQ_SSC)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export AFEC0_IRQHandler
func interruptAFEC0() {
	callHandlers(IRQ_AFEC0)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export ICM_IRQHandler
func interruptICM() {
	callHandlers(IRQ_ICM)
}

//export ACC_IRQHandler
func interruptACC() {
	callHandlers(IRQ_ACC)
}

//export USBHS_IRQHandler
func interruptUSBHS() {
	callHandlers(IRQ_USBHS)
}

//export AFEC1_IRQHandler
func interruptAFEC1() {
	callHandlers(IRQ_AFEC1)
}

//export QSPI_IRQHandler
func interruptQSPI() {
	callHandlers(IRQ_QSPI)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export TC6_IRQHandler
func interruptTC6() {
	callHandlers(IRQ_TC6)
}

//export TC7_IRQHandler
func interruptTC7() {
	callHandlers(IRQ_TC7)
}

//export TC8_IRQHandler
func interruptTC8() {
	callHandlers(IRQ_TC8)
}

//export TC9_IRQHandler
func interruptTC9() {
	callHandlers(IRQ_TC9)
}

//export TC10_IRQHandler
func interruptTC10() {
	callHandlers(IRQ_TC10)
}

//export TC11_IRQHandler
func interruptTC11() {
	callHandlers(IRQ_TC11)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export XDMAC_IRQHandler
func interruptXDMAC() {
	callHandlers(IRQ_XDMAC)
}

//export ISI_IRQHandler
func interruptISI() {
	callHandlers(IRQ_ISI)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export RSWDT_IRQHandler
func interruptRSWDT() {
	callHandlers(IRQ_RSWDT)
}

//export IXC_IRQHandler
func interruptIXC() {
	callHandlers(IRQ_IXC)
}

// Peripherals.
var (
	// Analog Comparator Controller
	ACC = (*ACC_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// Analog Front-End Controller
	AFEC0 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0940)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Embedded Flash Controller
	EFC = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0c00)))

	// General Purpose Backup Registers
	GPBR = (*GPBR_Type)(unsafe.Pointer(uintptr(0x400e1890)))

	// Integrity Check Monitor
	ICM = (*ICM_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Parallel Input/Output Controller
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Pulse Width Modulation Controller
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Quad Serial Peripheral Interface
	QSPI = (*QSPI_Type)(unsafe.Pointer(uintptr(0x4007c000)))

	// Reset Controller
	RSTC = (*RSTC_Type)(unsafe.Pointer(uintptr(0x400e1800)))

	// Reinforced Safety Watchdog Timer
	RSWDT = (*RSWDT_Type)(unsafe.Pointer(uintptr(0x400e1900)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x400e1860)))

	// Real-time Timer
	RTT = (*RTT_Type)(unsafe.Pointer(uintptr(0x400e1830)))

	// Synchronous Serial Controller
	SSC = (*SSC_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Supply Controller
	SUPC = (*SUPC_Type)(unsafe.Pointer(uintptr(0x400e1810)))

	// Timer Counter
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// Two-wire Interface High Speed
	TWIHS0 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Universal Asynchronous Receiver Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// USB High-Speed Interface
	USBHS = (*USBHS_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// USB Transmitter Interface Macrocell
	UTMI = (*UTMI_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x400e1850)))

	// Extensible DMA Controller
	XDMAC = (*XDMAC_Type)(unsafe.Pointer(uintptr(0x40078000)))

	LOCKBIT = (*LOCKBIT_Type)(unsafe.Pointer(uintptr(0x0)))

	// System control not in SCB
	SCnSCB = (*SCnSCB_Type)(unsafe.Pointer(uintptr(0xe000e000)))

	// System Control Block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// System timer
	SysTick = (*SysTick_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory Protection Unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// Floating Point Unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef30)))

	// Analog Front-End Controller
	AFEC1 = (*AFEC_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Parallel Input/Output Controller
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Parallel Input/Output Controller
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Pulse Width Modulation Controller
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// Timer Counter
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer Counter
	TC2 = (*TC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Timer Counter
	TC3 = (*TC_Type)(unsafe.Pointer(uintptr(0x40054000)))

	// Two-wire Interface High Speed
	TWIHS1 = (*TWIHS_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Universal Asynchronous Receiver Transmitter
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Universal Asynchronous Receiver Transmitter
	UART2 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e1a00)))

	// Universal Synchronous Asynchronous Receiver Transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))
)

// Analog Comparator Controller
type ACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	_    [28]byte
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	ISR  volatile.Register32 // 0x30
	_    [96]byte
	ACR  volatile.Register32 // 0x94
	_    [76]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// ACC.CR: Control Register
func (o *ACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ACC.MR: Mode Register
func (o *ACC_Type) SetMR_SELMINUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *ACC_Type) GetMR_SELMINUS() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}
func (o *ACC_Type) SetMR_SELPLUS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70)|value<<4)
}
func (o *ACC_Type) GetMR_SELPLUS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70) >> 4
}
func (o *ACC_Type) SetMR_ACEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *ACC_Type) GetMR_ACEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *ACC_Type) SetMR_EDGETYP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x600)|value<<9)
}
func (o *ACC_Type) GetMR_EDGETYP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x600) >> 9
}
func (o *ACC_Type) SetMR_INV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *ACC_Type) GetMR_INV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *ACC_Type) SetMR_SELFS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *ACC_Type) GetMR_SELFS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *ACC_Type) SetMR_FE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *ACC_Type) GetMR_FE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}

// ACC.IER: Interrupt Enable Register
func (o *ACC_Type) SetIER_CE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIER_CE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ACC.IDR: Interrupt Disable Register
func (o *ACC_Type) SetIDR_CE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIDR_CE() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// ACC.IMR: Interrupt Mask Register
func (o *ACC_Type) SetIMR_CE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetIMR_CE() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// ACC.ISR: Interrupt Status Register
func (o *ACC_Type) SetISR_CE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetISR_CE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ACC_Type) SetISR_SCO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ACC_Type) GetISR_SCO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ACC_Type) SetISR_MASK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *ACC_Type) GetISR_MASK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// ACC.ACR: Analog Control Register
func (o *ACC_Type) SetACR_ISEL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetACR_ISEL() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *ACC_Type) SetACR_HYST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x6)|value<<1)
}
func (o *ACC_Type) GetACR_HYST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x6) >> 1
}

// ACC.WPMR: Write Protection Mode Register
func (o *ACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ACC.WPSR: Write Protection Status Register
func (o *ACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}

// Advanced Encryption Standard
type AES_Type struct {
	CR      volatile.Register32 // 0x0
	MR      volatile.Register32 // 0x4
	_       [8]byte
	IER     volatile.Register32    // 0x10
	IDR     volatile.Register32    // 0x14
	IMR     volatile.Register32    // 0x18
	ISR     volatile.Register32    // 0x1C
	KEYWR   [8]volatile.Register32 // 0x20
	IDATAR  [4]volatile.Register32 // 0x40
	ODATAR  [4]volatile.Register32 // 0x50
	IVR     [4]volatile.Register32 // 0x60
	AADLENR volatile.Register32    // 0x70
	CLENR   volatile.Register32    // 0x74
	GHASHR  [4]volatile.Register32 // 0x78
	TAGR    [4]volatile.Register32 // 0x88
	CTRR    volatile.Register32    // 0x98
	GCMHR   [4]volatile.Register32 // 0x9C
}

// AES.CR: Control Register
func (o *AES_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AES_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// AES.MR: Mode Register
func (o *AES_Type) SetMR_CIPHER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetMR_CIPHER() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AES_Type) SetMR_GTAGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetMR_GTAGEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetMR_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetMR_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetMR_PROCDLY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0)|value<<4)
}
func (o *AES_Type) GetMR_PROCDLY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0) >> 4
}
func (o *AES_Type) SetMR_SMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x300)|value<<8)
}
func (o *AES_Type) GetMR_SMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x300) >> 8
}
func (o *AES_Type) SetMR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc00)|value<<10)
}
func (o *AES_Type) GetMR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc00) >> 10
}
func (o *AES_Type) SetMR_OPMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000)|value<<12)
}
func (o *AES_Type) GetMR_OPMOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000) >> 12
}
func (o *AES_Type) SetMR_LOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *AES_Type) GetMR_LOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *AES_Type) SetMR_CFBS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70000)|value<<16)
}
func (o *AES_Type) GetMR_CFBS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70000) >> 16
}
func (o *AES_Type) SetMR_CKEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00000)|value<<20)
}
func (o *AES_Type) GetMR_CKEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00000) >> 20
}

// AES.IER: Interrupt Enable Register
func (o *AES_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AES_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIER_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIER_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}

// AES.IDR: Interrupt Disable Register
func (o *AES_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AES_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIDR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIDR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}

// AES.IMR: Interrupt Mask Register
func (o *AES_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AES_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetIMR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetIMR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}

// AES.ISR: Interrupt Status Register
func (o *AES_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *AES_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetISR_URAT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf000)|value<<12)
}
func (o *AES_Type) GetISR_URAT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf000) >> 12
}
func (o *AES_Type) SetISR_TAGRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetISR_TAGRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// AES.KEYWR: Key Word Register 0
func (o *AES_Type) SetKEYWR(idx int, value uint32) {
	volatile.StoreUint32(&o.KEYWR[idx].Reg, value)
}
func (o *AES_Type) GetKEYWR(idx int) uint32 {
	return volatile.LoadUint32(&o.KEYWR[idx].Reg)
}

// AES.IDATAR: Input Data Register 0
func (o *AES_Type) SetIDATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.IDATAR[idx].Reg, value)
}
func (o *AES_Type) GetIDATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.IDATAR[idx].Reg)
}

// AES.ODATAR: Output Data Register 0
func (o *AES_Type) SetODATAR(idx int, value uint32) {
	volatile.StoreUint32(&o.ODATAR[idx].Reg, value)
}
func (o *AES_Type) GetODATAR(idx int) uint32 {
	return volatile.LoadUint32(&o.ODATAR[idx].Reg)
}

// AES.IVR: Initialization Vector Register 0
func (o *AES_Type) SetIVR(idx int, value uint32) {
	volatile.StoreUint32(&o.IVR[idx].Reg, value)
}
func (o *AES_Type) GetIVR(idx int) uint32 {
	return volatile.LoadUint32(&o.IVR[idx].Reg)
}

// AES.AADLENR: Additional Authenticated Data Length Register
func (o *AES_Type) SetAADLENR(value uint32) {
	volatile.StoreUint32(&o.AADLENR.Reg, value)
}
func (o *AES_Type) GetAADLENR() uint32 {
	return volatile.LoadUint32(&o.AADLENR.Reg)
}

// AES.CLENR: Plaintext/Ciphertext Length Register
func (o *AES_Type) SetCLENR(value uint32) {
	volatile.StoreUint32(&o.CLENR.Reg, value)
}
func (o *AES_Type) GetCLENR() uint32 {
	return volatile.LoadUint32(&o.CLENR.Reg)
}

// AES.GHASHR: GCM Intermediate Hash Word Register 0
func (o *AES_Type) SetGHASHR(idx int, value uint32) {
	volatile.StoreUint32(&o.GHASHR[idx].Reg, value)
}
func (o *AES_Type) GetGHASHR(idx int) uint32 {
	return volatile.LoadUint32(&o.GHASHR[idx].Reg)
}

// AES.TAGR: GCM Authentication Tag Word Register 0
func (o *AES_Type) SetTAGR(idx int, value uint32) {
	volatile.StoreUint32(&o.TAGR[idx].Reg, value)
}
func (o *AES_Type) GetTAGR(idx int) uint32 {
	return volatile.LoadUint32(&o.TAGR[idx].Reg)
}

// AES.CTRR: GCM Encryption Counter Value Register
func (o *AES_Type) SetCTRR(value uint32) {
	volatile.StoreUint32(&o.CTRR.Reg, value)
}
func (o *AES_Type) GetCTRR() uint32 {
	return volatile.LoadUint32(&o.CTRR.Reg)
}

// AES.GCMHR: GCM H Word Register 0
func (o *AES_Type) SetGCMHR(idx int, value uint32) {
	volatile.StoreUint32(&o.GCMHR[idx].Reg, value)
}
func (o *AES_Type) GetGCMHR(idx int) uint32 {
	return volatile.LoadUint32(&o.GCMHR[idx].Reg)
}

// Analog Front-End Controller
type AFEC_Type struct {
	CR      volatile.Register32 // 0x0
	MR      volatile.Register32 // 0x4
	EMR     volatile.Register32 // 0x8
	SEQ1R   volatile.Register32 // 0xC
	SEQ2R   volatile.Register32 // 0x10
	CHER    volatile.Register32 // 0x14
	CHDR    volatile.Register32 // 0x18
	CHSR    volatile.Register32 // 0x1C
	LCDR    volatile.Register32 // 0x20
	IER     volatile.Register32 // 0x24
	IDR     volatile.Register32 // 0x28
	IMR     volatile.Register32 // 0x2C
	ISR     volatile.Register32 // 0x30
	_       [24]byte
	OVER    volatile.Register32 // 0x4C
	CWR     volatile.Register32 // 0x50
	CGR     volatile.Register32 // 0x54
	_       [8]byte
	DIFFR   volatile.Register32 // 0x60
	CSELR   volatile.Register32 // 0x64
	CDR     volatile.Register32 // 0x68
	COCR    volatile.Register32 // 0x6C
	TEMPMR  volatile.Register32 // 0x70
	TEMPCWR volatile.Register32 // 0x74
	_       [28]byte
	ACR     volatile.Register32 // 0x94
	_       [8]byte
	SHMR    volatile.Register32 // 0xA0
	_       [44]byte
	COSR    volatile.Register32 // 0xD0
	CVR     volatile.Register32 // 0xD4
	CECR    volatile.Register32 // 0xD8
	_       [8]byte
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
}

// AFEC.CR: AFEC Control Register
func (o *AFEC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *AFEC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// AFEC.MR: AFEC Mode Register
func (o *AFEC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AFEC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *AFEC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *AFEC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetMR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetMR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *AFEC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *AFEC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetMR_ONE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *AFEC_Type) GetMR_ONE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *AFEC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetMR_TRANSFER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetMR_TRANSFER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}
func (o *AFEC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *AFEC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// AFEC.EMR: AFEC Extended Mode Register
func (o *AFEC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *AFEC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf8)|value<<3)
}
func (o *AFEC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf8) >> 3
}
func (o *AFEC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetEMR_CMPFILTER(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetEMR_CMPFILTER() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetEMR_RES(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x70000)|value<<16)
}
func (o *AFEC_Type) GetEMR_RES() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x70000) >> 16
}
func (o *AFEC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetEMR_STM(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetEMR_STM() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetEMR_SIGNMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30000000)|value<<28)
}
func (o *AFEC_Type) GetEMR_SIGNMODE() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30000000) >> 28
}

// AFEC.SEQ1R: AFEC Channel Sequence 1 Register
func (o *AFEC_Type) SetSEQ1R_USCH0(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetSEQ1R_USCH0() uint32 {
	return volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf
}
func (o *AFEC_Type) SetSEQ1R_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetSEQ1R_USCH1() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetSEQ1R_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetSEQ1R_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetSEQ1R_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetSEQ1R_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf000) >> 12
}
func (o *AFEC_Type) SetSEQ1R_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0000)|value<<16)
}
func (o *AFEC_Type) GetSEQ1R_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0000) >> 16
}
func (o *AFEC_Type) SetSEQ1R_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf00000)|value<<20)
}
func (o *AFEC_Type) GetSEQ1R_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf00000) >> 20
}
func (o *AFEC_Type) SetSEQ1R_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetSEQ1R_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf000000) >> 24
}
func (o *AFEC_Type) SetSEQ1R_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQ1R.Reg, volatile.LoadUint32(&o.SEQ1R.Reg)&^(0xf0000000)|value<<28)
}
func (o *AFEC_Type) GetSEQ1R_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQ1R.Reg) & 0xf0000000) >> 28
}

// AFEC.SEQ2R: AFEC Channel Sequence 2 Register
func (o *AFEC_Type) SetSEQ2R_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetSEQ2R_USCH8() uint32 {
	return volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf
}
func (o *AFEC_Type) SetSEQ2R_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf0)|value<<4)
}
func (o *AFEC_Type) GetSEQ2R_USCH9() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf0) >> 4
}
func (o *AFEC_Type) SetSEQ2R_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf00)|value<<8)
}
func (o *AFEC_Type) GetSEQ2R_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf00) >> 8
}
func (o *AFEC_Type) SetSEQ2R_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQ2R.Reg, volatile.LoadUint32(&o.SEQ2R.Reg)&^(0xf000)|value<<12)
}
func (o *AFEC_Type) GetSEQ2R_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQ2R.Reg) & 0xf000) >> 12
}

// AFEC.CHER: AFEC Channel Enable Register
func (o *AFEC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *AFEC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}

// AFEC.CHDR: AFEC Channel Disable Register
func (o *AFEC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *AFEC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}

// AFEC.CHSR: AFEC Channel Status Register
func (o *AFEC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *AFEC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}

// AFEC.LCDR: AFEC Last Converted Data Register
func (o *AFEC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xffff
}
func (o *AFEC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000000)|value<<24)
}
func (o *AFEC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000000) >> 24
}

// AFEC.IER: AFEC Interrupt Enable Register
func (o *AFEC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AFEC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIER_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIER_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// AFEC.IDR: AFEC Interrupt Disable Register
func (o *AFEC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AFEC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIDR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIDR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// AFEC.IMR: AFEC Interrupt Mask Register
func (o *AFEC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AFEC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetIMR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetIMR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// AFEC.ISR: AFEC Interrupt Status Register
func (o *AFEC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *AFEC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *AFEC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *AFEC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *AFEC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *AFEC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *AFEC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *AFEC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *AFEC_Type) SetISR_TEMPCHG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *AFEC_Type) GetISR_TEMPCHG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}

// AFEC.OVER: AFEC Overrun Status Register
func (o *AFEC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *AFEC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}

// AFEC.CWR: AFEC Compare Window Register
func (o *AFEC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xffff0000) >> 16
}

// AFEC.CGR: AFEC Channel Gain Register
func (o *AFEC_Type) SetCGR_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3)|value)
}
func (o *AFEC_Type) GetCGR_GAIN0() uint32 {
	return volatile.LoadUint32(&o.CGR.Reg) & 0x3
}
func (o *AFEC_Type) SetCGR_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc)|value<<2)
}
func (o *AFEC_Type) GetCGR_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc) >> 2
}
func (o *AFEC_Type) SetCGR_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetCGR_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30) >> 4
}
func (o *AFEC_Type) SetCGR_GAIN3(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0)|value<<6)
}
func (o *AFEC_Type) GetCGR_GAIN3() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0) >> 6
}
func (o *AFEC_Type) SetCGR_GAIN4(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetCGR_GAIN4() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300) >> 8
}
func (o *AFEC_Type) SetCGR_GAIN5(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00)|value<<10)
}
func (o *AFEC_Type) GetCGR_GAIN5() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00) >> 10
}
func (o *AFEC_Type) SetCGR_GAIN6(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x3000)|value<<12)
}
func (o *AFEC_Type) GetCGR_GAIN6() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x3000) >> 12
}
func (o *AFEC_Type) SetCGR_GAIN7(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc000)|value<<14)
}
func (o *AFEC_Type) GetCGR_GAIN7() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc000) >> 14
}
func (o *AFEC_Type) SetCGR_GAIN8(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x30000)|value<<16)
}
func (o *AFEC_Type) GetCGR_GAIN8() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x30000) >> 16
}
func (o *AFEC_Type) SetCGR_GAIN9(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc0000)|value<<18)
}
func (o *AFEC_Type) GetCGR_GAIN9() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc0000) >> 18
}
func (o *AFEC_Type) SetCGR_GAIN10(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0x300000)|value<<20)
}
func (o *AFEC_Type) GetCGR_GAIN10() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0x300000) >> 20
}
func (o *AFEC_Type) SetCGR_GAIN11(value uint32) {
	volatile.StoreUint32(&o.CGR.Reg, volatile.LoadUint32(&o.CGR.Reg)&^(0xc00000)|value<<22)
}
func (o *AFEC_Type) GetCGR_GAIN11() uint32 {
	return (volatile.LoadUint32(&o.CGR.Reg) & 0xc00000) >> 22
}

// AFEC.DIFFR: AFEC Channel Differential Register
func (o *AFEC_Type) SetDIFFR_DIFF0(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetDIFFR_DIFF0() uint32 {
	return volatile.LoadUint32(&o.DIFFR.Reg) & 0x1
}
func (o *AFEC_Type) SetDIFFR_DIFF1(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetDIFFR_DIFF1() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetDIFFR_DIFF2(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetDIFFR_DIFF2() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetDIFFR_DIFF3(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetDIFFR_DIFF3() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetDIFFR_DIFF4(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetDIFFR_DIFF4() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetDIFFR_DIFF5(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetDIFFR_DIFF5() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetDIFFR_DIFF6(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetDIFFR_DIFF6() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetDIFFR_DIFF7(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetDIFFR_DIFF7() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetDIFFR_DIFF8(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetDIFFR_DIFF8() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetDIFFR_DIFF9(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetDIFFR_DIFF9() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetDIFFR_DIFF10(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetDIFFR_DIFF10() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetDIFFR_DIFF11(value uint32) {
	volatile.StoreUint32(&o.DIFFR.Reg, volatile.LoadUint32(&o.DIFFR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetDIFFR_DIFF11() uint32 {
	return (volatile.LoadUint32(&o.DIFFR.Reg) & 0x800) >> 11
}

// AFEC.CSELR: AFEC Channel Selection Register
func (o *AFEC_Type) SetCSELR_CSEL(value uint32) {
	volatile.StoreUint32(&o.CSELR.Reg, volatile.LoadUint32(&o.CSELR.Reg)&^(0xf)|value)
}
func (o *AFEC_Type) GetCSELR_CSEL() uint32 {
	return volatile.LoadUint32(&o.CSELR.Reg) & 0xf
}

// AFEC.CDR: AFEC Channel Data Register
func (o *AFEC_Type) SetCDR_DATA(value uint32) {
	volatile.StoreUint32(&o.CDR.Reg, volatile.LoadUint32(&o.CDR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCDR_DATA() uint32 {
	return volatile.LoadUint32(&o.CDR.Reg) & 0xffff
}

// AFEC.COCR: AFEC Channel Offset Compensation Register
func (o *AFEC_Type) SetCOCR_AOFF(value uint32) {
	volatile.StoreUint32(&o.COCR.Reg, volatile.LoadUint32(&o.COCR.Reg)&^(0x3ff)|value)
}
func (o *AFEC_Type) GetCOCR_AOFF() uint32 {
	return volatile.LoadUint32(&o.COCR.Reg) & 0x3ff
}

// AFEC.TEMPMR: AFEC Temperature Sensor Mode Register
func (o *AFEC_Type) SetTEMPMR_RTCT(value uint32) {
	volatile.StoreUint32(&o.TEMPMR.Reg, volatile.LoadUint32(&o.TEMPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetTEMPMR_RTCT() uint32 {
	return volatile.LoadUint32(&o.TEMPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetTEMPMR_TEMPCMPMOD(value uint32) {
	volatile.StoreUint32(&o.TEMPMR.Reg, volatile.LoadUint32(&o.TEMPMR.Reg)&^(0x30)|value<<4)
}
func (o *AFEC_Type) GetTEMPMR_TEMPCMPMOD() uint32 {
	return (volatile.LoadUint32(&o.TEMPMR.Reg) & 0x30) >> 4
}

// AFEC.TEMPCWR: AFEC Temperature Compare Window Register
func (o *AFEC_Type) SetTEMPCWR_TLOWTHRES(value uint32) {
	volatile.StoreUint32(&o.TEMPCWR.Reg, volatile.LoadUint32(&o.TEMPCWR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetTEMPCWR_TLOWTHRES() uint32 {
	return volatile.LoadUint32(&o.TEMPCWR.Reg) & 0xffff
}
func (o *AFEC_Type) SetTEMPCWR_THIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.TEMPCWR.Reg, volatile.LoadUint32(&o.TEMPCWR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetTEMPCWR_THIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.TEMPCWR.Reg) & 0xffff0000) >> 16
}

// AFEC.ACR: AFEC Analog Control Register
func (o *AFEC_Type) SetACR_PGA0EN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetACR_PGA0EN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetACR_PGA1EN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetACR_PGA1EN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetACR_IBCTL(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x300)|value<<8)
}
func (o *AFEC_Type) GetACR_IBCTL() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x300) >> 8
}

// AFEC.SHMR: AFEC Sample & Hold Mode Register
func (o *AFEC_Type) SetSHMR_DUAL0(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetSHMR_DUAL0() uint32 {
	return volatile.LoadUint32(&o.SHMR.Reg) & 0x1
}
func (o *AFEC_Type) SetSHMR_DUAL1(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetSHMR_DUAL1() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetSHMR_DUAL2(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetSHMR_DUAL2() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetSHMR_DUAL3(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetSHMR_DUAL3() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetSHMR_DUAL4(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetSHMR_DUAL4() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetSHMR_DUAL5(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetSHMR_DUAL5() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetSHMR_DUAL6(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetSHMR_DUAL6() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetSHMR_DUAL7(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetSHMR_DUAL7() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetSHMR_DUAL8(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetSHMR_DUAL8() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetSHMR_DUAL9(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetSHMR_DUAL9() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetSHMR_DUAL10(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetSHMR_DUAL10() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetSHMR_DUAL11(value uint32) {
	volatile.StoreUint32(&o.SHMR.Reg, volatile.LoadUint32(&o.SHMR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetSHMR_DUAL11() uint32 {
	return (volatile.LoadUint32(&o.SHMR.Reg) & 0x800) >> 11
}

// AFEC.COSR: AFEC Correction Select Register
func (o *AFEC_Type) SetCOSR_CSEL(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCOSR_CSEL() uint32 {
	return volatile.LoadUint32(&o.COSR.Reg) & 0x1
}

// AFEC.CVR: AFEC Correction Values Register
func (o *AFEC_Type) SetCVR_OFFSETCORR(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffff)|value)
}
func (o *AFEC_Type) GetCVR_OFFSETCORR() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffff
}
func (o *AFEC_Type) SetCVR_GAINCORR(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffff0000)|value<<16)
}
func (o *AFEC_Type) GetCVR_GAINCORR() uint32 {
	return (volatile.LoadUint32(&o.CVR.Reg) & 0xffff0000) >> 16
}

// AFEC.CECR: AFEC Channel Error Correction Register
func (o *AFEC_Type) SetCECR_ECORR0(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetCECR_ECORR0() uint32 {
	return volatile.LoadUint32(&o.CECR.Reg) & 0x1
}
func (o *AFEC_Type) SetCECR_ECORR1(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x2)|value<<1)
}
func (o *AFEC_Type) GetCECR_ECORR1() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x2) >> 1
}
func (o *AFEC_Type) SetCECR_ECORR2(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x4)|value<<2)
}
func (o *AFEC_Type) GetCECR_ECORR2() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x4) >> 2
}
func (o *AFEC_Type) SetCECR_ECORR3(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x8)|value<<3)
}
func (o *AFEC_Type) GetCECR_ECORR3() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x8) >> 3
}
func (o *AFEC_Type) SetCECR_ECORR4(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x10)|value<<4)
}
func (o *AFEC_Type) GetCECR_ECORR4() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x10) >> 4
}
func (o *AFEC_Type) SetCECR_ECORR5(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x20)|value<<5)
}
func (o *AFEC_Type) GetCECR_ECORR5() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x20) >> 5
}
func (o *AFEC_Type) SetCECR_ECORR6(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x40)|value<<6)
}
func (o *AFEC_Type) GetCECR_ECORR6() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x40) >> 6
}
func (o *AFEC_Type) SetCECR_ECORR7(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x80)|value<<7)
}
func (o *AFEC_Type) GetCECR_ECORR7() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x80) >> 7
}
func (o *AFEC_Type) SetCECR_ECORR8(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x100)|value<<8)
}
func (o *AFEC_Type) GetCECR_ECORR8() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x100) >> 8
}
func (o *AFEC_Type) SetCECR_ECORR9(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x200)|value<<9)
}
func (o *AFEC_Type) GetCECR_ECORR9() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x200) >> 9
}
func (o *AFEC_Type) SetCECR_ECORR10(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x400)|value<<10)
}
func (o *AFEC_Type) GetCECR_ECORR10() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x400) >> 10
}
func (o *AFEC_Type) SetCECR_ECORR11(value uint32) {
	volatile.StoreUint32(&o.CECR.Reg, volatile.LoadUint32(&o.CECR.Reg)&^(0x800)|value<<11)
}
func (o *AFEC_Type) GetCECR_ECORR11() uint32 {
	return (volatile.LoadUint32(&o.CECR.Reg) & 0x800) >> 11
}

// AFEC.WPMR: AFEC Write Protection Mode Register
func (o *AFEC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *AFEC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *AFEC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// AFEC.WPSR: AFEC Write Protection Status Register
func (o *AFEC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *AFEC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *AFEC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *AFEC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	TRIGR volatile.Register32 // 0x8
	_     [4]byte
	CHER  volatile.Register32    // 0x10
	CHDR  volatile.Register32    // 0x14
	CHSR  volatile.Register32    // 0x18
	CDR   [2]volatile.Register32 // 0x1C
	IER   volatile.Register32    // 0x24
	IDR   volatile.Register32    // 0x28
	IMR   volatile.Register32    // 0x2C
	ISR   volatile.Register32    // 0x30
	_     [96]byte
	ACR   volatile.Register32 // 0x94
	_     [76]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// DACC.CR: Control Register
func (o *DACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DACC.MR: Mode Register
func (o *DACC_Type) SetMR_MAXS0(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetMR_MAXS0() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *DACC_Type) SetMR_MAXS1(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetMR_MAXS1() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetMR_WORD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetMR_WORD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetMR_ZERO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetMR_ZERO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *DACC_Type) SetMR_DIFF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *DACC_Type) GetMR_DIFF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *DACC_Type) SetMR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *DACC_Type) GetMR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// DACC.TRIGR: Trigger Register
func (o *DACC_Type) SetTRIGR_TRGEN0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetTRIGR_TRGEN0() uint32 {
	return volatile.LoadUint32(&o.TRIGR.Reg) & 0x1
}
func (o *DACC_Type) SetTRIGR_TRGEN1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetTRIGR_TRGEN1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetTRIGR_TRGSEL0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x70)|value<<4)
}
func (o *DACC_Type) GetTRIGR_TRGSEL0() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x70) >> 4
}
func (o *DACC_Type) SetTRIGR_TRGSEL1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x700)|value<<8)
}
func (o *DACC_Type) GetTRIGR_TRGSEL1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x700) >> 8
}
func (o *DACC_Type) SetTRIGR_OSR0(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x70000)|value<<16)
}
func (o *DACC_Type) GetTRIGR_OSR0() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x70000) >> 16
}
func (o *DACC_Type) SetTRIGR_OSR1(value uint32) {
	volatile.StoreUint32(&o.TRIGR.Reg, volatile.LoadUint32(&o.TRIGR.Reg)&^(0x700000)|value<<20)
}
func (o *DACC_Type) GetTRIGR_OSR1() uint32 {
	return (volatile.LoadUint32(&o.TRIGR.Reg) & 0x700000) >> 20
}

// DACC.CHER: Channel Enable Register
func (o *DACC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DACC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}

// DACC.CHDR: Channel Disable Register
func (o *DACC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DACC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}

// DACC.CHSR: Channel Status Register
func (o *DACC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DACC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetCHSR_DACRDY0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetCHSR_DACRDY0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetCHSR_DACRDY1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetCHSR_DACRDY1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}

// DACC.CDR: Conversion Data Register 0
func (o *DACC_Type) SetCDR_DATA0(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetCDR_DATA0(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xffff
}
func (o *DACC_Type) SetCDR_DATA1(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xffff0000)|value<<16)
}
func (o *DACC_Type) GetCDR_DATA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CDR[idx].Reg) & 0xffff0000) >> 16
}

// DACC.IER: Interrupt Enable Register
func (o *DACC_Type) SetIER_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIER_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DACC_Type) SetIER_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIER_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIER_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}

// DACC.IDR: Interrupt Disable Register
func (o *DACC_Type) SetIDR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIDR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DACC_Type) SetIDR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIDR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIDR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}

// DACC.IMR: Interrupt Mask Register
func (o *DACC_Type) SetIMR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIMR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DACC_Type) SetIMR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIMR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetIMR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}

// DACC.ISR: Interrupt Status Register
func (o *DACC_Type) SetISR_TXRDY0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetISR_TXRDY0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DACC_Type) SetISR_TXRDY1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetISR_TXRDY1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetISR_EOC0() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}

// DACC.ACR: Analog Current Register
func (o *DACC_Type) SetACR_IBCTLCH0(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x3)|value)
}
func (o *DACC_Type) GetACR_IBCTLCH0() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x3
}
func (o *DACC_Type) SetACR_IBCTLCH1(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xc)|value<<2)
}
func (o *DACC_Type) GetACR_IBCTLCH1() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xc) >> 2
}

// DACC.WPMR: Write Protection Mode Register
func (o *DACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.WPSR: Write Protection Status Register
func (o *DACC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Embedded Flash Controller
type EFC_Type struct {
	EEFC_FMR  volatile.Register32 // 0x0
	EEFC_FCR  volatile.Register32 // 0x4
	EEFC_FSR  volatile.Register32 // 0x8
	EEFC_FRR  volatile.Register32 // 0xC
	_         [212]byte
	EEFC_WPMR volatile.Register32 // 0xE4
}

// EFC.EEFC_FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetEEFC_FMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FMR_FWS(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetEEFC_FMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FMR_CLOE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FMR.Reg, volatile.LoadUint32(&o.EEFC_FMR.Reg)&^(0x4000000)|value<<26)
}
func (o *EFC_Type) GetEEFC_FMR_CLOE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FMR.Reg) & 0x4000000) >> 26
}

// EFC.EEFC_FCR: EEFC Flash Command Register
func (o *EFC_Type) SetEEFC_FCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetEEFC_FCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff
}
func (o *EFC_Type) SetEEFC_FCR_FARG(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_FCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetEEFC_FCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FCR.Reg, volatile.LoadUint32(&o.EEFC_FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetEEFC_FCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FCR.Reg) & 0xff000000) >> 24
}

// EFC.EEFC_FSR: EEFC Flash Status Register
func (o *EFC_Type) SetEEFC_FSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_FSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_FSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetEEFC_FSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetEEFC_FSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetEEFC_FSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x4) >> 2
}
func (o *EFC_Type) SetEEFC_FSR_FLERR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x8)|value<<3)
}
func (o *EFC_Type) GetEEFC_FSR_FLERR() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x8) >> 3
}
func (o *EFC_Type) SetEEFC_FSR_UECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetEEFC_FSR_UECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetEEFC_FSR_MECCELSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x20000)|value<<17)
}
func (o *EFC_Type) GetEEFC_FSR_MECCELSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x20000) >> 17
}
func (o *EFC_Type) SetEEFC_FSR_UECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x40000)|value<<18)
}
func (o *EFC_Type) GetEEFC_FSR_UECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x40000) >> 18
}
func (o *EFC_Type) SetEEFC_FSR_MECCEMSB(value uint32) {
	volatile.StoreUint32(&o.EEFC_FSR.Reg, volatile.LoadUint32(&o.EEFC_FSR.Reg)&^(0x80000)|value<<19)
}
func (o *EFC_Type) GetEEFC_FSR_MECCEMSB() uint32 {
	return (volatile.LoadUint32(&o.EEFC_FSR.Reg) & 0x80000) >> 19
}

// EFC.EEFC_FRR: EEFC Flash Result Register
func (o *EFC_Type) SetEEFC_FRR(value uint32) {
	volatile.StoreUint32(&o.EEFC_FRR.Reg, value)
}
func (o *EFC_Type) GetEEFC_FRR() uint32 {
	return volatile.LoadUint32(&o.EEFC_FRR.Reg)
}

// EFC.EEFC_WPMR: Write Protection Mode Register
func (o *EFC_Type) SetEEFC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetEEFC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0x1
}
func (o *EFC_Type) SetEEFC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.EEFC_WPMR.Reg, volatile.LoadUint32(&o.EEFC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EFC_Type) GetEEFC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.EEFC_WPMR.Reg) & 0xffffff00) >> 8
}

// General Purpose Backup Registers
type GPBR_Type struct {
	SYS_GPBR [8]volatile.Register32 // 0x0
}

// GPBR.SYS_GPBR: General Purpose Backup Register 0
func (o *GPBR_Type) SetSYS_GPBR(idx int, value uint32) {
	volatile.StoreUint32(&o.SYS_GPBR[idx].Reg, value)
}
func (o *GPBR_Type) GetSYS_GPBR(idx int) uint32 {
	return volatile.LoadUint32(&o.SYS_GPBR[idx].Reg)
}

// Integrity Check Monitor
type ICM_Type struct {
	CFG    volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	_      [4]byte
	IER    volatile.Register32 // 0x10
	IDR    volatile.Register32 // 0x14
	IMR    volatile.Register32 // 0x18
	ISR    volatile.Register32 // 0x1C
	UASR   volatile.Register32 // 0x20
	_      [12]byte
	DSCR   volatile.Register32    // 0x30
	HASH   volatile.Register32    // 0x34
	UIHVAL [8]volatile.Register32 // 0x38
}

// ICM.CFG: Configuration Register
func (o *ICM_Type) SetCFG_WBDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetCFG_WBDIS() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *ICM_Type) SetCFG_EOMDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetCFG_EOMDIS() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetCFG_SLBDIS(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetCFG_SLBDIS() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetCFG_BBC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetCFG_BBC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetCFG_ASCD(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *ICM_Type) GetCFG_ASCD() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *ICM_Type) SetCFG_DUALBUFF(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x200)|value<<9)
}
func (o *ICM_Type) GetCFG_DUALBUFF() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x200) >> 9
}
func (o *ICM_Type) SetCFG_UIHASH(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *ICM_Type) GetCFG_UIHASH() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}
func (o *ICM_Type) SetCFG_UALGO(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0xe000)|value<<13)
}
func (o *ICM_Type) GetCFG_UALGO() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0xe000) >> 13
}

// ICM.CTRL: Control Register
func (o *ICM_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *ICM_Type) SetCTRL_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ICM_Type) GetCTRL_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *ICM_Type) SetCTRL_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ICM_Type) GetCTRL_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *ICM_Type) SetCTRL_REHASH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetCTRL_REHASH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetCTRL_RMDIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetCTRL_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetCTRL_RMEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetCTRL_RMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xf000) >> 12
}

// ICM.SR: Status Register
func (o *ICM_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ICM_Type) GetSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ICM_Type) SetSR_RAWRMDIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetSR_RAWRMDIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetSR_RMDIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetSR_RMDIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xf000) >> 12
}

// ICM.IER: Interrupt Enable Register
func (o *ICM_Type) SetIER_RHC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIER_RHC() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0xf
}
func (o *ICM_Type) SetIER_RDM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIER_RDM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIER_RBE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIER_RBE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIER_RWC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIER_RWC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIER_REC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIER_REC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIER_RSU(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIER_RSU() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIER_URAD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIER_URAD() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// ICM.IDR: Interrupt Disable Register
func (o *ICM_Type) SetIDR_RHC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIDR_RHC() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xf
}
func (o *ICM_Type) SetIDR_RDM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIDR_RDM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIDR_RBE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIDR_RBE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIDR_RWC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIDR_RWC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIDR_REC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIDR_REC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIDR_RSU(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIDR_RSU() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIDR_URAD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIDR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// ICM.IMR: Interrupt Mask Register
func (o *ICM_Type) SetIMR_RHC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetIMR_RHC() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0xf
}
func (o *ICM_Type) SetIMR_RDM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetIMR_RDM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetIMR_RBE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetIMR_RBE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetIMR_RWC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetIMR_RWC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetIMR_REC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetIMR_REC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetIMR_RSU(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetIMR_RSU() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetIMR_URAD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetIMR_URAD() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// ICM.ISR: Interrupt Status Register
func (o *ICM_Type) SetISR_RHC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf)|value)
}
func (o *ICM_Type) GetISR_RHC() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0xf
}
func (o *ICM_Type) SetISR_RDM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf0)|value<<4)
}
func (o *ICM_Type) GetISR_RDM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf0) >> 4
}
func (o *ICM_Type) SetISR_RBE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf00)|value<<8)
}
func (o *ICM_Type) GetISR_RBE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf00) >> 8
}
func (o *ICM_Type) SetISR_RWC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf000)|value<<12)
}
func (o *ICM_Type) GetISR_RWC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf000) >> 12
}
func (o *ICM_Type) SetISR_REC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf0000)|value<<16)
}
func (o *ICM_Type) GetISR_REC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf0000) >> 16
}
func (o *ICM_Type) SetISR_RSU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xf00000)|value<<20)
}
func (o *ICM_Type) GetISR_RSU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xf00000) >> 20
}
func (o *ICM_Type) SetISR_URAD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ICM_Type) GetISR_URAD() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}

// ICM.UASR: Undefined Access Status Register
func (o *ICM_Type) SetUASR_URAT(value uint32) {
	volatile.StoreUint32(&o.UASR.Reg, volatile.LoadUint32(&o.UASR.Reg)&^(0x7)|value)
}
func (o *ICM_Type) GetUASR_URAT() uint32 {
	return volatile.LoadUint32(&o.UASR.Reg) & 0x7
}

// ICM.DSCR: Region Descriptor Area Start Address Register
func (o *ICM_Type) SetDSCR_DASA(value uint32) {
	volatile.StoreUint32(&o.DSCR.Reg, volatile.LoadUint32(&o.DSCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *ICM_Type) GetDSCR_DASA() uint32 {
	return (volatile.LoadUint32(&o.DSCR.Reg) & 0xffffffc0) >> 6
}

// ICM.HASH: Region Hash Area Start Address Register
func (o *ICM_Type) SetHASH_HASA(value uint32) {
	volatile.StoreUint32(&o.HASH.Reg, volatile.LoadUint32(&o.HASH.Reg)&^(0xffffff80)|value<<7)
}
func (o *ICM_Type) GetHASH_HASA() uint32 {
	return (volatile.LoadUint32(&o.HASH.Reg) & 0xffffff80) >> 7
}

// ICM.UIHVAL: User Initial Hash Value 0 Register 0
func (o *ICM_Type) SetUIHVAL(idx int, value uint32) {
	volatile.StoreUint32(&o.UIHVAL[idx].Reg, value)
}
func (o *ICM_Type) GetUIHVAL(idx int) uint32 {
	return volatile.LoadUint32(&o.UIHVAL[idx].Reg)
}

// Image Sensor Interface
type ISI_Type struct {
	CFG1       volatile.Register32 // 0x0
	CFG2       volatile.Register32 // 0x4
	PSIZE      volatile.Register32 // 0x8
	PDECF      volatile.Register32 // 0xC
	Y2R_SET0   volatile.Register32 // 0x10
	Y2R_SET1   volatile.Register32 // 0x14
	R2Y_SET0   volatile.Register32 // 0x18
	R2Y_SET1   volatile.Register32 // 0x1C
	R2Y_SET2   volatile.Register32 // 0x20
	CR         volatile.Register32 // 0x24
	SR         volatile.Register32 // 0x28
	IER        volatile.Register32 // 0x2C
	IDR        volatile.Register32 // 0x30
	IMR        volatile.Register32 // 0x34
	DMA_CHER   volatile.Register32 // 0x38
	DMA_CHDR   volatile.Register32 // 0x3C
	DMA_CHSR   volatile.Register32 // 0x40
	DMA_P_ADDR volatile.Register32 // 0x44
	DMA_P_CTRL volatile.Register32 // 0x48
	DMA_P_DSCR volatile.Register32 // 0x4C
	DMA_C_ADDR volatile.Register32 // 0x50
	DMA_C_CTRL volatile.Register32 // 0x54
	DMA_C_DSCR volatile.Register32 // 0x58
	_          [136]byte
	WPMR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
}

// ISI.CFG1: ISI Configuration 1 Register
func (o *ISI_Type) SetCFG1_HSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCFG1_HSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCFG1_VSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetCFG1_VSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x8) >> 3
}
func (o *ISI_Type) SetCFG1_PIXCLK_POL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ISI_Type) GetCFG1_PIXCLK_POL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10) >> 4
}
func (o *ISI_Type) SetCFG1_GRAYLE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x20)|value<<5)
}
func (o *ISI_Type) GetCFG1_GRAYLE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x20) >> 5
}
func (o *ISI_Type) SetCFG1_EMB_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x40)|value<<6)
}
func (o *ISI_Type) GetCFG1_EMB_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x40) >> 6
}
func (o *ISI_Type) SetCFG1_CRC_SYNC(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ISI_Type) GetCFG1_CRC_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x80) >> 7
}
func (o *ISI_Type) SetCFG1_FRATE(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x700)|value<<8)
}
func (o *ISI_Type) GetCFG1_FRATE() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x700) >> 8
}
func (o *ISI_Type) SetCFG1_DISCR(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG1_DISCR() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG1_FULL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG1_FULL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG1_THMASK(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x6000)|value<<13)
}
func (o *ISI_Type) GetCFG1_THMASK() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x6000) >> 13
}
func (o *ISI_Type) SetCFG1_SLD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetCFG1_SLD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetCFG1_SFD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetCFG1_SFD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xff000000) >> 24
}

// ISI.CFG2: ISI Configuration 2 Register
func (o *ISI_Type) SetCFG2_IM_VSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff)|value)
}
func (o *ISI_Type) GetCFG2_IM_VSIZE() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff
}
func (o *ISI_Type) SetCFG2_GS_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetCFG2_GS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetCFG2_RGB_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetCFG2_RGB_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetCFG2_GRAYSCALE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetCFG2_GRAYSCALE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetCFG2_RGB_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetCFG2_RGB_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x4000) >> 14
}
func (o *ISI_Type) SetCFG2_COL_SPACE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *ISI_Type) GetCFG2_COL_SPACE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x8000) >> 15
}
func (o *ISI_Type) SetCFG2_IM_HSIZE(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ISI_Type) GetCFG2_IM_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7ff0000) >> 16
}
func (o *ISI_Type) SetCFG2_YCC_SWAP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *ISI_Type) GetCFG2_YCC_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}
func (o *ISI_Type) SetCFG2_RGB_CFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ISI_Type) GetCFG2_RGB_CFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xc0000000) >> 30
}

// ISI.PSIZE: ISI Preview Size Register
func (o *ISI_Type) SetPSIZE_PREV_VSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff)|value)
}
func (o *ISI_Type) GetPSIZE_PREV_VSIZE() uint32 {
	return volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff
}
func (o *ISI_Type) SetPSIZE_PREV_HSIZE(value uint32) {
	volatile.StoreUint32(&o.PSIZE.Reg, volatile.LoadUint32(&o.PSIZE.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ISI_Type) GetPSIZE_PREV_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.PSIZE.Reg) & 0x3ff0000) >> 16
}

// ISI.PDECF: ISI Preview Decimation Factor Register
func (o *ISI_Type) SetPDECF_DEC_FACTOR(value uint32) {
	volatile.StoreUint32(&o.PDECF.Reg, volatile.LoadUint32(&o.PDECF.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetPDECF_DEC_FACTOR() uint32 {
	return volatile.LoadUint32(&o.PDECF.Reg) & 0xff
}

// ISI.Y2R_SET0: ISI Color Space Conversion YCrCb To RGB Set 0 Register
func (o *ISI_Type) SetY2R_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetY2R_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetY2R_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetY2R_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetY2R_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetY2R_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetY2R_SET0_C3(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET0.Reg, volatile.LoadUint32(&o.Y2R_SET0.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetY2R_SET0_C3() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET0.Reg) & 0xff000000) >> 24
}

// ISI.Y2R_SET1: ISI Color Space Conversion YCrCb To RGB Set 1 Register
func (o *ISI_Type) SetY2R_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1ff)|value)
}
func (o *ISI_Type) GetY2R_SET1_C4() uint32 {
	return volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1ff
}
func (o *ISI_Type) SetY2R_SET1_Yoff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetY2R_SET1_Yoff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetY2R_SET1_Croff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetY2R_SET1_Croff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetY2R_SET1_Cboff(value uint32) {
	volatile.StoreUint32(&o.Y2R_SET1.Reg, volatile.LoadUint32(&o.Y2R_SET1.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetY2R_SET1_Cboff() uint32 {
	return (volatile.LoadUint32(&o.Y2R_SET1.Reg) & 0x4000) >> 14
}

// ISI.R2Y_SET0: ISI Color Space Conversion RGB To YCrCb Set 0 Register
func (o *ISI_Type) SetR2Y_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET0_Roff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET0.Reg, volatile.LoadUint32(&o.R2Y_SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET0_Roff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET0.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET1: ISI Color Space Conversion RGB To YCrCb Set 1 Register
func (o *ISI_Type) SetR2Y_SET1_C3(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET1_C3() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET1_C4() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET1_C5(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET1_C5() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET1_Goff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET1.Reg, volatile.LoadUint32(&o.R2Y_SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET1_Goff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET1.Reg) & 0x1000000) >> 24
}

// ISI.R2Y_SET2: ISI Color Space Conversion RGB To YCrCb Set 2 Register
func (o *ISI_Type) SetR2Y_SET2_C6(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f)|value)
}
func (o *ISI_Type) GetR2Y_SET2_C6() uint32 {
	return volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f
}
func (o *ISI_Type) SetR2Y_SET2_C7(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f00)|value<<8)
}
func (o *ISI_Type) GetR2Y_SET2_C7() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f00) >> 8
}
func (o *ISI_Type) SetR2Y_SET2_C8(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x7f0000)|value<<16)
}
func (o *ISI_Type) GetR2Y_SET2_C8() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x7f0000) >> 16
}
func (o *ISI_Type) SetR2Y_SET2_Boff(value uint32) {
	volatile.StoreUint32(&o.R2Y_SET2.Reg, volatile.LoadUint32(&o.R2Y_SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetR2Y_SET2_Boff() uint32 {
	return (volatile.LoadUint32(&o.R2Y_SET2.Reg) & 0x1000000) >> 24
}

// ISI.CR: ISI Control Register
func (o *ISI_Type) SetCR_ISI_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetCR_ISI_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ISI_Type) SetCR_ISI_DIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetCR_ISI_DIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetCR_ISI_SRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetCR_ISI_SRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetCR_ISI_CDC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetCR_ISI_CDC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// ISI.SR: ISI Status Register
func (o *ISI_Type) SetSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *ISI_Type) SetSR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetSR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetSR_SRST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetSR_SRST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetSR_CDC_PND(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetSR_CDC_PND() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ISI_Type) SetSR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetSR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetSR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetSR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetSR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetSR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetSR_SIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *ISI_Type) GetSR_SIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *ISI_Type) SetSR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetSR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetSR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetSR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetSR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetSR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetSR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetSR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}

// ISI.IER: ISI Interrupt Enable Register
func (o *ISI_Type) SetIER_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIER_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIER_SRST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIER_SRST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIER_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIER_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIER_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIER_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIER_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIER_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIER_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIER_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIER_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIER_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIER_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIER_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIER_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIER_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}

// ISI.IDR: ISI Interrupt Disable Register
func (o *ISI_Type) SetIDR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIDR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIDR_SRST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIDR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIDR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIDR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIDR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIDR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIDR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIDR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIDR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIDR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIDR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIDR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIDR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIDR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIDR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIDR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}

// ISI.IMR: ISI Interrupt Mask Register
func (o *ISI_Type) SetIMR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetIMR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetIMR_SRST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetIMR_SRST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetIMR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetIMR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetIMR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetIMR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetIMR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetIMR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetIMR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetIMR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetIMR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetIMR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetIMR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetIMR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetIMR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetIMR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}

// ISI.DMA_CHER: DMA Channel Enable Register
func (o *ISI_Type) SetDMA_CHER_P_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHER_P_CH_EN() uint32 {
	return volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHER_C_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHER_C_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x2) >> 1
}

// ISI.DMA_CHDR: DMA Channel Disable Register
func (o *ISI_Type) SetDMA_CHDR_P_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHDR_P_CH_DIS() uint32 {
	return volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHDR_C_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHDR_C_CH_DIS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x2) >> 1
}

// ISI.DMA_CHSR: DMA Channel Status Register
func (o *ISI_Type) SetDMA_CHSR_P_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHSR_P_CH_S() uint32 {
	return volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHSR_C_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHSR_C_CH_S() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x2) >> 1
}

// ISI.DMA_P_ADDR: DMA Preview Base Address Register
func (o *ISI_Type) SetDMA_P_ADDR_P_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_ADDR.Reg, volatile.LoadUint32(&o.DMA_P_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_ADDR_P_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_P_CTRL: DMA Preview Control Register
func (o *ISI_Type) SetDMA_P_CTRL_P_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_P_CTRL_P_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_P_DSCR: DMA Preview Descriptor Address Register
func (o *ISI_Type) SetDMA_P_DSCR_P_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_DSCR.Reg, volatile.LoadUint32(&o.DMA_P_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_DSCR_P_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_ADDR: DMA Codec Base Address Register
func (o *ISI_Type) SetDMA_C_ADDR_C_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_ADDR.Reg, volatile.LoadUint32(&o.DMA_C_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_ADDR_C_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_CTRL: DMA Codec Control Register
func (o *ISI_Type) SetDMA_C_CTRL_C_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_C_CTRL_C_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_C_DSCR: DMA Codec Descriptor Address Register
func (o *ISI_Type) SetDMA_C_DSCR_C_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_DSCR.Reg, volatile.LoadUint32(&o.DMA_C_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_DSCR_C_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.WPMR: Write Protection Mode Register
func (o *ISI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ISI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ISI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ISI.WPSR: Write Protection Status Register
func (o *ISI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ISI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ISI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG         [9]volatile.Register32 // 0x0
	_            [28]byte
	SCFG         [9]volatile.Register32 // 0x40
	_            [28]byte
	MATRIX_PR    [9]MATRIX_MATRIX_PR_Type // 0x80
	_            [56]byte
	MRCR         volatile.Register32 // 0x100
	_            [16]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [12]byte
	CCFG_SMCNFCS volatile.Register32 // 0x124
	_            [188]byte
	WPMR         volatile.Register32 // 0x1E4
	WPSR         volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register 0
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register 0
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetMRCR_RCB6(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMRCR_RCB6() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetMRCR_RCB8(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetMRCR_RCB8() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x100) >> 8
}

// MATRIX.CCFG_SYSIO: System I/O Configuration Register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO4(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO4() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO5(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO5() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO6(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO6() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO7(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO7() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}

// MATRIX.CCFG_SMCNFCS: SMC NAND Flash Chip Select Configuration Register
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS0(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS0() uint32 {
	return volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS1(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS1() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS2(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS2() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SMC_NFCS3(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SMC_NFCS3() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetCCFG_SMCNFCS_SDRAMEN(value uint32) {
	volatile.StoreUint32(&o.CCFG_SMCNFCS.Reg, volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SMCNFCS_SDRAMEN() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SMCNFCS.Reg) & 0x10) >> 4
}

// MATRIX.WPMR: Write Protection Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protection Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Priority Register A for Slave 0
type MATRIX_MATRIX_PR_Type struct {
	PRAS volatile.Register32 // 0x80
	PRBS volatile.Register32 // 0x84
}

// MATRIX_MATRIX_PR.PRAS: Priority Register A for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS.Reg) & 0x3
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x30) >> 4
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x300) >> 8
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x3000) >> 12
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x30000) >> 16
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x300000) >> 20
}
func (o *MATRIX_MATRIX_PR_Type) SetPRAS_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS.Reg, volatile.LoadUint32(&o.PRAS.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRAS_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS.Reg) & 0x3000000) >> 24
}

// MATRIX_MATRIX_PR.PRBS: Priority Register B for Slave 0
func (o *MATRIX_MATRIX_PR_Type) SetPRBS_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS.Reg, volatile.LoadUint32(&o.PRBS.Reg)&^(0x3)|value)
}
func (o *MATRIX_MATRIX_PR_Type) GetPRBS_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS.Reg) & 0x3
}

// Parallel Input/Output Controller
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
	_       [20]byte
	DRIVER  volatile.Register32 // 0x118
	_       [52]byte
	PCMR    volatile.Register32 // 0x150
	PCIER   volatile.Register32 // 0x154
	PCIDR   volatile.Register32 // 0x158
	PCIMR   volatile.Register32 // 0x15C
	PCISR   volatile.Register32 // 0x160
	PCRHR   volatile.Register32 // 0x164
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABCDSR: Peripheral ABCD Select Register 0
func (o *PIO_Type) SetABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetIFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetIFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetIFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMER_P8(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMER_P9(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMER_P10(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMER_P11(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMER_P12(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMER_P13(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMER_P14(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMER_P15(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMER_P16(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMER_P17(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMER_P18(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMER_P19(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMER_P20(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMER_P21(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMER_P22(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMER_P23(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMER_P24(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMER_P25(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMER_P26(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMER_P27(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMER_P28(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMER_P29(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMER_P30(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMER_P31(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000000) >> 31
}

// PIO.AIMDR: Additional Interrupt Modes Disable Register
func (o *PIO_Type) SetAIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetAIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.ESR: Edge Select Register
func (o *PIO_Type) SetESR_P0(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetESR_P0() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}
func (o *PIO_Type) SetESR_P1(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetESR_P1() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetESR_P2(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetESR_P2() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetESR_P3(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetESR_P3() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetESR_P4(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetESR_P4() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetESR_P5(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetESR_P5() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetESR_P6(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetESR_P6() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetESR_P7(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetESR_P7() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetESR_P8(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetESR_P8() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetESR_P9(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetESR_P9() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetESR_P10(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetESR_P10() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetESR_P11(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetESR_P11() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetESR_P12(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetESR_P12() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetESR_P13(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetESR_P13() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetESR_P14(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetESR_P14() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetESR_P15(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetESR_P15() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetESR_P16(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetESR_P16() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetESR_P17(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetESR_P17() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetESR_P18(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetESR_P18() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetESR_P19(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetESR_P19() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetESR_P20(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetESR_P20() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetESR_P21(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetESR_P21() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetESR_P22(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetESR_P22() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetESR_P23(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetESR_P23() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetESR_P24(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetESR_P24() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetESR_P25(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetESR_P25() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetESR_P26(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetESR_P26() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetESR_P27(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetESR_P27() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetESR_P28(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetESR_P28() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetESR_P29(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetESR_P29() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetESR_P30(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetESR_P30() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetESR_P31(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetESR_P31() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000000) >> 31
}

// PIO.LSR: Level Select Register
func (o *PIO_Type) SetLSR_P0(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLSR_P0() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *PIO_Type) SetLSR_P1(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLSR_P2(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLSR_P3(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLSR_P4(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLSR_P5(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLSR_P6(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLSR_P7(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLSR_P8(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLSR_P9(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLSR_P10(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLSR_P11(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLSR_P12(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLSR_P13(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLSR_P14(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLSR_P15(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLSR_P16(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLSR_P17(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLSR_P18(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLSR_P19(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLSR_P20(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLSR_P21(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLSR_P22(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLSR_P23(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLSR_P24(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLSR_P25(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLSR_P26(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLSR_P27(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLSR_P28(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLSR_P29(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLSR_P30(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLSR_P31(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000000) >> 31
}

// PIO.ELSR: Edge/Level Status Register
func (o *PIO_Type) SetELSR_P0(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetELSR_P0() uint32 {
	return volatile.LoadUint32(&o.ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetELSR_P1(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetELSR_P2(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetELSR_P3(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetELSR_P4(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetELSR_P5(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetELSR_P6(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetELSR_P7(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetELSR_P8(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetELSR_P9(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetELSR_P10(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetELSR_P11(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetELSR_P12(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetELSR_P13(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetELSR_P14(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetELSR_P15(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetELSR_P16(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetELSR_P17(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetELSR_P18(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetELSR_P19(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetELSR_P20(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetELSR_P21(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetELSR_P22(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetELSR_P23(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetELSR_P24(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetELSR_P25(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetELSR_P26(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetELSR_P27(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetELSR_P28(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetELSR_P29(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetELSR_P30(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetELSR_P31(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000000) >> 31
}

// PIO.FELLSR: Falling Edge/Low-Level Select Register
func (o *PIO_Type) SetFELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetFELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.REHLSR: Rising Edge/High-Level Select Register
func (o *PIO_Type) SetREHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetREHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetREHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetREHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetREHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetREHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetREHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetREHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetREHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetREHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetREHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetREHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetREHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetREHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetREHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetREHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetREHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetREHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetREHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetREHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetREHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetREHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetREHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetREHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetREHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetREHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetREHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetREHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetREHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetREHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetREHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetREHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetREHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetREHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetREHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetREHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetREHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetREHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetREHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetREHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetREHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetREHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetREHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetREHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetREHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetREHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetREHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetREHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetREHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetREHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetREHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetREHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetREHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetREHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetREHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetREHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetREHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetREHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetREHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetREHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetREHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetREHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetREHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetREHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetFRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetFRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.LOCKSR: Lock Status
func (o *PIO_Type) SetLOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetLOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.WPMR: Write Protection Mode Register
func (o *PIO_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.WPSR: Write Protection Status Register
func (o *PIO_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PIO.SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetSCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000000) >> 31
}

// PIO.DRIVER: I/O Drive Register
func (o *PIO_Type) SetDRIVER_LINE0(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetDRIVER_LINE0() uint32 {
	return volatile.LoadUint32(&o.DRIVER.Reg) & 0x1
}
func (o *PIO_Type) SetDRIVER_LINE1(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetDRIVER_LINE1() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetDRIVER_LINE2(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetDRIVER_LINE2() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetDRIVER_LINE3(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetDRIVER_LINE3() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetDRIVER_LINE4(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetDRIVER_LINE4() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetDRIVER_LINE5(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetDRIVER_LINE5() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetDRIVER_LINE6(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetDRIVER_LINE6() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetDRIVER_LINE7(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetDRIVER_LINE7() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetDRIVER_LINE8(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetDRIVER_LINE8() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetDRIVER_LINE9(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetDRIVER_LINE9() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetDRIVER_LINE10(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetDRIVER_LINE10() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetDRIVER_LINE11(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetDRIVER_LINE11() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetDRIVER_LINE12(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetDRIVER_LINE12() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetDRIVER_LINE13(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetDRIVER_LINE13() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetDRIVER_LINE14(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetDRIVER_LINE14() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetDRIVER_LINE15(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetDRIVER_LINE15() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetDRIVER_LINE16(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetDRIVER_LINE16() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetDRIVER_LINE17(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetDRIVER_LINE17() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetDRIVER_LINE18(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetDRIVER_LINE18() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetDRIVER_LINE19(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetDRIVER_LINE19() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetDRIVER_LINE20(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetDRIVER_LINE20() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetDRIVER_LINE21(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetDRIVER_LINE21() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetDRIVER_LINE22(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetDRIVER_LINE22() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetDRIVER_LINE23(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetDRIVER_LINE23() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetDRIVER_LINE24(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetDRIVER_LINE24() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetDRIVER_LINE25(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetDRIVER_LINE25() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetDRIVER_LINE26(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetDRIVER_LINE26() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetDRIVER_LINE27(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetDRIVER_LINE27() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetDRIVER_LINE28(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetDRIVER_LINE28() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetDRIVER_LINE29(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetDRIVER_LINE29() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetDRIVER_LINE30(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetDRIVER_LINE30() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetDRIVER_LINE31(value uint32) {
	volatile.StoreUint32(&o.DRIVER.Reg, volatile.LoadUint32(&o.DRIVER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetDRIVER_LINE31() uint32 {
	return (volatile.LoadUint32(&o.DRIVER.Reg) & 0x80000000) >> 31
}

// PIO.PCMR: Parallel Capture Mode Register
func (o *PIO_Type) SetPCMR_PCEN(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCMR_PCEN() uint32 {
	return volatile.LoadUint32(&o.PCMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCMR_DSIZE(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x30)|value<<4)
}
func (o *PIO_Type) GetPCMR_DSIZE() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x30) >> 4
}
func (o *PIO_Type) SetPCMR_ALWYS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPCMR_ALWYS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPCMR_HALFS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPCMR_HALFS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPCMR_FRSTS(value uint32) {
	volatile.StoreUint32(&o.PCMR.Reg, volatile.LoadUint32(&o.PCMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPCMR_FRSTS() uint32 {
	return (volatile.LoadUint32(&o.PCMR.Reg) & 0x800) >> 11
}

// PIO.PCIER: Parallel Capture Interrupt Enable Register
func (o *PIO_Type) SetPCIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIER_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIER.Reg) & 0x1
}
func (o *PIO_Type) SetPCIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIER.Reg, volatile.LoadUint32(&o.PCIER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIER.Reg) & 0x8) >> 3
}

// PIO.PCIDR: Parallel Capture Interrupt Disable Register
func (o *PIO_Type) SetPCIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIDR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIDR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIDR.Reg, volatile.LoadUint32(&o.PCIDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIDR.Reg) & 0x8) >> 3
}

// PIO.PCIMR: Parallel Capture Interrupt Mask Register
func (o *PIO_Type) SetPCIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCIMR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCIMR.Reg) & 0x1
}
func (o *PIO_Type) SetPCIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPCIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPCIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPCIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.PCIMR.Reg, volatile.LoadUint32(&o.PCIMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPCIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.PCIMR.Reg) & 0x8) >> 3
}

// PIO.PCISR: Parallel Capture Interrupt Status Register
func (o *PIO_Type) SetPCISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPCISR_DRDY() uint32 {
	return volatile.LoadUint32(&o.PCISR.Reg) & 0x1
}
func (o *PIO_Type) SetPCISR_OVRE(value uint32) {
	volatile.StoreUint32(&o.PCISR.Reg, volatile.LoadUint32(&o.PCISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPCISR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.PCISR.Reg) & 0x2) >> 1
}

// PIO.PCRHR: Parallel Capture Reception Holding Register
func (o *PIO_Type) SetPCRHR(value uint32) {
	volatile.StoreUint32(&o.PCRHR.Reg, value)
}
func (o *PIO_Type) GetPCRHR() uint32 {
	return volatile.LoadUint32(&o.PCRHR.Reg)
}

// Power Management Controller
type PMC_Type struct {
	SCER       volatile.Register32 // 0x0
	SCDR       volatile.Register32 // 0x4
	SCSR       volatile.Register32 // 0x8
	_          [4]byte
	PCER0      volatile.Register32 // 0x10
	PCDR0      volatile.Register32 // 0x14
	PCSR0      volatile.Register32 // 0x18
	CKGR_UCKR  volatile.Register32 // 0x1C
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	MCKR       volatile.Register32 // 0x30
	_          [4]byte
	USB        volatile.Register32 // 0x38
	_          [4]byte
	PCK        [8]volatile.Register32 // 0x40
	IER        volatile.Register32    // 0x60
	IDR        volatile.Register32    // 0x64
	SR         volatile.Register32    // 0x68
	IMR        volatile.Register32    // 0x6C
	FSMR       volatile.Register32    // 0x70
	FSPR       volatile.Register32    // 0x74
	FOCR       volatile.Register32    // 0x78
	_          [104]byte
	WPMR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
	_          [20]byte
	PCER1      volatile.Register32 // 0x100
	PCDR1      volatile.Register32 // 0x104
	PCSR1      volatile.Register32 // 0x108
	PCR        volatile.Register32 // 0x10C
	OCR        volatile.Register32 // 0x110
	SLPWK_ER0  volatile.Register32 // 0x114
	SLPWK_DR0  volatile.Register32 // 0x118
	SLPWK_SR0  volatile.Register32 // 0x11C
	SLPWK_ASR0 volatile.Register32 // 0x120
	_          [12]byte
	PMMR       volatile.Register32 // 0x130
	SLPWK_ER1  volatile.Register32 // 0x134
	SLPWK_DR1  volatile.Register32 // 0x138
	SLPWK_SR1  volatile.Register32 // 0x13C
	SLPWK_ASR1 volatile.Register32 // 0x140
	SLPWK_AIPR volatile.Register32 // 0x144
}

// PMC.SCER: System Clock Enable Register
func (o *PMC_Type) SetSCER_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCER_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCER_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCER_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCER_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCER_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCER_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCER_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCER_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCER.Reg, volatile.LoadUint32(&o.SCER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCER_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCER.Reg) & 0x4000) >> 14
}

// PMC.SCDR: System Clock Disable Register
func (o *PMC_Type) SetSCDR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCDR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCDR_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCDR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCDR_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCDR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCDR_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCDR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCDR_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCDR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCDR.Reg) & 0x4000) >> 14
}

// PMC.SCSR: System Clock Status Register
func (o *PMC_Type) SetSCSR_HCLKS(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSCSR_HCLKS() uint32 {
	return volatile.LoadUint32(&o.SCSR.Reg) & 0x1
}
func (o *PMC_Type) SetSCSR_USBCLK(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSCSR_USBCLK() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSCSR_PCK3(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSCSR_PCK3() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSCSR_PCK4(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSCSR_PCK4() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSCSR_PCK5(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSCSR_PCK5() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSCSR_PCK6(value uint32) {
	volatile.StoreUint32(&o.SCSR.Reg, volatile.LoadUint32(&o.SCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSCSR_PCK6() uint32 {
	return (volatile.LoadUint32(&o.SCSR.Reg) & 0x4000) >> 14
}

// PMC.PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPCER0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCER0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCER0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCER0_PID17(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCER0_PID18(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCER0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCER0.Reg, volatile.LoadUint32(&o.PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPCDR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCDR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCDR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCDR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCDR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCDR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCDR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCDR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCDR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCDR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCDR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCDR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCDR0.Reg, volatile.LoadUint32(&o.PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPCSR0_PID7(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCSR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCSR0_PID8(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCSR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCSR0_PID16(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCSR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCSR0_PID17(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCSR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCSR0_PID18(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCSR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCSR0_PID22(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetPCSR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetPCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PCSR0.Reg, volatile.LoadUint32(&o.PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_UCKR: UTMI Clock Register
func (o *PMC_Type) SetCKGR_UCKR_UPLLEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_UCKR_UPLLCOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_UCKR.Reg, volatile.LoadUint32(&o.CKGR_UCKR.Reg)&^(0xf00000)|value<<20)
}
func (o *PMC_Type) GetCKGR_UCKR_UPLLCOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_UCKR.Reg) & 0xf00000) >> 20
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_WAITMODE(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetCKGR_MOR_WAITMODE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetCKGR_MOR_XT32KFME(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetCKGR_MOR_XT32KFME() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x4000000) >> 26
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetCKGR_MCFR_RCMEAS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetCKGR_MCFR_RCMEAS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetCKGR_MCFR_CCSS(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MCFR_CCSS() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x1000000) >> 24
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.MCKR: Master Clock Register
func (o *PMC_Type) SetMCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetMCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetMCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetMCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetMCKR_MDIV(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x300)|value<<8)
}
func (o *PMC_Type) GetMCKR_MDIV() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x300) >> 8
}
func (o *PMC_Type) SetMCKR_UPLLDIV2(value uint32) {
	volatile.StoreUint32(&o.MCKR.Reg, volatile.LoadUint32(&o.MCKR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetMCKR_UPLLDIV2() uint32 {
	return (volatile.LoadUint32(&o.MCKR.Reg) & 0x2000) >> 13
}

// PMC.USB: USB Clock Register
func (o *PMC_Type) SetUSB_USBS(value uint32) {
	volatile.StoreUint32(&o.USB.Reg, volatile.LoadUint32(&o.USB.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetUSB_USBS() uint32 {
	return volatile.LoadUint32(&o.USB.Reg) & 0x1
}
func (o *PMC_Type) SetUSB_USBDIV(value uint32) {
	volatile.StoreUint32(&o.USB.Reg, volatile.LoadUint32(&o.USB.Reg)&^(0xf00)|value<<8)
}
func (o *PMC_Type) GetUSB_USBDIV() uint32 {
	return (volatile.LoadUint32(&o.USB.Reg) & 0xf00) >> 8
}

// PMC.PCK: Programmable Clock Register
func (o *PMC_Type) SetPCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PCK[idx].Reg, volatile.LoadUint32(&o.PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PCK[idx].Reg, volatile.LoadUint32(&o.PCK[idx].Reg)&^(0xff0)|value<<4)
}
func (o *PMC_Type) GetPCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PCK[idx].Reg) & 0xff0) >> 4
}

// PMC.IER: Interrupt Enable Register
func (o *PMC_Type) SetIER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PMC_Type) SetIER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIER_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIER_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIER_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIER_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIER_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIER_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIER_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIER_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIER_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIER_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIER_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIER_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}

// PMC.IDR: Interrupt Disable Register
func (o *PMC_Type) SetIDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PMC_Type) SetIDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIDR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIDR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIDR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIDR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIDR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIDR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIDR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIDR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIDR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIDR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIDR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIDR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}

// PMC.SR: Status Register
func (o *PMC_Type) SetSR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PMC_Type) SetSR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetSR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetSR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSR_CFDS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSR_FOS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSR_FOS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}

// PMC.IMR: Interrupt Mask Register
func (o *PMC_Type) SetIMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetIMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PMC_Type) SetIMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetIMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetIMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetIMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetIMR_LOCKU(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetIMR_LOCKU() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetIMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetIMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetIMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetIMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetIMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetIMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetIMR_PCKRDY3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetIMR_PCKRDY3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetIMR_PCKRDY4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetIMR_PCKRDY4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetIMR_PCKRDY5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetIMR_PCKRDY5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetIMR_PCKRDY6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetIMR_PCKRDY6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetIMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetIMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetIMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetIMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetIMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetIMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetIMR_XT32KERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetIMR_XT32KERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}

// PMC.FSMR: Fast Startup Mode Register
func (o *PMC_Type) SetFSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetFSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetFSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetFSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetFSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetFSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetFSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetFSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetFSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetFSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetFSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetFSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetFSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetFSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetFSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetFSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetFSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetFSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetFSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetFSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetFSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetFSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetFSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetFSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetFSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetFSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetFSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetFSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetFSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetFSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetFSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetFSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetFSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetFSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetFSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetFSMR_USBAL(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetFSMR_USBAL() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetFSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetFSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetFSMR_FLPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x600000)|value<<21)
}
func (o *PMC_Type) GetFSMR_FLPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x600000) >> 21
}
func (o *PMC_Type) SetFSMR_FFLPM(value uint32) {
	volatile.StoreUint32(&o.FSMR.Reg, volatile.LoadUint32(&o.FSMR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetFSMR_FFLPM() uint32 {
	return (volatile.LoadUint32(&o.FSMR.Reg) & 0x800000) >> 23
}

// PMC.FSPR: Fast Startup Polarity Register
func (o *PMC_Type) SetFSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetFSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetFSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetFSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetFSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetFSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetFSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetFSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetFSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetFSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetFSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetFSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetFSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetFSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetFSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetFSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetFSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetFSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetFSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetFSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetFSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetFSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetFSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetFSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetFSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetFSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetFSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetFSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetFSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetFSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.FSPR.Reg, volatile.LoadUint32(&o.FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetFSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.FSPR.Reg) & 0x8000) >> 15
}

// PMC.FOCR: Fault Output Clear Register
func (o *PMC_Type) SetFOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.FOCR.Reg, volatile.LoadUint32(&o.FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetFOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.FOCR.Reg) & 0x1
}

// PMC.WPMR: Write Protection Mode Register
func (o *PMC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.WPSR: Write Protection Status Register
func (o *PMC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PMC.PCER1: Peripheral Clock Enable Register 1
func (o *PMC_Type) SetPCER1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCER1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCER1.Reg) & 0x1
}
func (o *PMC_Type) SetPCER1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCER1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCER1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCER1_PID37(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPCER1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPCER1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCER1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCER1_PID41(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCER1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCER1_PID42(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCER1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCER1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCER1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCER1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCER1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCER1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCER1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCER1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCER1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCER1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCER1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCER1_PID53(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCER1_PID53() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCER1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCER1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCER1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCER1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCER1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCER1.Reg, volatile.LoadUint32(&o.PCER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCER1.Reg) & 0x10000000) >> 28
}

// PMC.PCDR1: Peripheral Clock Disable Register 1
func (o *PMC_Type) SetPCDR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCDR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCDR1.Reg) & 0x1
}
func (o *PMC_Type) SetPCDR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCDR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCDR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCDR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCDR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCDR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCDR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPCDR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPCDR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCDR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCDR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCDR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCDR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCDR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCDR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCDR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCDR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCDR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCDR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCDR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCDR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCDR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCDR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCDR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCDR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCDR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCDR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCDR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCDR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCDR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCDR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCDR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCDR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCDR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCDR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCDR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCDR1_PID53(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCDR1_PID53() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCDR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCDR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCDR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCDR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCDR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCDR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCDR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCDR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCDR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCDR1.Reg, volatile.LoadUint32(&o.PCDR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCDR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCDR1.Reg) & 0x10000000) >> 28
}

// PMC.PCSR1: Peripheral Clock Status Register 1
func (o *PMC_Type) SetPCSR1_PID32(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPCSR1_PID32() uint32 {
	return volatile.LoadUint32(&o.PCSR1.Reg) & 0x1
}
func (o *PMC_Type) SetPCSR1_PID33(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPCSR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPCSR1_PID34(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPCSR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPCSR1_PID35(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPCSR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPCSR1_PID37(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPCSR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPCSR1_PID39(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPCSR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPCSR1_PID40(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPCSR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPCSR1_PID41(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPCSR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPCSR1_PID42(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPCSR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPCSR1_PID43(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPCSR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPCSR1_PID44(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCSR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCSR1_PID45(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPCSR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPCSR1_PID46(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPCSR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPCSR1_PID47(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPCSR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPCSR1_PID48(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPCSR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPCSR1_PID49(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPCSR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPCSR1_PID50(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPCSR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPCSR1_PID51(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPCSR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPCSR1_PID52(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPCSR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPCSR1_PID53(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPCSR1_PID53() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPCSR1_PID56(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPCSR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPCSR1_PID57(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPCSR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPCSR1_PID58(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPCSR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPCSR1_PID59(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPCSR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPCSR1_PID60(value uint32) {
	volatile.StoreUint32(&o.PCSR1.Reg, volatile.LoadUint32(&o.PCSR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCSR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.PCSR1.Reg) & 0x10000000) >> 28
}

// PMC.PCR: Peripheral Control Register
func (o *PMC_Type) SetPCR_PID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetPCR_PID() uint32 {
	return volatile.LoadUint32(&o.PCR.Reg) & 0x7f
}
func (o *PMC_Type) SetPCR_GCLKCSS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x700)|value<<8)
}
func (o *PMC_Type) GetPCR_GCLKCSS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x700) >> 8
}
func (o *PMC_Type) SetPCR_CMD(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPCR_CMD() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPCR_GCLKDIV(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xff00000)|value<<20)
}
func (o *PMC_Type) GetPCR_GCLKDIV() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xff00000) >> 20
}
func (o *PMC_Type) SetPCR_EN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPCR_EN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPCR_GCLKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPCR_GCLKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x20000000) >> 29
}

// PMC.OCR: Oscillator Calibration Register
func (o *PMC_Type) SetOCR_CAL4(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f)|value)
}
func (o *PMC_Type) GetOCR_CAL4() uint32 {
	return volatile.LoadUint32(&o.OCR.Reg) & 0x7f
}
func (o *PMC_Type) SetOCR_SEL4(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetOCR_SEL4() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetOCR_CAL8(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f00)|value<<8)
}
func (o *PMC_Type) GetOCR_CAL8() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x7f00) >> 8
}
func (o *PMC_Type) SetOCR_SEL8(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetOCR_SEL8() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetOCR_CAL12(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x7f0000)|value<<16)
}
func (o *PMC_Type) GetOCR_CAL12() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x7f0000) >> 16
}
func (o *PMC_Type) SetOCR_SEL12(value uint32) {
	volatile.StoreUint32(&o.OCR.Reg, volatile.LoadUint32(&o.OCR.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetOCR_SEL12() uint32 {
	return (volatile.LoadUint32(&o.OCR.Reg) & 0x800000) >> 23
}

// PMC.SLPWK_ER0: SleepWalking Enable Register 0
func (o *PMC_Type) SetSLPWK_ER0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ER0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ER0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ER0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ER0_PID9(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_ER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_ER0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ER0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ER0_PID12(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ER0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ER0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ER0_PID15(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ER0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ER0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ER0_PID17(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ER0_PID17() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ER0_PID18(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ER0_PID18() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ER0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ER0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ER0_PID21(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_ER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_ER0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_ER0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_ER0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_ER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_ER0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ER0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ER0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ER0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ER0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_ER0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_ER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_ER0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_ER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_ER0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER0.Reg, volatile.LoadUint32(&o.SLPWK_ER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_ER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_DR0: SleepWalking Disable Register 0
func (o *PMC_Type) SetSLPWK_DR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_DR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_DR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_DR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_DR0_PID9(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_DR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_DR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_DR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_DR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_DR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_DR0_PID12(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_DR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_DR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_DR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_DR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_DR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_DR0_PID15(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_DR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_DR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_DR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_DR0_PID17(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_DR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_DR0_PID18(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_DR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_DR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_DR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_DR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_DR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_DR0_PID21(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_DR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_DR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_DR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_DR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_DR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_DR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_DR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_DR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_DR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_DR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_DR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_DR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_DR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_DR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_DR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_DR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_DR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_DR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_DR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_DR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR0.Reg, volatile.LoadUint32(&o.SLPWK_DR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_DR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_SR0: SleepWalking Status Register 0
func (o *PMC_Type) SetSLPWK_SR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_SR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_SR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_SR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_SR0_PID9(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_SR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_SR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_SR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_SR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_SR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_SR0_PID12(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_SR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_SR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_SR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_SR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_SR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_SR0_PID15(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_SR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_SR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_SR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_SR0_PID17(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_SR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_SR0_PID18(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_SR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_SR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_SR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_SR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_SR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_SR0_PID21(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_SR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_SR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_SR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_SR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_SR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_SR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_SR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_SR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_SR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_SR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_SR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_SR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_SR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_SR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_SR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_SR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_SR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_SR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_SR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_SR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR0.Reg, volatile.LoadUint32(&o.SLPWK_SR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_SR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR0.Reg) & 0x80000000) >> 31
}

// PMC.SLPWK_ASR0: SleepWalking Activity Status Register 0
func (o *PMC_Type) SetSLPWK_ASR0_PID7(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID7() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ASR0_PID8(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID8() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ASR0_PID9(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_ASR0_PID10(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ASR0_PID11(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ASR0_PID12(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ASR0_PID13(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ASR0_PID14(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ASR0_PID15(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ASR0_PID16(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID16() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ASR0_PID17(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID17() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ASR0_PID18(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID18() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ASR0_PID19(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ASR0_PID20(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ASR0_PID21(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_ASR0_PID22(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x400000)|value<<22)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID22() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x400000) >> 22
}
func (o *PMC_Type) SetSLPWK_ASR0_PID23(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetSLPWK_ASR0_PID24(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ASR0_PID25(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ASR0_PID26(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ASR0_PID27(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ASR0_PID28(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetSLPWK_ASR0_PID29(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetSLPWK_ASR0_PID30(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetSLPWK_ASR0_PID31(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR0.Reg, volatile.LoadUint32(&o.SLPWK_ASR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetSLPWK_ASR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR0.Reg) & 0x80000000) >> 31
}

// PMC.PMMR: PLL Maximum Multiplier Value Register
func (o *PMC_Type) SetPMMR_PLLA_MMAX(value uint32) {
	volatile.StoreUint32(&o.PMMR.Reg, volatile.LoadUint32(&o.PMMR.Reg)&^(0x7ff)|value)
}
func (o *PMC_Type) GetPMMR_PLLA_MMAX() uint32 {
	return volatile.LoadUint32(&o.PMMR.Reg) & 0x7ff
}

// PMC.SLPWK_ER1: SleepWalking Enable Register 1
func (o *PMC_Type) SetSLPWK_ER1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_ER1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_ER1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_ER1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_ER1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_ER1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_ER1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_ER1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_ER1_PID37(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSLPWK_ER1_PID37() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSLPWK_ER1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ER1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ER1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ER1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ER1_PID41(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_ER1_PID41() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_ER1_PID42(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ER1_PID42() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ER1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ER1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ER1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ER1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ER1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ER1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ER1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ER1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ER1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ER1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ER1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ER1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ER1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ER1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ER1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ER1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ER1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ER1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ER1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ER1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ER1_PID53(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_ER1_PID53() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_ER1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ER1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ER1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ER1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ER1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ER1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ER1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ER1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ER1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ER1.Reg, volatile.LoadUint32(&o.SLPWK_ER1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ER1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ER1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_DR1: SleepWalking Disable Register 1
func (o *PMC_Type) SetSLPWK_DR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_DR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_DR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_DR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_DR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_DR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_DR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_DR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_DR1_PID37(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSLPWK_DR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSLPWK_DR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_DR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_DR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_DR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_DR1_PID41(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_DR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_DR1_PID42(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_DR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_DR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_DR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_DR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_DR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_DR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_DR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_DR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_DR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_DR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_DR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_DR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_DR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_DR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_DR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_DR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_DR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_DR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_DR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_DR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_DR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_DR1_PID53(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_DR1_PID53() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_DR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_DR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_DR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_DR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_DR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_DR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_DR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_DR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_DR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_DR1.Reg, volatile.LoadUint32(&o.SLPWK_DR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_DR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_DR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_SR1: SleepWalking Status Register 1
func (o *PMC_Type) SetSLPWK_SR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_SR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_SR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_SR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_SR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_SR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_SR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_SR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_SR1_PID37(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSLPWK_SR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSLPWK_SR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_SR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_SR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_SR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_SR1_PID41(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_SR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_SR1_PID42(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_SR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_SR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_SR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_SR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_SR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_SR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_SR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_SR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_SR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_SR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_SR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_SR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_SR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_SR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_SR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_SR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_SR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_SR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_SR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_SR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_SR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_SR1_PID53(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_SR1_PID53() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_SR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_SR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_SR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_SR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_SR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_SR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_SR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_SR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_SR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_SR1.Reg, volatile.LoadUint32(&o.SLPWK_SR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_SR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_SR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_ASR1: SleepWalking Activity Status Register 1
func (o *PMC_Type) SetSLPWK_ASR1_PID32(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID32() uint32 {
	return volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1
}
func (o *PMC_Type) SetSLPWK_ASR1_PID33(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID33() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetSLPWK_ASR1_PID34(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID34() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetSLPWK_ASR1_PID35(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID35() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetSLPWK_ASR1_PID37(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID37() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetSLPWK_ASR1_PID39(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID39() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetSLPWK_ASR1_PID40(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID40() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetSLPWK_ASR1_PID41(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID41() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetSLPWK_ASR1_PID42(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID42() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetSLPWK_ASR1_PID43(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID43() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetSLPWK_ASR1_PID44(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID44() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetSLPWK_ASR1_PID45(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID45() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetSLPWK_ASR1_PID46(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID46() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetSLPWK_ASR1_PID47(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID47() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetSLPWK_ASR1_PID48(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID48() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetSLPWK_ASR1_PID49(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID49() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetSLPWK_ASR1_PID50(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID50() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetSLPWK_ASR1_PID51(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID51() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetSLPWK_ASR1_PID52(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID52() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetSLPWK_ASR1_PID53(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID53() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetSLPWK_ASR1_PID56(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID56() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetSLPWK_ASR1_PID57(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID57() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetSLPWK_ASR1_PID58(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID58() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetSLPWK_ASR1_PID59(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID59() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetSLPWK_ASR1_PID60(value uint32) {
	volatile.StoreUint32(&o.SLPWK_ASR1.Reg, volatile.LoadUint32(&o.SLPWK_ASR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetSLPWK_ASR1_PID60() uint32 {
	return (volatile.LoadUint32(&o.SLPWK_ASR1.Reg) & 0x10000000) >> 28
}

// PMC.SLPWK_AIPR: SleepWalking Activity In Progress Register
func (o *PMC_Type) SetSLPWK_AIPR_AIP(value uint32) {
	volatile.StoreUint32(&o.SLPWK_AIPR.Reg, volatile.LoadUint32(&o.SLPWK_AIPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetSLPWK_AIPR_AIP() uint32 {
	return volatile.LoadUint32(&o.SLPWK_AIPR.Reg) & 0x1
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	CLK        volatile.Register32 // 0x0
	ENA        volatile.Register32 // 0x4
	DIS        volatile.Register32 // 0x8
	SR         volatile.Register32 // 0xC
	IER1       volatile.Register32 // 0x10
	IDR1       volatile.Register32 // 0x14
	IMR1       volatile.Register32 // 0x18
	ISR1       volatile.Register32 // 0x1C
	SCM        volatile.Register32 // 0x20
	DMAR       volatile.Register32 // 0x24
	SCUC       volatile.Register32 // 0x28
	SCUP       volatile.Register32 // 0x2C
	SCUPUPD    volatile.Register32 // 0x30
	IER2       volatile.Register32 // 0x34
	IDR2       volatile.Register32 // 0x38
	IMR2       volatile.Register32 // 0x3C
	ISR2       volatile.Register32 // 0x40
	OOV        volatile.Register32 // 0x44
	OS         volatile.Register32 // 0x48
	OSS        volatile.Register32 // 0x4C
	OSC        volatile.Register32 // 0x50
	OSSUPD     volatile.Register32 // 0x54
	OSCUPD     volatile.Register32 // 0x58
	FMR        volatile.Register32 // 0x5C
	FSR        volatile.Register32 // 0x60
	FCR        volatile.Register32 // 0x64
	FPV1       volatile.Register32 // 0x68
	FPE        volatile.Register32 // 0x6C
	_          [12]byte
	ELMR       [2]volatile.Register32 // 0x7C
	_          [28]byte
	SSPR       volatile.Register32 // 0xA0
	SSPUP      volatile.Register32 // 0xA4
	_          [8]byte
	SMMR       volatile.Register32 // 0xB0
	_          [12]byte
	FPV2       volatile.Register32 // 0xC0
	_          [32]byte
	WPCR       volatile.Register32 // 0xE4
	WPSR       volatile.Register32 // 0xE8
	_          [68]byte
	PWM_CMP    [8]PWM_PWM_CMP_Type // 0x130
	_          [80]byte
	PWM_CH_NUM [4]PWM_PWM_CH_NUM_Type // 0x200
	_          [384]byte
	CMUPD0     volatile.Register32 // 0x400
	_          [28]byte
	CMUPD1     volatile.Register32 // 0x420
	_          [8]byte
	ETRG1      volatile.Register32 // 0x42C
	LEBR1      volatile.Register32 // 0x430
	_          [12]byte
	CMUPD2     volatile.Register32 // 0x440
	_          [8]byte
	ETRG2      volatile.Register32 // 0x44C
	LEBR2      volatile.Register32 // 0x450
	_          [12]byte
	CMUPD3     volatile.Register32 // 0x460
}

// PWM.CLK: PWM Clock Register
func (o *PWM_Type) SetCLK_DIVA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetCLK_DIVA() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0xff
}
func (o *PWM_Type) SetCLK_PREA(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetCLK_PREA() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetCLK_DIVB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetCLK_DIVB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetCLK_PREB(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetCLK_PREB() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER1: PWM Interrupt Enable Register 1
func (o *PWM_Type) SetIER1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *PWM_Type) SetIER1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80000) >> 19
}

// PWM.IDR1: PWM Interrupt Disable Register 1
func (o *PWM_Type) SetIDR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *PWM_Type) SetIDR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80000) >> 19
}

// PWM.IMR1: PWM Interrupt Mask Register 1
func (o *PWM_Type) SetIMR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *PWM_Type) SetIMR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}

// PWM.ISR1: PWM Interrupt Status Register 1
func (o *PWM_Type) SetISR1_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR1_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR1.Reg) & 0x1
}
func (o *PWM_Type) SetISR1_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR1_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR1_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR1_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR1_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR1_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR1_FCHID0(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR1_FCHID0() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR1_FCHID1(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR1_FCHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR1_FCHID2(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR1_FCHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR1_FCHID3(value uint32) {
	volatile.StoreUint32(&o.ISR1.Reg, volatile.LoadUint32(&o.ISR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR1_FCHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR1.Reg) & 0x80000) >> 19
}

// PWM.SCM: PWM Sync Channels Mode Register
func (o *PWM_Type) SetSCM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.SCM.Reg) & 0x1
}
func (o *PWM_Type) SetSCM_SYNC1(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSCM_SYNC1() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSCM_SYNC2(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSCM_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSCM_SYNC3(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSCM_SYNC3() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSCM_UPDM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x30000)|value<<16)
}
func (o *PWM_Type) GetSCM_UPDM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x30000) >> 16
}
func (o *PWM_Type) SetSCM_PTRM(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetSCM_PTRM() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetSCM_PTRCS(value uint32) {
	volatile.StoreUint32(&o.SCM.Reg, volatile.LoadUint32(&o.SCM.Reg)&^(0xe00000)|value<<21)
}
func (o *PWM_Type) GetSCM_PTRCS() uint32 {
	return (volatile.LoadUint32(&o.SCM.Reg) & 0xe00000) >> 21
}

// PWM.DMAR: PWM DMA Register
func (o *PWM_Type) SetDMAR_DMADUTY(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetDMAR_DMADUTY() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffffff
}

// PWM.SCUC: PWM Sync Channels Update Control Register
func (o *PWM_Type) SetSCUC_UPDULOCK(value uint32) {
	volatile.StoreUint32(&o.SCUC.Reg, volatile.LoadUint32(&o.SCUC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSCUC_UPDULOCK() uint32 {
	return volatile.LoadUint32(&o.SCUC.Reg) & 0x1
}

// PWM.SCUP: PWM Sync Channels Update Period Register
func (o *PWM_Type) SetSCUP_UPR(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUP_UPR() uint32 {
	return volatile.LoadUint32(&o.SCUP.Reg) & 0xf
}
func (o *PWM_Type) SetSCUP_UPRCNT(value uint32) {
	volatile.StoreUint32(&o.SCUP.Reg, volatile.LoadUint32(&o.SCUP.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_Type) GetSCUP_UPRCNT() uint32 {
	return (volatile.LoadUint32(&o.SCUP.Reg) & 0xf0) >> 4
}

// PWM.SCUPUPD: PWM Sync Channels Update Period Update Register
func (o *PWM_Type) SetSCUPUPD_UPRUPD(value uint32) {
	volatile.StoreUint32(&o.SCUPUPD.Reg, volatile.LoadUint32(&o.SCUPUPD.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetSCUPUPD_UPRUPD() uint32 {
	return volatile.LoadUint32(&o.SCUPUPD.Reg) & 0xf
}

// PWM.IER2: PWM Interrupt Enable Register 2
func (o *PWM_Type) SetIER2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *PWM_Type) SetIER2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIER2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIER2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIER2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIER2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIER2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIER2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIER2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIER2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIER2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIER2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIER2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIER2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIER2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIER2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIER2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIER2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIER2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIER2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIER2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIER2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIER2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIER2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIER2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIER2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIER2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIER2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIER2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIER2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIER2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIER2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIER2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIER2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x800000) >> 23
}

// PWM.IDR2: PWM Interrupt Disable Register 2
func (o *PWM_Type) SetIDR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *PWM_Type) SetIDR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIDR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIDR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIDR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIDR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIDR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIDR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIDR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIDR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIDR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIDR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIDR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIDR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIDR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIDR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIDR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIDR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIDR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIDR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIDR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIDR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIDR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIDR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIDR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIDR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIDR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIDR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIDR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIDR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIDR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIDR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIDR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIDR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x800000) >> 23
}

// PWM.IMR2: PWM Interrupt Mask Register 2
func (o *PWM_Type) SetIMR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *PWM_Type) SetIMR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIMR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIMR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIMR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIMR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIMR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIMR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIMR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetIMR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetIMR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetIMR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetIMR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetIMR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetIMR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetIMR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetIMR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetIMR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetIMR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetIMR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetIMR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetIMR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetIMR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetIMR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetIMR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetIMR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetIMR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetIMR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetIMR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetIMR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetIMR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetIMR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetIMR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetIMR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x800000) >> 23
}

// PWM.ISR2: PWM Interrupt Status Register 2
func (o *PWM_Type) SetISR2_WRDY(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR2_WRDY() uint32 {
	return volatile.LoadUint32(&o.ISR2.Reg) & 0x1
}
func (o *PWM_Type) SetISR2_UNRE(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR2_UNRE() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetISR2_CMPM0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetISR2_CMPM0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetISR2_CMPM1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetISR2_CMPM1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetISR2_CMPM2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetISR2_CMPM2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetISR2_CMPM3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetISR2_CMPM3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetISR2_CMPM4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetISR2_CMPM4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetISR2_CMPM5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetISR2_CMPM5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetISR2_CMPM6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetISR2_CMPM6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetISR2_CMPM7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetISR2_CMPM7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetISR2_CMPU0(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetISR2_CMPU0() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetISR2_CMPU1(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetISR2_CMPU1() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetISR2_CMPU2(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetISR2_CMPU2() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetISR2_CMPU3(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetISR2_CMPU3() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetISR2_CMPU4(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetISR2_CMPU4() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetISR2_CMPU5(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x200000)|value<<21)
}
func (o *PWM_Type) GetISR2_CMPU5() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x200000) >> 21
}
func (o *PWM_Type) SetISR2_CMPU6(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x400000)|value<<22)
}
func (o *PWM_Type) GetISR2_CMPU6() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x400000) >> 22
}
func (o *PWM_Type) SetISR2_CMPU7(value uint32) {
	volatile.StoreUint32(&o.ISR2.Reg, volatile.LoadUint32(&o.ISR2.Reg)&^(0x800000)|value<<23)
}
func (o *PWM_Type) GetISR2_CMPU7() uint32 {
	return (volatile.LoadUint32(&o.ISR2.Reg) & 0x800000) >> 23
}

// PWM.OOV: PWM Output Override Value Register
func (o *PWM_Type) SetOOV_OOVH0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOOV_OOVH0() uint32 {
	return volatile.LoadUint32(&o.OOV.Reg) & 0x1
}
func (o *PWM_Type) SetOOV_OOVH1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOOV_OOVH1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOOV_OOVH2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOOV_OOVH2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOOV_OOVH3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOOV_OOVH3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOOV_OOVL0(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOOV_OOVL0() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOOV_OOVL1(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOOV_OOVL1() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOOV_OOVL2(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOOV_OOVL2() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOOV_OOVL3(value uint32) {
	volatile.StoreUint32(&o.OOV.Reg, volatile.LoadUint32(&o.OOV.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOOV_OOVL3() uint32 {
	return (volatile.LoadUint32(&o.OOV.Reg) & 0x80000) >> 19
}

// PWM.OS: PWM Output Selection Register
func (o *PWM_Type) SetOS_OSH0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOS_OSH0() uint32 {
	return volatile.LoadUint32(&o.OS.Reg) & 0x1
}
func (o *PWM_Type) SetOS_OSH1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOS_OSH1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOS_OSH2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOS_OSH2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOS_OSH3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOS_OSH3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOS_OSL0(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOS_OSL0() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOS_OSL1(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOS_OSL1() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOS_OSL2(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOS_OSL2() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOS_OSL3(value uint32) {
	volatile.StoreUint32(&o.OS.Reg, volatile.LoadUint32(&o.OS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOS_OSL3() uint32 {
	return (volatile.LoadUint32(&o.OS.Reg) & 0x80000) >> 19
}

// PWM.OSS: PWM Output Selection Set Register
func (o *PWM_Type) SetOSS_OSSH0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSS_OSSH0() uint32 {
	return volatile.LoadUint32(&o.OSS.Reg) & 0x1
}
func (o *PWM_Type) SetOSS_OSSH1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSS_OSSH1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSS_OSSH2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSS_OSSH2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSS_OSSH3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSS_OSSH3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSS_OSSL0(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSS_OSSL0() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSS_OSSL1(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSS_OSSL1() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSS_OSSL2(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSS_OSSL2() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSS_OSSL3(value uint32) {
	volatile.StoreUint32(&o.OSS.Reg, volatile.LoadUint32(&o.OSS.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSS_OSSL3() uint32 {
	return (volatile.LoadUint32(&o.OSS.Reg) & 0x80000) >> 19
}

// PWM.OSC: PWM Output Selection Clear Register
func (o *PWM_Type) SetOSC_OSCH0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSC_OSCH0() uint32 {
	return volatile.LoadUint32(&o.OSC.Reg) & 0x1
}
func (o *PWM_Type) SetOSC_OSCH1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSC_OSCH1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSC_OSCH2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSC_OSCH2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSC_OSCH3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSC_OSCH3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSC_OSCL0(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSC_OSCL0() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSC_OSCL1(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSC_OSCL1() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSC_OSCL2(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSC_OSCL2() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSC_OSCL3(value uint32) {
	volatile.StoreUint32(&o.OSC.Reg, volatile.LoadUint32(&o.OSC.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSC_OSCL3() uint32 {
	return (volatile.LoadUint32(&o.OSC.Reg) & 0x80000) >> 19
}

// PWM.OSSUPD: PWM Output Selection Set Update Register
func (o *PWM_Type) SetOSSUPD_OSSUPH0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH0() uint32 {
	return volatile.LoadUint32(&o.OSSUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSSUPD_OSSUPH2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSSUPD_OSSUPH3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSSUPD_OSSUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSSUPD_OSSUPL0(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSSUPD_OSSUPL1(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSSUPD_OSSUPL2(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSSUPD_OSSUPL3(value uint32) {
	volatile.StoreUint32(&o.OSSUPD.Reg, volatile.LoadUint32(&o.OSSUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSSUPD_OSSUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSSUPD.Reg) & 0x80000) >> 19
}

// PWM.OSCUPD: PWM Output Selection Clear Update Register
func (o *PWM_Type) SetOSCUPD_OSCUPH0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH0() uint32 {
	return volatile.LoadUint32(&o.OSCUPD.Reg) & 0x1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetOSCUPD_OSCUPH2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetOSCUPD_OSCUPH3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetOSCUPD_OSCUPH3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetOSCUPD_OSCUPL0(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL0() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetOSCUPD_OSCUPL1(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL1() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetOSCUPD_OSCUPL2(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL2() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetOSCUPD_OSCUPL3(value uint32) {
	volatile.StoreUint32(&o.OSCUPD.Reg, volatile.LoadUint32(&o.OSCUPD.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetOSCUPD_OSCUPL3() uint32 {
	return (volatile.LoadUint32(&o.OSCUPD.Reg) & 0x80000) >> 19
}

// PWM.FMR: PWM Fault Mode Register
func (o *PWM_Type) SetFMR_FPOL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFMR_FPOL() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0xff
}
func (o *PWM_Type) SetFMR_FMOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFMR_FMOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFMR_FFIL(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFMR_FFIL() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xff0000) >> 16
}

// PWM.FSR: PWM Fault Status Register
func (o *PWM_Type) SetFSR_FIV(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFSR_FIV() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0xff
}
func (o *PWM_Type) SetFSR_FS(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFSR_FS() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0xff00) >> 8
}

// PWM.FCR: PWM Fault Clear Register
func (o *PWM_Type) SetFCR_FCLR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFCR_FCLR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// PWM.FPV1: PWM Fault Protection Value Register 1
func (o *PWM_Type) SetFPV1_FPVH0(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV1_FPVH0() uint32 {
	return volatile.LoadUint32(&o.FPV1.Reg) & 0x1
}
func (o *PWM_Type) SetFPV1_FPVH1(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV1_FPVH1() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV1_FPVH2(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV1_FPVH2() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV1_FPVH3(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV1_FPVH3() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV1_FPVL0(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV1_FPVL0() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV1_FPVL1(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV1_FPVL1() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV1_FPVL2(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV1_FPVL2() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV1_FPVL3(value uint32) {
	volatile.StoreUint32(&o.FPV1.Reg, volatile.LoadUint32(&o.FPV1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV1_FPVL3() uint32 {
	return (volatile.LoadUint32(&o.FPV1.Reg) & 0x80000) >> 19
}

// PWM.FPE: PWM Fault Protection Enable Register
func (o *PWM_Type) SetFPE_FPE0(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetFPE_FPE0() uint32 {
	return volatile.LoadUint32(&o.FPE.Reg) & 0xff
}
func (o *PWM_Type) SetFPE_FPE1(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff00)|value<<8)
}
func (o *PWM_Type) GetFPE_FPE1() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff00) >> 8
}
func (o *PWM_Type) SetFPE_FPE2(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetFPE_FPE2() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetFPE_FPE3(value uint32) {
	volatile.StoreUint32(&o.FPE.Reg, volatile.LoadUint32(&o.FPE.Reg)&^(0xff000000)|value<<24)
}
func (o *PWM_Type) GetFPE_FPE3() uint32 {
	return (volatile.LoadUint32(&o.FPE.Reg) & 0xff000000) >> 24
}

// PWM.ELMR: PWM Event Line 0 Mode Register 0
func (o *PWM_Type) SetELMR_CSEL0(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetELMR_CSEL0(idx int) uint32 {
	return volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x1
}
func (o *PWM_Type) SetELMR_CSEL1(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetELMR_CSEL1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetELMR_CSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetELMR_CSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetELMR_CSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetELMR_CSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetELMR_CSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetELMR_CSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetELMR_CSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetELMR_CSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetELMR_CSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetELMR_CSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetELMR_CSEL7(idx int, value uint32) {
	volatile.StoreUint32(&o.ELMR[idx].Reg, volatile.LoadUint32(&o.ELMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetELMR_CSEL7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ELMR[idx].Reg) & 0x80) >> 7
}

// PWM.SSPR: PWM Spread Spectrum Register
func (o *PWM_Type) SetSSPR_SPRD(value uint32) {
	volatile.StoreUint32(&o.SSPR.Reg, volatile.LoadUint32(&o.SSPR.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetSSPR_SPRD() uint32 {
	return volatile.LoadUint32(&o.SSPR.Reg) & 0xffffff
}
func (o *PWM_Type) SetSSPR_SPRDM(value uint32) {
	volatile.StoreUint32(&o.SSPR.Reg, volatile.LoadUint32(&o.SSPR.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_Type) GetSSPR_SPRDM() uint32 {
	return (volatile.LoadUint32(&o.SSPR.Reg) & 0x1000000) >> 24
}

// PWM.SSPUP: PWM Spread Spectrum Update Register
func (o *PWM_Type) SetSSPUP_SPRDUP(value uint32) {
	volatile.StoreUint32(&o.SSPUP.Reg, volatile.LoadUint32(&o.SSPUP.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetSSPUP_SPRDUP() uint32 {
	return volatile.LoadUint32(&o.SSPUP.Reg) & 0xffffff
}

// PWM.SMMR: PWM Stepper Motor Mode Register
func (o *PWM_Type) SetSMMR_GCEN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSMMR_GCEN0() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *PWM_Type) SetSMMR_GCEN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSMMR_GCEN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSMMR_DOWN0(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetSMMR_DOWN0() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetSMMR_DOWN1(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetSMMR_DOWN1() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x20000) >> 17
}

// PWM.FPV2: PWM Fault Protection Value 2 Register
func (o *PWM_Type) SetFPV2_FPZH0(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetFPV2_FPZH0() uint32 {
	return volatile.LoadUint32(&o.FPV2.Reg) & 0x1
}
func (o *PWM_Type) SetFPV2_FPZH1(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetFPV2_FPZH1() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetFPV2_FPZH2(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetFPV2_FPZH2() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetFPV2_FPZH3(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetFPV2_FPZH3() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetFPV2_FPZL0(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetFPV2_FPZL0() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetFPV2_FPZL1(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetFPV2_FPZL1() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetFPV2_FPZL2(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetFPV2_FPZL2() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetFPV2_FPZL3(value uint32) {
	volatile.StoreUint32(&o.FPV2.Reg, volatile.LoadUint32(&o.FPV2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetFPV2_FPZL3() uint32 {
	return (volatile.LoadUint32(&o.FPV2.Reg) & 0x80000) >> 19
}

// PWM.WPCR: PWM Write Protection Control Register
func (o *PWM_Type) SetWPCR_WPCMD(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetWPCR_WPCMD() uint32 {
	return volatile.LoadUint32(&o.WPCR.Reg) & 0x3
}
func (o *PWM_Type) SetWPCR_WPRG0(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPCR_WPRG0() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPCR_WPRG1(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPCR_WPRG1() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPCR_WPRG2(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPCR_WPRG2() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPCR_WPRG3(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPCR_WPRG3() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPCR_WPRG4(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetWPCR_WPRG4() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetWPCR_WPRG5(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPCR_WPRG5() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPCR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPCR.Reg, volatile.LoadUint32(&o.WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PWM_Type) GetWPCR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPCR.Reg) & 0xffffff00) >> 8
}

// PWM.WPSR: PWM Write Protection Status Register
func (o *PWM_Type) SetWPSR_WPSWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetWPSR_WPSWS0() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PWM_Type) SetWPSR_WPSWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetWPSR_WPSWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetWPSR_WPSWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetWPSR_WPSWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetWPSR_WPSWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetWPSR_WPSWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetWPSR_WPSWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetWPSR_WPSWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetWPSR_WPSWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetWPSR_WPSWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetWPSR_WPVS() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetWPSR_WPHWS0(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetWPSR_WPHWS0() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetWPSR_WPHWS1(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetWPSR_WPHWS1() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetWPSR_WPHWS2(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetWPSR_WPHWS2() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetWPSR_WPHWS3(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetWPSR_WPHWS3() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetWPSR_WPHWS4(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetWPSR_WPHWS4() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetWPSR_WPHWS5(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetWPSR_WPHWS5() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff0000) >> 16
}

// PWM.CMUPD0: PWM Channel Mode Update Register (ch_num = 0)
func (o *PWM_Type) SetCMUPD0_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD0.Reg, volatile.LoadUint32(&o.CMUPD0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD0_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD0_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD0.Reg, volatile.LoadUint32(&o.CMUPD0.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD0_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD0.Reg) & 0x2000) >> 13
}

// PWM.CMUPD1: PWM Channel Mode Update Register (ch_num = 1)
func (o *PWM_Type) SetCMUPD1_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD1.Reg, volatile.LoadUint32(&o.CMUPD1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD1_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD1_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD1.Reg, volatile.LoadUint32(&o.CMUPD1.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD1_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD1.Reg) & 0x2000) >> 13
}

// PWM.ETRG1: PWM External Trigger Register (trg_num = 1)
func (o *PWM_Type) SetETRG1_MAXCNT(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetETRG1_MAXCNT() uint32 {
	return volatile.LoadUint32(&o.ETRG1.Reg) & 0xffffff
}
func (o *PWM_Type) SetETRG1_TRGMODE(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x3000000)|value<<24)
}
func (o *PWM_Type) GetETRG1_TRGMODE() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x3000000) >> 24
}
func (o *PWM_Type) SetETRG1_TRGEDGE(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x10000000)|value<<28)
}
func (o *PWM_Type) GetETRG1_TRGEDGE() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x10000000) >> 28
}
func (o *PWM_Type) SetETRG1_TRGFILT(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x20000000)|value<<29)
}
func (o *PWM_Type) GetETRG1_TRGFILT() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x20000000) >> 29
}
func (o *PWM_Type) SetETRG1_TRGSRC(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x40000000)|value<<30)
}
func (o *PWM_Type) GetETRG1_TRGSRC() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x40000000) >> 30
}
func (o *PWM_Type) SetETRG1_RFEN(value uint32) {
	volatile.StoreUint32(&o.ETRG1.Reg, volatile.LoadUint32(&o.ETRG1.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetETRG1_RFEN() uint32 {
	return (volatile.LoadUint32(&o.ETRG1.Reg) & 0x80000000) >> 31
}

// PWM.LEBR1: PWM Leading-Edge Blanking Register (trg_num = 1)
func (o *PWM_Type) SetLEBR1_LEBDELAY(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x7f)|value)
}
func (o *PWM_Type) GetLEBR1_LEBDELAY() uint32 {
	return volatile.LoadUint32(&o.LEBR1.Reg) & 0x7f
}
func (o *PWM_Type) SetLEBR1_PWMLFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetLEBR1_PWMLFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetLEBR1_PWMLREN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetLEBR1_PWMLREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetLEBR1_PWMHFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetLEBR1_PWMHFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetLEBR1_PWMHREN(value uint32) {
	volatile.StoreUint32(&o.LEBR1.Reg, volatile.LoadUint32(&o.LEBR1.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetLEBR1_PWMHREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR1.Reg) & 0x80000) >> 19
}

// PWM.CMUPD2: PWM Channel Mode Update Register (ch_num = 2)
func (o *PWM_Type) SetCMUPD2_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD2.Reg, volatile.LoadUint32(&o.CMUPD2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD2_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD2_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD2.Reg, volatile.LoadUint32(&o.CMUPD2.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD2_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD2.Reg) & 0x2000) >> 13
}

// PWM.ETRG2: PWM External Trigger Register (trg_num = 2)
func (o *PWM_Type) SetETRG2_MAXCNT(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0xffffff)|value)
}
func (o *PWM_Type) GetETRG2_MAXCNT() uint32 {
	return volatile.LoadUint32(&o.ETRG2.Reg) & 0xffffff
}
func (o *PWM_Type) SetETRG2_TRGMODE(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x3000000)|value<<24)
}
func (o *PWM_Type) GetETRG2_TRGMODE() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x3000000) >> 24
}
func (o *PWM_Type) SetETRG2_TRGEDGE(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x10000000)|value<<28)
}
func (o *PWM_Type) GetETRG2_TRGEDGE() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x10000000) >> 28
}
func (o *PWM_Type) SetETRG2_TRGFILT(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x20000000)|value<<29)
}
func (o *PWM_Type) GetETRG2_TRGFILT() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x20000000) >> 29
}
func (o *PWM_Type) SetETRG2_TRGSRC(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x40000000)|value<<30)
}
func (o *PWM_Type) GetETRG2_TRGSRC() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x40000000) >> 30
}
func (o *PWM_Type) SetETRG2_RFEN(value uint32) {
	volatile.StoreUint32(&o.ETRG2.Reg, volatile.LoadUint32(&o.ETRG2.Reg)&^(0x80000000)|value<<31)
}
func (o *PWM_Type) GetETRG2_RFEN() uint32 {
	return (volatile.LoadUint32(&o.ETRG2.Reg) & 0x80000000) >> 31
}

// PWM.LEBR2: PWM Leading-Edge Blanking Register (trg_num = 2)
func (o *PWM_Type) SetLEBR2_LEBDELAY(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x7f)|value)
}
func (o *PWM_Type) GetLEBR2_LEBDELAY() uint32 {
	return volatile.LoadUint32(&o.LEBR2.Reg) & 0x7f
}
func (o *PWM_Type) SetLEBR2_PWMLFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetLEBR2_PWMLFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetLEBR2_PWMLREN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetLEBR2_PWMLREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetLEBR2_PWMHFEN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetLEBR2_PWMHFEN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetLEBR2_PWMHREN(value uint32) {
	volatile.StoreUint32(&o.LEBR2.Reg, volatile.LoadUint32(&o.LEBR2.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetLEBR2_PWMHREN() uint32 {
	return (volatile.LoadUint32(&o.LEBR2.Reg) & 0x80000) >> 19
}

// PWM.CMUPD3: PWM Channel Mode Update Register (ch_num = 3)
func (o *PWM_Type) SetCMUPD3_CPOLUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD3.Reg, volatile.LoadUint32(&o.CMUPD3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMUPD3_CPOLUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMUPD3_CPOLINVUP(value uint32) {
	volatile.StoreUint32(&o.CMUPD3.Reg, volatile.LoadUint32(&o.CMUPD3.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCMUPD3_CPOLINVUP() uint32 {
	return (volatile.LoadUint32(&o.CMUPD3.Reg) & 0x2000) >> 13
}

// PWM Comparison 0 Value Register
type PWM_PWM_CMP_Type struct {
	CMPV    volatile.Register32 // 0x130
	CMPVUPD volatile.Register32 // 0x134
	CMPM    volatile.Register32 // 0x138
	CMPMUPD volatile.Register32 // 0x13C
}

// PWM_PWM_CMP.CMPV: PWM Comparison 0 Value Register
func (o *PWM_PWM_CMP_Type) SetCMPV_CV(value uint32) {
	volatile.StoreUint32(&o.CMPV.Reg, volatile.LoadUint32(&o.CMPV.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPV_CV() uint32 {
	return volatile.LoadUint32(&o.CMPV.Reg) & 0xffffff
}
func (o *PWM_PWM_CMP_Type) SetCMPV_CVM(value uint32) {
	volatile.StoreUint32(&o.CMPV.Reg, volatile.LoadUint32(&o.CMPV.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_PWM_CMP_Type) GetCMPV_CVM() uint32 {
	return (volatile.LoadUint32(&o.CMPV.Reg) & 0x1000000) >> 24
}

// PWM_PWM_CMP.CMPVUPD: PWM Comparison 0 Value Update Register
func (o *PWM_PWM_CMP_Type) SetCMPVUPD_CVUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD.Reg, volatile.LoadUint32(&o.CMPVUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPVUPD_CVUPD() uint32 {
	return volatile.LoadUint32(&o.CMPVUPD.Reg) & 0xffffff
}
func (o *PWM_PWM_CMP_Type) SetCMPVUPD_CVMUPD(value uint32) {
	volatile.StoreUint32(&o.CMPVUPD.Reg, volatile.LoadUint32(&o.CMPVUPD.Reg)&^(0x1000000)|value<<24)
}
func (o *PWM_PWM_CMP_Type) GetCMPVUPD_CVMUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPVUPD.Reg) & 0x1000000) >> 24
}

// PWM_PWM_CMP.CMPM: PWM Comparison 0 Mode Register
func (o *PWM_PWM_CMP_Type) SetCMPM_CEN(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0x1)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CEN() uint32 {
	return volatile.LoadUint32(&o.CMPM.Reg) & 0x1
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CTR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CTR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf0) >> 4
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CPR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf00) >> 8
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf000)|value<<12)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf000) >> 12
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CUPR(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CUPR() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf0000) >> 16
}
func (o *PWM_PWM_CMP_Type) SetCMPM_CUPRCNT(value uint32) {
	volatile.StoreUint32(&o.CMPM.Reg, volatile.LoadUint32(&o.CMPM.Reg)&^(0xf00000)|value<<20)
}
func (o *PWM_PWM_CMP_Type) GetCMPM_CUPRCNT() uint32 {
	return (volatile.LoadUint32(&o.CMPM.Reg) & 0xf00000) >> 20
}

// PWM_PWM_CMP.CMPMUPD: PWM Comparison 0 Mode Update Register
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CENUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0x1)|value)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CENUPD() uint32 {
	return volatile.LoadUint32(&o.CMPMUPD.Reg) & 0x1
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CTRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf0)|value<<4)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CTRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf0) >> 4
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf00) >> 8
}
func (o *PWM_PWM_CMP_Type) SetCMPMUPD_CUPRUPD(value uint32) {
	volatile.StoreUint32(&o.CMPMUPD.Reg, volatile.LoadUint32(&o.CMPMUPD.Reg)&^(0xf0000)|value<<16)
}
func (o *PWM_PWM_CMP_Type) GetCMPMUPD_CUPRUPD() uint32 {
	return (volatile.LoadUint32(&o.CMPMUPD.Reg) & 0xf0000) >> 16
}

// PWM Channel Mode Register (ch_num = 0)
type PWM_PWM_CH_NUM_Type struct {
	CMR     volatile.Register32 // 0x200
	CDTY    volatile.Register32 // 0x204
	CDTYUPD volatile.Register32 // 0x208
	CPRD    volatile.Register32 // 0x20C
	CPRDUPD volatile.Register32 // 0x210
	CCNT    volatile.Register32 // 0x214
	DT      volatile.Register32 // 0x218
	DTUPD   volatile.Register32 // 0x21C
}

// PWM_PWM_CH_NUM.CMR: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xf)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xf
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x100) >> 8
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x200) >> 9
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_CES(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_CES() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x400) >> 10
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_UPDS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_UPDS() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x800) >> 11
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DPOLI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DPOLI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x1000) >> 12
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_TCTS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_TCTS() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x2000) >> 13
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTE() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x10000) >> 16
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTHI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTHI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x20000) >> 17
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_DTLI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_DTLI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x40000) >> 18
}
func (o *PWM_PWM_CH_NUM_Type) SetCMR_PPM(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_PWM_CH_NUM_Type) GetCMR_PPM() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x80000) >> 19
}

// PWM_PWM_CH_NUM.CDTY: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCDTY(value uint32) {
	volatile.StoreUint32(&o.CDTY.Reg, volatile.LoadUint32(&o.CDTY.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCDTY() uint32 {
	return volatile.LoadUint32(&o.CDTY.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CDTYUPD: PWM Channel Duty Cycle Update Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCDTYUPD(value uint32) {
	volatile.StoreUint32(&o.CDTYUPD.Reg, volatile.LoadUint32(&o.CDTYUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCDTYUPD() uint32 {
	return volatile.LoadUint32(&o.CDTYUPD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CPRD: PWM Channel Period Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCPRD(value uint32) {
	volatile.StoreUint32(&o.CPRD.Reg, volatile.LoadUint32(&o.CPRD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCPRD() uint32 {
	return volatile.LoadUint32(&o.CPRD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CPRDUPD: PWM Channel Period Update Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCPRDUPD(value uint32) {
	volatile.StoreUint32(&o.CPRDUPD.Reg, volatile.LoadUint32(&o.CPRDUPD.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCPRDUPD() uint32 {
	return volatile.LoadUint32(&o.CPRDUPD.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.CCNT: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetCCNT_CNT(value uint32) {
	volatile.StoreUint32(&o.CCNT.Reg, volatile.LoadUint32(&o.CCNT.Reg)&^(0xffffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetCCNT_CNT() uint32 {
	return volatile.LoadUint32(&o.CCNT.Reg) & 0xffffff
}

// PWM_PWM_CH_NUM.DT: PWM Channel Dead Time Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetDT_DTH(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetDT_DTH() uint32 {
	return volatile.LoadUint32(&o.DT.Reg) & 0xffff
}
func (o *PWM_PWM_CH_NUM_Type) SetDT_DTL(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetDT_DTL() uint32 {
	return (volatile.LoadUint32(&o.DT.Reg) & 0xffff0000) >> 16
}

// PWM_PWM_CH_NUM.DTUPD: PWM Channel Dead Time Update Register (ch_num = 0)
func (o *PWM_PWM_CH_NUM_Type) SetDTUPD_DTHUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD.Reg, volatile.LoadUint32(&o.DTUPD.Reg)&^(0xffff)|value)
}
func (o *PWM_PWM_CH_NUM_Type) GetDTUPD_DTHUPD() uint32 {
	return volatile.LoadUint32(&o.DTUPD.Reg) & 0xffff
}
func (o *PWM_PWM_CH_NUM_Type) SetDTUPD_DTLUPD(value uint32) {
	volatile.StoreUint32(&o.DTUPD.Reg, volatile.LoadUint32(&o.DTUPD.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_PWM_CH_NUM_Type) GetDTUPD_DTLUPD() uint32 {
	return (volatile.LoadUint32(&o.DTUPD.Reg) & 0xffff0000) >> 16
}

// Quad Serial Peripheral Interface
type QSPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	SCR  volatile.Register32 // 0x20
	_    [12]byte
	IAR  volatile.Register32 // 0x30
	ICR  volatile.Register32 // 0x34
	IFR  volatile.Register32 // 0x38
	_    [4]byte
	SMR  volatile.Register32 // 0x40
	SKR  volatile.Register32 // 0x44
	_    [156]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// QSPI.CR: Control Register
func (o *QSPI_Type) SetCR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetCR_QSPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *QSPI_Type) SetCR_QSPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetCR_QSPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QSPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QSPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *QSPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// QSPI.MR: Mode Register
func (o *QSPI_Type) SetMR_SMM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetMR_SMM() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *QSPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetMR_CSMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *QSPI_Type) GetMR_CSMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *QSPI_Type) SetMR_NBBITS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *QSPI_Type) GetMR_NBBITS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *QSPI_Type) SetMR_DLYBCT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetMR_DLYBCT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *QSPI_Type) SetMR_DLYCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *QSPI_Type) GetMR_DLYCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// QSPI.RDR: Receive Data Register
func (o *QSPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *QSPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}

// QSPI.TDR: Transmit Data Register
func (o *QSPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *QSPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}

// QSPI.SR: Status Register
func (o *QSPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *QSPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetSR_CSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetSR_CSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetSR_CSS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetSR_CSS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetSR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetSR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *QSPI_Type) SetSR_QSPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *QSPI_Type) GetSR_QSPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}

// QSPI.IER: Interrupt Enable Register
func (o *QSPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *QSPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIER_CSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIER_CSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIER_CSS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIER_CSS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIER_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIER_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// QSPI.IDR: Interrupt Disable Register
func (o *QSPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *QSPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIDR_CSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIDR_CSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIDR_CSS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIDR_CSS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIDR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIDR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// QSPI.IMR: Interrupt Mask Register
func (o *QSPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *QSPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *QSPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *QSPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *QSPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *QSPI_Type) SetIMR_CSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *QSPI_Type) GetIMR_CSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *QSPI_Type) SetIMR_CSS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *QSPI_Type) GetIMR_CSS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *QSPI_Type) SetIMR_INSTRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIMR_INSTRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// QSPI.SCR: Serial Clock Register
func (o *QSPI_Type) SetSCR_CPOL(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSCR_CPOL() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0x1
}
func (o *QSPI_Type) SetSCR_CPHA(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSCR_CPHA() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *QSPI_Type) SetSCR_SCBR(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetSCR_SCBR() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xff00) >> 8
}
func (o *QSPI_Type) SetSCR_DLYBS(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetSCR_DLYBS() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xff0000) >> 16
}

// QSPI.IAR: Instruction Address Register
func (o *QSPI_Type) SetIAR(value uint32) {
	volatile.StoreUint32(&o.IAR.Reg, value)
}
func (o *QSPI_Type) GetIAR() uint32 {
	return volatile.LoadUint32(&o.IAR.Reg)
}

// QSPI.ICR: Instruction Code Register
func (o *QSPI_Type) SetICR_INST(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff)|value)
}
func (o *QSPI_Type) GetICR_INST() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0xff
}
func (o *QSPI_Type) SetICR_OPT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *QSPI_Type) GetICR_OPT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff0000) >> 16
}

// QSPI.IFR: Instruction Frame Register
func (o *QSPI_Type) SetIFR_WIDTH(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x7)|value)
}
func (o *QSPI_Type) GetIFR_WIDTH() uint32 {
	return volatile.LoadUint32(&o.IFR.Reg) & 0x7
}
func (o *QSPI_Type) SetIFR_INSTEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x10)|value<<4)
}
func (o *QSPI_Type) GetIFR_INSTEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x10) >> 4
}
func (o *QSPI_Type) SetIFR_ADDREN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x20)|value<<5)
}
func (o *QSPI_Type) GetIFR_ADDREN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x20) >> 5
}
func (o *QSPI_Type) SetIFR_OPTEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x40)|value<<6)
}
func (o *QSPI_Type) GetIFR_OPTEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x40) >> 6
}
func (o *QSPI_Type) SetIFR_DATAEN(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x80)|value<<7)
}
func (o *QSPI_Type) GetIFR_DATAEN() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x80) >> 7
}
func (o *QSPI_Type) SetIFR_OPTL(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x300)|value<<8)
}
func (o *QSPI_Type) GetIFR_OPTL() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x300) >> 8
}
func (o *QSPI_Type) SetIFR_ADDRL(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x400)|value<<10)
}
func (o *QSPI_Type) GetIFR_ADDRL() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x400) >> 10
}
func (o *QSPI_Type) SetIFR_TFRTYP(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x3000)|value<<12)
}
func (o *QSPI_Type) GetIFR_TFRTYP() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x3000) >> 12
}
func (o *QSPI_Type) SetIFR_CRM(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x4000)|value<<14)
}
func (o *QSPI_Type) GetIFR_CRM() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x4000) >> 14
}
func (o *QSPI_Type) SetIFR_NBDUM(value uint32) {
	volatile.StoreUint32(&o.IFR.Reg, volatile.LoadUint32(&o.IFR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QSPI_Type) GetIFR_NBDUM() uint32 {
	return (volatile.LoadUint32(&o.IFR.Reg) & 0x1f0000) >> 16
}

// QSPI.SMR: Scrambling Mode Register
func (o *QSPI_Type) SetSMR_SCREN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetSMR_SCREN() uint32 {
	return volatile.LoadUint32(&o.SMR.Reg) & 0x1
}
func (o *QSPI_Type) SetSMR_RVDIS(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x2)|value<<1)
}
func (o *QSPI_Type) GetSMR_RVDIS() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x2) >> 1
}

// QSPI.SKR: Scrambling Key Register
func (o *QSPI_Type) SetSKR(value uint32) {
	volatile.StoreUint32(&o.SKR.Reg, value)
}
func (o *QSPI_Type) GetSKR() uint32 {
	return volatile.LoadUint32(&o.SKR.Reg)
}

// QSPI.WPMR: Write Protection Mode Register
func (o *QSPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *QSPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *QSPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// QSPI.WPSR: Write Protection Status Register
func (o *QSPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *QSPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *QSPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *QSPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// Reset Controller
type RSTC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// RSTC.CR: Control Register
func (o *RSTC_Type) SetCR_PROCRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetCR_PROCRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RSTC_Type) SetCR_EXTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RSTC_Type) GetCR_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RSTC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSTC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// RSTC.SR: Status Register
func (o *RSTC_Type) SetSR_URSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetSR_URSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RSTC_Type) SetSR_RSTTYP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x700)|value<<8)
}
func (o *RSTC_Type) GetSR_RSTTYP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x700) >> 8
}
func (o *RSTC_Type) SetSR_NRSTL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *RSTC_Type) GetSR_NRSTL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *RSTC_Type) SetSR_SRCMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *RSTC_Type) GetSR_SRCMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// RSTC.MR: Mode Register
func (o *RSTC_Type) SetMR_URSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetMR_URSTEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *RSTC_Type) SetMR_URSTIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *RSTC_Type) GetMR_URSTIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *RSTC_Type) SetMR_ERSTL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *RSTC_Type) GetMR_ERSTL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *RSTC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSTC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// Reinforced Safety Watchdog Timer
type RSWDT_Type struct {
	CR volatile.Register32 // 0x0
	MR volatile.Register32 // 0x4
	SR volatile.Register32 // 0x8
}

// RSWDT.CR: Control Register
func (o *RSWDT_Type) SetCR_WDRSTT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RSWDT_Type) GetCR_WDRSTT() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RSWDT_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *RSWDT_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// RSWDT.MR: Mode Register
func (o *RSWDT_Type) SetMR_WDV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xfff)|value)
}
func (o *RSWDT_Type) GetMR_WDV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xfff
}
func (o *RSWDT_Type) SetMR_WDFIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *RSWDT_Type) GetMR_WDFIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *RSWDT_Type) SetMR_WDRSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *RSWDT_Type) GetMR_WDRSTEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *RSWDT_Type) SetMR_WDDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *RSWDT_Type) GetMR_WDDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *RSWDT_Type) SetMR_ALLONES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xfff0000)|value<<16)
}
func (o *RSWDT_Type) GetMR_ALLONES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xfff0000) >> 16
}
func (o *RSWDT_Type) SetMR_WDDBGHLT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *RSWDT_Type) GetMR_WDDBGHLT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *RSWDT_Type) SetMR_WDIDLEHLT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *RSWDT_Type) GetMR_WDIDLEHLT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}

// RSWDT.SR: Status Register
func (o *RSWDT_Type) SetSR_WDUNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RSWDT_Type) GetSR_WDUNF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Real-time Clock
type RTC_Type struct {
	CR     volatile.Register32 // 0x0
	MR     volatile.Register32 // 0x4
	TIMR   volatile.Register32 // 0x8
	CALR   volatile.Register32 // 0xC
	TIMALR volatile.Register32 // 0x10
	CALALR volatile.Register32 // 0x14
	SR     volatile.Register32 // 0x18
	SCCR   volatile.Register32 // 0x1C
	IER    volatile.Register32 // 0x20
	IDR    volatile.Register32 // 0x24
	IMR    volatile.Register32 // 0x28
	VER    volatile.Register32 // 0x2C
}

// RTC.CR: Control Register
func (o *RTC_Type) SetCR_UPDTIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCR_UPDTIM() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RTC_Type) SetCR_UPDCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCR_UPDCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCR_TIMEVSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *RTC_Type) GetCR_TIMEVSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *RTC_Type) SetCR_CALEVSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *RTC_Type) GetCR_CALEVSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}

// RTC.MR: Mode Register
func (o *RTC_Type) SetMR_HRMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetMR_HRMOD() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *RTC_Type) SetMR_PERSIAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetMR_PERSIAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetMR_NEGPPM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetMR_NEGPPM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetMR_CORRECTION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetMR_CORRECTION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetMR_HIGHPPM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetMR_HIGHPPM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetMR_OUT0(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_Type) GetMR_OUT0() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x70000) >> 16
}
func (o *RTC_Type) SetMR_OUT1(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700000)|value<<20)
}
func (o *RTC_Type) GetMR_OUT1() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700000) >> 20
}
func (o *RTC_Type) SetMR_THIGH(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *RTC_Type) GetMR_THIGH() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *RTC_Type) SetMR_TPERIOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetMR_TPERIOD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30000000) >> 28
}

// RTC.TIMR: Time Register
func (o *RTC_Type) SetTIMR_SEC(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetTIMR_SEC() uint32 {
	return volatile.LoadUint32(&o.TIMR.Reg) & 0x7f
}
func (o *RTC_Type) SetTIMR_MIN(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetTIMR_MIN() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetTIMR_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetTIMR_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetTIMR_AMPM(value uint32) {
	volatile.StoreUint32(&o.TIMR.Reg, volatile.LoadUint32(&o.TIMR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTIMR_AMPM() uint32 {
	return (volatile.LoadUint32(&o.TIMR.Reg) & 0x400000) >> 22
}

// RTC.CALR: Calendar Register
func (o *RTC_Type) SetCALR_CENT(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetCALR_CENT() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x7f
}
func (o *RTC_Type) SetCALR_YEAR(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0xff00)|value<<8)
}
func (o *RTC_Type) GetCALR_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0xff00) >> 8
}
func (o *RTC_Type) SetCALR_MONTH(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCALR_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCALR_DAY(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0xe00000)|value<<21)
}
func (o *RTC_Type) GetCALR_DAY() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0xe00000) >> 21
}
func (o *RTC_Type) SetCALR_DATE(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetCALR_DATE() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x3f000000) >> 24
}

// RTC.TIMALR: Time Alarm Register
func (o *RTC_Type) SetTIMALR_SEC(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x7f)|value)
}
func (o *RTC_Type) GetTIMALR_SEC() uint32 {
	return volatile.LoadUint32(&o.TIMALR.Reg) & 0x7f
}
func (o *RTC_Type) SetTIMALR_SECEN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTIMALR_SECEN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTIMALR_MIN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x7f00)|value<<8)
}
func (o *RTC_Type) GetTIMALR_MIN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x7f00) >> 8
}
func (o *RTC_Type) SetTIMALR_MINEN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTIMALR_MINEN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTIMALR_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x3f0000)|value<<16)
}
func (o *RTC_Type) GetTIMALR_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x3f0000) >> 16
}
func (o *RTC_Type) SetTIMALR_AMPM(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTIMALR_AMPM() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTIMALR_HOUREN(value uint32) {
	volatile.StoreUint32(&o.TIMALR.Reg, volatile.LoadUint32(&o.TIMALR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTIMALR_HOUREN() uint32 {
	return (volatile.LoadUint32(&o.TIMALR.Reg) & 0x800000) >> 23
}

// RTC.CALALR: Calendar Alarm Register
func (o *RTC_Type) SetCALALR_MONTH(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCALALR_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCALALR_MTHEN(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCALALR_MTHEN() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCALALR_DATE(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetCALALR_DATE() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x3f000000) >> 24
}
func (o *RTC_Type) SetCALALR_DATEEN(value uint32) {
	volatile.StoreUint32(&o.CALALR.Reg, volatile.LoadUint32(&o.CALALR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetCALALR_DATEEN() uint32 {
	return (volatile.LoadUint32(&o.CALALR.Reg) & 0x80000000) >> 31
}

// RTC.SR: Status Register
func (o *RTC_Type) SetSR_ACKUPD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSR_ACKUPD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTC_Type) SetSR_ALARM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSR_ALARM() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSR_SEC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSR_SEC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSR_TIMEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSR_TIMEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSR_CALEV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSR_CALEV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSR_TDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSR_TDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}

// RTC.SCCR: Status Clear Command Register
func (o *RTC_Type) SetSCCR_ACKCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSCCR_ACKCLR() uint32 {
	return volatile.LoadUint32(&o.SCCR.Reg) & 0x1
}
func (o *RTC_Type) SetSCCR_ALRCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSCCR_ALRCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSCCR_SECCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSCCR_SECCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSCCR_TIMCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSCCR_TIMCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetSCCR_CALCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetSCCR_CALCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetSCCR_TDERRCLR(value uint32) {
	volatile.StoreUint32(&o.SCCR.Reg, volatile.LoadUint32(&o.SCCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetSCCR_TDERRCLR() uint32 {
	return (volatile.LoadUint32(&o.SCCR.Reg) & 0x20) >> 5
}

// RTC.IER: Interrupt Enable Register
func (o *RTC_Type) SetIER_ACKEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIER_ACKEN() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *RTC_Type) SetIER_ALREN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIER_ALREN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIER_SECEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIER_SECEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIER_TIMEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIER_TIMEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIER_CALEN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIER_CALEN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIER_TDERREN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIER_TDERREN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}

// RTC.IDR: Interrupt Disable Register
func (o *RTC_Type) SetIDR_ACKDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIDR_ACKDIS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *RTC_Type) SetIDR_ALRDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIDR_ALRDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIDR_SECDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIDR_SECDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIDR_TIMDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIDR_TIMDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIDR_CALDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIDR_CALDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIDR_TDERRDIS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIDR_TDERRDIS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}

// RTC.IMR: Interrupt Mask Register
func (o *RTC_Type) SetIMR_ACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetIMR_ACK() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *RTC_Type) SetIMR_ALR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetIMR_ALR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetIMR_SEC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetIMR_SEC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetIMR_TIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetIMR_TIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetIMR_CAL(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetIMR_CAL() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetIMR_TDERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetIMR_TDERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}

// RTC.VER: Valid Entry Register
func (o *RTC_Type) SetVER_NVTIM(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetVER_NVTIM() uint32 {
	return volatile.LoadUint32(&o.VER.Reg) & 0x1
}
func (o *RTC_Type) SetVER_NVCAL(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetVER_NVCAL() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetVER_NVTIMALR(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetVER_NVTIMALR() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetVER_NVCALALR(value uint32) {
	volatile.StoreUint32(&o.VER.Reg, volatile.LoadUint32(&o.VER.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetVER_NVCALALR() uint32 {
	return (volatile.LoadUint32(&o.VER.Reg) & 0x8) >> 3
}

// Real-time Timer
type RTT_Type struct {
	MR volatile.Register32 // 0x0
	AR volatile.Register32 // 0x4
	VR volatile.Register32 // 0x8
	SR volatile.Register32 // 0xC
}

// RTT.MR: Mode Register
func (o *RTT_Type) SetMR_RTPRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xffff)|value)
}
func (o *RTT_Type) GetMR_RTPRES() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xffff
}
func (o *RTT_Type) SetMR_ALMIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *RTT_Type) GetMR_ALMIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *RTT_Type) SetMR_RTTINCIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *RTT_Type) GetMR_RTTINCIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *RTT_Type) SetMR_RTTRST(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *RTT_Type) GetMR_RTTRST() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *RTT_Type) SetMR_RTTDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *RTT_Type) GetMR_RTTDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *RTT_Type) SetMR_RTC1HZ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTT_Type) GetMR_RTC1HZ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000000) >> 24
}

// RTT.AR: Alarm Register
func (o *RTT_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *RTT_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// RTT.VR: Value Register
func (o *RTT_Type) SetVR(value uint32) {
	volatile.StoreUint32(&o.VR.Reg, value)
}
func (o *RTT_Type) GetVR() uint32 {
	return volatile.LoadUint32(&o.VR.Reg)
}

// RTT.SR: Status Register
func (o *RTT_Type) SetSR_ALMS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RTT_Type) GetSR_ALMS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *RTT_Type) SetSR_RTTINC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RTT_Type) GetSR_RTTINC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}

// Synchronous Serial Controller
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.WPMR: Write Protection Mode Register
func (o *SSC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SSC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SSC.WPSR: Write Protection Status Register
func (o *SSC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SSC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *SSC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Supply Controller
type SUPC_Type struct {
	CR   volatile.Register32 // 0x0
	SMMR volatile.Register32 // 0x4
	MR   volatile.Register32 // 0x8
	WUMR volatile.Register32 // 0xC
	WUIR volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
}

// SUPC.CR: Supply Controller Control Register
func (o *SUPC_Type) SetCR_VROFF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetCR_VROFF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetCR_XTALSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetCR_XTALSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// SUPC.SMMR: Supply Controller Supply Monitor Mode Register
func (o *SUPC_Type) SetSMMR_SMTH(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0xf)|value)
}
func (o *SUPC_Type) GetSMMR_SMTH() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0xf
}
func (o *SUPC_Type) SetSMMR_SMSMPL(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x700)|value<<8)
}
func (o *SUPC_Type) GetSMMR_SMSMPL() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x700) >> 8
}
func (o *SUPC_Type) SetSMMR_SMRSTEN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetSMMR_SMRSTEN() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetSMMR_SMIEN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetSMMR_SMIEN() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2000) >> 13
}

// SUPC.MR: Supply Controller Mode Register
func (o *SUPC_Type) SetMR_BODRSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetMR_BODRSTEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetMR_BODDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetMR_BODDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *SUPC_Type) SetMR_ONREG(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *SUPC_Type) GetMR_ONREG() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *SUPC_Type) SetMR_BKUPRETON(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *SUPC_Type) GetMR_BKUPRETON() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *SUPC_Type) SetMR_OSCBYPASS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *SUPC_Type) GetMR_OSCBYPASS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *SUPC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SUPC.WUMR: Supply Controller Wake-up Mode Register
func (o *SUPC_Type) SetWUMR_SMEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetWUMR_SMEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetWUMR_RTTEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetWUMR_RTTEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetWUMR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetWUMR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetWUMR_LPDBCEN0(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetWUMR_LPDBCEN0() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetWUMR_LPDBCEN1(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetWUMR_LPDBCEN1() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetWUMR_LPDBCCLR(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetWUMR_LPDBCCLR() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetWUMR_WKUPDBC(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x7000)|value<<12)
}
func (o *SUPC_Type) GetWUMR_WKUPDBC() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x7000) >> 12
}
func (o *SUPC_Type) SetWUMR_LPDBC(value uint32) {
	volatile.StoreUint32(&o.WUMR.Reg, volatile.LoadUint32(&o.WUMR.Reg)&^(0x70000)|value<<16)
}
func (o *SUPC_Type) GetWUMR_LPDBC() uint32 {
	return (volatile.LoadUint32(&o.WUMR.Reg) & 0x70000) >> 16
}

// SUPC.WUIR: Supply Controller Wake-up Inputs Register
func (o *SUPC_Type) SetWUIR_WKUPEN0(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetWUIR_WKUPEN0() uint32 {
	return volatile.LoadUint32(&o.WUIR.Reg) & 0x1
}
func (o *SUPC_Type) SetWUIR_WKUPEN1(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetWUIR_WKUPEN1() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetWUIR_WKUPEN2(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetWUIR_WKUPEN2() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetWUIR_WKUPEN3(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetWUIR_WKUPEN3() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetWUIR_WKUPEN4(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetWUIR_WKUPEN4() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetWUIR_WKUPEN5(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetWUIR_WKUPEN5() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetWUIR_WKUPEN6(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetWUIR_WKUPEN6() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetWUIR_WKUPEN7(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetWUIR_WKUPEN7() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetWUIR_WKUPEN8(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetWUIR_WKUPEN8() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetWUIR_WKUPEN9(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetWUIR_WKUPEN9() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetWUIR_WKUPEN10(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetWUIR_WKUPEN10() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetWUIR_WKUPEN11(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetWUIR_WKUPEN11() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x800) >> 11
}
func (o *SUPC_Type) SetWUIR_WKUPEN12(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x1000)|value<<12)
}
func (o *SUPC_Type) GetWUIR_WKUPEN12() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x1000) >> 12
}
func (o *SUPC_Type) SetWUIR_WKUPEN13(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetWUIR_WKUPEN13() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x2000) >> 13
}
func (o *SUPC_Type) SetWUIR_WKUPT0(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x10000)|value<<16)
}
func (o *SUPC_Type) GetWUIR_WKUPT0() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x10000) >> 16
}
func (o *SUPC_Type) SetWUIR_WKUPT1(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x20000)|value<<17)
}
func (o *SUPC_Type) GetWUIR_WKUPT1() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x20000) >> 17
}
func (o *SUPC_Type) SetWUIR_WKUPT2(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x40000)|value<<18)
}
func (o *SUPC_Type) GetWUIR_WKUPT2() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x40000) >> 18
}
func (o *SUPC_Type) SetWUIR_WKUPT3(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x80000)|value<<19)
}
func (o *SUPC_Type) GetWUIR_WKUPT3() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x80000) >> 19
}
func (o *SUPC_Type) SetWUIR_WKUPT4(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x100000)|value<<20)
}
func (o *SUPC_Type) GetWUIR_WKUPT4() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x100000) >> 20
}
func (o *SUPC_Type) SetWUIR_WKUPT5(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x200000)|value<<21)
}
func (o *SUPC_Type) GetWUIR_WKUPT5() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x200000) >> 21
}
func (o *SUPC_Type) SetWUIR_WKUPT6(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x400000)|value<<22)
}
func (o *SUPC_Type) GetWUIR_WKUPT6() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x400000) >> 22
}
func (o *SUPC_Type) SetWUIR_WKUPT7(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x800000)|value<<23)
}
func (o *SUPC_Type) GetWUIR_WKUPT7() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x800000) >> 23
}
func (o *SUPC_Type) SetWUIR_WKUPT8(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x1000000)|value<<24)
}
func (o *SUPC_Type) GetWUIR_WKUPT8() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x1000000) >> 24
}
func (o *SUPC_Type) SetWUIR_WKUPT9(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x2000000)|value<<25)
}
func (o *SUPC_Type) GetWUIR_WKUPT9() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x2000000) >> 25
}
func (o *SUPC_Type) SetWUIR_WKUPT10(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x4000000)|value<<26)
}
func (o *SUPC_Type) GetWUIR_WKUPT10() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x4000000) >> 26
}
func (o *SUPC_Type) SetWUIR_WKUPT11(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x8000000)|value<<27)
}
func (o *SUPC_Type) GetWUIR_WKUPT11() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x8000000) >> 27
}
func (o *SUPC_Type) SetWUIR_WKUPT12(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x10000000)|value<<28)
}
func (o *SUPC_Type) GetWUIR_WKUPT12() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x10000000) >> 28
}
func (o *SUPC_Type) SetWUIR_WKUPT13(value uint32) {
	volatile.StoreUint32(&o.WUIR.Reg, volatile.LoadUint32(&o.WUIR.Reg)&^(0x20000000)|value<<29)
}
func (o *SUPC_Type) GetWUIR_WKUPT13() uint32 {
	return (volatile.LoadUint32(&o.WUIR.Reg) & 0x20000000) >> 29
}

// SUPC.SR: Supply Controller Status Register
func (o *SUPC_Type) SetSR_WKUPS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetSR_WKUPS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetSR_SMWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetSR_SMWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetSR_BODRSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetSR_BODRSTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetSR_SMRSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetSR_SMRSTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetSR_SMS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetSR_SMS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetSR_SMOS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetSR_SMOS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetSR_OSCSEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetSR_OSCSEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetSR_LPDBCS0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *SUPC_Type) GetSR_LPDBCS0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *SUPC_Type) SetSR_LPDBCS1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *SUPC_Type) GetSR_LPDBCS1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *SUPC_Type) SetSR_WKUPIS0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SUPC_Type) GetSR_WKUPIS0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SUPC_Type) SetSR_WKUPIS1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SUPC_Type) GetSR_WKUPIS1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *SUPC_Type) SetSR_WKUPIS2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *SUPC_Type) GetSR_WKUPIS2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *SUPC_Type) SetSR_WKUPIS3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *SUPC_Type) GetSR_WKUPIS3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *SUPC_Type) SetSR_WKUPIS4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *SUPC_Type) GetSR_WKUPIS4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *SUPC_Type) SetSR_WKUPIS5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *SUPC_Type) GetSR_WKUPIS5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *SUPC_Type) SetSR_WKUPIS6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *SUPC_Type) GetSR_WKUPIS6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *SUPC_Type) SetSR_WKUPIS7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *SUPC_Type) GetSR_WKUPIS7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *SUPC_Type) SetSR_WKUPIS8(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *SUPC_Type) GetSR_WKUPIS8() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *SUPC_Type) SetSR_WKUPIS9(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *SUPC_Type) GetSR_WKUPIS9() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *SUPC_Type) SetSR_WKUPIS10(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *SUPC_Type) GetSR_WKUPIS10() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *SUPC_Type) SetSR_WKUPIS11(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *SUPC_Type) GetSR_WKUPIS11() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *SUPC_Type) SetSR_WKUPIS12(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *SUPC_Type) GetSR_WKUPIS12() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *SUPC_Type) SetSR_WKUPIS13(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *SUPC_Type) GetSR_WKUPIS13() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}

// Timer Counter
type TC_Type struct {
	TC_CHANNEL [3]TC_TC_CHANNEL_Type // 0x0
	BCR        volatile.Register32   // 0xC0
	BMR        volatile.Register32   // 0xC4
	QIER       volatile.Register32   // 0xC8
	QIDR       volatile.Register32   // 0xCC
	QIMR       volatile.Register32   // 0xD0
	QISR       volatile.Register32   // 0xD4
	FMR        volatile.Register32   // 0xD8
	_          [8]byte
	WPMR       volatile.Register32 // 0xE4
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// TC.FMR: Fault Mode Register
func (o *TC_Type) SetFMR_ENCF0(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetFMR_ENCF0() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *TC_Type) SetFMR_ENCF1(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetFMR_ENCF1() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x2) >> 1
}

// TC.WPMR: Write Protection Mode Register
func (o *TC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Channel Control Register (channel = 0)
type TC_TC_CHANNEL_Type struct {
	CCR  volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	SMMR volatile.Register32 // 0x8
	RAB  volatile.Register32 // 0xC
	CV   volatile.Register32 // 0x10
	RA   volatile.Register32 // 0x14
	RB   volatile.Register32 // 0x18
	RC   volatile.Register32 // 0x1C
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	EMR  volatile.Register32 // 0x30
	_    [12]byte
}

// TC_TC_CHANNEL.CCR: Channel Control Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetCCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetCCR_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetCCR_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetCCR_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *TC_TC_CHANNEL_Type) SetCCR_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *TC_TC_CHANNEL_Type) GetCCR_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}

// TC_TC_CHANNEL.CMR: Channel Mode Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetCMR_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x7)|value)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0x7
}
func (o *TC_TC_CHANNEL_Type) SetCMR_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x8)|value<<3)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x8) >> 3
}
func (o *TC_TC_CHANNEL_Type) SetCMR_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x30) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetCMR_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x40)|value<<6)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x40) >> 6
}
func (o *TC_TC_CHANNEL_Type) SetCMR_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x80)|value<<7)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x80) >> 7
}
func (o *TC_TC_CHANNEL_Type) SetCMR_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x300)|value<<8)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x300) >> 8
}
func (o *TC_TC_CHANNEL_Type) SetCMR_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x400) >> 10
}
func (o *TC_TC_CHANNEL_Type) SetCMR_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x4000) >> 14
}
func (o *TC_TC_CHANNEL_Type) SetCMR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x8000) >> 15
}
func (o *TC_TC_CHANNEL_Type) SetCMR_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x30000)|value<<16)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x30000) >> 16
}
func (o *TC_TC_CHANNEL_Type) SetCMR_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0xc0000) >> 18
}
func (o *TC_TC_CHANNEL_Type) SetCMR_SBSMPLR(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x700000)|value<<20)
}
func (o *TC_TC_CHANNEL_Type) GetCMR_SBSMPLR() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x700000) >> 20
}

// TC_TC_CHANNEL.SMMR: Stepper Motor Mode Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetSMMR_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetSMMR_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetSMMR_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR.Reg, volatile.LoadUint32(&o.SMMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetSMMR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR.Reg) & 0x2) >> 1
}

// TC_TC_CHANNEL.RAB: Register AB (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetRAB(value uint32) {
	volatile.StoreUint32(&o.RAB.Reg, value)
}
func (o *TC_TC_CHANNEL_Type) GetRAB() uint32 {
	return volatile.LoadUint32(&o.RAB.Reg)
}

// TC_TC_CHANNEL.CV: Counter Value (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetCV(value uint32) {
	volatile.StoreUint32(&o.CV.Reg, value)
}
func (o *TC_TC_CHANNEL_Type) GetCV() uint32 {
	return volatile.LoadUint32(&o.CV.Reg)
}

// TC_TC_CHANNEL.RA: Register A (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetRA(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, value)
}
func (o *TC_TC_CHANNEL_Type) GetRA() uint32 {
	return volatile.LoadUint32(&o.RA.Reg)
}

// TC_TC_CHANNEL.RB: Register B (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetRB(value uint32) {
	volatile.StoreUint32(&o.RB.Reg, value)
}
func (o *TC_TC_CHANNEL_Type) GetRB() uint32 {
	return volatile.LoadUint32(&o.RB.Reg)
}

// TC_TC_CHANNEL.RC: Register C (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetRC(value uint32) {
	volatile.StoreUint32(&o.RC.Reg, value)
}
func (o *TC_TC_CHANNEL_Type) GetRC() uint32 {
	return volatile.LoadUint32(&o.RC.Reg)
}

// TC_TC_CHANNEL.SR: Status Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetSR_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetSR_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetSR_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetSR_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TC_TC_CHANNEL_Type) SetSR_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TC_TC_CHANNEL_Type) GetSR_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TC_TC_CHANNEL_Type) SetSR_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TC_TC_CHANNEL_Type) GetSR_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TC_TC_CHANNEL_Type) SetSR_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetSR_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetSR_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TC_TC_CHANNEL_Type) GetSR_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TC_TC_CHANNEL_Type) SetSR_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TC_TC_CHANNEL_Type) GetSR_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TC_TC_CHANNEL_Type) SetSR_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TC_TC_CHANNEL_Type) GetSR_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TC_TC_CHANNEL_Type) SetSR_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_TC_CHANNEL_Type) GetSR_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TC_TC_CHANNEL_Type) SetSR_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_TC_CHANNEL_Type) GetSR_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *TC_TC_CHANNEL_Type) SetSR_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TC_TC_CHANNEL_Type) GetSR_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}

// TC_TC_CHANNEL.IER: Interrupt Enable Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetIER_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetIER_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetIER_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetIER_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TC_TC_CHANNEL_Type) SetIER_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TC_TC_CHANNEL_Type) GetIER_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TC_TC_CHANNEL_Type) SetIER_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *TC_TC_CHANNEL_Type) GetIER_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *TC_TC_CHANNEL_Type) SetIER_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetIER_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetIER_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TC_TC_CHANNEL_Type) GetIER_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TC_TC_CHANNEL_Type) SetIER_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TC_TC_CHANNEL_Type) GetIER_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TC_TC_CHANNEL_Type) SetIER_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *TC_TC_CHANNEL_Type) GetIER_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}

// TC_TC_CHANNEL.IDR: Interrupt Disable Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetIDR_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetIDR_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TC_TC_CHANNEL_Type) SetIDR_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TC_TC_CHANNEL_Type) SetIDR_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *TC_TC_CHANNEL_Type) SetIDR_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetIDR_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TC_TC_CHANNEL_Type) SetIDR_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TC_TC_CHANNEL_Type) SetIDR_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *TC_TC_CHANNEL_Type) GetIDR_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}

// TC_TC_CHANNEL.IMR: Interrupt Mask Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetIMR_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TC_TC_CHANNEL_Type) SetIMR_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TC_TC_CHANNEL_Type) SetIMR_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TC_TC_CHANNEL_Type) SetIMR_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *TC_TC_CHANNEL_Type) SetIMR_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetIMR_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TC_TC_CHANNEL_Type) SetIMR_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TC_TC_CHANNEL_Type) SetIMR_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *TC_TC_CHANNEL_Type) GetIMR_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}

// TC_TC_CHANNEL.EMR: Extended Mode Register (channel = 0)
func (o *TC_TC_CHANNEL_Type) SetEMR_TRIGSRCA(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *TC_TC_CHANNEL_Type) GetEMR_TRIGSRCA() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *TC_TC_CHANNEL_Type) SetEMR_TRIGSRCB(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_TC_CHANNEL_Type) GetEMR_TRIGSRCB() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *TC_TC_CHANNEL_Type) SetEMR_NODIVCLK(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_TC_CHANNEL_Type) GetEMR_NODIVCLK() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// TRNG.CR: Control Register
func (o *TRNG_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TRNG_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TRNG_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffffff00) >> 8
}

// TRNG.IER: Interrupt Enable Register
func (o *TRNG_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TRNG.IDR: Interrupt Disable Register
func (o *TRNG_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// TRNG.IMR: Interrupt Mask Register
func (o *TRNG_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// TRNG.ISR: Interrupt Status Register
func (o *TRNG_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TRNG.ODATA: Output Data Register
func (o *TRNG_Type) SetODATA(value uint32) {
	volatile.StoreUint32(&o.ODATA.Reg, value)
}
func (o *TRNG_Type) GetODATA() uint32 {
	return volatile.LoadUint32(&o.ODATA.Reg)
}

// Two-wire Interface High Speed
type TWIHS_Type struct {
	CR    volatile.Register32 // 0x0
	MMR   volatile.Register32 // 0x4
	SMR   volatile.Register32 // 0x8
	IADR  volatile.Register32 // 0xC
	CWGR  volatile.Register32 // 0x10
	_     [12]byte
	SR    volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	RHR   volatile.Register32 // 0x30
	THR   volatile.Register32 // 0x34
	SMBTR volatile.Register32 // 0x38
	_     [8]byte
	FILTR volatile.Register32 // 0x44
	_     [4]byte
	SWMR  volatile.Register32 // 0x4C
	_     [148]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// TWIHS.CR: Control Register
func (o *TWIHS_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWIHS_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWIHS_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWIHS_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWIHS_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWIHS_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWIHS_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWIHS_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWIHS_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *TWIHS_Type) SetCR_HSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *TWIHS_Type) GetCR_HSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *TWIHS_Type) SetCR_HSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *TWIHS_Type) GetCR_HSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *TWIHS_Type) SetCR_SMBEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *TWIHS_Type) GetCR_SMBEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *TWIHS_Type) SetCR_SMBDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *TWIHS_Type) GetCR_SMBDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *TWIHS_Type) SetCR_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *TWIHS_Type) GetCR_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *TWIHS_Type) SetCR_PECDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *TWIHS_Type) GetCR_PECDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *TWIHS_Type) SetCR_PECRQ(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *TWIHS_Type) GetCR_PECRQ() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *TWIHS_Type) SetCR_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *TWIHS_Type) GetCR_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *TWIHS_Type) SetCR_ACMEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *TWIHS_Type) GetCR_ACMEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *TWIHS_Type) SetCR_ACMDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *TWIHS_Type) GetCR_ACMDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *TWIHS_Type) SetCR_THRCLR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIHS_Type) GetCR_THRCLR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *TWIHS_Type) SetCR_LOCKCLR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIHS_Type) GetCR_LOCKCLR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *TWIHS_Type) SetCR_FIFOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *TWIHS_Type) GetCR_FIFOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *TWIHS_Type) SetCR_FIFODIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *TWIHS_Type) GetCR_FIFODIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}

// TWIHS.MMR: Master Mode Register
func (o *TWIHS_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWIHS_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWIHS_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWIHS_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWIHS_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWIHS_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWIHS.SMR: Slave Mode Register
func (o *TWIHS_Type) SetSMR_NACKEN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetSMR_NACKEN() uint32 {
	return volatile.LoadUint32(&o.SMR.Reg) & 0x1
}
func (o *TWIHS_Type) SetSMR_SMDA(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetSMR_SMDA() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetSMR_SMHH(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x8)|value<<3)
}
func (o *TWIHS_Type) GetSMR_SMHH() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x8) >> 3
}
func (o *TWIHS_Type) SetSMR_SCLWSDIS(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetSMR_SCLWSDIS() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetSMR_MASK(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f00)|value<<8)
}
func (o *TWIHS_Type) GetSMR_MASK() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f00) >> 8
}
func (o *TWIHS_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWIHS_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}
func (o *TWIHS_Type) SetSMR_SADR1EN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x10000000)|value<<28)
}
func (o *TWIHS_Type) GetSMR_SADR1EN() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x10000000) >> 28
}
func (o *TWIHS_Type) SetSMR_SADR2EN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x20000000)|value<<29)
}
func (o *TWIHS_Type) GetSMR_SADR2EN() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x20000000) >> 29
}
func (o *TWIHS_Type) SetSMR_SADR3EN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x40000000)|value<<30)
}
func (o *TWIHS_Type) GetSMR_SADR3EN() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x40000000) >> 30
}
func (o *TWIHS_Type) SetSMR_DATAMEN(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIHS_Type) GetSMR_DATAMEN() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x80000000) >> 31
}

// TWIHS.IADR: Internal Address Register
func (o *TWIHS_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWIHS_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWIHS.CWGR: Clock Waveform Generator Register
func (o *TWIHS_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWIHS_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWIHS_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWIHS_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWIHS_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWIHS_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}
func (o *TWIHS_Type) SetCWGR_HOLD(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x3f000000)|value<<24)
}
func (o *TWIHS_Type) GetCWGR_HOLD() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x3f000000) >> 24
}

// TWIHS.SR: Status Register
func (o *TWIHS_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWIHS_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWIHS_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWIHS_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWIHS_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWIHS_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWIHS_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWIHS_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TWIHS_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TWIHS_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWIHS_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWIHS_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWIHS_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWIHS_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWIHS_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWIHS_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWIHS_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TWIHS_Type) SetSR_MCACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TWIHS_Type) GetSR_MCACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TWIHS_Type) SetSR_TOUT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIHS_Type) GetSR_TOUT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TWIHS_Type) SetSR_PECERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIHS_Type) GetSR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *TWIHS_Type) SetSR_SMBDAM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIHS_Type) GetSR_SMBDAM() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TWIHS_Type) SetSR_SMBHHM(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *TWIHS_Type) GetSR_SMBHHM() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *TWIHS_Type) SetSR_SCL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIHS_Type) GetSR_SCL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *TWIHS_Type) SetSR_SDA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIHS_Type) GetSR_SDA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}

// TWIHS.IER: Interrupt Enable Register
func (o *TWIHS_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWIHS_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWIHS_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWIHS_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWIHS_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWIHS_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *TWIHS_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *TWIHS_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWIHS_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWIHS_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWIHS_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWIHS_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWIHS_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWIHS_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWIHS_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TWIHS_Type) SetIER_MCACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *TWIHS_Type) GetIER_MCACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *TWIHS_Type) SetIER_TOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TWIHS_Type) GetIER_TOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TWIHS_Type) SetIER_PECERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *TWIHS_Type) GetIER_PECERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *TWIHS_Type) SetIER_SMBDAM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TWIHS_Type) GetIER_SMBDAM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TWIHS_Type) SetIER_SMBHHM(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *TWIHS_Type) GetIER_SMBHHM() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}

// TWIHS.IDR: Interrupt Disable Register
func (o *TWIHS_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWIHS_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWIHS_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWIHS_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWIHS_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWIHS_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *TWIHS_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *TWIHS_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWIHS_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWIHS_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWIHS_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWIHS_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWIHS_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWIHS_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWIHS_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TWIHS_Type) SetIDR_MCACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *TWIHS_Type) GetIDR_MCACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *TWIHS_Type) SetIDR_TOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIHS_Type) GetIDR_TOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *TWIHS_Type) SetIDR_PECERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIHS_Type) GetIDR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *TWIHS_Type) SetIDR_SMBDAM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIHS_Type) GetIDR_SMBDAM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *TWIHS_Type) SetIDR_SMBHHM(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *TWIHS_Type) GetIDR_SMBHHM() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}

// TWIHS.IMR: Interrupt Mask Register
func (o *TWIHS_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWIHS_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWIHS_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWIHS_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWIHS_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWIHS_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWIHS_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWIHS_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *TWIHS_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *TWIHS_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWIHS_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWIHS_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWIHS_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWIHS_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWIHS_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWIHS_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWIHS_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TWIHS_Type) SetIMR_MCACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *TWIHS_Type) GetIMR_MCACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *TWIHS_Type) SetIMR_TOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIHS_Type) GetIMR_TOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *TWIHS_Type) SetIMR_PECERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIHS_Type) GetIMR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *TWIHS_Type) SetIMR_SMBDAM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIHS_Type) GetIMR_SMBDAM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *TWIHS_Type) SetIMR_SMBHHM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *TWIHS_Type) GetIMR_SMBHHM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}

// TWIHS.RHR: Receive Holding Register
func (o *TWIHS_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWIHS_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWIHS.THR: Transmit Holding Register
func (o *TWIHS_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWIHS_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWIHS.SMBTR: SMBus Timing Register
func (o *TWIHS_Type) SetSMBTR_PRESC(value uint32) {
	volatile.StoreUint32(&o.SMBTR.Reg, volatile.LoadUint32(&o.SMBTR.Reg)&^(0xf)|value)
}
func (o *TWIHS_Type) GetSMBTR_PRESC() uint32 {
	return volatile.LoadUint32(&o.SMBTR.Reg) & 0xf
}
func (o *TWIHS_Type) SetSMBTR_TLOWS(value uint32) {
	volatile.StoreUint32(&o.SMBTR.Reg, volatile.LoadUint32(&o.SMBTR.Reg)&^(0xff00)|value<<8)
}
func (o *TWIHS_Type) GetSMBTR_TLOWS() uint32 {
	return (volatile.LoadUint32(&o.SMBTR.Reg) & 0xff00) >> 8
}
func (o *TWIHS_Type) SetSMBTR_TLOWM(value uint32) {
	volatile.StoreUint32(&o.SMBTR.Reg, volatile.LoadUint32(&o.SMBTR.Reg)&^(0xff0000)|value<<16)
}
func (o *TWIHS_Type) GetSMBTR_TLOWM() uint32 {
	return (volatile.LoadUint32(&o.SMBTR.Reg) & 0xff0000) >> 16
}
func (o *TWIHS_Type) SetSMBTR_THMAX(value uint32) {
	volatile.StoreUint32(&o.SMBTR.Reg, volatile.LoadUint32(&o.SMBTR.Reg)&^(0xff000000)|value<<24)
}
func (o *TWIHS_Type) GetSMBTR_THMAX() uint32 {
	return (volatile.LoadUint32(&o.SMBTR.Reg) & 0xff000000) >> 24
}

// TWIHS.FILTR: Filter Register
func (o *TWIHS_Type) SetFILTR_FILT(value uint32) {
	volatile.StoreUint32(&o.FILTR.Reg, volatile.LoadUint32(&o.FILTR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetFILTR_FILT() uint32 {
	return volatile.LoadUint32(&o.FILTR.Reg) & 0x1
}
func (o *TWIHS_Type) SetFILTR_PADFEN(value uint32) {
	volatile.StoreUint32(&o.FILTR.Reg, volatile.LoadUint32(&o.FILTR.Reg)&^(0x2)|value<<1)
}
func (o *TWIHS_Type) GetFILTR_PADFEN() uint32 {
	return (volatile.LoadUint32(&o.FILTR.Reg) & 0x2) >> 1
}
func (o *TWIHS_Type) SetFILTR_PADFCFG(value uint32) {
	volatile.StoreUint32(&o.FILTR.Reg, volatile.LoadUint32(&o.FILTR.Reg)&^(0x4)|value<<2)
}
func (o *TWIHS_Type) GetFILTR_PADFCFG() uint32 {
	return (volatile.LoadUint32(&o.FILTR.Reg) & 0x4) >> 2
}
func (o *TWIHS_Type) SetFILTR_THRES(value uint32) {
	volatile.StoreUint32(&o.FILTR.Reg, volatile.LoadUint32(&o.FILTR.Reg)&^(0x700)|value<<8)
}
func (o *TWIHS_Type) GetFILTR_THRES() uint32 {
	return (volatile.LoadUint32(&o.FILTR.Reg) & 0x700) >> 8
}

// TWIHS.SWMR: SleepWalking Matching Register
func (o *TWIHS_Type) SetSWMR_SADR1(value uint32) {
	volatile.StoreUint32(&o.SWMR.Reg, volatile.LoadUint32(&o.SWMR.Reg)&^(0x7f)|value)
}
func (o *TWIHS_Type) GetSWMR_SADR1() uint32 {
	return volatile.LoadUint32(&o.SWMR.Reg) & 0x7f
}
func (o *TWIHS_Type) SetSWMR_SADR2(value uint32) {
	volatile.StoreUint32(&o.SWMR.Reg, volatile.LoadUint32(&o.SWMR.Reg)&^(0x7f00)|value<<8)
}
func (o *TWIHS_Type) GetSWMR_SADR2() uint32 {
	return (volatile.LoadUint32(&o.SWMR.Reg) & 0x7f00) >> 8
}
func (o *TWIHS_Type) SetSWMR_SADR3(value uint32) {
	volatile.StoreUint32(&o.SWMR.Reg, volatile.LoadUint32(&o.SWMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWIHS_Type) GetSWMR_SADR3() uint32 {
	return (volatile.LoadUint32(&o.SWMR.Reg) & 0x7f0000) >> 16
}
func (o *TWIHS_Type) SetSWMR_DATAM(value uint32) {
	volatile.StoreUint32(&o.SWMR.Reg, volatile.LoadUint32(&o.SWMR.Reg)&^(0xff000000)|value<<24)
}
func (o *TWIHS_Type) GetSWMR_DATAM() uint32 {
	return (volatile.LoadUint32(&o.SWMR.Reg) & 0xff000000) >> 24
}

// TWIHS.WPMR: Write Protection Mode Register
func (o *TWIHS_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TWIHS_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWIHS_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// TWIHS.WPSR: Write Protection Status Register
func (o *TWIHS_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *TWIHS_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *TWIHS_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TWIHS_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffffff00) >> 8
}

// Universal Asynchronous Receiver Transmitter
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	CMPR volatile.Register32 // 0x24
	_    [188]byte
	WPMR volatile.Register32 // 0xE4
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetCR_REQCLR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetCR_REQCLR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_BRSRCCK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetMR_BRSRCCK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIER_CMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetIER_CMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIDR_CMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetIDR_CMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIMR_CMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetIMR_CMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetSR_CMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *UART_Type) GetSR_CMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// UART.CMPR: Comparison Register
func (o *UART_Type) SetCMPR_VAL1(value uint32) {
	volatile.StoreUint32(&o.CMPR.Reg, volatile.LoadUint32(&o.CMPR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetCMPR_VAL1() uint32 {
	return volatile.LoadUint32(&o.CMPR.Reg) & 0xff
}
func (o *UART_Type) SetCMPR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.CMPR.Reg, volatile.LoadUint32(&o.CMPR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetCMPR_CMPMODE() uint32 {
	return (volatile.LoadUint32(&o.CMPR.Reg) & 0x1000) >> 12
}
func (o *UART_Type) SetCMPR_CMPPAR(value uint32) {
	volatile.StoreUint32(&o.CMPR.Reg, volatile.LoadUint32(&o.CMPR.Reg)&^(0x4000)|value<<14)
}
func (o *UART_Type) GetCMPR_CMPPAR() uint32 {
	return (volatile.LoadUint32(&o.CMPR.Reg) & 0x4000) >> 14
}
func (o *UART_Type) SetCMPR_VAL2(value uint32) {
	volatile.StoreUint32(&o.CMPR.Reg, volatile.LoadUint32(&o.CMPR.Reg)&^(0xff0000)|value<<16)
}
func (o *UART_Type) GetCMPR_VAL2() uint32 {
	return (volatile.LoadUint32(&o.CMPR.Reg) & 0xff0000) >> 16
}

// UART.WPMR: Write Protection Mode Register
func (o *UART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *UART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Universal Synchronous Asynchronous Receiver Transmitter
type USART_Type struct {
	US_CR       volatile.Register32 // 0x0
	US_MR       volatile.Register32 // 0x4
	US_IER      volatile.Register32 // 0x8
	US_IDR      volatile.Register32 // 0xC
	US_IMR      volatile.Register32 // 0x10
	US_CSR      volatile.Register32 // 0x14
	US_RHR      volatile.Register32 // 0x18
	US_THR      volatile.Register32 // 0x1C
	US_BRGR     volatile.Register32 // 0x20
	US_RTOR     volatile.Register32 // 0x24
	US_TTGR     volatile.Register32 // 0x28
	_           [20]byte
	US_FIDI     volatile.Register32 // 0x40
	US_NER      volatile.Register32 // 0x44
	_           [4]byte
	US_IF       volatile.Register32 // 0x4C
	US_MAN      volatile.Register32 // 0x50
	US_LINMR    volatile.Register32 // 0x54
	US_LINIR    volatile.Register32 // 0x58
	US_LINBRR   volatile.Register32 // 0x5C
	US_LONMR    volatile.Register32 // 0x60
	US_LONPR    volatile.Register32 // 0x64
	US_LONDL    volatile.Register32 // 0x68
	US_LONL2HDR volatile.Register32 // 0x6C
	US_LONBL    volatile.Register32 // 0x70
	US_LONB1TX  volatile.Register32 // 0x74
	US_LONB1RX  volatile.Register32 // 0x78
	US_LONPRIO  volatile.Register32 // 0x7C
	US_IDTTX    volatile.Register32 // 0x80
	US_IDTRX    volatile.Register32 // 0x84
	US_ICDIFF   volatile.Register32 // 0x88
	_           [88]byte
	US_WPMR     volatile.Register32 // 0xE4
	US_WPSR     volatile.Register32 // 0xE8
}

// USART.US_CR: Control Register
func (o *USART_Type) SetUS_CR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_CR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_CR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetUS_CR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetUS_CR_RXEN(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetUS_CR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetUS_CR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_CR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_CR_TXEN(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_CR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_CR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_CR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_CR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_CR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_CR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetUS_CR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetUS_CR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetUS_CR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetUS_CR_STTTO(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetUS_CR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetUS_CR_SENDA(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetUS_CR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetUS_CR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetUS_CR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetUS_CR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetUS_CR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetUS_CR_RETTO(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetUS_CR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetUS_CR_DTREN(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_CR_DTREN() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_CR_DTRDIS(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_CR_DTRDIS() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_CR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_CR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_CR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_CR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_CR_LINABT(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetUS_CR_LINABT() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetUS_CR_LINWKUP(value uint32) {
	volatile.StoreUint32(&o.US_CR.Reg, volatile.LoadUint32(&o.US_CR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetUS_CR_LINWKUP() uint32 {
	return (volatile.LoadUint32(&o.US_CR.Reg) & 0x200000) >> 21
}

// USART.US_MR: Mode Register
func (o *USART_Type) SetUS_MR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetUS_MR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.US_MR.Reg) & 0xf
}
func (o *USART_Type) SetUS_MR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetUS_MR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetUS_MR_CHRL(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetUS_MR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetUS_MR_SYNC(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_MR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_MR_PAR(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetUS_MR_PAR() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetUS_MR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetUS_MR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetUS_MR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetUS_MR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetUS_MR_MSBF(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_MR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_MR_MODE9(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_MR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_MR_CLKO(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_MR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_MR_OVER(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_MR_OVER() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_MR_INACK(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetUS_MR_INACK() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetUS_MR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetUS_MR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetUS_MR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetUS_MR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetUS_MR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetUS_MR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetUS_MR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetUS_MR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetUS_MR_FILTER(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetUS_MR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetUS_MR_MAN(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetUS_MR_MAN() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetUS_MR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetUS_MR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetUS_MR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.US_MR.Reg, volatile.LoadUint32(&o.US_MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetUS_MR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.US_MR.Reg) & 0x80000000) >> 31
}

// USART.US_IER: Interrupt Enable Register
func (o *USART_Type) SetUS_IER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_IER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.US_IER.Reg) & 0x1
}
func (o *USART_Type) SetUS_IER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetUS_IER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetUS_IER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_IER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_IER_OVRE(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_IER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_IER_FRAME(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_IER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_IER_PARE(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_IER_PARE() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_IER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_IER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_IER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetUS_IER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetUS_IER_ITER(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetUS_IER_ITER() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetUS_IER_NACK(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetUS_IER_NACK() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetUS_IER_RIIC(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_IER_RIIC() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_IER_DSRIC(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_IER_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_IER_DCDIC(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_IER_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_IER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_IER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_IER_MANE(value uint32) {
	volatile.StoreUint32(&o.US_IER.Reg, volatile.LoadUint32(&o.US_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetUS_IER_MANE() uint32 {
	return (volatile.LoadUint32(&o.US_IER.Reg) & 0x1000000) >> 24
}

// USART.US_IDR: Interrupt Disable Register
func (o *USART_Type) SetUS_IDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_IDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.US_IDR.Reg) & 0x1
}
func (o *USART_Type) SetUS_IDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetUS_IDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetUS_IDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_IDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_IDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_IDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_IDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_IDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_IDR_PARE(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_IDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_IDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_IDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_IDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetUS_IDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetUS_IDR_ITER(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetUS_IDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetUS_IDR_NACK(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetUS_IDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetUS_IDR_RIIC(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_IDR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_IDR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_IDR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_IDR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_IDR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_IDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_IDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_IDR_MANE(value uint32) {
	volatile.StoreUint32(&o.US_IDR.Reg, volatile.LoadUint32(&o.US_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetUS_IDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.US_IDR.Reg) & 0x1000000) >> 24
}

// USART.US_IMR: Interrupt Mask Register
func (o *USART_Type) SetUS_IMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_IMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.US_IMR.Reg) & 0x1
}
func (o *USART_Type) SetUS_IMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetUS_IMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetUS_IMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_IMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_IMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_IMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_IMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_IMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_IMR_PARE(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_IMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_IMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_IMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_IMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetUS_IMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetUS_IMR_ITER(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetUS_IMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetUS_IMR_NACK(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetUS_IMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetUS_IMR_RIIC(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_IMR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_IMR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_IMR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_IMR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_IMR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_IMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_IMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_IMR_MANE(value uint32) {
	volatile.StoreUint32(&o.US_IMR.Reg, volatile.LoadUint32(&o.US_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetUS_IMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.US_IMR.Reg) & 0x1000000) >> 24
}

// USART.US_CSR: Channel Status Register
func (o *USART_Type) SetUS_CSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_CSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.US_CSR.Reg) & 0x1
}
func (o *USART_Type) SetUS_CSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetUS_CSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetUS_CSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_CSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_CSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_CSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_CSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_CSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_CSR_PARE(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_CSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_CSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetUS_CSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetUS_CSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetUS_CSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetUS_CSR_ITER(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetUS_CSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetUS_CSR_NACK(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetUS_CSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetUS_CSR_RIIC(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_CSR_RIIC() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_CSR_DSRIC(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_CSR_DSRIC() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetUS_CSR_DCDIC(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetUS_CSR_DCDIC() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetUS_CSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetUS_CSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetUS_CSR_RI(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetUS_CSR_RI() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetUS_CSR_DSR(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetUS_CSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetUS_CSR_DCD(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetUS_CSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetUS_CSR_CTS(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetUS_CSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetUS_CSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.US_CSR.Reg, volatile.LoadUint32(&o.US_CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetUS_CSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.US_CSR.Reg) & 0x1000000) >> 24
}

// USART.US_RHR: Receive Holding Register
func (o *USART_Type) SetUS_RHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.US_RHR.Reg, volatile.LoadUint32(&o.US_RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetUS_RHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.US_RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetUS_RHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.US_RHR.Reg, volatile.LoadUint32(&o.US_RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetUS_RHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.US_RHR.Reg) & 0x8000) >> 15
}

// USART.US_THR: Transmit Holding Register
func (o *USART_Type) SetUS_THR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.US_THR.Reg, volatile.LoadUint32(&o.US_THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetUS_THR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.US_THR.Reg) & 0x1ff
}
func (o *USART_Type) SetUS_THR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.US_THR.Reg, volatile.LoadUint32(&o.US_THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetUS_THR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.US_THR.Reg) & 0x8000) >> 15
}

// USART.US_BRGR: Baud Rate Generator Register
func (o *USART_Type) SetUS_BRGR_CD(value uint32) {
	volatile.StoreUint32(&o.US_BRGR.Reg, volatile.LoadUint32(&o.US_BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetUS_BRGR_CD() uint32 {
	return volatile.LoadUint32(&o.US_BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetUS_BRGR_FP(value uint32) {
	volatile.StoreUint32(&o.US_BRGR.Reg, volatile.LoadUint32(&o.US_BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetUS_BRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.US_BRGR.Reg) & 0x70000) >> 16
}

// USART.US_RTOR: Receiver Time-out Register
func (o *USART_Type) SetUS_RTOR_TO(value uint32) {
	volatile.StoreUint32(&o.US_RTOR.Reg, volatile.LoadUint32(&o.US_RTOR.Reg)&^(0x1ffff)|value)
}
func (o *USART_Type) GetUS_RTOR_TO() uint32 {
	return volatile.LoadUint32(&o.US_RTOR.Reg) & 0x1ffff
}

// USART.US_TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetUS_TTGR_TG(value uint32) {
	volatile.StoreUint32(&o.US_TTGR.Reg, volatile.LoadUint32(&o.US_TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetUS_TTGR_TG() uint32 {
	return volatile.LoadUint32(&o.US_TTGR.Reg) & 0xff
}

// USART.US_FIDI: FI DI Ratio Register
func (o *USART_Type) SetUS_FIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.US_FIDI.Reg, volatile.LoadUint32(&o.US_FIDI.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetUS_FIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.US_FIDI.Reg) & 0xffff
}

// USART.US_NER: Number of Errors Register
func (o *USART_Type) SetUS_NER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.US_NER.Reg, volatile.LoadUint32(&o.US_NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetUS_NER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.US_NER.Reg) & 0xff
}

// USART.US_IF: IrDA Filter Register
func (o *USART_Type) SetUS_IF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.US_IF.Reg, volatile.LoadUint32(&o.US_IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetUS_IF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.US_IF.Reg) & 0xff
}

// USART.US_MAN: Manchester Configuration Register
func (o *USART_Type) SetUS_MAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetUS_MAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.US_MAN.Reg) & 0xf
}
func (o *USART_Type) SetUS_MAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetUS_MAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetUS_MAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetUS_MAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetUS_MAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetUS_MAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetUS_MAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetUS_MAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetUS_MAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetUS_MAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetUS_MAN_ONE(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetUS_MAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetUS_MAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetUS_MAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetUS_MAN_RXIDLEV(value uint32) {
	volatile.StoreUint32(&o.US_MAN.Reg, volatile.LoadUint32(&o.US_MAN.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetUS_MAN_RXIDLEV() uint32 {
	return (volatile.LoadUint32(&o.US_MAN.Reg) & 0x80000000) >> 31
}

// USART.US_LINMR: LIN Mode Register
func (o *USART_Type) SetUS_LINMR_NACT(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x3)|value)
}
func (o *USART_Type) GetUS_LINMR_NACT() uint32 {
	return volatile.LoadUint32(&o.US_LINMR.Reg) & 0x3
}
func (o *USART_Type) SetUS_LINMR_PARDIS(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_LINMR_PARDIS() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_LINMR_CHKDIS(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetUS_LINMR_CHKDIS() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetUS_LINMR_CHKTYP(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetUS_LINMR_CHKTYP() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetUS_LINMR_DLM(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_LINMR_DLM() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_LINMR_FSDIS(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_LINMR_FSDIS() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_LINMR_WKUPTYP(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_LINMR_WKUPTYP() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetUS_LINMR_DLC(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetUS_LINMR_DLC() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetUS_LINMR_PDCM(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetUS_LINMR_PDCM() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetUS_LINMR_SYNCDIS(value uint32) {
	volatile.StoreUint32(&o.US_LINMR.Reg, volatile.LoadUint32(&o.US_LINMR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetUS_LINMR_SYNCDIS() uint32 {
	return (volatile.LoadUint32(&o.US_LINMR.Reg) & 0x20000) >> 17
}

// USART.US_LINIR: LIN Identifier Register
func (o *USART_Type) SetUS_LINIR_IDCHR(value uint32) {
	volatile.StoreUint32(&o.US_LINIR.Reg, volatile.LoadUint32(&o.US_LINIR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetUS_LINIR_IDCHR() uint32 {
	return volatile.LoadUint32(&o.US_LINIR.Reg) & 0xff
}

// USART.US_LINBRR: LIN Baud Rate Register
func (o *USART_Type) SetUS_LINBRR_LINCD(value uint32) {
	volatile.StoreUint32(&o.US_LINBRR.Reg, volatile.LoadUint32(&o.US_LINBRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetUS_LINBRR_LINCD() uint32 {
	return volatile.LoadUint32(&o.US_LINBRR.Reg) & 0xffff
}
func (o *USART_Type) SetUS_LINBRR_LINFP(value uint32) {
	volatile.StoreUint32(&o.US_LINBRR.Reg, volatile.LoadUint32(&o.US_LINBRR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetUS_LINBRR_LINFP() uint32 {
	return (volatile.LoadUint32(&o.US_LINBRR.Reg) & 0x70000) >> 16
}

// USART.US_LONMR: LON Mode Register
func (o *USART_Type) SetUS_LONMR_COMMT(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_LONMR_COMMT() uint32 {
	return volatile.LoadUint32(&o.US_LONMR.Reg) & 0x1
}
func (o *USART_Type) SetUS_LONMR_COLDET(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetUS_LONMR_COLDET() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetUS_LONMR_TCOL(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetUS_LONMR_TCOL() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetUS_LONMR_CDTAIL(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetUS_LONMR_CDTAIL() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetUS_LONMR_DMAM(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetUS_LONMR_DMAM() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetUS_LONMR_LCDS(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetUS_LONMR_LCDS() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetUS_LONMR_EOFS(value uint32) {
	volatile.StoreUint32(&o.US_LONMR.Reg, volatile.LoadUint32(&o.US_LONMR.Reg)&^(0xff0000)|value<<16)
}
func (o *USART_Type) GetUS_LONMR_EOFS() uint32 {
	return (volatile.LoadUint32(&o.US_LONMR.Reg) & 0xff0000) >> 16
}

// USART.US_LONPR: LON Preamble Register
func (o *USART_Type) SetUS_LONPR_LONPL(value uint32) {
	volatile.StoreUint32(&o.US_LONPR.Reg, volatile.LoadUint32(&o.US_LONPR.Reg)&^(0x3fff)|value)
}
func (o *USART_Type) GetUS_LONPR_LONPL() uint32 {
	return volatile.LoadUint32(&o.US_LONPR.Reg) & 0x3fff
}

// USART.US_LONDL: LON Data Length Register
func (o *USART_Type) SetUS_LONDL_LONDL(value uint32) {
	volatile.StoreUint32(&o.US_LONDL.Reg, volatile.LoadUint32(&o.US_LONDL.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetUS_LONDL_LONDL() uint32 {
	return volatile.LoadUint32(&o.US_LONDL.Reg) & 0xff
}

// USART.US_LONL2HDR: LON L2HDR Register
func (o *USART_Type) SetUS_LONL2HDR_BLI(value uint32) {
	volatile.StoreUint32(&o.US_LONL2HDR.Reg, volatile.LoadUint32(&o.US_LONL2HDR.Reg)&^(0x3f)|value)
}
func (o *USART_Type) GetUS_LONL2HDR_BLI() uint32 {
	return volatile.LoadUint32(&o.US_LONL2HDR.Reg) & 0x3f
}
func (o *USART_Type) SetUS_LONL2HDR_ALTP(value uint32) {
	volatile.StoreUint32(&o.US_LONL2HDR.Reg, volatile.LoadUint32(&o.US_LONL2HDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetUS_LONL2HDR_ALTP() uint32 {
	return (volatile.LoadUint32(&o.US_LONL2HDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetUS_LONL2HDR_PB(value uint32) {
	volatile.StoreUint32(&o.US_LONL2HDR.Reg, volatile.LoadUint32(&o.US_LONL2HDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetUS_LONL2HDR_PB() uint32 {
	return (volatile.LoadUint32(&o.US_LONL2HDR.Reg) & 0x80) >> 7
}

// USART.US_LONBL: LON Backlog Register
func (o *USART_Type) SetUS_LONBL_LONBL(value uint32) {
	volatile.StoreUint32(&o.US_LONBL.Reg, volatile.LoadUint32(&o.US_LONBL.Reg)&^(0x3f)|value)
}
func (o *USART_Type) GetUS_LONBL_LONBL() uint32 {
	return volatile.LoadUint32(&o.US_LONBL.Reg) & 0x3f
}

// USART.US_LONB1TX: LON Beta1 Tx Register
func (o *USART_Type) SetUS_LONB1TX_BETA1TX(value uint32) {
	volatile.StoreUint32(&o.US_LONB1TX.Reg, volatile.LoadUint32(&o.US_LONB1TX.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetUS_LONB1TX_BETA1TX() uint32 {
	return volatile.LoadUint32(&o.US_LONB1TX.Reg) & 0xffffff
}

// USART.US_LONB1RX: LON Beta1 Rx Register
func (o *USART_Type) SetUS_LONB1RX_BETA1RX(value uint32) {
	volatile.StoreUint32(&o.US_LONB1RX.Reg, volatile.LoadUint32(&o.US_LONB1RX.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetUS_LONB1RX_BETA1RX() uint32 {
	return volatile.LoadUint32(&o.US_LONB1RX.Reg) & 0xffffff
}

// USART.US_LONPRIO: LON Priority Register
func (o *USART_Type) SetUS_LONPRIO_PSNB(value uint32) {
	volatile.StoreUint32(&o.US_LONPRIO.Reg, volatile.LoadUint32(&o.US_LONPRIO.Reg)&^(0x7f)|value)
}
func (o *USART_Type) GetUS_LONPRIO_PSNB() uint32 {
	return volatile.LoadUint32(&o.US_LONPRIO.Reg) & 0x7f
}
func (o *USART_Type) SetUS_LONPRIO_NPS(value uint32) {
	volatile.StoreUint32(&o.US_LONPRIO.Reg, volatile.LoadUint32(&o.US_LONPRIO.Reg)&^(0x7f00)|value<<8)
}
func (o *USART_Type) GetUS_LONPRIO_NPS() uint32 {
	return (volatile.LoadUint32(&o.US_LONPRIO.Reg) & 0x7f00) >> 8
}

// USART.US_IDTTX: LON IDT Tx Register
func (o *USART_Type) SetUS_IDTTX_IDTTX(value uint32) {
	volatile.StoreUint32(&o.US_IDTTX.Reg, volatile.LoadUint32(&o.US_IDTTX.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetUS_IDTTX_IDTTX() uint32 {
	return volatile.LoadUint32(&o.US_IDTTX.Reg) & 0xffffff
}

// USART.US_IDTRX: LON IDT Rx Register
func (o *USART_Type) SetUS_IDTRX_IDTRX(value uint32) {
	volatile.StoreUint32(&o.US_IDTRX.Reg, volatile.LoadUint32(&o.US_IDTRX.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetUS_IDTRX_IDTRX() uint32 {
	return volatile.LoadUint32(&o.US_IDTRX.Reg) & 0xffffff
}

// USART.US_ICDIFF: IC DIFF Register
func (o *USART_Type) SetUS_ICDIFF_ICDIFF(value uint32) {
	volatile.StoreUint32(&o.US_ICDIFF.Reg, volatile.LoadUint32(&o.US_ICDIFF.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetUS_ICDIFF_ICDIFF() uint32 {
	return volatile.LoadUint32(&o.US_ICDIFF.Reg) & 0xf
}

// USART.US_WPMR: Write Protection Mode Register
func (o *USART_Type) SetUS_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.US_WPMR.Reg, volatile.LoadUint32(&o.US_WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.US_WPMR.Reg) & 0x1
}
func (o *USART_Type) SetUS_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.US_WPMR.Reg, volatile.LoadUint32(&o.US_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetUS_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.US_WPMR.Reg) & 0xffffff00) >> 8
}

// USART.US_WPSR: Write Protection Status Register
func (o *USART_Type) SetUS_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.US_WPSR.Reg, volatile.LoadUint32(&o.US_WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetUS_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.US_WPSR.Reg) & 0x1
}
func (o *USART_Type) SetUS_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.US_WPSR.Reg, volatile.LoadUint32(&o.US_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetUS_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.US_WPSR.Reg) & 0xffff00) >> 8
}

// USB High-Speed Interface
type USBHS_Type struct {
	DEVCTRL      volatile.Register32 // 0x0
	DEVISR       volatile.Register32 // 0x4
	DEVICR       volatile.Register32 // 0x8
	DEVIFR       volatile.Register32 // 0xC
	DEVIMR       volatile.Register32 // 0x10
	DEVIDR       volatile.Register32 // 0x14
	DEVIER       volatile.Register32 // 0x18
	DEVEPT       volatile.Register32 // 0x1C
	DEVFNUM      volatile.Register32 // 0x20
	_            [220]byte
	DEVEPTCFG    [10]volatile.Register32 // 0x100
	_            [8]byte
	DEVEPTISR    [10]volatile.Register32 // 0x130
	_            [8]byte
	DEVEPTICR    [10]volatile.Register32 // 0x160
	_            [8]byte
	DEVEPTIFR    [10]volatile.Register32 // 0x190
	_            [8]byte
	DEVEPTIMR    [10]volatile.Register32 // 0x1C0
	_            [8]byte
	DEVEPTIER    [10]volatile.Register32 // 0x1F0
	_            [8]byte
	DEVEPTIDR    [10]volatile.Register32 // 0x220
	_            [200]byte
	USBHS_DEVDMA [7]USBHS_USBHS_DEVDMA_Type // 0x310
	_            [128]byte
	HSTCTRL      volatile.Register32 // 0x400
	HSTISR       volatile.Register32 // 0x404
	HSTICR       volatile.Register32 // 0x408
	HSTIFR       volatile.Register32 // 0x40C
	HSTIMR       volatile.Register32 // 0x410
	HSTIDR       volatile.Register32 // 0x414
	HSTIER       volatile.Register32 // 0x418
	HSTPIP       volatile.Register32 // 0x41C
	HSTFNUM      volatile.Register32 // 0x420
	HSTADDR1     volatile.Register32 // 0x424
	HSTADDR2     volatile.Register32 // 0x428
	HSTADDR3     volatile.Register32 // 0x42C
	_            [208]byte
	HSTPIPCFG    [10]volatile.Register32 // 0x500
	_            [8]byte
	HSTPIPISR    [10]volatile.Register32 // 0x530
	_            [8]byte
	HSTPIPICR    [10]volatile.Register32 // 0x560
	_            [8]byte
	HSTPIPIFR    [10]volatile.Register32 // 0x590
	_            [8]byte
	HSTPIPIMR    [10]volatile.Register32 // 0x5C0
	_            [8]byte
	HSTPIPIER    [10]volatile.Register32 // 0x5F0
	_            [8]byte
	HSTPIPIDR    [10]volatile.Register32 // 0x620
	_            [8]byte
	HSTPIPINRQ   [10]volatile.Register32 // 0x650
	_            [8]byte
	HSTPIPERR    [10]volatile.Register32 // 0x680
	_            [104]byte
	USBHS_HSTDMA [7]USBHS_USBHS_HSTDMA_Type // 0x710
	_            [128]byte
	CTRL         volatile.Register32 // 0x800
	SR           volatile.Register32 // 0x804
	SCR          volatile.Register32 // 0x808
	SFR          volatile.Register32 // 0x80C
}

// USBHS.DEVCTRL: Device General Control Register
func (o *USBHS_Type) SetDEVCTRL_UADD(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x7f)|value)
}
func (o *USBHS_Type) GetDEVCTRL_UADD() uint32 {
	return volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x7f
}
func (o *USBHS_Type) SetDEVCTRL_ADDEN(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVCTRL_ADDEN() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *USBHS_Type) GetDEVCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x100) >> 8
}
func (o *USBHS_Type) SetDEVCTRL_RMWKUP(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *USBHS_Type) GetDEVCTRL_RMWKUP() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x200) >> 9
}
func (o *USBHS_Type) SetDEVCTRL_SPDCONF(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0xc00)|value<<10)
}
func (o *USBHS_Type) GetDEVCTRL_SPDCONF() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0xc00) >> 10
}
func (o *USBHS_Type) SetDEVCTRL_LS(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVCTRL_LS() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVCTRL_TSTJ(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVCTRL_TSTJ() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVCTRL_TSTK(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVCTRL_TSTK() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVCTRL_TSTPCKT(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVCTRL_TSTPCKT() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetDEVCTRL_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.DEVCTRL.Reg, volatile.LoadUint32(&o.DEVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVCTRL_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.DEVCTRL.Reg) & 0x10000) >> 16
}

// USBHS.DEVISR: Device Global Interrupt Status Register
func (o *USBHS_Type) SetDEVISR_SUSP(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVISR_SUSP() uint32 {
	return volatile.LoadUint32(&o.DEVISR.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVISR_MSOF(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVISR_MSOF() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVISR_SOF(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVISR_SOF() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVISR_EORST(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVISR_EORST() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVISR_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVISR_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVISR_EORSM(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVISR_EORSM() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVISR_UPRSM(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVISR_UPRSM() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVISR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVISR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVISR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVISR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVISR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVISR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVISR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVISR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetDEVISR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVISR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVISR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVISR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVISR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVISR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVISR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVISR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetDEVISR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x100000)|value<<20)
}
func (o *USBHS_Type) GetDEVISR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x100000) >> 20
}
func (o *USBHS_Type) SetDEVISR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x200000)|value<<21)
}
func (o *USBHS_Type) GetDEVISR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x200000) >> 21
}
func (o *USBHS_Type) SetDEVISR_PEP_10(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x400000)|value<<22)
}
func (o *USBHS_Type) GetDEVISR_PEP_10() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x400000) >> 22
}
func (o *USBHS_Type) SetDEVISR_PEP_11(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x800000)|value<<23)
}
func (o *USBHS_Type) GetDEVISR_PEP_11() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x800000) >> 23
}
func (o *USBHS_Type) SetDEVISR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVISR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetDEVISR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetDEVISR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetDEVISR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetDEVISR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetDEVISR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetDEVISR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetDEVISR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetDEVISR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetDEVISR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetDEVISR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetDEVISR_DMA_7(value uint32) {
	volatile.StoreUint32(&o.DEVISR.Reg, volatile.LoadUint32(&o.DEVISR.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetDEVISR_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.DEVISR.Reg) & 0x80000000) >> 31
}

// USBHS.DEVICR: Device Global Interrupt Clear Register
func (o *USBHS_Type) SetDEVICR_SUSPC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVICR_SUSPC() uint32 {
	return volatile.LoadUint32(&o.DEVICR.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVICR_MSOFC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVICR_MSOFC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVICR_SOFC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVICR_SOFC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVICR_EORSTC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVICR_EORSTC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVICR_WAKEUPC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVICR_WAKEUPC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVICR_EORSMC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVICR_EORSMC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVICR_UPRSMC(value uint32) {
	volatile.StoreUint32(&o.DEVICR.Reg, volatile.LoadUint32(&o.DEVICR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVICR_UPRSMC() uint32 {
	return (volatile.LoadUint32(&o.DEVICR.Reg) & 0x40) >> 6
}

// USBHS.DEVIFR: Device Global Interrupt Set Register
func (o *USBHS_Type) SetDEVIFR_SUSPS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVIFR_SUSPS() uint32 {
	return volatile.LoadUint32(&o.DEVIFR.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVIFR_MSOFS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVIFR_MSOFS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVIFR_SOFS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVIFR_SOFS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVIFR_EORSTS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVIFR_EORSTS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVIFR_WAKEUPS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVIFR_WAKEUPS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVIFR_EORSMS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVIFR_EORSMS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVIFR_UPRSMS(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVIFR_UPRSMS() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVIFR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVIFR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetDEVIFR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetDEVIFR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetDEVIFR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetDEVIFR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetDEVIFR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetDEVIFR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetDEVIFR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetDEVIFR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetDEVIFR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetDEVIFR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetDEVIFR_DMA_7(value uint32) {
	volatile.StoreUint32(&o.DEVIFR.Reg, volatile.LoadUint32(&o.DEVIFR.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetDEVIFR_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIFR.Reg) & 0x80000000) >> 31
}

// USBHS.DEVIMR: Device Global Interrupt Mask Register
func (o *USBHS_Type) SetDEVIMR_SUSPE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVIMR_SUSPE() uint32 {
	return volatile.LoadUint32(&o.DEVIMR.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVIMR_MSOFE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVIMR_MSOFE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVIMR_SOFE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVIMR_SOFE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVIMR_EORSTE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVIMR_EORSTE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVIMR_WAKEUPE(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVIMR_WAKEUPE() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVIMR_EORSME(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVIMR_EORSME() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVIMR_UPRSME(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVIMR_UPRSME() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVIMR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVIMR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVIMR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVIMR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVIMR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVIMR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVIMR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVIMR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetDEVIMR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVIMR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVIMR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVIMR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVIMR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVIMR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVIMR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVIMR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetDEVIMR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x100000)|value<<20)
}
func (o *USBHS_Type) GetDEVIMR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x100000) >> 20
}
func (o *USBHS_Type) SetDEVIMR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x200000)|value<<21)
}
func (o *USBHS_Type) GetDEVIMR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x200000) >> 21
}
func (o *USBHS_Type) SetDEVIMR_PEP_10(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x400000)|value<<22)
}
func (o *USBHS_Type) GetDEVIMR_PEP_10() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x400000) >> 22
}
func (o *USBHS_Type) SetDEVIMR_PEP_11(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x800000)|value<<23)
}
func (o *USBHS_Type) GetDEVIMR_PEP_11() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x800000) >> 23
}
func (o *USBHS_Type) SetDEVIMR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVIMR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetDEVIMR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetDEVIMR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetDEVIMR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetDEVIMR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetDEVIMR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetDEVIMR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetDEVIMR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetDEVIMR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetDEVIMR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetDEVIMR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetDEVIMR_DMA_7(value uint32) {
	volatile.StoreUint32(&o.DEVIMR.Reg, volatile.LoadUint32(&o.DEVIMR.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetDEVIMR_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIMR.Reg) & 0x80000000) >> 31
}

// USBHS.DEVIDR: Device Global Interrupt Disable Register
func (o *USBHS_Type) SetDEVIDR_SUSPEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVIDR_SUSPEC() uint32 {
	return volatile.LoadUint32(&o.DEVIDR.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVIDR_MSOFEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVIDR_MSOFEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVIDR_SOFEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVIDR_SOFEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVIDR_EORSTEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVIDR_EORSTEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVIDR_WAKEUPEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVIDR_WAKEUPEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVIDR_EORSMEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVIDR_EORSMEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVIDR_UPRSMEC(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVIDR_UPRSMEC() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVIDR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVIDR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVIDR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVIDR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVIDR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVIDR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVIDR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVIDR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetDEVIDR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVIDR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVIDR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVIDR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVIDR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVIDR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVIDR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVIDR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetDEVIDR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x100000)|value<<20)
}
func (o *USBHS_Type) GetDEVIDR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x100000) >> 20
}
func (o *USBHS_Type) SetDEVIDR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x200000)|value<<21)
}
func (o *USBHS_Type) GetDEVIDR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x200000) >> 21
}
func (o *USBHS_Type) SetDEVIDR_PEP_10(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x400000)|value<<22)
}
func (o *USBHS_Type) GetDEVIDR_PEP_10() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x400000) >> 22
}
func (o *USBHS_Type) SetDEVIDR_PEP_11(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x800000)|value<<23)
}
func (o *USBHS_Type) GetDEVIDR_PEP_11() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x800000) >> 23
}
func (o *USBHS_Type) SetDEVIDR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVIDR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetDEVIDR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetDEVIDR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetDEVIDR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetDEVIDR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetDEVIDR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetDEVIDR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetDEVIDR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetDEVIDR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetDEVIDR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetDEVIDR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetDEVIDR_DMA_7(value uint32) {
	volatile.StoreUint32(&o.DEVIDR.Reg, volatile.LoadUint32(&o.DEVIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetDEVIDR_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIDR.Reg) & 0x80000000) >> 31
}

// USBHS.DEVIER: Device Global Interrupt Enable Register
func (o *USBHS_Type) SetDEVIER_SUSPES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVIER_SUSPES() uint32 {
	return volatile.LoadUint32(&o.DEVIER.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVIER_MSOFES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVIER_MSOFES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVIER_SOFES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVIER_SOFES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVIER_EORSTES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVIER_EORSTES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVIER_WAKEUPES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVIER_WAKEUPES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVIER_EORSMES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVIER_EORSMES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVIER_UPRSMES(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVIER_UPRSMES() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVIER_PEP_0(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVIER_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVIER_PEP_1(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVIER_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVIER_PEP_2(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVIER_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVIER_PEP_3(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVIER_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetDEVIER_PEP_4(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVIER_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVIER_PEP_5(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVIER_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVIER_PEP_6(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVIER_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVIER_PEP_7(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVIER_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetDEVIER_PEP_8(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x100000)|value<<20)
}
func (o *USBHS_Type) GetDEVIER_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x100000) >> 20
}
func (o *USBHS_Type) SetDEVIER_PEP_9(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x200000)|value<<21)
}
func (o *USBHS_Type) GetDEVIER_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x200000) >> 21
}
func (o *USBHS_Type) SetDEVIER_PEP_10(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x400000)|value<<22)
}
func (o *USBHS_Type) GetDEVIER_PEP_10() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x400000) >> 22
}
func (o *USBHS_Type) SetDEVIER_PEP_11(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x800000)|value<<23)
}
func (o *USBHS_Type) GetDEVIER_PEP_11() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x800000) >> 23
}
func (o *USBHS_Type) SetDEVIER_DMA_1(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVIER_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetDEVIER_DMA_2(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetDEVIER_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetDEVIER_DMA_3(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetDEVIER_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetDEVIER_DMA_4(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetDEVIER_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetDEVIER_DMA_5(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetDEVIER_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetDEVIER_DMA_6(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetDEVIER_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetDEVIER_DMA_7(value uint32) {
	volatile.StoreUint32(&o.DEVIER.Reg, volatile.LoadUint32(&o.DEVIER.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetDEVIER_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.DEVIER.Reg) & 0x80000000) >> 31
}

// USBHS.DEVEPT: Device Endpoint Register
func (o *USBHS_Type) SetDEVEPT_EPEN0(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPT_EPEN0() uint32 {
	return volatile.LoadUint32(&o.DEVEPT.Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPT_EPEN1(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPT_EPEN1() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPT_EPEN2(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPT_EPEN2() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPT_EPEN3(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPT_EPEN3() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPT_EPEN4(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPT_EPEN4() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPT_EPEN5(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPT_EPEN5() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPT_EPEN6(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPT_EPEN6() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPT_EPEN7(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPT_EPEN7() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPT_EPEN8(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x100)|value<<8)
}
func (o *USBHS_Type) GetDEVEPT_EPEN8() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x100) >> 8
}
func (o *USBHS_Type) SetDEVEPT_EPEN9(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x200)|value<<9)
}
func (o *USBHS_Type) GetDEVEPT_EPEN9() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x200) >> 9
}
func (o *USBHS_Type) SetDEVEPT_EPRST0(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVEPT_EPRST0() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVEPT_EPRST1(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVEPT_EPRST1() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVEPT_EPRST2(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVEPT_EPRST2() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVEPT_EPRST3(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVEPT_EPRST3() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetDEVEPT_EPRST4(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x100000)|value<<20)
}
func (o *USBHS_Type) GetDEVEPT_EPRST4() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x100000) >> 20
}
func (o *USBHS_Type) SetDEVEPT_EPRST5(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x200000)|value<<21)
}
func (o *USBHS_Type) GetDEVEPT_EPRST5() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x200000) >> 21
}
func (o *USBHS_Type) SetDEVEPT_EPRST6(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x400000)|value<<22)
}
func (o *USBHS_Type) GetDEVEPT_EPRST6() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x400000) >> 22
}
func (o *USBHS_Type) SetDEVEPT_EPRST7(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x800000)|value<<23)
}
func (o *USBHS_Type) GetDEVEPT_EPRST7() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x800000) >> 23
}
func (o *USBHS_Type) SetDEVEPT_EPRST8(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x1000000)|value<<24)
}
func (o *USBHS_Type) GetDEVEPT_EPRST8() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x1000000) >> 24
}
func (o *USBHS_Type) SetDEVEPT_EPRST9(value uint32) {
	volatile.StoreUint32(&o.DEVEPT.Reg, volatile.LoadUint32(&o.DEVEPT.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetDEVEPT_EPRST9() uint32 {
	return (volatile.LoadUint32(&o.DEVEPT.Reg) & 0x2000000) >> 25
}

// USBHS.DEVFNUM: Device Frame Number Register
func (o *USBHS_Type) SetDEVFNUM_MFNUM(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x7)|value)
}
func (o *USBHS_Type) GetDEVFNUM_MFNUM() uint32 {
	return volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x7
}
func (o *USBHS_Type) SetDEVFNUM_FNUM(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *USBHS_Type) GetDEVFNUM_FNUM() uint32 {
	return (volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x3ff8) >> 3
}
func (o *USBHS_Type) SetDEVFNUM_FNCERR(value uint32) {
	volatile.StoreUint32(&o.DEVFNUM.Reg, volatile.LoadUint32(&o.DEVFNUM.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetDEVFNUM_FNCERR() uint32 {
	return (volatile.LoadUint32(&o.DEVFNUM.Reg) & 0x8000) >> 15
}

// USBHS.DEVEPTCFG: Device Endpoint Configuration Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTCFG_ALLOC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTCFG_ALLOC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTCFG_EPBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0xc)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTCFG_EPBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0xc) >> 2
}
func (o *USBHS_Type) SetDEVEPTCFG_EPSIZE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x70)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTCFG_EPSIZE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x70) >> 4
}
func (o *USBHS_Type) SetDEVEPTCFG_EPDIR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x100)|value<<8)
}
func (o *USBHS_Type) GetDEVEPTCFG_EPDIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x100) >> 8
}
func (o *USBHS_Type) SetDEVEPTCFG_AUTOSW(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x200)|value<<9)
}
func (o *USBHS_Type) GetDEVEPTCFG_AUTOSW(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x200) >> 9
}
func (o *USBHS_Type) SetDEVEPTCFG_EPTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x1800)|value<<11)
}
func (o *USBHS_Type) GetDEVEPTCFG_EPTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x1800) >> 11
}
func (o *USBHS_Type) SetDEVEPTCFG_NBTRANS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTCFG[idx].Reg, volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg)&^(0x6000)|value<<13)
}
func (o *USBHS_Type) GetDEVEPTCFG_NBTRANS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTCFG[idx].Reg) & 0x6000) >> 13
}

// USBHS.DEVEPTISR: Device Endpoint Status Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTISR_TXINI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTISR_TXINI(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTISR_RXOUTI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTISR_RXOUTI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTISR_RXSTPI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTISR_RXSTPI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTISR_NAKOUTI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTISR_NAKOUTI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTISR_NAKINI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTISR_NAKINI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTISR_OVERFI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTISR_OVERFI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTISR_STALLEDI(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTISR_STALLEDI(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTISR_SHORTPACKET(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTISR_SHORTPACKET(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPTISR_DTSEQ(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x300)|value<<8)
}
func (o *USBHS_Type) GetDEVEPTISR_DTSEQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x300) >> 8
}
func (o *USBHS_Type) SetDEVEPTISR_NBUSYBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x3000)|value<<12)
}
func (o *USBHS_Type) GetDEVEPTISR_NBUSYBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x3000) >> 12
}
func (o *USBHS_Type) SetDEVEPTISR_CURRBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0xc000)|value<<14)
}
func (o *USBHS_Type) GetDEVEPTISR_CURRBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0xc000) >> 14
}
func (o *USBHS_Type) SetDEVEPTISR_RWALL(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVEPTISR_RWALL(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVEPTISR_CTRLDIR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVEPTISR_CTRLDIR(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVEPTISR_CFGOK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVEPTISR_CFGOK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVEPTISR_BYCT(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTISR[idx].Reg, volatile.LoadUint32(&o.DEVEPTISR[idx].Reg)&^(0x7ff00000)|value<<20)
}
func (o *USBHS_Type) GetDEVEPTISR_BYCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTISR[idx].Reg) & 0x7ff00000) >> 20
}

// USBHS.DEVEPTICR: Device Endpoint Clear Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTICR_TXINIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTICR_TXINIC(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTICR_RXOUTIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTICR_RXOUTIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTICR_RXSTPIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTICR_RXSTPIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTICR_NAKOUTIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTICR_NAKOUTIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTICR_NAKINIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTICR_NAKINIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTICR_OVERFIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTICR_OVERFIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTICR_STALLEDIC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTICR_STALLEDIC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTICR_SHORTPACKETC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTICR[idx].Reg, volatile.LoadUint32(&o.DEVEPTICR[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTICR_SHORTPACKETC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTICR[idx].Reg) & 0x80) >> 7
}

// USBHS.DEVEPTIFR: Device Endpoint Set Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTIFR_TXINIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTIFR_TXINIS(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTIFR_RXOUTIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTIFR_RXOUTIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTIFR_RXSTPIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTIFR_RXSTPIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTIFR_NAKOUTIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTIFR_NAKOUTIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTIFR_NAKINIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTIFR_NAKINIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTIFR_OVERFIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTIFR_OVERFIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTIFR_STALLEDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTIFR_STALLEDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTIFR_SHORTPACKETS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTIFR_SHORTPACKETS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPTIFR_NBUSYBKS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIFR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVEPTIFR_NBUSYBKS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIFR[idx].Reg) & 0x1000) >> 12
}

// USBHS.DEVEPTIMR: Device Endpoint Mask Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTIMR_TXINE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTIMR_TXINE(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTIMR_RXOUTE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTIMR_RXOUTE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTIMR_RXSTPE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTIMR_RXSTPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTIMR_NAKOUTE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTIMR_NAKOUTE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTIMR_NAKINE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTIMR_NAKINE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTIMR_OVERFE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTIMR_OVERFE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTIMR_STALLEDE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTIMR_STALLEDE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTIMR_SHORTPACKETE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTIMR_SHORTPACKETE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPTIMR_NBUSYBKE(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVEPTIMR_NBUSYBKE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVEPTIMR_KILLBK(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVEPTIMR_KILLBK(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVEPTIMR_FIFOCON(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVEPTIMR_FIFOCON(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVEPTIMR_EPDISHDMA(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVEPTIMR_EPDISHDMA(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVEPTIMR_NYETDIS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVEPTIMR_NYETDIS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVEPTIMR_RSTDT(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVEPTIMR_RSTDT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVEPTIMR_STALLRQ(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIMR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVEPTIMR_STALLRQ(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIMR[idx].Reg) & 0x80000) >> 19
}

// USBHS.DEVEPTIER: Device Endpoint Enable Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTIER_TXINES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTIER_TXINES(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTIER_RXOUTES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTIER_RXOUTES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTIER_RXSTPES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTIER_RXSTPES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTIER_NAKOUTES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTIER_NAKOUTES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTIER_NAKINES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTIER_NAKINES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTIER_OVERFES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTIER_OVERFES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTIER_STALLEDES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTIER_STALLEDES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTIER_SHORTPACKETES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTIER_SHORTPACKETES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPTIER_NBUSYBKES(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVEPTIER_NBUSYBKES(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVEPTIER_KILLBKS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetDEVEPTIER_KILLBKS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetDEVEPTIER_FIFOCONS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVEPTIER_FIFOCONS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVEPTIER_EPDISHDMAS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVEPTIER_EPDISHDMAS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVEPTIER_NYETDISS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVEPTIER_NYETDISS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVEPTIER_RSTDTS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetDEVEPTIER_RSTDTS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetDEVEPTIER_STALLRQS(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIER[idx].Reg, volatile.LoadUint32(&o.DEVEPTIER[idx].Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVEPTIER_STALLRQS(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIER[idx].Reg) & 0x80000) >> 19
}

// USBHS.DEVEPTIDR: Device Endpoint Disable Register (n = 0) 0
func (o *USBHS_Type) SetDEVEPTIDR_TXINEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetDEVEPTIDR_TXINEC(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x1
}
func (o *USBHS_Type) SetDEVEPTIDR_RXOUTEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetDEVEPTIDR_RXOUTEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetDEVEPTIDR_RXSTPEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetDEVEPTIDR_RXSTPEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetDEVEPTIDR_NAKOUTEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetDEVEPTIDR_NAKOUTEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetDEVEPTIDR_NAKINEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetDEVEPTIDR_NAKINEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetDEVEPTIDR_OVERFEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetDEVEPTIDR_OVERFEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetDEVEPTIDR_STALLEDEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetDEVEPTIDR_STALLEDEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetDEVEPTIDR_SHORTPACKETEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x80)|value<<7)
}
func (o *USBHS_Type) GetDEVEPTIDR_SHORTPACKETEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x80) >> 7
}
func (o *USBHS_Type) SetDEVEPTIDR_NBUSYBKEC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetDEVEPTIDR_NBUSYBKEC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetDEVEPTIDR_FIFOCONC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetDEVEPTIDR_FIFOCONC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetDEVEPTIDR_EPDISHDMAC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetDEVEPTIDR_EPDISHDMAC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetDEVEPTIDR_NYETDISC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetDEVEPTIDR_NYETDISC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetDEVEPTIDR_STALLRQC(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVEPTIDR[idx].Reg, volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetDEVEPTIDR_STALLRQC(idx int) uint32 {
	return (volatile.LoadUint32(&o.DEVEPTIDR[idx].Reg) & 0x80000) >> 19
}

// USBHS.HSTCTRL: Host General Control Register
func (o *USBHS_Type) SetHSTCTRL_SOFE(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x100)|value<<8)
}
func (o *USBHS_Type) GetHSTCTRL_SOFE() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x100) >> 8
}
func (o *USBHS_Type) SetHSTCTRL_RESET(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x200)|value<<9)
}
func (o *USBHS_Type) GetHSTCTRL_RESET() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x200) >> 9
}
func (o *USBHS_Type) SetHSTCTRL_RESUME(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x400)|value<<10)
}
func (o *USBHS_Type) GetHSTCTRL_RESUME() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x400) >> 10
}
func (o *USBHS_Type) SetHSTCTRL_SPDCONF(value uint32) {
	volatile.StoreUint32(&o.HSTCTRL.Reg, volatile.LoadUint32(&o.HSTCTRL.Reg)&^(0x3000)|value<<12)
}
func (o *USBHS_Type) GetHSTCTRL_SPDCONF() uint32 {
	return (volatile.LoadUint32(&o.HSTCTRL.Reg) & 0x3000) >> 12
}

// USBHS.HSTISR: Host Global Interrupt Status Register
func (o *USBHS_Type) SetHSTISR_DCONNI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetHSTISR_DCONNI() uint32 {
	return volatile.LoadUint32(&o.HSTISR.Reg) & 0x1
}
func (o *USBHS_Type) SetHSTISR_DDISCI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetHSTISR_DDISCI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetHSTISR_RSTI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetHSTISR_RSTI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetHSTISR_RSMEDI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetHSTISR_RSMEDI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetHSTISR_RXRSMI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetHSTISR_RXRSMI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetHSTISR_HSOFI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetHSTISR_HSOFI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetHSTISR_HWUPI(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetHSTISR_HWUPI() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x40) >> 6
}
func (o *USBHS_Type) SetHSTISR_PEP_0(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x100)|value<<8)
}
func (o *USBHS_Type) GetHSTISR_PEP_0() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x100) >> 8
}
func (o *USBHS_Type) SetHSTISR_PEP_1(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x200)|value<<9)
}
func (o *USBHS_Type) GetHSTISR_PEP_1() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x200) >> 9
}
func (o *USBHS_Type) SetHSTISR_PEP_2(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x400)|value<<10)
}
func (o *USBHS_Type) GetHSTISR_PEP_2() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x400) >> 10
}
func (o *USBHS_Type) SetHSTISR_PEP_3(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x800)|value<<11)
}
func (o *USBHS_Type) GetHSTISR_PEP_3() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x800) >> 11
}
func (o *USBHS_Type) SetHSTISR_PEP_4(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x1000)|value<<12)
}
func (o *USBHS_Type) GetHSTISR_PEP_4() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x1000) >> 12
}
func (o *USBHS_Type) SetHSTISR_PEP_5(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2000)|value<<13)
}
func (o *USBHS_Type) GetHSTISR_PEP_5() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2000) >> 13
}
func (o *USBHS_Type) SetHSTISR_PEP_6(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4000)|value<<14)
}
func (o *USBHS_Type) GetHSTISR_PEP_6() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4000) >> 14
}
func (o *USBHS_Type) SetHSTISR_PEP_7(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8000)|value<<15)
}
func (o *USBHS_Type) GetHSTISR_PEP_7() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8000) >> 15
}
func (o *USBHS_Type) SetHSTISR_PEP_8(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10000)|value<<16)
}
func (o *USBHS_Type) GetHSTISR_PEP_8() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10000) >> 16
}
func (o *USBHS_Type) SetHSTISR_PEP_9(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20000)|value<<17)
}
func (o *USBHS_Type) GetHSTISR_PEP_9() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20000) >> 17
}
func (o *USBHS_Type) SetHSTISR_PEP_10(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x40000)|value<<18)
}
func (o *USBHS_Type) GetHSTISR_PEP_10() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x40000) >> 18
}
func (o *USBHS_Type) SetHSTISR_PEP_11(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x80000)|value<<19)
}
func (o *USBHS_Type) GetHSTISR_PEP_11() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x80000) >> 19
}
func (o *USBHS_Type) SetHSTISR_DMA_1(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x2000000)|value<<25)
}
func (o *USBHS_Type) GetHSTISR_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x2000000) >> 25
}
func (o *USBHS_Type) SetHSTISR_DMA_2(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x4000000)|value<<26)
}
func (o *USBHS_Type) GetHSTISR_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x4000000) >> 26
}
func (o *USBHS_Type) SetHSTISR_DMA_3(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x8000000)|value<<27)
}
func (o *USBHS_Type) GetHSTISR_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x8000000) >> 27
}
func (o *USBHS_Type) SetHSTISR_DMA_4(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x10000000)|value<<28)
}
func (o *USBHS_Type) GetHSTISR_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x10000000) >> 28
}
func (o *USBHS_Type) SetHSTISR_DMA_5(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x20000000)|value<<29)
}
func (o *USBHS_Type) GetHSTISR_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x20000000) >> 29
}
func (o *USBHS_Type) SetHSTISR_DMA_6(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x40000000)|value<<30)
}
func (o *USBHS_Type) GetHSTISR_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x40000000) >> 30
}
func (o *USBHS_Type) SetHSTISR_DMA_7(value uint32) {
	volatile.StoreUint32(&o.HSTISR.Reg, volatile.LoadUint32(&o.HSTISR.Reg)&^(0x80000000)|value<<31)
}
func (o *USBHS_Type) GetHSTISR_DMA_7() uint32 {
	return (volatile.LoadUint32(&o.HSTISR.Reg) & 0x80000000) >> 31
}

// USBHS.HSTICR: Host Global Interrupt Clear Register
func (o *USBHS_Type) SetHSTICR_DCONNIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetHSTICR_DCONNIC() uint32 {
	return volatile.LoadUint32(&o.HSTICR.Reg) & 0x1
}
func (o *USBHS_Type) SetHSTICR_DDISCIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetHSTICR_DDISCIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetHSTICR_RSTIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetHSTICR_RSTIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetHSTICR_RSMEDIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetHSTICR_RSMEDIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetHSTICR_RXRSMIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetHSTICR_RXRSMIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) SetHSTICR_HSOFIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x20)|value<<5)
}
func (o *USBHS_Type) GetHSTICR_HSOFIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x20) >> 5
}
func (o *USBHS_Type) SetHSTICR_HWUPIC(value uint32) {
	volatile.StoreUint32(&o.HSTICR.Reg, volatile.LoadUint32(&o.HSTICR.Reg)&^(0x40)|value<<6)
}
func (o *USBHS_Type) GetHSTICR_HWUPIC() uint32 {
	return (volatile.LoadUint32(&o.HSTICR.Reg) & 0x40) >> 6
}

// USBHS.HSTIFR: Host Global Interrupt Set Register
func (o *USBHS_Type) SetHSTIFR_DCONNIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x1)|value)
}
func (o *USBHS_Type) GetHSTIFR_DCONNIS() uint32 {
	return volatile.LoadUint32(&o.HSTIFR.Reg) & 0x1
}
func (o *USBHS_Type) SetHSTIFR_DDISCIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x2)|value<<1)
}
func (o *USBHS_Type) GetHSTIFR_DDISCIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x2) >> 1
}
func (o *USBHS_Type) SetHSTIFR_RSTIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x4)|value<<2)
}
func (o *USBHS_Type) GetHSTIFR_RSTIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x4) >> 2
}
func (o *USBHS_Type) SetHSTIFR_RSMEDIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x8)|value<<3)
}
func (o *USBHS_Type) GetHSTIFR_RSMEDIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x8) >> 3
}
func (o *USBHS_Type) SetHSTIFR_RXRSMIS(value uint32) {
	volatile.StoreUint32(&o.HSTIFR.Reg, volatile.LoadUint32(&o.HSTIFR.Reg)&^(0x10)|value<<4)
}
func (o *USBHS_Type) GetHSTIFR_RXRSMIS() uint32 {
	return (volatile.LoadUint32(&o.HSTIFR.Reg) & 0x10) >> 4
}
func (o *USBHS_Type) 