// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from rp2350.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/RaspberryPi

//go:build rp && rp2350

/*
//
//         Dual Cortex-M33 or Hazard3 processors at 150MHz
//         520kB on-chip SRAM, in 10 independent banks
//         Extended low-power sleep states with optional SRAM retention: as low as 10uA DVDD
//         8kB of one-time-programmable storage (OTP)
//         Up to 16MB of external QSPI flash/PSRAM via dedicated QSPI bus
//             Additional 16MB flash/PSRAM accessible via optional second chip-select
//         On-chip switched-mode power supply to generate core voltage
//             Low-quiescent-current LDO mode can be enabled for sleep states
//         2x on-chip PLLs for internal or external clock generation
//         GPIOs are 5V-tolerant (powered), and 3.3V-failsafe (unpowered)
//         Security features:
//             Optional boot signing, enforced by on-chip mask ROM, with key fingerprint in OTP
//             Protected OTP storage for optional boot decryption key
//             Global bus filtering based on Arm or RISC-V security/privilege levels
//             Peripherals, GPIOs and DMA channels individually assignable to security domains
//             Hardware mitigations for fault injection attacks
//             Hardware SHA-256 accelerator
//         Peripherals:
//             2x UARTs
//             2x SPI controllers
//             2x I2C controllers
//             24x PWM channels
//             USB 1.1 controller and PHY, with host and device support
//             12x PIO state machines
//             1x HSTX peripheral
//
*/
//     Copyright (c) 2024 Raspberry Pi Ltd. SPDX-License-Identifier: BSD-3-Clause
package rp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "RP2350"
	CPU          = "CM33"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	IRQ_TIMER0_IRQ_0 = 0

	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	IRQ_TIMER0_IRQ_1 = 1

	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	IRQ_TIMER0_IRQ_2 = 2

	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	IRQ_TIMER0_IRQ_3 = 3

	IRQ_TIMER1_IRQ_0 = 4

	IRQ_TIMER1_IRQ_1 = 5

	IRQ_TIMER1_IRQ_2 = 6

	IRQ_TIMER1_IRQ_3 = 7

	// Simple PWM
	IRQ_PWM_IRQ_WRAP_0 = 8

	// Simple PWM
	IRQ_PWM_IRQ_WRAP_1 = 9

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_0 = 10

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_1 = 11

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_2 = 12

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_3 = 13

	// USB FS/LS controller device registers
	IRQ_USBCTRL_IRQ = 14

	// Programmable IO block
	IRQ_PIO0_IRQ_0 = 15

	// Programmable IO block
	IRQ_PIO0_IRQ_1 = 16

	IRQ_PIO1_IRQ_0 = 17

	IRQ_PIO1_IRQ_1 = 18

	IRQ_PIO2_IRQ_0 = 19

	IRQ_PIO2_IRQ_1 = 20

	IRQ_IO_IRQ_BANK0 = 21

	IRQ_IO_IRQ_BANK0_NS = 22

	IRQ_IO_IRQ_QSPI = 23

	IRQ_IO_IRQ_QSPI_NS = 24

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_FIFO = 25

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_BELL = 26

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_FIFO_NS = 27

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_BELL_NS = 28

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_MTIMECMP = 29

	IRQ_CLOCKS_IRQ = 30

	IRQ_SPI0_IRQ = 31

	IRQ_SPI1_IRQ = 32

	IRQ_UART0_IRQ = 33

	IRQ_UART1_IRQ = 34

	// Control and data interface to SAR ADC
	IRQ_ADC_IRQ_FIFO = 35

	// DW_apb_i2c address block List of configuration constants for the Synopsys I2C hardware (you may see references to these in I2C register header; these are *fixed* values, set at hardware design time): IC_ULTRA_FAST_MODE ................ 0x0 IC_UFM_TBUF_CNT_DEFAULT ........... 0x8 IC_UFM_SCL_LOW_COUNT .............. 0x0008 IC_UFM_SCL_HIGH_COUNT ............. 0x0006 IC_TX_TL .......................... 0x0 IC_TX_CMD_BLOCK ................... 0x1 IC_HAS_DMA ........................ 0x1 IC_HAS_ASYNC_FIFO ................. 0x0 IC_SMBUS_ARP ...................... 0x0 IC_FIRST_DATA_BYTE_STATUS ......... 0x1 IC_INTR_IO ........................ 0x1 IC_MASTER_MODE .................... 0x1 IC_DEFAULT_ACK_GENERAL_CALL ....... 0x1 IC_INTR_POL ....................... 0x1 IC_OPTIONAL_SAR ................... 0x0 IC_DEFAULT_TAR_SLAVE_ADDR ......... 0x055 IC_DEFAULT_SLAVE_ADDR ............. 0x055 IC_DEFAULT_HS_SPKLEN .............. 0x1 IC_FS_SCL_HIGH_COUNT .............. 0x0006 IC_HS_SCL_LOW_COUNT ............... 0x0008 IC_DEVICE_ID_VALUE ................ 0x0 IC_10BITADDR_MASTER ............... 0x0 IC_CLK_FREQ_OPTIMIZATION .......... 0x0 IC_DEFAULT_FS_SPKLEN .............. 0x7 IC_ADD_ENCODED_PARAMS ............. 0x0 IC_DEFAULT_SDA_HOLD ............... 0x000001 IC_DEFAULT_SDA_SETUP .............. 0x64 IC_AVOID_RX_FIFO_FLUSH_ON_TX_ABRT . 0x0 IC_CLOCK_PERIOD ................... 100 IC_EMPTYFIFO_HOLD_MASTER_EN ....... 1 IC_RESTART_EN ..................... 0x1 IC_TX_CMD_BLOCK_DEFAULT ........... 0x0 IC_BUS_CLEAR_FEATURE .............. 0x0 IC_CAP_LOADING .................... 100 IC_FS_SCL_LOW_COUNT ............... 0x000d APB_DATA_WIDTH .................... 32 IC_SDA_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_SLV_DATA_NACK_ONLY ............. 0x1 IC_10BITADDR_SLAVE ................ 0x0 IC_CLK_TYPE ....................... 0x0 IC_SMBUS_UDID_MSB ................. 0x0 IC_SMBUS_SUSPEND_ALERT ............ 0x0 IC_HS_SCL_HIGH_COUNT .............. 0x0006 IC_SLV_RESTART_DET_EN ............. 0x1 IC_SMBUS .......................... 0x0 IC_OPTIONAL_SAR_DEFAULT ........... 0x0 IC_PERSISTANT_SLV_ADDR_DEFAULT .... 0x0 IC_USE_COUNTS ..................... 0x0 IC_RX_BUFFER_DEPTH ................ 16 IC_SCL_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_RX_FULL_HLD_BUS_EN ............. 0x1 IC_SLAVE_DISABLE .................. 0x1 IC_RX_TL .......................... 0x0 IC_DEVICE_ID ...................... 0x0 IC_HC_COUNT_VALUES ................ 0x0 I2C_DYNAMIC_TAR_UPDATE ............ 0 IC_SMBUS_CLK_LOW_MEXT_DEFAULT ..... 0xffffffff IC_SMBUS_CLK_LOW_SEXT_DEFAULT ..... 0xffffffff IC_HS_MASTER_CODE ................. 0x1 IC_SMBUS_RST_IDLE_CNT_DEFAULT ..... 0xffff IC_SMBUS_UDID_LSB_DEFAULT ......... 0xffffffff IC_SS_SCL_HIGH_COUNT .............. 0x0028 IC_SS_SCL_LOW_COUNT ............... 0x002f IC_MAX_SPEED_MODE ................. 0x2 IC_STAT_FOR_CLK_STRETCH ........... 0x0 IC_STOP_DET_IF_MASTER_ACTIVE ...... 0x0 IC_DEFAULT_UFM_SPKLEN ............. 0x1 IC_TX_BUFFER_DEPTH ................ 16
	IRQ_I2C0_IRQ = 36

	IRQ_I2C1_IRQ = 37

	// SNPS OTP control IF (SBPI and RPi wrapper control)
	IRQ_OTP_IRQ = 38

	// ARM TrustZone RNG register block
	IRQ_TRNG_IRQ = 39

	IRQ_PLL_SYS_IRQ = 42

	IRQ_PLL_USB_IRQ = 43

	// Controls vreg, bor, lposc, chip resets & xosc startup, powman and provides scratch register for general use and for bootcode use
	IRQ_POWMAN_IRQ_POW = 44

	// Controls vreg, bor, lposc, chip resets & xosc startup, powman and provides scratch register for general use and for bootcode use
	IRQ_POWMAN_IRQ_TIMER = 45

	// Highest interrupt number on this device.
	IRQ_max = 45
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export TIMER0_IRQ_0_IRQHandler
func interruptTIMER0_IRQ_0() {
	callHandlers(IRQ_TIMER0_IRQ_0)
}

//export TIMER0_IRQ_1_IRQHandler
func interruptTIMER0_IRQ_1() {
	callHandlers(IRQ_TIMER0_IRQ_1)
}

//export TIMER0_IRQ_2_IRQHandler
func interruptTIMER0_IRQ_2() {
	callHandlers(IRQ_TIMER0_IRQ_2)
}

//export TIMER0_IRQ_3_IRQHandler
func interruptTIMER0_IRQ_3() {
	callHandlers(IRQ_TIMER0_IRQ_3)
}

//export TIMER1_IRQ_0_IRQHandler
func interruptTIMER1_IRQ_0() {
	callHandlers(IRQ_TIMER1_IRQ_0)
}

//export TIMER1_IRQ_1_IRQHandler
func interruptTIMER1_IRQ_1() {
	callHandlers(IRQ_TIMER1_IRQ_1)
}

//export TIMER1_IRQ_2_IRQHandler
func interruptTIMER1_IRQ_2() {
	callHandlers(IRQ_TIMER1_IRQ_2)
}

//export TIMER1_IRQ_3_IRQHandler
func interruptTIMER1_IRQ_3() {
	callHandlers(IRQ_TIMER1_IRQ_3)
}

//export PWM_IRQ_WRAP_0_IRQHandler
func interruptPWM_IRQ_WRAP_0() {
	callHandlers(IRQ_PWM_IRQ_WRAP_0)
}

//export PWM_IRQ_WRAP_1_IRQHandler
func interruptPWM_IRQ_WRAP_1() {
	callHandlers(IRQ_PWM_IRQ_WRAP_1)
}

//export DMA_IRQ_0_IRQHandler
func interruptDMA_IRQ_0() {
	callHandlers(IRQ_DMA_IRQ_0)
}

//export DMA_IRQ_1_IRQHandler
func interruptDMA_IRQ_1() {
	callHandlers(IRQ_DMA_IRQ_1)
}

//export DMA_IRQ_2_IRQHandler
func interruptDMA_IRQ_2() {
	callHandlers(IRQ_DMA_IRQ_2)
}

//export DMA_IRQ_3_IRQHandler
func interruptDMA_IRQ_3() {
	callHandlers(IRQ_DMA_IRQ_3)
}

//export USBCTRL_IRQ_IRQHandler
func interruptUSBCTRL_IRQ() {
	callHandlers(IRQ_USBCTRL_IRQ)
}

//export PIO0_IRQ_0_IRQHandler
func interruptPIO0_IRQ_0() {
	callHandlers(IRQ_PIO0_IRQ_0)
}

//export PIO0_IRQ_1_IRQHandler
func interruptPIO0_IRQ_1() {
	callHandlers(IRQ_PIO0_IRQ_1)
}

//export PIO1_IRQ_0_IRQHandler
func interruptPIO1_IRQ_0() {
	callHandlers(IRQ_PIO1_IRQ_0)
}

//export PIO1_IRQ_1_IRQHandler
func interruptPIO1_IRQ_1() {
	callHandlers(IRQ_PIO1_IRQ_1)
}

//export PIO2_IRQ_0_IRQHandler
func interruptPIO2_IRQ_0() {
	callHandlers(IRQ_PIO2_IRQ_0)
}

//export PIO2_IRQ_1_IRQHandler
func interruptPIO2_IRQ_1() {
	callHandlers(IRQ_PIO2_IRQ_1)
}

//export IO_IRQ_BANK0_IRQHandler
func interruptIO_IRQ_BANK0() {
	callHandlers(IRQ_IO_IRQ_BANK0)
}

//export IO_IRQ_BANK0_NS_IRQHandler
func interruptIO_IRQ_BANK0_NS() {
	callHandlers(IRQ_IO_IRQ_BANK0_NS)
}

//export IO_IRQ_QSPI_IRQHandler
func interruptIO_IRQ_QSPI() {
	callHandlers(IRQ_IO_IRQ_QSPI)
}

//export IO_IRQ_QSPI_NS_IRQHandler
func interruptIO_IRQ_QSPI_NS() {
	callHandlers(IRQ_IO_IRQ_QSPI_NS)
}

//export SIO_IRQ_FIFO_IRQHandler
func interruptSIO_IRQ_FIFO() {
	callHandlers(IRQ_SIO_IRQ_FIFO)
}

//export SIO_IRQ_BELL_IRQHandler
func interruptSIO_IRQ_BELL() {
	callHandlers(IRQ_SIO_IRQ_BELL)
}

//export SIO_IRQ_FIFO_NS_IRQHandler
func interruptSIO_IRQ_FIFO_NS() {
	callHandlers(IRQ_SIO_IRQ_FIFO_NS)
}

//export SIO_IRQ_BELL_NS_IRQHandler
func interruptSIO_IRQ_BELL_NS() {
	callHandlers(IRQ_SIO_IRQ_BELL_NS)
}

//export SIO_IRQ_MTIMECMP_IRQHandler
func interruptSIO_IRQ_MTIMECMP() {
	callHandlers(IRQ_SIO_IRQ_MTIMECMP)
}

//export CLOCKS_IRQ_IRQHandler
func interruptCLOCKS_IRQ() {
	callHandlers(IRQ_CLOCKS_IRQ)
}

//export SPI0_IRQ_IRQHandler
func interruptSPI0_IRQ() {
	callHandlers(IRQ_SPI0_IRQ)
}

//export SPI1_IRQ_IRQHandler
func interruptSPI1_IRQ() {
	callHandlers(IRQ_SPI1_IRQ)
}

//export UART0_IRQ_IRQHandler
func interruptUART0_IRQ() {
	callHandlers(IRQ_UART0_IRQ)
}

//export UART1_IRQ_IRQHandler
func interruptUART1_IRQ() {
	callHandlers(IRQ_UART1_IRQ)
}

//export ADC_IRQ_FIFO_IRQHandler
func interruptADC_IRQ_FIFO() {
	callHandlers(IRQ_ADC_IRQ_FIFO)
}

//export I2C0_IRQ_IRQHandler
func interruptI2C0_IRQ() {
	callHandlers(IRQ_I2C0_IRQ)
}

//export I2C1_IRQ_IRQHandler
func interruptI2C1_IRQ() {
	callHandlers(IRQ_I2C1_IRQ)
}

//export OTP_IRQ_IRQHandler
func interruptOTP_IRQ() {
	callHandlers(IRQ_OTP_IRQ)
}

//export TRNG_IRQ_IRQHandler
func interruptTRNG_IRQ() {
	callHandlers(IRQ_TRNG_IRQ)
}

//export PLL_SYS_IRQ_IRQHandler
func interruptPLL_SYS_IRQ() {
	callHandlers(IRQ_PLL_SYS_IRQ)
}

//export PLL_USB_IRQ_IRQHandler
func interruptPLL_USB_IRQ() {
	callHandlers(IRQ_PLL_USB_IRQ)
}

//export POWMAN_IRQ_POW_IRQHandler
func interruptPOWMAN_IRQ_POW() {
	callHandlers(IRQ_POWMAN_IRQ_POW)
}

//export POWMAN_IRQ_TIMER_IRQHandler
func interruptPOWMAN_IRQ_TIMER() {
	callHandlers(IRQ_POWMAN_IRQ_TIMER)
}

// Peripherals.
var (
	RESETS = (*RESETS_Type)(unsafe.Pointer(uintptr(0x40020000)))

	PSM = (*PSM_Type)(unsafe.Pointer(uintptr(0x40018000)))

	CLOCKS = (*CLOCKS_Type)(unsafe.Pointer(uintptr(0x40010000)))

	TICKS = (*TICKS_Type)(unsafe.Pointer(uintptr(0x40108000)))

	PADS_BANK0 = (*PADS_BANK0_Type)(unsafe.Pointer(uintptr(0x40038000)))

	PADS_QSPI = (*PADS_QSPI_Type)(unsafe.Pointer(uintptr(0x40040000)))

	IO_QSPI = (*IO_QSPI_Type)(unsafe.Pointer(uintptr(0x40030000)))

	IO_BANK0 = (*IO_BANK0_Type)(unsafe.Pointer(uintptr(0x40028000)))

	SYSINFO = (*SYSINFO_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// SHA-256 hash function implementation
	SHA256 = (*SHA256_Type)(unsafe.Pointer(uintptr(0x400f8000)))

	// FIFO status and write access for HSTX
	HSTX_FIFO = (*HSTX_FIFO_Type)(unsafe.Pointer(uintptr(0x50600000)))

	// Control interface to HSTX. For FIFO write access and status, see the HSTX_FIFO register block.
	HSTX_CTRL = (*HSTX_CTRL_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// Cortex-M33 EPPB vendor register block for RP2350
	EPPB = (*EPPB_Type)(unsafe.Pointer(uintptr(0xe0080000)))

	// TEAL registers accessible through the debug interface
	PPB = (*PPB_Type)(unsafe.Pointer(uintptr(0xe0000000)))

	// TEAL registers accessible through the debug interface
	PPB_NS = (*PPB_Type)(unsafe.Pointer(uintptr(0xe0020000)))

	// QSPI Memory Interface. Provides a memory-mapped interface to up to two SPI/DSPI/QSPI flash or PSRAM devices. Also provides a serial interface for programming and configuration of the external device.
	QMI = (*QMI_Type)(unsafe.Pointer(uintptr(0x400d0000)))

	// QSPI flash execute-in-place block
	XIP_CTRL = (*XIP_CTRL_Type)(unsafe.Pointer(uintptr(0x400c8000)))

	// Auxiliary DMA access to XIP FIFOs, via fast AHB bus access
	XIP_AUX = (*XIP_AUX_Type)(unsafe.Pointer(uintptr(0x50500000)))

	// Register block for various chip control signals
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Controls the crystal oscillator
	XOSC = (*XOSC_Type)(unsafe.Pointer(uintptr(0x40048000)))

	PLL_SYS = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x40050000)))

	PLL_USB = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// Hardware access control registers
	ACCESSCTRL = (*ACCESSCTRL_Type)(unsafe.Pointer(uintptr(0x40060000)))

	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40070000)))

	UART1 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40078000)))

	ROSC = (*ROSC_Type)(unsafe.Pointer(uintptr(0x400e8000)))

	// Controls vreg, bor, lposc, chip resets & xosc startup, powman and provides scratch register for general use and for bootcode use
	POWMAN = (*POWMAN_Type)(unsafe.Pointer(uintptr(0x40100000)))

	WATCHDOG = (*WATCHDOG_Type)(unsafe.Pointer(uintptr(0x400d8000)))

	// DMA with separate read and write masters
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	TIMER0 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x400b0000)))

	// Controls time and alarms time is a 64 bit value indicating the time since power-on timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing
	TIMER1 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Simple PWM
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Control and data interface to SAR ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// DW_apb_i2c address block List of configuration constants for the Synopsys I2C hardware (you may see references to these in I2C register header; these are *fixed* values, set at hardware design time): IC_ULTRA_FAST_MODE ................ 0x0 IC_UFM_TBUF_CNT_DEFAULT ........... 0x8 IC_UFM_SCL_LOW_COUNT .............. 0x0008 IC_UFM_SCL_HIGH_COUNT ............. 0x0006 IC_TX_TL .......................... 0x0 IC_TX_CMD_BLOCK ................... 0x1 IC_HAS_DMA ........................ 0x1 IC_HAS_ASYNC_FIFO ................. 0x0 IC_SMBUS_ARP ...................... 0x0 IC_FIRST_DATA_BYTE_STATUS ......... 0x1 IC_INTR_IO ........................ 0x1 IC_MASTER_MODE .................... 0x1 IC_DEFAULT_ACK_GENERAL_CALL ....... 0x1 IC_INTR_POL ....................... 0x1 IC_OPTIONAL_SAR ................... 0x0 IC_DEFAULT_TAR_SLAVE_ADDR ......... 0x055 IC_DEFAULT_SLAVE_ADDR ............. 0x055 IC_DEFAULT_HS_SPKLEN .............. 0x1 IC_FS_SCL_HIGH_COUNT .............. 0x0006 IC_HS_SCL_LOW_COUNT ............... 0x0008 IC_DEVICE_ID_VALUE ................ 0x0 IC_10BITADDR_MASTER ............... 0x0 IC_CLK_FREQ_OPTIMIZATION .......... 0x0 IC_DEFAULT_FS_SPKLEN .............. 0x7 IC_ADD_ENCODED_PARAMS ............. 0x0 IC_DEFAULT_SDA_HOLD ............... 0x000001 IC_DEFAULT_SDA_SETUP .............. 0x64 IC_AVOID_RX_FIFO_FLUSH_ON_TX_ABRT . 0x0 IC_CLOCK_PERIOD ................... 100 IC_EMPTYFIFO_HOLD_MASTER_EN ....... 1 IC_RESTART_EN ..................... 0x1 IC_TX_CMD_BLOCK_DEFAULT ........... 0x0 IC_BUS_CLEAR_FEATURE .............. 0x0 IC_CAP_LOADING .................... 100 IC_FS_SCL_LOW_COUNT ............... 0x000d APB_DATA_WIDTH .................... 32 IC_SDA_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_SLV_DATA_NACK_ONLY ............. 0x1 IC_10BITADDR_SLAVE ................ 0x0 IC_CLK_TYPE ....................... 0x0 IC_SMBUS_UDID_MSB ................. 0x0 IC_SMBUS_SUSPEND_ALERT ............ 0x0 IC_HS_SCL_HIGH_COUNT .............. 0x0006 IC_SLV_RESTART_DET_EN ............. 0x1 IC_SMBUS .......................... 0x0 IC_OPTIONAL_SAR_DEFAULT ........... 0x0 IC_PERSISTANT_SLV_ADDR_DEFAULT .... 0x0 IC_USE_COUNTS ..................... 0x0 IC_RX_BUFFER_DEPTH ................ 16 IC_SCL_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_RX_FULL_HLD_BUS_EN ............. 0x1 IC_SLAVE_DISABLE .................. 0x1 IC_RX_TL .......................... 0x0 IC_DEVICE_ID ...................... 0x0 IC_HC_COUNT_VALUES ................ 0x0 I2C_DYNAMIC_TAR_UPDATE ............ 0 IC_SMBUS_CLK_LOW_MEXT_DEFAULT ..... 0xffffffff IC_SMBUS_CLK_LOW_SEXT_DEFAULT ..... 0xffffffff IC_HS_MASTER_CODE ................. 0x1 IC_SMBUS_RST_IDLE_CNT_DEFAULT ..... 0xffff IC_SMBUS_UDID_LSB_DEFAULT ......... 0xffffffff IC_SS_SCL_HIGH_COUNT .............. 0x0028 IC_SS_SCL_LOW_COUNT ............... 0x002f IC_MAX_SPEED_MODE ................. 0x2 IC_STAT_FOR_CLK_STRETCH ........... 0x0 IC_STOP_DET_IF_MASTER_ACTIVE ...... 0x0 IC_DEFAULT_UFM_SPKLEN ............. 0x1 IC_TX_BUFFER_DEPTH ................ 16
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// DW_apb_i2c address block List of configuration constants for the Synopsys I2C hardware (you may see references to these in I2C register header; these are *fixed* values, set at hardware design time): IC_ULTRA_FAST_MODE ................ 0x0 IC_UFM_TBUF_CNT_DEFAULT ........... 0x8 IC_UFM_SCL_LOW_COUNT .............. 0x0008 IC_UFM_SCL_HIGH_COUNT ............. 0x0006 IC_TX_TL .......................... 0x0 IC_TX_CMD_BLOCK ................... 0x1 IC_HAS_DMA ........................ 0x1 IC_HAS_ASYNC_FIFO ................. 0x0 IC_SMBUS_ARP ...................... 0x0 IC_FIRST_DATA_BYTE_STATUS ......... 0x1 IC_INTR_IO ........................ 0x1 IC_MASTER_MODE .................... 0x1 IC_DEFAULT_ACK_GENERAL_CALL ....... 0x1 IC_INTR_POL ....................... 0x1 IC_OPTIONAL_SAR ................... 0x0 IC_DEFAULT_TAR_SLAVE_ADDR ......... 0x055 IC_DEFAULT_SLAVE_ADDR ............. 0x055 IC_DEFAULT_HS_SPKLEN .............. 0x1 IC_FS_SCL_HIGH_COUNT .............. 0x0006 IC_HS_SCL_LOW_COUNT ............... 0x0008 IC_DEVICE_ID_VALUE ................ 0x0 IC_10BITADDR_MASTER ............... 0x0 IC_CLK_FREQ_OPTIMIZATION .......... 0x0 IC_DEFAULT_FS_SPKLEN .............. 0x7 IC_ADD_ENCODED_PARAMS ............. 0x0 IC_DEFAULT_SDA_HOLD ............... 0x000001 IC_DEFAULT_SDA_SETUP .............. 0x64 IC_AVOID_RX_FIFO_FLUSH_ON_TX_ABRT . 0x0 IC_CLOCK_PERIOD ................... 100 IC_EMPTYFIFO_HOLD_MASTER_EN ....... 1 IC_RESTART_EN ..................... 0x1 IC_TX_CMD_BLOCK_DEFAULT ........... 0x0 IC_BUS_CLEAR_FEATURE .............. 0x0 IC_CAP_LOADING .................... 100 IC_FS_SCL_LOW_COUNT ............... 0x000d APB_DATA_WIDTH .................... 32 IC_SDA_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_SLV_DATA_NACK_ONLY ............. 0x1 IC_10BITADDR_SLAVE ................ 0x0 IC_CLK_TYPE ....................... 0x0 IC_SMBUS_UDID_MSB ................. 0x0 IC_SMBUS_SUSPEND_ALERT ............ 0x0 IC_HS_SCL_HIGH_COUNT .............. 0x0006 IC_SLV_RESTART_DET_EN ............. 0x1 IC_SMBUS .......................... 0x0 IC_OPTIONAL_SAR_DEFAULT ........... 0x0 IC_PERSISTANT_SLV_ADDR_DEFAULT .... 0x0 IC_USE_COUNTS ..................... 0x0 IC_RX_BUFFER_DEPTH ................ 16 IC_SCL_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff IC_RX_FULL_HLD_BUS_EN ............. 0x1 IC_SLAVE_DISABLE .................. 0x1 IC_RX_TL .......................... 0x0 IC_DEVICE_ID ...................... 0x0 IC_HC_COUNT_VALUES ................ 0x0 I2C_DYNAMIC_TAR_UPDATE ............ 0 IC_SMBUS_CLK_LOW_MEXT_DEFAULT ..... 0xffffffff IC_SMBUS_CLK_LOW_SEXT_DEFAULT ..... 0xffffffff IC_HS_MASTER_CODE ................. 0x1 IC_SMBUS_RST_IDLE_CNT_DEFAULT ..... 0xffff IC_SMBUS_UDID_LSB_DEFAULT ......... 0xffffffff IC_SS_SCL_HIGH_COUNT .............. 0x0028 IC_SS_SCL_LOW_COUNT ............... 0x002f IC_MAX_SPEED_MODE ................. 0x2 IC_STAT_FOR_CLK_STRETCH ........... 0x0 IC_STOP_DET_IF_MASTER_ACTIVE ...... 0x0 IC_DEFAULT_UFM_SPKLEN ............. 0x1 IC_TX_BUFFER_DEPTH ................ 16
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40098000)))

	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40080000)))

	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Programmable IO block
	PIO0 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50200000)))

	// Programmable IO block
	PIO1 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50300000)))

	// Programmable IO block
	PIO2 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50400000)))

	// Register block for busfabric control signals and performance counters
	BUSCTRL = (*BUSCTRL_Type)(unsafe.Pointer(uintptr(0x40068000)))

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	SIO = (*SIO_Type)(unsafe.Pointer(uintptr(0xd0000000)))

	// Single-cycle IO block Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	SIO_NS = (*SIO_Type)(unsafe.Pointer(uintptr(0xd0020000)))

	// Additional registers mapped adjacent to the bootram, for use by the bootrom.
	BOOTRAM = (*BOOTRAM_Type)(unsafe.Pointer(uintptr(0x400e0000)))

	// Coresight block - RP specific registers
	CORESIGHT_TRACE = (*CORESIGHT_TRACE_Type)(unsafe.Pointer(uintptr(0x50700000)))

	// USB FS/LS controller device registers
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x50110000)))

	// ARM TrustZone RNG register block
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x400f0000)))

	// Glitch detector controls
	GLITCH_DETECTOR = (*GLITCH_DETECTOR_Type)(unsafe.Pointer(uintptr(0x40158000)))

	// SNPS OTP control IF (SBPI and RPi wrapper control)
	OTP = (*OTP_Type)(unsafe.Pointer(uintptr(0x40120000)))

	// Predefined OTP data layout for RP2350
	OTP_DATA = (*OTP_DATA_Type)(unsafe.Pointer(uintptr(0x40130000)))

	// Predefined OTP data layout for RP2350
	OTP_DATA_RAW = (*OTP_DATA_RAW_Type)(unsafe.Pointer(uintptr(0x40134000)))

	// For managing simulation testbenches
	TBMAN = (*TBMAN_Type)(unsafe.Pointer(uintptr(0x40160000)))

	// DPRAM layout for USB device.
	USB_DPRAM = (*USB_DPRAM_Type)(unsafe.Pointer(uintptr(0x50100000)))
)

type RESETS_Type struct {
	RESET      volatile.Register32 // 0x0
	WDSEL      volatile.Register32 // 0x4
	RESET_DONE volatile.Register32 // 0x8
}

// RESETS.RESET
func (o *RESETS_Type) SetRESET_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x10000000)|value<<28)
}
func (o *RESETS_Type) GetRESET_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x10000000) >> 28
}
func (o *RESETS_Type) SetRESET_UART1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x8000000)|value<<27)
}
func (o *RESETS_Type) GetRESET_UART1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x8000000) >> 27
}
func (o *RESETS_Type) SetRESET_UART0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x4000000)|value<<26)
}
func (o *RESETS_Type) GetRESET_UART0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x4000000) >> 26
}
func (o *RESETS_Type) SetRESET_TRNG(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x2000000)|value<<25)
}
func (o *RESETS_Type) GetRESET_TRNG() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x2000000) >> 25
}
func (o *RESETS_Type) SetRESET_TIMER1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetRESET_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetRESET_TIMER0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetRESET_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetRESET_TBMAN(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetRESET_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetRESET_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetRESET_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetRESET_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetRESET_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetRESET_SPI1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetRESET_SPI1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetRESET_SPI0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetRESET_SPI0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetRESET_SHA256(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetRESET_SHA256() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetRESET_PWM(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetRESET_PWM() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetRESET_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetRESET_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetRESET_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetRESET_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetRESET_PIO2(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetRESET_PIO2() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetRESET_PIO1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetRESET_PIO1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetRESET_PIO0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetRESET_PIO0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetRESET_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetRESET_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetRESET_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetRESET_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetRESET_JTAG(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetRESET_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetRESET_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetRESET_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetRESET_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetRESET_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetRESET_I2C1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetRESET_I2C1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetRESET_I2C0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetRESET_I2C0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetRESET_HSTX(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetRESET_HSTX() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetRESET_DMA(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetRESET_DMA() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetRESET_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetRESET_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetRESET_ADC(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetRESET_ADC() uint32 {
	return volatile.LoadUint32(&o.RESET.Reg) & 0x1
}

// RESETS.WDSEL
func (o *RESETS_Type) SetWDSEL_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10000000)|value<<28)
}
func (o *RESETS_Type) GetWDSEL_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10000000) >> 28
}
func (o *RESETS_Type) SetWDSEL_UART1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8000000)|value<<27)
}
func (o *RESETS_Type) GetWDSEL_UART1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8000000) >> 27
}
func (o *RESETS_Type) SetWDSEL_UART0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4000000)|value<<26)
}
func (o *RESETS_Type) GetWDSEL_UART0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4000000) >> 26
}
func (o *RESETS_Type) SetWDSEL_TRNG(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2000000)|value<<25)
}
func (o *RESETS_Type) GetWDSEL_TRNG() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2000000) >> 25
}
func (o *RESETS_Type) SetWDSEL_TIMER1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetWDSEL_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetWDSEL_TIMER0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetWDSEL_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetWDSEL_TBMAN(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetWDSEL_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetWDSEL_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetWDSEL_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetWDSEL_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetWDSEL_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetWDSEL_SPI1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetWDSEL_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetWDSEL_SPI0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetWDSEL_SPI0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetWDSEL_SHA256(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetWDSEL_SHA256() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetWDSEL_PWM(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetWDSEL_PWM() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetWDSEL_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetWDSEL_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetWDSEL_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetWDSEL_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetWDSEL_PIO2(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetWDSEL_PIO2() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetWDSEL_PIO1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetWDSEL_PIO1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetWDSEL_PIO0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetWDSEL_PIO0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetWDSEL_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetWDSEL_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetWDSEL_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetWDSEL_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetWDSEL_JTAG(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetWDSEL_JTAG() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetWDSEL_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetWDSEL_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetWDSEL_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetWDSEL_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetWDSEL_I2C1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetWDSEL_I2C1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetWDSEL_I2C0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetWDSEL_I2C0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetWDSEL_HSTX(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetWDSEL_HSTX() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetWDSEL_DMA(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetWDSEL_DMA() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetWDSEL_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetWDSEL_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetWDSEL_ADC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetWDSEL_ADC() uint32 {
	return volatile.LoadUint32(&o.WDSEL.Reg) & 0x1
}

// RESETS.RESET_DONE
func (o *RESETS_Type) SetRESET_DONE_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x10000000)|value<<28)
}
func (o *RESETS_Type) GetRESET_DONE_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x10000000) >> 28
}
func (o *RESETS_Type) SetRESET_DONE_UART1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x8000000)|value<<27)
}
func (o *RESETS_Type) GetRESET_DONE_UART1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x8000000) >> 27
}
func (o *RESETS_Type) SetRESET_DONE_UART0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x4000000)|value<<26)
}
func (o *RESETS_Type) GetRESET_DONE_UART0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x4000000) >> 26
}
func (o *RESETS_Type) SetRESET_DONE_TRNG(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x2000000)|value<<25)
}
func (o *RESETS_Type) GetRESET_DONE_TRNG() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x2000000) >> 25
}
func (o *RESETS_Type) SetRESET_DONE_TIMER1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetRESET_DONE_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetRESET_DONE_TIMER0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetRESET_DONE_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetRESET_DONE_TBMAN(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetRESET_DONE_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetRESET_DONE_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetRESET_DONE_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetRESET_DONE_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetRESET_DONE_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetRESET_DONE_SPI1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetRESET_DONE_SPI1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetRESET_DONE_SPI0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetRESET_DONE_SPI0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetRESET_DONE_SHA256(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetRESET_DONE_SHA256() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetRESET_DONE_PWM(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetRESET_DONE_PWM() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetRESET_DONE_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetRESET_DONE_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetRESET_DONE_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetRESET_DONE_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetRESET_DONE_PIO2(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetRESET_DONE_PIO2() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetRESET_DONE_PIO1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetRESET_DONE_PIO1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetRESET_DONE_PIO0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetRESET_DONE_PIO0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetRESET_DONE_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetRESET_DONE_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetRESET_DONE_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetRESET_DONE_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetRESET_DONE_JTAG(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetRESET_DONE_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetRESET_DONE_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetRESET_DONE_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetRESET_DONE_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetRESET_DONE_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetRESET_DONE_I2C1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetRESET_DONE_I2C1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetRESET_DONE_I2C0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetRESET_DONE_I2C0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetRESET_DONE_HSTX(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetRESET_DONE_HSTX() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetRESET_DONE_DMA(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetRESET_DONE_DMA() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetRESET_DONE_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetRESET_DONE_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetRESET_DONE_ADC(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetRESET_DONE_ADC() uint32 {
	return volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1
}

type PSM_Type struct {
	FRCE_ON  volatile.Register32 // 0x0
	FRCE_OFF volatile.Register32 // 0x4
	WDSEL    volatile.Register32 // 0x8
	DONE     volatile.Register32 // 0xC
}

// PSM.FRCE_ON: Force block out of reset (i.e. power it on)
func (o *PSM_Type) SetFRCE_ON_PROC1(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x1000000)|value<<24)
}
func (o *PSM_Type) GetFRCE_ON_PROC1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x1000000) >> 24
}
func (o *PSM_Type) SetFRCE_ON_PROC0(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x800000)|value<<23)
}
func (o *PSM_Type) GetFRCE_ON_PROC0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x800000) >> 23
}
func (o *PSM_Type) SetFRCE_ON_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x400000)|value<<22)
}
func (o *PSM_Type) GetFRCE_ON_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x400000) >> 22
}
func (o *PSM_Type) SetFRCE_ON_SIO(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x200000)|value<<21)
}
func (o *PSM_Type) GetFRCE_ON_SIO() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x200000) >> 21
}
func (o *PSM_Type) SetFRCE_ON_XIP(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x100000)|value<<20)
}
func (o *PSM_Type) GetFRCE_ON_XIP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x100000) >> 20
}
func (o *PSM_Type) SetFRCE_ON_SRAM9(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x80000)|value<<19)
}
func (o *PSM_Type) GetFRCE_ON_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x80000) >> 19
}
func (o *PSM_Type) SetFRCE_ON_SRAM8(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x40000)|value<<18)
}
func (o *PSM_Type) GetFRCE_ON_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x40000) >> 18
}
func (o *PSM_Type) SetFRCE_ON_SRAM7(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x20000)|value<<17)
}
func (o *PSM_Type) GetFRCE_ON_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x20000) >> 17
}
func (o *PSM_Type) SetFRCE_ON_SRAM6(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetFRCE_ON_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetFRCE_ON_SRAM5(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetFRCE_ON_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetFRCE_ON_SRAM4(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetFRCE_ON_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetFRCE_ON_SRAM3(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetFRCE_ON_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetFRCE_ON_SRAM2(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetFRCE_ON_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetFRCE_ON_SRAM1(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetFRCE_ON_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetFRCE_ON_SRAM0(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetFRCE_ON_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetFRCE_ON_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetFRCE_ON_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetFRCE_ON_ROM(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetFRCE_ON_ROM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetFRCE_ON_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetFRCE_ON_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetFRCE_ON_PSM_READY(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetFRCE_ON_PSM_READY() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetFRCE_ON_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetFRCE_ON_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetFRCE_ON_RESETS(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetFRCE_ON_RESETS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetFRCE_ON_XOSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetFRCE_ON_XOSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetFRCE_ON_ROSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetFRCE_ON_ROSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetFRCE_ON_OTP(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetFRCE_ON_OTP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetFRCE_ON_PROC_COLD(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetFRCE_ON_PROC_COLD() uint32 {
	return volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x1
}

// PSM.FRCE_OFF: Force into reset (i.e. power it off)
func (o *PSM_Type) SetFRCE_OFF_PROC1(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x1000000)|value<<24)
}
func (o *PSM_Type) GetFRCE_OFF_PROC1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x1000000) >> 24
}
func (o *PSM_Type) SetFRCE_OFF_PROC0(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x800000)|value<<23)
}
func (o *PSM_Type) GetFRCE_OFF_PROC0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x800000) >> 23
}
func (o *PSM_Type) SetFRCE_OFF_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x400000)|value<<22)
}
func (o *PSM_Type) GetFRCE_OFF_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x400000) >> 22
}
func (o *PSM_Type) SetFRCE_OFF_SIO(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x200000)|value<<21)
}
func (o *PSM_Type) GetFRCE_OFF_SIO() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x200000) >> 21
}
func (o *PSM_Type) SetFRCE_OFF_XIP(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x100000)|value<<20)
}
func (o *PSM_Type) GetFRCE_OFF_XIP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x100000) >> 20
}
func (o *PSM_Type) SetFRCE_OFF_SRAM9(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x80000)|value<<19)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x80000) >> 19
}
func (o *PSM_Type) SetFRCE_OFF_SRAM8(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x40000)|value<<18)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x40000) >> 18
}
func (o *PSM_Type) SetFRCE_OFF_SRAM7(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x20000)|value<<17)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x20000) >> 17
}
func (o *PSM_Type) SetFRCE_OFF_SRAM6(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetFRCE_OFF_SRAM5(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetFRCE_OFF_SRAM4(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetFRCE_OFF_SRAM3(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetFRCE_OFF_SRAM2(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetFRCE_OFF_SRAM1(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetFRCE_OFF_SRAM0(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetFRCE_OFF_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetFRCE_OFF_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetFRCE_OFF_ROM(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetFRCE_OFF_ROM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetFRCE_OFF_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetFRCE_OFF_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetFRCE_OFF_PSM_READY(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetFRCE_OFF_PSM_READY() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetFRCE_OFF_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetFRCE_OFF_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetFRCE_OFF_RESETS(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetFRCE_OFF_RESETS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetFRCE_OFF_XOSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetFRCE_OFF_XOSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetFRCE_OFF_ROSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetFRCE_OFF_ROSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetFRCE_OFF_OTP(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetFRCE_OFF_OTP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetFRCE_OFF_PROC_COLD(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetFRCE_OFF_PROC_COLD() uint32 {
	return volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x1
}

// PSM.WDSEL: Set to 1 if the watchdog should reset this
func (o *PSM_Type) SetWDSEL_PROC1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000000)|value<<24)
}
func (o *PSM_Type) GetWDSEL_PROC1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000000) >> 24
}
func (o *PSM_Type) SetWDSEL_PROC0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800000)|value<<23)
}
func (o *PSM_Type) GetWDSEL_PROC0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800000) >> 23
}
func (o *PSM_Type) SetWDSEL_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400000)|value<<22)
}
func (o *PSM_Type) GetWDSEL_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400000) >> 22
}
func (o *PSM_Type) SetWDSEL_SIO(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200000)|value<<21)
}
func (o *PSM_Type) GetWDSEL_SIO() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200000) >> 21
}
func (o *PSM_Type) SetWDSEL_XIP(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100000)|value<<20)
}
func (o *PSM_Type) GetWDSEL_XIP() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100000) >> 20
}
func (o *PSM_Type) SetWDSEL_SRAM9(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80000)|value<<19)
}
func (o *PSM_Type) GetWDSEL_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80000) >> 19
}
func (o *PSM_Type) SetWDSEL_SRAM8(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40000)|value<<18)
}
func (o *PSM_Type) GetWDSEL_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40000) >> 18
}
func (o *PSM_Type) SetWDSEL_SRAM7(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20000)|value<<17)
}
func (o *PSM_Type) GetWDSEL_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20000) >> 17
}
func (o *PSM_Type) SetWDSEL_SRAM6(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetWDSEL_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetWDSEL_SRAM5(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetWDSEL_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetWDSEL_SRAM4(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetWDSEL_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetWDSEL_SRAM3(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetWDSEL_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetWDSEL_SRAM2(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetWDSEL_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetWDSEL_SRAM1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetWDSEL_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetWDSEL_SRAM0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetWDSEL_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetWDSEL_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetWDSEL_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetWDSEL_ROM(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetWDSEL_ROM() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetWDSEL_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetWDSEL_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetWDSEL_PSM_READY(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetWDSEL_PSM_READY() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetWDSEL_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetWDSEL_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetWDSEL_RESETS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetWDSEL_RESETS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetWDSEL_XOSC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetWDSEL_XOSC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetWDSEL_ROSC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetWDSEL_ROSC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetWDSEL_OTP(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetWDSEL_OTP() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetWDSEL_PROC_COLD(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetWDSEL_PROC_COLD() uint32 {
	return volatile.LoadUint32(&o.WDSEL.Reg) & 0x1
}

// PSM.DONE: Is the subsystem ready?
func (o *PSM_Type) SetDONE_PROC1(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1000000)|value<<24)
}
func (o *PSM_Type) GetDONE_PROC1() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x1000000) >> 24
}
func (o *PSM_Type) SetDONE_PROC0(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x800000)|value<<23)
}
func (o *PSM_Type) GetDONE_PROC0() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x800000) >> 23
}
func (o *PSM_Type) SetDONE_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x400000)|value<<22)
}
func (o *PSM_Type) GetDONE_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x400000) >> 22
}
func (o *PSM_Type) SetDONE_SIO(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x200000)|value<<21)
}
func (o *PSM_Type) GetDONE_SIO() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x200000) >> 21
}
func (o *PSM_Type) SetDONE_XIP(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x100000)|value<<20)
}
func (o *PSM_Type) GetDONE_XIP() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x100000) >> 20
}
func (o *PSM_Type) SetDONE_SRAM9(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x80000)|value<<19)
}
func (o *PSM_Type) GetDONE_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x80000) >> 19
}
func (o *PSM_Type) SetDONE_SRAM8(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x40000)|value<<18)
}
func (o *PSM_Type) GetDONE_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x40000) >> 18
}
func (o *PSM_Type) SetDONE_SRAM7(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x20000)|value<<17)
}
func (o *PSM_Type) GetDONE_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x20000) >> 17
}
func (o *PSM_Type) SetDONE_SRAM6(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetDONE_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetDONE_SRAM5(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetDONE_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetDONE_SRAM4(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetDONE_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetDONE_SRAM3(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetDONE_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetDONE_SRAM2(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetDONE_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetDONE_SRAM1(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetDONE_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetDONE_SRAM0(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetDONE_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetDONE_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetDONE_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetDONE_ROM(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetDONE_ROM() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetDONE_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetDONE_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetDONE_PSM_READY(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetDONE_PSM_READY() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetDONE_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetDONE_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetDONE_RESETS(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetDONE_RESETS() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetDONE_XOSC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetDONE_XOSC() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetDONE_ROSC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetDONE_ROSC() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetDONE_OTP(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetDONE_OTP() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetDONE_PROC_COLD(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetDONE_PROC_COLD() uint32 {
	return volatile.LoadUint32(&o.DONE.Reg) & 0x1
}

type CLOCKS_Type struct {
	CLK_GPOUT0_CTRL      volatile.Register32 // 0x0
	CLK_GPOUT0_DIV       volatile.Register32 // 0x4
	CLK_GPOUT0_SELECTED  volatile.Register32 // 0x8
	CLK_GPOUT1_CTRL      volatile.Register32 // 0xC
	CLK_GPOUT1_DIV       volatile.Register32 // 0x10
	CLK_GPOUT1_SELECTED  volatile.Register32 // 0x14
	CLK_GPOUT2_CTRL      volatile.Register32 // 0x18
	CLK_GPOUT2_DIV       volatile.Register32 // 0x1C
	CLK_GPOUT2_SELECTED  volatile.Register32 // 0x20
	CLK_GPOUT3_CTRL      volatile.Register32 // 0x24
	CLK_GPOUT3_DIV       volatile.Register32 // 0x28
	CLK_GPOUT3_SELECTED  volatile.Register32 // 0x2C
	CLK_REF_CTRL         volatile.Register32 // 0x30
	CLK_REF_DIV          volatile.Register32 // 0x34
	CLK_REF_SELECTED     volatile.Register32 // 0x38
	CLK_SYS_CTRL         volatile.Register32 // 0x3C
	CLK_SYS_DIV          volatile.Register32 // 0x40
	CLK_SYS_SELECTED     volatile.Register32 // 0x44
	CLK_PERI_CTRL        volatile.Register32 // 0x48
	CLK_PERI_DIV         volatile.Register32 // 0x4C
	CLK_PERI_SELECTED    volatile.Register32 // 0x50
	CLK_HSTX_CTRL        volatile.Register32 // 0x54
	CLK_HSTX_DIV         volatile.Register32 // 0x58
	CLK_HSTX_SELECTED    volatile.Register32 // 0x5C
	CLK_USB_CTRL         volatile.Register32 // 0x60
	CLK_USB_DIV          volatile.Register32 // 0x64
	CLK_USB_SELECTED     volatile.Register32 // 0x68
	CLK_ADC_CTRL         volatile.Register32 // 0x6C
	CLK_ADC_DIV          volatile.Register32 // 0x70
	CLK_ADC_SELECTED     volatile.Register32 // 0x74
	DFTCLK_XOSC_CTRL     volatile.Register32 // 0x78
	DFTCLK_ROSC_CTRL     volatile.Register32 // 0x7C
	DFTCLK_LPOSC_CTRL    volatile.Register32 // 0x80
	CLK_SYS_RESUS_CTRL   volatile.Register32 // 0x84
	CLK_SYS_RESUS_STATUS volatile.Register32 // 0x88
	FC0_REF_KHZ          volatile.Register32 // 0x8C
	FC0_MIN_KHZ          volatile.Register32 // 0x90
	FC0_MAX_KHZ          volatile.Register32 // 0x94
	FC0_DELAY            volatile.Register32 // 0x98
	FC0_INTERVAL         volatile.Register32 // 0x9C
	FC0_SRC              volatile.Register32 // 0xA0
	FC0_STATUS           volatile.Register32 // 0xA4
	FC0_RESULT           volatile.Register32 // 0xA8
	WAKE_EN0             volatile.Register32 // 0xAC
	WAKE_EN1             volatile.Register32 // 0xB0
	SLEEP_EN0            volatile.Register32 // 0xB4
	SLEEP_EN1            volatile.Register32 // 0xB8
	ENABLED0             volatile.Register32 // 0xBC
	ENABLED1             volatile.Register32 // 0xC0
	INTR                 volatile.Register32 // 0xC4
	INTE                 volatile.Register32 // 0xC8
	INTF                 volatile.Register32 // 0xCC
	INTS                 volatile.Register32 // 0xD0
}

// CLOCKS.CLK_GPOUT0_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT0_DIV
func (o *CLOCKS_Type) SetCLK_GPOUT0_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg) & 0xffff0000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg)&^(0xffff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg) & 0xffff
}

// CLOCKS.CLK_GPOUT0_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_GPOUT0_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_SELECTED.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT0_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_GPOUT1_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT1_DIV
func (o *CLOCKS_Type) SetCLK_GPOUT1_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg) & 0xffff0000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg)&^(0xffff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg) & 0xffff
}

// CLOCKS.CLK_GPOUT1_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_GPOUT1_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_SELECTED.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT1_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_GPOUT2_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT2_DIV
func (o *CLOCKS_Type) SetCLK_GPOUT2_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg) & 0xffff0000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg)&^(0xffff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg) & 0xffff
}

// CLOCKS.CLK_GPOUT2_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_GPOUT2_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_SELECTED.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT2_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_GPOUT3_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT3_DIV
func (o *CLOCKS_Type) SetCLK_GPOUT3_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg) & 0xffff0000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg)&^(0xffff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg) & 0xffff
}

// CLOCKS.CLK_GPOUT3_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_GPOUT3_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_SELECTED.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT3_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_REF_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_REF_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_CTRL.Reg, volatile.LoadUint32(&o.CLK_REF_CTRL.Reg)&^(0x60)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_REF_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_REF_CTRL.Reg) & 0x60) >> 5
}
func (o *CLOCKS_Type) SetCLK_REF_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_CTRL.Reg, volatile.LoadUint32(&o.CLK_REF_CTRL.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetCLK_REF_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.CLK_REF_CTRL.Reg) & 0x3
}

// CLOCKS.CLK_REF_DIV
func (o *CLOCKS_Type) SetCLK_REF_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_DIV.Reg, volatile.LoadUint32(&o.CLK_REF_DIV.Reg)&^(0xff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_REF_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_REF_DIV.Reg) & 0xff0000) >> 16
}

// CLOCKS.CLK_REF_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_REF_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_SELECTED.Reg, volatile.LoadUint32(&o.CLK_REF_SELECTED.Reg)&^(0xf)|value)
}
func (o *CLOCKS_Type) GetCLK_REF_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_REF_SELECTED.Reg) & 0xf
}

// CLOCKS.CLK_SYS_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_SYS_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_SYS_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg) & 0xe0) >> 5
}
func (o *CLOCKS_Type) SetCLK_SYS_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg) & 0x1
}

// CLOCKS.CLK_SYS_DIV
func (o *CLOCKS_Type) SetCLK_SYS_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_DIV.Reg, volatile.LoadUint32(&o.CLK_SYS_DIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_SYS_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_DIV.Reg) & 0xffff0000) >> 16
}
func (o *CLOCKS_Type) SetCLK_SYS_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_DIV.Reg, volatile.LoadUint32(&o.CLK_SYS_DIV.Reg)&^(0xffff)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_DIV.Reg) & 0xffff
}

// CLOCKS.CLK_SYS_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_SYS_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_SELECTED.Reg, volatile.LoadUint32(&o.CLK_SYS_SELECTED.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_SELECTED.Reg) & 0x3
}

// CLOCKS.CLK_PERI_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_PERI_DIV
func (o *CLOCKS_Type) SetCLK_PERI_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_DIV.Reg, volatile.LoadUint32(&o.CLK_PERI_DIV.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_PERI_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_DIV.Reg) & 0x30000) >> 16
}

// CLOCKS.CLK_PERI_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_PERI_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_SELECTED.Reg, volatile.LoadUint32(&o.CLK_PERI_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_PERI_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_PERI_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_HSTX_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_HSTX_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_CTRL.Reg, volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_HSTX_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_HSTX_DIV
func (o *CLOCKS_Type) SetCLK_HSTX_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_DIV.Reg, volatile.LoadUint32(&o.CLK_HSTX_DIV.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_HSTX_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_HSTX_DIV.Reg) & 0x30000) >> 16
}

// CLOCKS.CLK_HSTX_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_HSTX_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_HSTX_SELECTED.Reg, volatile.LoadUint32(&o.CLK_HSTX_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_HSTX_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_HSTX_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_USB_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_USB_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_USB_DIV
func (o *CLOCKS_Type) SetCLK_USB_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_DIV.Reg, volatile.LoadUint32(&o.CLK_USB_DIV.Reg)&^(0xf0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_USB_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_DIV.Reg) & 0xf0000) >> 16
}

// CLOCKS.CLK_USB_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_USB_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_SELECTED.Reg, volatile.LoadUint32(&o.CLK_USB_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_USB_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_USB_SELECTED.Reg) & 0x1
}

// CLOCKS.CLK_ADC_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_ENABLED(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_ADC_DIV
func (o *CLOCKS_Type) SetCLK_ADC_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_DIV.Reg, volatile.LoadUint32(&o.CLK_ADC_DIV.Reg)&^(0xf0000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_ADC_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_DIV.Reg) & 0xf0000) >> 16
}

// CLOCKS.CLK_ADC_SELECTED: Indicates which src is currently selected (one-hot)
func (o *CLOCKS_Type) SetCLK_ADC_SELECTED(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_SELECTED.Reg, volatile.LoadUint32(&o.CLK_ADC_SELECTED.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_ADC_SELECTED() uint32 {
	return volatile.LoadUint32(&o.CLK_ADC_SELECTED.Reg) & 0x1
}

// CLOCKS.DFTCLK_XOSC_CTRL
func (o *CLOCKS_Type) SetDFTCLK_XOSC_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.DFTCLK_XOSC_CTRL.Reg, volatile.LoadUint32(&o.DFTCLK_XOSC_CTRL.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetDFTCLK_XOSC_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.DFTCLK_XOSC_CTRL.Reg) & 0x3
}

// CLOCKS.DFTCLK_ROSC_CTRL
func (o *CLOCKS_Type) SetDFTCLK_ROSC_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.DFTCLK_ROSC_CTRL.Reg, volatile.LoadUint32(&o.DFTCLK_ROSC_CTRL.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetDFTCLK_ROSC_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.DFTCLK_ROSC_CTRL.Reg) & 0x3
}

// CLOCKS.DFTCLK_LPOSC_CTRL
func (o *CLOCKS_Type) SetDFTCLK_LPOSC_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.DFTCLK_LPOSC_CTRL.Reg, volatile.LoadUint32(&o.DFTCLK_LPOSC_CTRL.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetDFTCLK_LPOSC_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.DFTCLK_LPOSC_CTRL.Reg) & 0x3
}

// CLOCKS.CLK_SYS_RESUS_CTRL
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_FRCE(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_FRCE() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0xff
}

// CLOCKS.CLK_SYS_RESUS_STATUS
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_STATUS_RESUSSED(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_STATUS.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_STATUS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_STATUS_RESUSSED() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_RESUS_STATUS.Reg) & 0x1
}

// CLOCKS.FC0_REF_KHZ: Reference clock frequency in kHz
func (o *CLOCKS_Type) SetFC0_REF_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_REF_KHZ.Reg, volatile.LoadUint32(&o.FC0_REF_KHZ.Reg)&^(0xfffff)|value)
}
func (o *CLOCKS_Type) GetFC0_REF_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_REF_KHZ.Reg) & 0xfffff
}

// CLOCKS.FC0_MIN_KHZ: Minimum pass frequency in kHz. This is optional. Set to 0 if you are not using the pass/fail flags
func (o *CLOCKS_Type) SetFC0_MIN_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_MIN_KHZ.Reg, volatile.LoadUint32(&o.FC0_MIN_KHZ.Reg)&^(0x1ffffff)|value)
}
func (o *CLOCKS_Type) GetFC0_MIN_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_MIN_KHZ.Reg) & 0x1ffffff
}

// CLOCKS.FC0_MAX_KHZ: Maximum pass frequency in kHz. This is optional. Set to 0x1ffffff if you are not using the pass/fail flags
func (o *CLOCKS_Type) SetFC0_MAX_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_MAX_KHZ.Reg, volatile.LoadUint32(&o.FC0_MAX_KHZ.Reg)&^(0x1ffffff)|value)
}
func (o *CLOCKS_Type) GetFC0_MAX_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_MAX_KHZ.Reg) & 0x1ffffff
}

// CLOCKS.FC0_DELAY: Delays the start of frequency counting to allow the mux to settle Delay is measured in multiples of the reference clock period
func (o *CLOCKS_Type) SetFC0_DELAY(value uint32) {
	volatile.StoreUint32(&o.FC0_DELAY.Reg, volatile.LoadUint32(&o.FC0_DELAY.Reg)&^(0x7)|value)
}
func (o *CLOCKS_Type) GetFC0_DELAY() uint32 {
	return volatile.LoadUint32(&o.FC0_DELAY.Reg) & 0x7
}

// CLOCKS.FC0_INTERVAL: The test interval is 0.98us * 2**interval, but let's call it 1us * 2**interval The default gives a test interval of 250us
func (o *CLOCKS_Type) SetFC0_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.FC0_INTERVAL.Reg, volatile.LoadUint32(&o.FC0_INTERVAL.Reg)&^(0xf)|value)
}
func (o *CLOCKS_Type) GetFC0_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.FC0_INTERVAL.Reg) & 0xf
}

// CLOCKS.FC0_SRC: Clock sent to frequency counter, set to 0 when not required Writing to this register initiates the frequency count
func (o *CLOCKS_Type) SetFC0_SRC(value uint32) {
	volatile.StoreUint32(&o.FC0_SRC.Reg, volatile.LoadUint32(&o.FC0_SRC.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetFC0_SRC() uint32 {
	return volatile.LoadUint32(&o.FC0_SRC.Reg) & 0xff
}

// CLOCKS.FC0_STATUS: Frequency counter status
func (o *CLOCKS_Type) SetFC0_STATUS_DIED(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetFC0_STATUS_DIED() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetFC0_STATUS_FAST(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetFC0_STATUS_FAST() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetFC0_STATUS_SLOW(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetFC0_STATUS_SLOW() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetFC0_STATUS_FAIL(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetFC0_STATUS_FAIL() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetFC0_STATUS_WAITING(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetFC0_STATUS_WAITING() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetFC0_STATUS_RUNNING(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetFC0_STATUS_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetFC0_STATUS_DONE(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetFC0_STATUS_DONE() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetFC0_STATUS_PASS(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetFC0_STATUS_PASS() uint32 {
	return volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1
}

// CLOCKS.FC0_RESULT: Result of frequency measurement, only valid when status_done=1
func (o *CLOCKS_Type) SetFC0_RESULT_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_RESULT.Reg, volatile.LoadUint32(&o.FC0_RESULT.Reg)&^(0x3fffffe0)|value<<5)
}
func (o *CLOCKS_Type) GetFC0_RESULT_KHZ() uint32 {
	return (volatile.LoadUint32(&o.FC0_RESULT.Reg) & 0x3fffffe0) >> 5
}
func (o *CLOCKS_Type) SetFC0_RESULT_FRAC(value uint32) {
	volatile.StoreUint32(&o.FC0_RESULT.Reg, volatile.LoadUint32(&o.FC0_RESULT.Reg)&^(0x1f)|value)
}
func (o *CLOCKS_Type) GetFC0_RESULT_FRAC() uint32 {
	return volatile.LoadUint32(&o.FC0_RESULT.Reg) & 0x1f
}

// CLOCKS.WAKE_EN0: enable clock in wake mode
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SHA256(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SHA256() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_POWMAN(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_REF_POWMAN(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_REF_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PIO2(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PIO2() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_OTP(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_OTP() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_REF_OTP(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_REF_OTP() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_HSTX(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_HSTX() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_HSTX(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_HSTX() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_GLITCH_DETECTOR(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_GLITCH_DETECTOR() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_ADC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_ADC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1
}

// CLOCKS.WAKE_EN1: enable clock in wake mode
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_USB(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_USB() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TRNG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TRNG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TIMER1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TIMER0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TICKS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TICKS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_REF_TICKS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_REF_TICKS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM9(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM8(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM7(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM6(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_SPI0() uint32 {
	return volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x1
}

// CLOCKS.SLEEP_EN0: enable clock in sleep mode
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SHA256(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SHA256() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_POWMAN(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_REF_POWMAN(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_REF_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PIO2(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PIO2() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_OTP(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_OTP() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_REF_OTP(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_REF_OTP() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_HSTX(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_HSTX() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_HSTX(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_HSTX() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_GLITCH_DETECTOR(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_GLITCH_DETECTOR() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_ADC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_ADC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1
}

// CLOCKS.SLEEP_EN1: enable clock in sleep mode
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_USB(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_USB() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TRNG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TRNG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TIMER1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TIMER0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TICKS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TICKS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_REF_TICKS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_REF_TICKS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM9(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM8(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM7(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM6(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_SPI0() uint32 {
	return volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x1
}

// CLOCKS.ENABLED0: indicates the state of the clock enable
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SHA256(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SHA256() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_POWMAN(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetENABLED0_CLK_REF_POWMAN(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_REF_POWMAN() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PIO2(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PIO2() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_OTP(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_OTP() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetENABLED0_CLK_REF_OTP(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_REF_OTP() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_HSTX(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_HSTX() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetENABLED0_CLK_HSTX(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_HSTX() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_GLITCH_DETECTOR(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_GLITCH_DETECTOR() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_BOOTRAM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_BOOTRAM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetENABLED0_CLK_ADC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_ADC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ACCESSCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ACCESSCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1
}

// CLOCKS.ENABLED1: indicates the state of the clock enable
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetENABLED1_CLK_USB(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_USB() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TRNG(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TRNG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TIMER1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TIMER0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TICKS(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TICKS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetENABLED1_CLK_REF_TICKS(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_REF_TICKS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM9(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM9() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM8(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM8() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM7(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM7() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM6(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM6() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_SPI0() uint32 {
	return volatile.LoadUint32(&o.ENABLED1.Reg) & 0x1
}

// CLOCKS.INTR: Raw Interrupts
func (o *CLOCKS_Type) SetINTR_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTR_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// CLOCKS.INTE: Interrupt Enable
func (o *CLOCKS_Type) SetINTE_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTE_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTE.Reg) & 0x1
}

// CLOCKS.INTF: Interrupt Force
func (o *CLOCKS_Type) SetINTF_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTF_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}

// CLOCKS.INTS: Interrupt status after masking & forcing
func (o *CLOCKS_Type) SetINTS_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTS_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTS.Reg) & 0x1
}

type TICKS_Type struct {
	PROC0_CTRL      volatile.Register32 // 0x0
	PROC0_CYCLES    volatile.Register32 // 0x4
	PROC0_COUNT     volatile.Register32 // 0x8
	PROC1_CTRL      volatile.Register32 // 0xC
	PROC1_CYCLES    volatile.Register32 // 0x10
	PROC1_COUNT     volatile.Register32 // 0x14
	TIMER0_CTRL     volatile.Register32 // 0x18
	TIMER0_CYCLES   volatile.Register32 // 0x1C
	TIMER0_COUNT    volatile.Register32 // 0x20
	TIMER1_CTRL     volatile.Register32 // 0x24
	TIMER1_CYCLES   volatile.Register32 // 0x28
	TIMER1_COUNT    volatile.Register32 // 0x2C
	WATCHDOG_CTRL   volatile.Register32 // 0x30
	WATCHDOG_CYCLES volatile.Register32 // 0x34
	WATCHDOG_COUNT  volatile.Register32 // 0x38
	RISCV_CTRL      volatile.Register32 // 0x3C
	RISCV_CYCLES    volatile.Register32 // 0x40
	RISCV_COUNT     volatile.Register32 // 0x44
}

// TICKS.PROC0_CTRL: Controls the tick generator
func (o *TICKS_Type) SetPROC0_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.PROC0_CTRL.Reg, volatile.LoadUint32(&o.PROC0_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetPROC0_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.PROC0_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetPROC0_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PROC0_CTRL.Reg, volatile.LoadUint32(&o.PROC0_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetPROC0_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PROC0_CTRL.Reg) & 0x1
}

// TICKS.PROC0_CYCLES
func (o *TICKS_Type) SetPROC0_CYCLES(value uint32) {
	volatile.StoreUint32(&o.PROC0_CYCLES.Reg, volatile.LoadUint32(&o.PROC0_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetPROC0_CYCLES() uint32 {
	return volatile.LoadUint32(&o.PROC0_CYCLES.Reg) & 0x1ff
}

// TICKS.PROC0_COUNT
func (o *TICKS_Type) SetPROC0_COUNT(value uint32) {
	volatile.StoreUint32(&o.PROC0_COUNT.Reg, volatile.LoadUint32(&o.PROC0_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetPROC0_COUNT() uint32 {
	return volatile.LoadUint32(&o.PROC0_COUNT.Reg) & 0x1ff
}

// TICKS.PROC1_CTRL: Controls the tick generator
func (o *TICKS_Type) SetPROC1_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.PROC1_CTRL.Reg, volatile.LoadUint32(&o.PROC1_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetPROC1_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.PROC1_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetPROC1_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PROC1_CTRL.Reg, volatile.LoadUint32(&o.PROC1_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetPROC1_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PROC1_CTRL.Reg) & 0x1
}

// TICKS.PROC1_CYCLES
func (o *TICKS_Type) SetPROC1_CYCLES(value uint32) {
	volatile.StoreUint32(&o.PROC1_CYCLES.Reg, volatile.LoadUint32(&o.PROC1_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetPROC1_CYCLES() uint32 {
	return volatile.LoadUint32(&o.PROC1_CYCLES.Reg) & 0x1ff
}

// TICKS.PROC1_COUNT
func (o *TICKS_Type) SetPROC1_COUNT(value uint32) {
	volatile.StoreUint32(&o.PROC1_COUNT.Reg, volatile.LoadUint32(&o.PROC1_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetPROC1_COUNT() uint32 {
	return volatile.LoadUint32(&o.PROC1_COUNT.Reg) & 0x1ff
}

// TICKS.TIMER0_CTRL: Controls the tick generator
func (o *TICKS_Type) SetTIMER0_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CTRL.Reg, volatile.LoadUint32(&o.TIMER0_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetTIMER0_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.TIMER0_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetTIMER0_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CTRL.Reg, volatile.LoadUint32(&o.TIMER0_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetTIMER0_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.TIMER0_CTRL.Reg) & 0x1
}

// TICKS.TIMER0_CYCLES
func (o *TICKS_Type) SetTIMER0_CYCLES(value uint32) {
	volatile.StoreUint32(&o.TIMER0_CYCLES.Reg, volatile.LoadUint32(&o.TIMER0_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetTIMER0_CYCLES() uint32 {
	return volatile.LoadUint32(&o.TIMER0_CYCLES.Reg) & 0x1ff
}

// TICKS.TIMER0_COUNT
func (o *TICKS_Type) SetTIMER0_COUNT(value uint32) {
	volatile.StoreUint32(&o.TIMER0_COUNT.Reg, volatile.LoadUint32(&o.TIMER0_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetTIMER0_COUNT() uint32 {
	return volatile.LoadUint32(&o.TIMER0_COUNT.Reg) & 0x1ff
}

// TICKS.TIMER1_CTRL: Controls the tick generator
func (o *TICKS_Type) SetTIMER1_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CTRL.Reg, volatile.LoadUint32(&o.TIMER1_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetTIMER1_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.TIMER1_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetTIMER1_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CTRL.Reg, volatile.LoadUint32(&o.TIMER1_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetTIMER1_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.TIMER1_CTRL.Reg) & 0x1
}

// TICKS.TIMER1_CYCLES
func (o *TICKS_Type) SetTIMER1_CYCLES(value uint32) {
	volatile.StoreUint32(&o.TIMER1_CYCLES.Reg, volatile.LoadUint32(&o.TIMER1_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetTIMER1_CYCLES() uint32 {
	return volatile.LoadUint32(&o.TIMER1_CYCLES.Reg) & 0x1ff
}

// TICKS.TIMER1_COUNT
func (o *TICKS_Type) SetTIMER1_COUNT(value uint32) {
	volatile.StoreUint32(&o.TIMER1_COUNT.Reg, volatile.LoadUint32(&o.TIMER1_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetTIMER1_COUNT() uint32 {
	return volatile.LoadUint32(&o.TIMER1_COUNT.Reg) & 0x1ff
}

// TICKS.WATCHDOG_CTRL: Controls the tick generator
func (o *TICKS_Type) SetWATCHDOG_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.WATCHDOG_CTRL.Reg, volatile.LoadUint32(&o.WATCHDOG_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetWATCHDOG_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.WATCHDOG_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetWATCHDOG_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.WATCHDOG_CTRL.Reg, volatile.LoadUint32(&o.WATCHDOG_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetWATCHDOG_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.WATCHDOG_CTRL.Reg) & 0x1
}

// TICKS.WATCHDOG_CYCLES
func (o *TICKS_Type) SetWATCHDOG_CYCLES(value uint32) {
	volatile.StoreUint32(&o.WATCHDOG_CYCLES.Reg, volatile.LoadUint32(&o.WATCHDOG_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetWATCHDOG_CYCLES() uint32 {
	return volatile.LoadUint32(&o.WATCHDOG_CYCLES.Reg) & 0x1ff
}

// TICKS.WATCHDOG_COUNT
func (o *TICKS_Type) SetWATCHDOG_COUNT(value uint32) {
	volatile.StoreUint32(&o.WATCHDOG_COUNT.Reg, volatile.LoadUint32(&o.WATCHDOG_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetWATCHDOG_COUNT() uint32 {
	return volatile.LoadUint32(&o.WATCHDOG_COUNT.Reg) & 0x1ff
}

// TICKS.RISCV_CTRL: Controls the tick generator
func (o *TICKS_Type) SetRISCV_CTRL_RUNNING(value uint32) {
	volatile.StoreUint32(&o.RISCV_CTRL.Reg, volatile.LoadUint32(&o.RISCV_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *TICKS_Type) GetRISCV_CTRL_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.RISCV_CTRL.Reg) & 0x2) >> 1
}
func (o *TICKS_Type) SetRISCV_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RISCV_CTRL.Reg, volatile.LoadUint32(&o.RISCV_CTRL.Reg)&^(0x1)|value)
}
func (o *TICKS_Type) GetRISCV_CTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RISCV_CTRL.Reg) & 0x1
}

// TICKS.RISCV_CYCLES
func (o *TICKS_Type) SetRISCV_CYCLES(value uint32) {
	volatile.StoreUint32(&o.RISCV_CYCLES.Reg, volatile.LoadUint32(&o.RISCV_CYCLES.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetRISCV_CYCLES() uint32 {
	return volatile.LoadUint32(&o.RISCV_CYCLES.Reg) & 0x1ff
}

// TICKS.RISCV_COUNT
func (o *TICKS_Type) SetRISCV_COUNT(value uint32) {
	volatile.StoreUint32(&o.RISCV_COUNT.Reg, volatile.LoadUint32(&o.RISCV_COUNT.Reg)&^(0x1ff)|value)
}
func (o *TICKS_Type) GetRISCV_COUNT() uint32 {
	return volatile.LoadUint32(&o.RISCV_COUNT.Reg) & 0x1ff
}

type PADS_BANK0_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO0          volatile.Register32 // 0x4
	GPIO1          volatile.Register32 // 0x8
	GPIO2          volatile.Register32 // 0xC
	GPIO3          volatile.Register32 // 0x10
	GPIO4          volatile.Register32 // 0x14
	GPIO5          volatile.Register32 // 0x18
	GPIO6          volatile.Register32 // 0x1C
	GPIO7          volatile.Register32 // 0x20
	GPIO8          volatile.Register32 // 0x24
	GPIO9          volatile.Register32 // 0x28
	GPIO10         volatile.Register32 // 0x2C
	GPIO11         volatile.Register32 // 0x30
	GPIO12         volatile.Register32 // 0x34
	GPIO13         volatile.Register32 // 0x38
	GPIO14         volatile.Register32 // 0x3C
	GPIO15         volatile.Register32 // 0x40
	GPIO16         volatile.Register32 // 0x44
	GPIO17         volatile.Register32 // 0x48
	GPIO18         volatile.Register32 // 0x4C
	GPIO19         volatile.Register32 // 0x50
	GPIO20         volatile.Register32 // 0x54
	GPIO21         volatile.Register32 // 0x58
	GPIO22         volatile.Register32 // 0x5C
	GPIO23         volatile.Register32 // 0x60
	GPIO24         volatile.Register32 // 0x64
	GPIO25         volatile.Register32 // 0x68
	GPIO26         volatile.Register32 // 0x6C
	GPIO27         volatile.Register32 // 0x70
	GPIO28         volatile.Register32 // 0x74
	GPIO29         volatile.Register32 // 0x78
	GPIO30         volatile.Register32 // 0x7C
	GPIO31         volatile.Register32 // 0x80
	GPIO32         volatile.Register32 // 0x84
	GPIO33         volatile.Register32 // 0x88
	GPIO34         volatile.Register32 // 0x8C
	GPIO35         volatile.Register32 // 0x90
	GPIO36         volatile.Register32 // 0x94
	GPIO37         volatile.Register32 // 0x98
	GPIO38         volatile.Register32 // 0x9C
	GPIO39         volatile.Register32 // 0xA0
	GPIO40         volatile.Register32 // 0xA4
	GPIO41         volatile.Register32 // 0xA8
	GPIO42         volatile.Register32 // 0xAC
	GPIO43         volatile.Register32 // 0xB0
	GPIO44         volatile.Register32 // 0xB4
	GPIO45         volatile.Register32 // 0xB8
	GPIO46         volatile.Register32 // 0xBC
	GPIO47         volatile.Register32 // 0xC0
	SWCLK          volatile.Register32 // 0xC4
	SWD            volatile.Register32 // 0xC8
}

// PADS_BANK0.VOLTAGE_SELECT: Voltage select. Per bank control
func (o *PADS_BANK0_Type) SetVOLTAGE_SELECT(value uint32) {
	volatile.StoreUint32(&o.VOLTAGE_SELECT.Reg, volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetVOLTAGE_SELECT() uint32 {
	return volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg) & 0x1
}

// PADS_BANK0.GPIO0
func (o *PADS_BANK0_Type) SetGPIO0_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO0_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO0_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO0_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO0_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO0_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO0_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO0_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO0_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO0_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO0_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO0_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO0_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO0_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO0_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO0_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}

// PADS_BANK0.GPIO1
func (o *PADS_BANK0_Type) SetGPIO1_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO1_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO1_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO1_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO1_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO1_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO1_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO1_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO1_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO1_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO1_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO1_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO1_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO1_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO1_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO1_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}

// PADS_BANK0.GPIO2
func (o *PADS_BANK0_Type) SetGPIO2_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO2_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO2_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO2_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO2_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO2_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO2_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO2_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO2_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO2_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO2_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO2_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO2_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO2_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO2_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO2_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}

// PADS_BANK0.GPIO3
func (o *PADS_BANK0_Type) SetGPIO3_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO3_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO3_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO3_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO3_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO3_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO3_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO3_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO3_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO3_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO3_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO3_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO3_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO3_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO3_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO3_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}

// PADS_BANK0.GPIO4
func (o *PADS_BANK0_Type) SetGPIO4_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO4_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO4_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO4_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO4_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO4_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO4_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO4_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO4_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO4_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO4_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO4_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO4_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO4_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO4_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO4_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}

// PADS_BANK0.GPIO5
func (o *PADS_BANK0_Type) SetGPIO5_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO5_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO5_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO5_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO5_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO5_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO5_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO5_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO5_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO5_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO5_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO5_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO5_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO5_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO5_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO5_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}

// PADS_BANK0.GPIO6
func (o *PADS_BANK0_Type) SetGPIO6_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO6_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO6_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO6_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO6_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO6_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO6_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO6_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO6_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO6_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO6_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO6_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO6_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO6_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO6_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO6_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}

// PADS_BANK0.GPIO7
func (o *PADS_BANK0_Type) SetGPIO7_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO7_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO7_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO7_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO7_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO7_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO7_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO7_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO7_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO7_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO7_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO7_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO7_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO7_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO7_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO7_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}

// PADS_BANK0.GPIO8
func (o *PADS_BANK0_Type) SetGPIO8_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO8_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO8_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO8_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO8_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO8_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO8_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO8_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO8_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO8_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO8_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO8_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO8_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO8_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO8_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO8_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}

// PADS_BANK0.GPIO9
func (o *PADS_BANK0_Type) SetGPIO9_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO9_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO9_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO9_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO9_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO9_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO9_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO9_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO9_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO9_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO9_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO9_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO9_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO9_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO9_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO9_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}

// PADS_BANK0.GPIO10
func (o *PADS_BANK0_Type) SetGPIO10_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO10_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO10_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO10_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO10_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO10_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO10_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO10_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO10_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO10_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO10_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO10_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO10_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO10_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO10_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO10_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}

// PADS_BANK0.GPIO11
func (o *PADS_BANK0_Type) SetGPIO11_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO11_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO11_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO11_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO11_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO11_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO11_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO11_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO11_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO11_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO11_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO11_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO11_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO11_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO11_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO11_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}

// PADS_BANK0.GPIO12
func (o *PADS_BANK0_Type) SetGPIO12_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO12_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO12_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO12_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO12_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO12_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO12_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO12_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO12_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO12_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO12_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO12_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO12_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO12_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO12_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO12_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}

// PADS_BANK0.GPIO13
func (o *PADS_BANK0_Type) SetGPIO13_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO13_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO13_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO13_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO13_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO13_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO13_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO13_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO13_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO13_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO13_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO13_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO13_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO13_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO13_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO13_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}

// PADS_BANK0.GPIO14
func (o *PADS_BANK0_Type) SetGPIO14_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO14_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO14_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO14_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO14_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO14_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO14_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO14_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO14_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO14_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO14_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO14_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO14_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO14_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO14_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO14_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}

// PADS_BANK0.GPIO15
func (o *PADS_BANK0_Type) SetGPIO15_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO15_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO15_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO15_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO15_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO15_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO15_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO15_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO15_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO15_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO15_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO15_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO15_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO15_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO15_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO15_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}

// PADS_BANK0.GPIO16
func (o *PADS_BANK0_Type) SetGPIO16_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO16_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO16_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO16_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO16_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO16_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO16_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO16_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO16_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO16_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO16_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO16_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO16_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO16_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO16_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO16_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}

// PADS_BANK0.GPIO17
func (o *PADS_BANK0_Type) SetGPIO17_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO17_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO17_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO17_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO17_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO17_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO17_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO17_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO17_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO17_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO17_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO17_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO17_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO17_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO17_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO17_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}

// PADS_BANK0.GPIO18
func (o *PADS_BANK0_Type) SetGPIO18_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO18_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO18_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO18_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO18_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO18_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO18_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO18_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO18_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO18_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO18_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO18_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO18_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO18_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO18_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO18_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}

// PADS_BANK0.GPIO19
func (o *PADS_BANK0_Type) SetGPIO19_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO19_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO19_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO19_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO19_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO19_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO19_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO19_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO19_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO19_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO19_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO19_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO19_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO19_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO19_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO19_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}

// PADS_BANK0.GPIO20
func (o *PADS_BANK0_Type) SetGPIO20_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO20_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO20_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO20_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO20_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO20_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO20_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO20_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO20_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO20_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO20_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO20_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO20_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO20_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO20_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO20_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}

// PADS_BANK0.GPIO21
func (o *PADS_BANK0_Type) SetGPIO21_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO21_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO21_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO21_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO21_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO21_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO21_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO21_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO21_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO21_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO21_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO21_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO21_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO21_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO21_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO21_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO21.Reg) & 0x1
}

// PADS_BANK0.GPIO22
func (o *PADS_BANK0_Type) SetGPIO22_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO22_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO22_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO22_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO22_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO22_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO22_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO22_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO22_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO22_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO22_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO22_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO22_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO22_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO22_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO22_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO22.Reg) & 0x1
}

// PADS_BANK0.GPIO23
func (o *PADS_BANK0_Type) SetGPIO23_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO23_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO23_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO23_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO23_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO23_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO23_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO23_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO23_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO23_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO23_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO23_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO23_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO23_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO23_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO23_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO23.Reg) & 0x1
}

// PADS_BANK0.GPIO24
func (o *PADS_BANK0_Type) SetGPIO24_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO24_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO24_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO24_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO24_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO24_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO24_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO24_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO24_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO24_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO24_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO24_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO24_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO24_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO24_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO24_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO24.Reg) & 0x1
}

// PADS_BANK0.GPIO25
func (o *PADS_BANK0_Type) SetGPIO25_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO25_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO25_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO25_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO25_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO25_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO25_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO25_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO25_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO25_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO25_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO25_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO25_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO25_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO25_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO25_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO25.Reg) & 0x1
}

// PADS_BANK0.GPIO26
func (o *PADS_BANK0_Type) SetGPIO26_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO26_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO26_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO26_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO26_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO26_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO26_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO26_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO26_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO26_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO26_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO26_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO26_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO26_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO26_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO26_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO26.Reg) & 0x1
}

// PADS_BANK0.GPIO27
func (o *PADS_BANK0_Type) SetGPIO27_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO27_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO27_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO27_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO27_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO27_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO27_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO27_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO27_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO27_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO27_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO27_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO27_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO27_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO27_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO27_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO27.Reg) & 0x1
}

// PADS_BANK0.GPIO28
func (o *PADS_BANK0_Type) SetGPIO28_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO28_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO28_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO28_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO28_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO28_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO28_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO28_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO28_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO28_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO28_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO28_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO28_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO28_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO28_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO28_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO28.Reg) & 0x1
}

// PADS_BANK0.GPIO29
func (o *PADS_BANK0_Type) SetGPIO29_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO29_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO29_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO29_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO29_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO29_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO29_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO29_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO29_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO29_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO29_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO29_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO29_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO29_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO29_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO29_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO29.Reg) & 0x1
}

// PADS_BANK0.GPIO30
func (o *PADS_BANK0_Type) SetGPIO30_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO30_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO30_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO30_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO30_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO30_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO30_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO30_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO30_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO30_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO30_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO30_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO30_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO30_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO30_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO30_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO30.Reg) & 0x1
}

// PADS_BANK0.GPIO31
func (o *PADS_BANK0_Type) SetGPIO31_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO31_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO31_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO31_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO31_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO31_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO31_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO31_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO31_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO31_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO31_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO31_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO31_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO31_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO31_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO31_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO31.Reg) & 0x1
}

// PADS_BANK0.GPIO32
func (o *PADS_BANK0_Type) SetGPIO32_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO32_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO32_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO32_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO32_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO32_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO32_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO32_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO32_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO32_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO32_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO32_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO32_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO32_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO32_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO32_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO32.Reg) & 0x1
}

// PADS_BANK0.GPIO33
func (o *PADS_BANK0_Type) SetGPIO33_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO33_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO33_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO33_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO33_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO33_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO33_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO33_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO33_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO33_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO33_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO33_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO33_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO33_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO33_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO33_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO33.Reg) & 0x1
}

// PADS_BANK0.GPIO34
func (o *PADS_BANK0_Type) SetGPIO34_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO34_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO34_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO34_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO34_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO34_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO34_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO34_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO34_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO34_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO34_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO34_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO34_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO34_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO34_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO34_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO34.Reg) & 0x1
}

// PADS_BANK0.GPIO35
func (o *PADS_BANK0_Type) SetGPIO35_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO35_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO35_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO35_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO35_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO35_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO35_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO35_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO35_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO35_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO35_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO35_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO35_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO35_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO35_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO35_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO35.Reg) & 0x1
}

// PADS_BANK0.GPIO36
func (o *PADS_BANK0_Type) SetGPIO36_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO36_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO36_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO36_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO36_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO36_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO36_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO36_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO36_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO36_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO36_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO36_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO36_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO36_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO36_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO36_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO36.Reg) & 0x1
}

// PADS_BANK0.GPIO37
func (o *PADS_BANK0_Type) SetGPIO37_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO37_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO37_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO37_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO37_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO37_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO37_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO37_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO37_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO37_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO37_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO37_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO37_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO37_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO37_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO37_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO37.Reg) & 0x1
}

// PADS_BANK0.GPIO38
func (o *PADS_BANK0_Type) SetGPIO38_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO38_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO38_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO38_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO38_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO38_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO38_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO38_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO38_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO38_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO38_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO38_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO38_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO38_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO38_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO38_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO38.Reg) & 0x1
}

// PADS_BANK0.GPIO39
func (o *PADS_BANK0_Type) SetGPIO39_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO39_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO39_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO39_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO39_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO39_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO39_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO39_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO39_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO39_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO39_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO39_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO39_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO39_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO39_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO39_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO39.Reg) & 0x1
}

// PADS_BANK0.GPIO40
func (o *PADS_BANK0_Type) SetGPIO40_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO40_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO40_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO40_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO40_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO40_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO40_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO40_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO40_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO40_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO40_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO40_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO40_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO40_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO40.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO40_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO40.Reg, volatile.LoadUint32(&o.GPIO40.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO40_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO40.Reg) & 0x1
}

// PADS_BANK0.GPIO41
func (o *PADS_BANK0_Type) SetGPIO41_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO41_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO41_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO41_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO41_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO41_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO41_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO41_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO41_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO41_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO41_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO41_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO41_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO41_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO41.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO41_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO41.Reg, volatile.LoadUint32(&o.GPIO41.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO41_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO41.Reg) & 0x1
}

// PADS_BANK0.GPIO42
func (o *PADS_BANK0_Type) SetGPIO42_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO42_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO42_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO42_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO42_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO42_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO42_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO42_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO42_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO42_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO42_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO42_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO42_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO42_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO42.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO42_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO42.Reg, volatile.LoadUint32(&o.GPIO42.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO42_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO42.Reg) & 0x1
}

// PADS_BANK0.GPIO43
func (o *PADS_BANK0_Type) SetGPIO43_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO43_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO43_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO43_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO43_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO43_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO43_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO43_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO43_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO43_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO43_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO43_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO43_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO43_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO43.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO43_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO43.Reg, volatile.LoadUint32(&o.GPIO43.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO43_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO43.Reg) & 0x1
}

// PADS_BANK0.GPIO44
func (o *PADS_BANK0_Type) SetGPIO44_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO44_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO44_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO44_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO44_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO44_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO44_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO44_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO44_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO44_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO44_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO44_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO44_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO44_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO44.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO44_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO44.Reg, volatile.LoadUint32(&o.GPIO44.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO44_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO44.Reg) & 0x1
}

// PADS_BANK0.GPIO45
func (o *PADS_BANK0_Type) SetGPIO45_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO45_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO45_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO45_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO45_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO45_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO45_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO45_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO45_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO45_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO45_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO45_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO45_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO45_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO45.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO45_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO45.Reg, volatile.LoadUint32(&o.GPIO45.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO45_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO45.Reg) & 0x1
}

// PADS_BANK0.GPIO46
func (o *PADS_BANK0_Type) SetGPIO46_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO46_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO46_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO46_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO46_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO46_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO46_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO46_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO46_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO46_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO46_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO46_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO46_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO46_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO46.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO46_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO46.Reg, volatile.LoadUint32(&o.GPIO46.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO46_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO46.Reg) & 0x1
}

// PADS_BANK0.GPIO47
func (o *PADS_BANK0_Type) SetGPIO47_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetGPIO47_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetGPIO47_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO47_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO47_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO47_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO47_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO47_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO47_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO47_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO47_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO47_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO47_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO47_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO47.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO47_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO47.Reg, volatile.LoadUint32(&o.GPIO47.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO47_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO47.Reg) & 0x1
}

// PADS_BANK0.SWCLK
func (o *PADS_BANK0_Type) SetSWCLK_ISO(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetSWCLK_ISO() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetSWCLK_OD(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetSWCLK_OD() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetSWCLK_IE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetSWCLK_IE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetSWCLK_DRIVE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetSWCLK_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetSWCLK_PUE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetSWCLK_PUE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetSWCLK_PDE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetSWCLK_PDE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetSWCLK_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetSWCLK_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetSWCLK_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetSWCLK_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.SWCLK.Reg) & 0x1
}

// PADS_BANK0.SWD
func (o *PADS_BANK0_Type) SetSWD_ISO(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x100)|value<<8)
}
func (o *PADS_BANK0_Type) GetSWD_ISO() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x100) >> 8
}
func (o *PADS_BANK0_Type) SetSWD_OD(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetSWD_OD() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetSWD_IE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetSWD_IE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetSWD_DRIVE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetSWD_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetSWD_PUE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetSWD_PUE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetSWD_PDE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetSWD_PDE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetSWD_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetSWD_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetSWD_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetSWD_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.SWD.Reg) & 0x1
}

type PADS_QSPI_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO_QSPI_SCLK volatile.Register32 // 0x4
	GPIO_QSPI_SD0  volatile.Register32 // 0x8
	GPIO_QSPI_SD1  volatile.Register32 // 0xC
	GPIO_QSPI_SD2  volatile.Register32 // 0x10
	GPIO_QSPI_SD3  volatile.Register32 // 0x14
	GPIO_QSPI_SS   volatile.Register32 // 0x18
}

// PADS_QSPI.VOLTAGE_SELECT: Voltage select. Per bank control
func (o *PADS_QSPI_Type) SetVOLTAGE_SELECT(value uint32) {
	volatile.StoreUint32(&o.VOLTAGE_SELECT.Reg, volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetVOLTAGE_SELECT() uint32 {
	return volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SCLK
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD0
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD1
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD2
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD3
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SS
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_ISO(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x100)|value<<8)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_ISO() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x100) >> 8
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x1
}

type IO_QSPI_Type struct {
	USBPHY_DP_STATUS                  volatile.Register32 // 0x0
	USBPHY_DP_CTRL                    volatile.Register32 // 0x4
	USBPHY_DM_STATUS                  volatile.Register32 // 0x8
	USBPHY_DM_CTRL                    volatile.Register32 // 0xC
	GPIO_QSPI_SCLK_STATUS             volatile.Register32 // 0x10
	GPIO_QSPI_SCLK_CTRL               volatile.Register32 // 0x14
	GPIO_QSPI_SS_STATUS               volatile.Register32 // 0x18
	GPIO_QSPI_SS_CTRL                 volatile.Register32 // 0x1C
	GPIO_QSPI_SD0_STATUS              volatile.Register32 // 0x20
	GPIO_QSPI_SD0_CTRL                volatile.Register32 // 0x24
	GPIO_QSPI_SD1_STATUS              volatile.Register32 // 0x28
	GPIO_QSPI_SD1_CTRL                volatile.Register32 // 0x2C
	GPIO_QSPI_SD2_STATUS              volatile.Register32 // 0x30
	GPIO_QSPI_SD2_CTRL                volatile.Register32 // 0x34
	GPIO_QSPI_SD3_STATUS              volatile.Register32 // 0x38
	GPIO_QSPI_SD3_CTRL                volatile.Register32 // 0x3C
	_                                 [448]byte
	IRQSUMMARY_PROC0_SECURE           volatile.Register32 // 0x200
	IRQSUMMARY_PROC0_NONSECURE        volatile.Register32 // 0x204
	IRQSUMMARY_PROC1_SECURE           volatile.Register32 // 0x208
	IRQSUMMARY_PROC1_NONSECURE        volatile.Register32 // 0x20C
	IRQSUMMARY_DORMANT_WAKE_SECURE    volatile.Register32 // 0x210
	IRQSUMMARY_DORMANT_WAKE_NONSECURE volatile.Register32 // 0x214
	INTR                              volatile.Register32 // 0x218
	PROC0_INTE                        volatile.Register32 // 0x21C
	PROC0_INTF                        volatile.Register32 // 0x220
	PROC0_INTS                        volatile.Register32 // 0x224
	PROC1_INTE                        volatile.Register32 // 0x228
	PROC1_INTF                        volatile.Register32 // 0x22C
	PROC1_INTS                        volatile.Register32 // 0x230
	DORMANT_WAKE_INTE                 volatile.Register32 // 0x234
	DORMANT_WAKE_INTF                 volatile.Register32 // 0x238
	DORMANT_WAKE_INTS                 volatile.Register32 // 0x23C
}

// IO_QSPI.USBPHY_DP_STATUS
func (o *IO_QSPI_Type) SetUSBPHY_DP_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.USBPHY_DP_CTRL
func (o *IO_QSPI_Type) SetUSBPHY_DP_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetUSBPHY_DP_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DP_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetUSBPHY_DP_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.USBPHY_DP_CTRL.Reg) & 0x1f
}

// IO_QSPI.USBPHY_DM_STATUS
func (o *IO_QSPI_Type) SetUSBPHY_DM_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_STATUS.Reg, volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.USBPHY_DM_CTRL
func (o *IO_QSPI_Type) SetUSBPHY_DM_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetUSBPHY_DM_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.USBPHY_DM_CTRL.Reg, volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetUSBPHY_DM_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.USBPHY_DM_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SCLK_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SCLK_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SS_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SS_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD0_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SD0_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD1_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SD1_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD2_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SD2_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD3_STATUS
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x200) >> 9
}

// IO_QSPI.GPIO_QSPI_SD3_CTRL
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x1f
}

// IO_QSPI.IRQSUMMARY_PROC0_SECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_SECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_SECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE.Reg) & 0x1
}

// IO_QSPI.IRQSUMMARY_PROC0_NONSECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC0_NONSECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC0_NONSECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE.Reg) & 0x1
}

// IO_QSPI.IRQSUMMARY_PROC1_SECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_SECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_SECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE.Reg) & 0x1
}

// IO_QSPI.IRQSUMMARY_PROC1_NONSECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_PROC1_NONSECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_PROC1_NONSECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE.Reg) & 0x1
}

// IO_QSPI.IRQSUMMARY_DORMANT_WAKE_SECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE.Reg) & 0x1
}

// IO_QSPI.IRQSUMMARY_DORMANT_WAKE_NONSECURE
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SD0() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SS(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SS() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SCLK(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_GPIO_QSPI_SCLK() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DM(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DM() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DP(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE_USBPHY_DP() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE.Reg) & 0x1
}

// IO_QSPI.INTR: Raw Interrupts
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetINTR_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetINTR_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// IO_QSPI.PROC0_INTE: Interrupt Enable for proc0
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTE_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x1
}

// IO_QSPI.PROC0_INTF: Interrupt Force for proc0
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTF_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x1
}

// IO_QSPI.PROC0_INTS: Interrupt status after masking & forcing for proc0
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTS_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x1
}

// IO_QSPI.PROC1_INTE: Interrupt Enable for proc1
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTE_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x1
}

// IO_QSPI.PROC1_INTF: Interrupt Force for proc1
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTF_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x1
}

// IO_QSPI.PROC1_INTS: Interrupt status after masking & forcing for proc1
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTS_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTE: Interrupt Enable for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTF: Interrupt Force for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTS: Interrupt status after masking & forcing for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x80000000) >> 31
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x40000000) >> 30
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x20000000) >> 29
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x10000000) >> 28
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x8000000) >> 27
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x2000000) >> 25
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DM_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DM_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DM_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DM_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DM_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DM_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DM_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DM_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DP_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DP_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DP_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DP_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DP_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DP_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_USBPHY_DP_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_USBPHY_DP_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x1
}

type IO_BANK0_Type struct {
	GPIO0_STATUS                       volatile.Register32 // 0x0
	GPIO0_CTRL                         volatile.Register32 // 0x4
	GPIO1_STATUS                       volatile.Register32 // 0x8
	GPIO1_CTRL                         volatile.Register32 // 0xC
	GPIO2_STATUS                       volatile.Register32 // 0x10
	GPIO2_CTRL                         volatile.Register32 // 0x14
	GPIO3_STATUS                       volatile.Register32 // 0x18
	GPIO3_CTRL                         volatile.Register32 // 0x1C
	GPIO4_STATUS                       volatile.Register32 // 0x20
	GPIO4_CTRL                         volatile.Register32 // 0x24
	GPIO5_STATUS                       volatile.Register32 // 0x28
	GPIO5_CTRL                         volatile.Register32 // 0x2C
	GPIO6_STATUS                       volatile.Register32 // 0x30
	GPIO6_CTRL                         volatile.Register32 // 0x34
	GPIO7_STATUS                       volatile.Register32 // 0x38
	GPIO7_CTRL                         volatile.Register32 // 0x3C
	GPIO8_STATUS                       volatile.Register32 // 0x40
	GPIO8_CTRL                         volatile.Register32 // 0x44
	GPIO9_STATUS                       volatile.Register32 // 0x48
	GPIO9_CTRL                         volatile.Register32 // 0x4C
	GPIO10_STATUS                      volatile.Register32 // 0x50
	GPIO10_CTRL                        volatile.Register32 // 0x54
	GPIO11_STATUS                      volatile.Register32 // 0x58
	GPIO11_CTRL                        volatile.Register32 // 0x5C
	GPIO12_STATUS                      volatile.Register32 // 0x60
	GPIO12_CTRL                        volatile.Register32 // 0x64
	GPIO13_STATUS                      volatile.Register32 // 0x68
	GPIO13_CTRL                        volatile.Register32 // 0x6C
	GPIO14_STATUS                      volatile.Register32 // 0x70
	GPIO14_CTRL                        volatile.Register32 // 0x74
	GPIO15_STATUS                      volatile.Register32 // 0x78
	GPIO15_CTRL                        volatile.Register32 // 0x7C
	GPIO16_STATUS                      volatile.Register32 // 0x80
	GPIO16_CTRL                        volatile.Register32 // 0x84
	GPIO17_STATUS                      volatile.Register32 // 0x88
	GPIO17_CTRL                        volatile.Register32 // 0x8C
	GPIO18_STATUS                      volatile.Register32 // 0x90
	GPIO18_CTRL                        volatile.Register32 // 0x94
	GPIO19_STATUS                      volatile.Register32 // 0x98
	GPIO19_CTRL                        volatile.Register32 // 0x9C
	GPIO20_STATUS                      volatile.Register32 // 0xA0
	GPIO20_CTRL                        volatile.Register32 // 0xA4
	GPIO21_STATUS                      volatile.Register32 // 0xA8
	GPIO21_CTRL                        volatile.Register32 // 0xAC
	GPIO22_STATUS                      volatile.Register32 // 0xB0
	GPIO22_CTRL                        volatile.Register32 // 0xB4
	GPIO23_STATUS                      volatile.Register32 // 0xB8
	GPIO23_CTRL                        volatile.Register32 // 0xBC
	GPIO24_STATUS                      volatile.Register32 // 0xC0
	GPIO24_CTRL                        volatile.Register32 // 0xC4
	GPIO25_STATUS                      volatile.Register32 // 0xC8
	GPIO25_CTRL                        volatile.Register32 // 0xCC
	GPIO26_STATUS                      volatile.Register32 // 0xD0
	GPIO26_CTRL                        volatile.Register32 // 0xD4
	GPIO27_STATUS                      volatile.Register32 // 0xD8
	GPIO27_CTRL                        volatile.Register32 // 0xDC
	GPIO28_STATUS                      volatile.Register32 // 0xE0
	GPIO28_CTRL                        volatile.Register32 // 0xE4
	GPIO29_STATUS                      volatile.Register32 // 0xE8
	GPIO29_CTRL                        volatile.Register32 // 0xEC
	GPIO30_STATUS                      volatile.Register32 // 0xF0
	GPIO30_CTRL                        volatile.Register32 // 0xF4
	GPIO31_STATUS                      volatile.Register32 // 0xF8
	GPIO31_CTRL                        volatile.Register32 // 0xFC
	GPIO32_STATUS                      volatile.Register32 // 0x100
	GPIO32_CTRL                        volatile.Register32 // 0x104
	GPIO33_STATUS                      volatile.Register32 // 0x108
	GPIO33_CTRL                        volatile.Register32 // 0x10C
	GPIO34_STATUS                      volatile.Register32 // 0x110
	GPIO34_CTRL                        volatile.Register32 // 0x114
	GPIO35_STATUS                      volatile.Register32 // 0x118
	GPIO35_CTRL                        volatile.Register32 // 0x11C
	GPIO36_STATUS                      volatile.Register32 // 0x120
	GPIO36_CTRL                        volatile.Register32 // 0x124
	GPIO37_STATUS                      volatile.Register32 // 0x128
	GPIO37_CTRL                        volatile.Register32 // 0x12C
	GPIO38_STATUS                      volatile.Register32 // 0x130
	GPIO38_CTRL                        volatile.Register32 // 0x134
	GPIO39_STATUS                      volatile.Register32 // 0x138
	GPIO39_CTRL                        volatile.Register32 // 0x13C
	GPIO40_STATUS                      volatile.Register32 // 0x140
	GPIO40_CTRL                        volatile.Register32 // 0x144
	GPIO41_STATUS                      volatile.Register32 // 0x148
	GPIO41_CTRL                        volatile.Register32 // 0x14C
	GPIO42_STATUS                      volatile.Register32 // 0x150
	GPIO42_CTRL                        volatile.Register32 // 0x154
	GPIO43_STATUS                      volatile.Register32 // 0x158
	GPIO43_CTRL                        volatile.Register32 // 0x15C
	GPIO44_STATUS                      volatile.Register32 // 0x160
	GPIO44_CTRL                        volatile.Register32 // 0x164
	GPIO45_STATUS                      volatile.Register32 // 0x168
	GPIO45_CTRL                        volatile.Register32 // 0x16C
	GPIO46_STATUS                      volatile.Register32 // 0x170
	GPIO46_CTRL                        volatile.Register32 // 0x174
	GPIO47_STATUS                      volatile.Register32 // 0x178
	GPIO47_CTRL                        volatile.Register32 // 0x17C
	_                                  [128]byte
	IRQSUMMARY_PROC0_SECURE0           volatile.Register32 // 0x200
	IRQSUMMARY_PROC0_SECURE1           volatile.Register32 // 0x204
	IRQSUMMARY_PROC0_NONSECURE0        volatile.Register32 // 0x208
	IRQSUMMARY_PROC0_NONSECURE1        volatile.Register32 // 0x20C
	IRQSUMMARY_PROC1_SECURE0           volatile.Register32 // 0x210
	IRQSUMMARY_PROC1_SECURE1           volatile.Register32 // 0x214
	IRQSUMMARY_PROC1_NONSECURE0        volatile.Register32 // 0x218
	IRQSUMMARY_PROC1_NONSECURE1        volatile.Register32 // 0x21C
	IRQSUMMARY_DORMANT_WAKE_SECURE0    volatile.Register32 // 0x220
	IRQSUMMARY_DORMANT_WAKE_SECURE1    volatile.Register32 // 0x224
	IRQSUMMARY_DORMANT_WAKE_NONSECURE0 volatile.Register32 // 0x228
	IRQSUMMARY_DORMANT_WAKE_NONSECURE1 volatile.Register32 // 0x22C
	INTR0                              volatile.Register32 // 0x230
	INTR1                              volatile.Register32 // 0x234
	INTR2                              volatile.Register32 // 0x238
	INTR3                              volatile.Register32 // 0x23C
	INTR4                              volatile.Register32 // 0x240
	INTR5                              volatile.Register32 // 0x244
	PROC0_INTE0                        volatile.Register32 // 0x248
	PROC0_INTE1                        volatile.Register32 // 0x24C
	PROC0_INTE2                        volatile.Register32 // 0x250
	PROC0_INTE3                        volatile.Register32 // 0x254
	PROC0_INTE4                        volatile.Register32 // 0x258
	PROC0_INTE5                        volatile.Register32 // 0x25C
	PROC0_INTF0                        volatile.Register32 // 0x260
	PROC0_INTF1                        volatile.Register32 // 0x264
	PROC0_INTF2                        volatile.Register32 // 0x268
	PROC0_INTF3                        volatile.Register32 // 0x26C
	PROC0_INTF4                        volatile.Register32 // 0x270
	PROC0_INTF5                        volatile.Register32 // 0x274
	PROC0_INTS0                        volatile.Register32 // 0x278
	PROC0_INTS1                        volatile.Register32 // 0x27C
	PROC0_INTS2                        volatile.Register32 // 0x280
	PROC0_INTS3                        volatile.Register32 // 0x284
	PROC0_INTS4                        volatile.Register32 // 0x288
	PROC0_INTS5                        volatile.Register32 // 0x28C
	PROC1_INTE0                        volatile.Register32 // 0x290
	PROC1_INTE1                        volatile.Register32 // 0x294
	PROC1_INTE2                        volatile.Register32 // 0x298
	PROC1_INTE3                        volatile.Register32 // 0x29C
	PROC1_INTE4                        volatile.Register32 // 0x2A0
	PROC1_INTE5                        volatile.Register32 // 0x2A4
	PROC1_INTF0                        volatile.Register32 // 0x2A8
	PROC1_INTF1                        volatile.Register32 // 0x2AC
	PROC1_INTF2                        volatile.Register32 // 0x2B0
	PROC1_INTF3                        volatile.Register32 // 0x2B4
	PROC1_INTF4                        volatile.Register32 // 0x2B8
	PROC1_INTF5                        volatile.Register32 // 0x2BC
	PROC1_INTS0                        volatile.Register32 // 0x2C0
	PROC1_INTS1                        volatile.Register32 // 0x2C4
	PROC1_INTS2                        volatile.Register32 // 0x2C8
	PROC1_INTS3                        volatile.Register32 // 0x2CC
	PROC1_INTS4                        volatile.Register32 // 0x2D0
	PROC1_INTS5                        volatile.Register32 // 0x2D4
	DORMANT_WAKE_INTE0                 volatile.Register32 // 0x2D8
	DORMANT_WAKE_INTE1                 volatile.Register32 // 0x2DC
	DORMANT_WAKE_INTE2                 volatile.Register32 // 0x2E0
	DORMANT_WAKE_INTE3                 volatile.Register32 // 0x2E4
	DORMANT_WAKE_INTE4                 volatile.Register32 // 0x2E8
	DORMANT_WAKE_INTE5                 volatile.Register32 // 0x2EC
	DORMANT_WAKE_INTF0                 volatile.Register32 // 0x2F0
	DORMANT_WAKE_INTF1                 volatile.Register32 // 0x2F4
	DORMANT_WAKE_INTF2                 volatile.Register32 // 0x2F8
	DORMANT_WAKE_INTF3                 volatile.Register32 // 0x2FC
	DORMANT_WAKE_INTF4                 volatile.Register32 // 0x300
	DORMANT_WAKE_INTF5                 volatile.Register32 // 0x304
	DORMANT_WAKE_INTS0                 volatile.Register32 // 0x308
	DORMANT_WAKE_INTS1                 volatile.Register32 // 0x30C
	DORMANT_WAKE_INTS2                 volatile.Register32 // 0x310
	DORMANT_WAKE_INTS3                 volatile.Register32 // 0x314
	DORMANT_WAKE_INTS4                 volatile.Register32 // 0x318
	DORMANT_WAKE_INTS5                 volatile.Register32 // 0x31C
}

// IO_BANK0.GPIO0_STATUS
func (o *IO_BANK0_Type) SetGPIO0_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO0_CTRL
func (o *IO_BANK0_Type) SetGPIO0_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO1_STATUS
func (o *IO_BANK0_Type) SetGPIO1_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO1_CTRL
func (o *IO_BANK0_Type) SetGPIO1_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO2_STATUS
func (o *IO_BANK0_Type) SetGPIO2_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO2_CTRL
func (o *IO_BANK0_Type) SetGPIO2_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO3_STATUS
func (o *IO_BANK0_Type) SetGPIO3_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO3_CTRL
func (o *IO_BANK0_Type) SetGPIO3_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO4_STATUS
func (o *IO_BANK0_Type) SetGPIO4_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO4_CTRL
func (o *IO_BANK0_Type) SetGPIO4_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO5_STATUS
func (o *IO_BANK0_Type) SetGPIO5_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO5_CTRL
func (o *IO_BANK0_Type) SetGPIO5_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO6_STATUS
func (o *IO_BANK0_Type) SetGPIO6_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO6_CTRL
func (o *IO_BANK0_Type) SetGPIO6_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO7_STATUS
func (o *IO_BANK0_Type) SetGPIO7_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO7_CTRL
func (o *IO_BANK0_Type) SetGPIO7_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO8_STATUS
func (o *IO_BANK0_Type) SetGPIO8_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO8_CTRL
func (o *IO_BANK0_Type) SetGPIO8_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO9_STATUS
func (o *IO_BANK0_Type) SetGPIO9_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO9_CTRL
func (o *IO_BANK0_Type) SetGPIO9_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO10_STATUS
func (o *IO_BANK0_Type) SetGPIO10_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO10_CTRL
func (o *IO_BANK0_Type) SetGPIO10_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO11_STATUS
func (o *IO_BANK0_Type) SetGPIO11_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO11_CTRL
func (o *IO_BANK0_Type) SetGPIO11_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO12_STATUS
func (o *IO_BANK0_Type) SetGPIO12_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO12_CTRL
func (o *IO_BANK0_Type) SetGPIO12_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO13_STATUS
func (o *IO_BANK0_Type) SetGPIO13_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO13_CTRL
func (o *IO_BANK0_Type) SetGPIO13_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO14_STATUS
func (o *IO_BANK0_Type) SetGPIO14_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO14_CTRL
func (o *IO_BANK0_Type) SetGPIO14_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO15_STATUS
func (o *IO_BANK0_Type) SetGPIO15_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO15_CTRL
func (o *IO_BANK0_Type) SetGPIO15_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO16_STATUS
func (o *IO_BANK0_Type) SetGPIO16_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO16_CTRL
func (o *IO_BANK0_Type) SetGPIO16_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO17_STATUS
func (o *IO_BANK0_Type) SetGPIO17_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO17_CTRL
func (o *IO_BANK0_Type) SetGPIO17_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO18_STATUS
func (o *IO_BANK0_Type) SetGPIO18_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO18_CTRL
func (o *IO_BANK0_Type) SetGPIO18_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO19_STATUS
func (o *IO_BANK0_Type) SetGPIO19_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO19_CTRL
func (o *IO_BANK0_Type) SetGPIO19_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO20_STATUS
func (o *IO_BANK0_Type) SetGPIO20_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO20_CTRL
func (o *IO_BANK0_Type) SetGPIO20_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO21_STATUS
func (o *IO_BANK0_Type) SetGPIO21_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO21_CTRL
func (o *IO_BANK0_Type) SetGPIO21_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO22_STATUS
func (o *IO_BANK0_Type) SetGPIO22_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO22_CTRL
func (o *IO_BANK0_Type) SetGPIO22_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO23_STATUS
func (o *IO_BANK0_Type) SetGPIO23_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO23_CTRL
func (o *IO_BANK0_Type) SetGPIO23_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO24_STATUS
func (o *IO_BANK0_Type) SetGPIO24_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO24_CTRL
func (o *IO_BANK0_Type) SetGPIO24_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO25_STATUS
func (o *IO_BANK0_Type) SetGPIO25_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO25_CTRL
func (o *IO_BANK0_Type) SetGPIO25_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO26_STATUS
func (o *IO_BANK0_Type) SetGPIO26_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO26_CTRL
func (o *IO_BANK0_Type) SetGPIO26_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO27_STATUS
func (o *IO_BANK0_Type) SetGPIO27_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO27_CTRL
func (o *IO_BANK0_Type) SetGPIO27_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO28_STATUS
func (o *IO_BANK0_Type) SetGPIO28_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO28_CTRL
func (o *IO_BANK0_Type) SetGPIO28_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO29_STATUS
func (o *IO_BANK0_Type) SetGPIO29_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO29_CTRL
func (o *IO_BANK0_Type) SetGPIO29_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO30_STATUS
func (o *IO_BANK0_Type) SetGPIO30_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO30_STATUS.Reg, volatile.LoadUint32(&o.GPIO30_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO30_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO30_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO30_STATUS.Reg, volatile.LoadUint32(&o.GPIO30_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO30_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO30_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO30_STATUS.Reg, volatile.LoadUint32(&o.GPIO30_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO30_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO30_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO30_STATUS.Reg, volatile.LoadUint32(&o.GPIO30_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO30_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO30_CTRL
func (o *IO_BANK0_Type) SetGPIO30_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO30_CTRL.Reg, volatile.LoadUint32(&o.GPIO30_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO30_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO30_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO30_CTRL.Reg, volatile.LoadUint32(&o.GPIO30_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO30_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO30_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO30_CTRL.Reg, volatile.LoadUint32(&o.GPIO30_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO30_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO30_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO30_CTRL.Reg, volatile.LoadUint32(&o.GPIO30_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO30_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO30_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO30_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO30_CTRL.Reg, volatile.LoadUint32(&o.GPIO30_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO30_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO30_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO31_STATUS
func (o *IO_BANK0_Type) SetGPIO31_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO31_STATUS.Reg, volatile.LoadUint32(&o.GPIO31_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO31_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO31_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO31_STATUS.Reg, volatile.LoadUint32(&o.GPIO31_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO31_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO31_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO31_STATUS.Reg, volatile.LoadUint32(&o.GPIO31_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO31_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO31_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO31_STATUS.Reg, volatile.LoadUint32(&o.GPIO31_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO31_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO31_CTRL
func (o *IO_BANK0_Type) SetGPIO31_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO31_CTRL.Reg, volatile.LoadUint32(&o.GPIO31_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO31_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO31_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO31_CTRL.Reg, volatile.LoadUint32(&o.GPIO31_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO31_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO31_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO31_CTRL.Reg, volatile.LoadUint32(&o.GPIO31_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO31_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO31_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO31_CTRL.Reg, volatile.LoadUint32(&o.GPIO31_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO31_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO31_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO31_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO31_CTRL.Reg, volatile.LoadUint32(&o.GPIO31_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO31_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO31_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO32_STATUS
func (o *IO_BANK0_Type) SetGPIO32_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO32_STATUS.Reg, volatile.LoadUint32(&o.GPIO32_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO32_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO32_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO32_STATUS.Reg, volatile.LoadUint32(&o.GPIO32_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO32_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO32_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO32_STATUS.Reg, volatile.LoadUint32(&o.GPIO32_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO32_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO32_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO32_STATUS.Reg, volatile.LoadUint32(&o.GPIO32_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO32_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO32_CTRL
func (o *IO_BANK0_Type) SetGPIO32_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO32_CTRL.Reg, volatile.LoadUint32(&o.GPIO32_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO32_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO32_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO32_CTRL.Reg, volatile.LoadUint32(&o.GPIO32_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO32_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO32_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO32_CTRL.Reg, volatile.LoadUint32(&o.GPIO32_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO32_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO32_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO32_CTRL.Reg, volatile.LoadUint32(&o.GPIO32_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO32_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO32_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO32_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO32_CTRL.Reg, volatile.LoadUint32(&o.GPIO32_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO32_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO32_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO33_STATUS
func (o *IO_BANK0_Type) SetGPIO33_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO33_STATUS.Reg, volatile.LoadUint32(&o.GPIO33_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO33_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO33_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO33_STATUS.Reg, volatile.LoadUint32(&o.GPIO33_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO33_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO33_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO33_STATUS.Reg, volatile.LoadUint32(&o.GPIO33_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO33_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO33_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO33_STATUS.Reg, volatile.LoadUint32(&o.GPIO33_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO33_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO33_CTRL
func (o *IO_BANK0_Type) SetGPIO33_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO33_CTRL.Reg, volatile.LoadUint32(&o.GPIO33_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO33_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO33_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO33_CTRL.Reg, volatile.LoadUint32(&o.GPIO33_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO33_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO33_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO33_CTRL.Reg, volatile.LoadUint32(&o.GPIO33_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO33_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO33_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO33_CTRL.Reg, volatile.LoadUint32(&o.GPIO33_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO33_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO33_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO33_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO33_CTRL.Reg, volatile.LoadUint32(&o.GPIO33_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO33_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO33_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO34_STATUS
func (o *IO_BANK0_Type) SetGPIO34_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO34_STATUS.Reg, volatile.LoadUint32(&o.GPIO34_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO34_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO34_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO34_STATUS.Reg, volatile.LoadUint32(&o.GPIO34_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO34_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO34_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO34_STATUS.Reg, volatile.LoadUint32(&o.GPIO34_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO34_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO34_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO34_STATUS.Reg, volatile.LoadUint32(&o.GPIO34_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO34_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO34_CTRL
func (o *IO_BANK0_Type) SetGPIO34_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO34_CTRL.Reg, volatile.LoadUint32(&o.GPIO34_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO34_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO34_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO34_CTRL.Reg, volatile.LoadUint32(&o.GPIO34_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO34_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO34_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO34_CTRL.Reg, volatile.LoadUint32(&o.GPIO34_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO34_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO34_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO34_CTRL.Reg, volatile.LoadUint32(&o.GPIO34_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO34_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO34_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO34_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO34_CTRL.Reg, volatile.LoadUint32(&o.GPIO34_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO34_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO34_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO35_STATUS
func (o *IO_BANK0_Type) SetGPIO35_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO35_STATUS.Reg, volatile.LoadUint32(&o.GPIO35_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO35_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO35_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO35_STATUS.Reg, volatile.LoadUint32(&o.GPIO35_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO35_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO35_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO35_STATUS.Reg, volatile.LoadUint32(&o.GPIO35_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO35_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO35_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO35_STATUS.Reg, volatile.LoadUint32(&o.GPIO35_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO35_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO35_CTRL
func (o *IO_BANK0_Type) SetGPIO35_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO35_CTRL.Reg, volatile.LoadUint32(&o.GPIO35_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO35_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO35_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO35_CTRL.Reg, volatile.LoadUint32(&o.GPIO35_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO35_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO35_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO35_CTRL.Reg, volatile.LoadUint32(&o.GPIO35_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO35_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO35_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO35_CTRL.Reg, volatile.LoadUint32(&o.GPIO35_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO35_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO35_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO35_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO35_CTRL.Reg, volatile.LoadUint32(&o.GPIO35_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO35_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO35_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO36_STATUS
func (o *IO_BANK0_Type) SetGPIO36_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO36_STATUS.Reg, volatile.LoadUint32(&o.GPIO36_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO36_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO36_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO36_STATUS.Reg, volatile.LoadUint32(&o.GPIO36_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO36_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO36_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO36_STATUS.Reg, volatile.LoadUint32(&o.GPIO36_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO36_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO36_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO36_STATUS.Reg, volatile.LoadUint32(&o.GPIO36_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO36_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO36_CTRL
func (o *IO_BANK0_Type) SetGPIO36_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO36_CTRL.Reg, volatile.LoadUint32(&o.GPIO36_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO36_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO36_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO36_CTRL.Reg, volatile.LoadUint32(&o.GPIO36_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO36_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO36_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO36_CTRL.Reg, volatile.LoadUint32(&o.GPIO36_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO36_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO36_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO36_CTRL.Reg, volatile.LoadUint32(&o.GPIO36_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO36_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO36_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO36_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO36_CTRL.Reg, volatile.LoadUint32(&o.GPIO36_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO36_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO36_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO37_STATUS
func (o *IO_BANK0_Type) SetGPIO37_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO37_STATUS.Reg, volatile.LoadUint32(&o.GPIO37_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO37_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO37_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO37_STATUS.Reg, volatile.LoadUint32(&o.GPIO37_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO37_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO37_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO37_STATUS.Reg, volatile.LoadUint32(&o.GPIO37_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO37_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO37_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO37_STATUS.Reg, volatile.LoadUint32(&o.GPIO37_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO37_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO37_CTRL
func (o *IO_BANK0_Type) SetGPIO37_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO37_CTRL.Reg, volatile.LoadUint32(&o.GPIO37_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO37_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO37_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO37_CTRL.Reg, volatile.LoadUint32(&o.GPIO37_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO37_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO37_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO37_CTRL.Reg, volatile.LoadUint32(&o.GPIO37_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO37_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO37_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO37_CTRL.Reg, volatile.LoadUint32(&o.GPIO37_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO37_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO37_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO37_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO37_CTRL.Reg, volatile.LoadUint32(&o.GPIO37_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO37_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO37_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO38_STATUS
func (o *IO_BANK0_Type) SetGPIO38_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO38_STATUS.Reg, volatile.LoadUint32(&o.GPIO38_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO38_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO38_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO38_STATUS.Reg, volatile.LoadUint32(&o.GPIO38_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO38_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO38_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO38_STATUS.Reg, volatile.LoadUint32(&o.GPIO38_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO38_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO38_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO38_STATUS.Reg, volatile.LoadUint32(&o.GPIO38_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO38_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO38_CTRL
func (o *IO_BANK0_Type) SetGPIO38_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO38_CTRL.Reg, volatile.LoadUint32(&o.GPIO38_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO38_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO38_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO38_CTRL.Reg, volatile.LoadUint32(&o.GPIO38_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO38_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO38_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO38_CTRL.Reg, volatile.LoadUint32(&o.GPIO38_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO38_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO38_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO38_CTRL.Reg, volatile.LoadUint32(&o.GPIO38_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO38_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO38_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO38_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO38_CTRL.Reg, volatile.LoadUint32(&o.GPIO38_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO38_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO38_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO39_STATUS
func (o *IO_BANK0_Type) SetGPIO39_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO39_STATUS.Reg, volatile.LoadUint32(&o.GPIO39_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO39_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO39_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO39_STATUS.Reg, volatile.LoadUint32(&o.GPIO39_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO39_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO39_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO39_STATUS.Reg, volatile.LoadUint32(&o.GPIO39_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO39_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO39_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO39_STATUS.Reg, volatile.LoadUint32(&o.GPIO39_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO39_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO39_CTRL
func (o *IO_BANK0_Type) SetGPIO39_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO39_CTRL.Reg, volatile.LoadUint32(&o.GPIO39_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO39_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO39_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO39_CTRL.Reg, volatile.LoadUint32(&o.GPIO39_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO39_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO39_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO39_CTRL.Reg, volatile.LoadUint32(&o.GPIO39_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO39_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO39_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO39_CTRL.Reg, volatile.LoadUint32(&o.GPIO39_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO39_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO39_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO39_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO39_CTRL.Reg, volatile.LoadUint32(&o.GPIO39_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO39_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO39_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO40_STATUS
func (o *IO_BANK0_Type) SetGPIO40_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO40_STATUS.Reg, volatile.LoadUint32(&o.GPIO40_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO40_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO40_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO40_STATUS.Reg, volatile.LoadUint32(&o.GPIO40_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO40_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO40_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO40_STATUS.Reg, volatile.LoadUint32(&o.GPIO40_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO40_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO40_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO40_STATUS.Reg, volatile.LoadUint32(&o.GPIO40_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO40_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO40_CTRL
func (o *IO_BANK0_Type) SetGPIO40_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO40_CTRL.Reg, volatile.LoadUint32(&o.GPIO40_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO40_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO40_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO40_CTRL.Reg, volatile.LoadUint32(&o.GPIO40_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO40_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO40_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO40_CTRL.Reg, volatile.LoadUint32(&o.GPIO40_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO40_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO40_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO40_CTRL.Reg, volatile.LoadUint32(&o.GPIO40_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO40_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO40_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO40_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO40_CTRL.Reg, volatile.LoadUint32(&o.GPIO40_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO40_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO40_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO41_STATUS
func (o *IO_BANK0_Type) SetGPIO41_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO41_STATUS.Reg, volatile.LoadUint32(&o.GPIO41_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO41_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO41_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO41_STATUS.Reg, volatile.LoadUint32(&o.GPIO41_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO41_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO41_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO41_STATUS.Reg, volatile.LoadUint32(&o.GPIO41_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO41_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO41_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO41_STATUS.Reg, volatile.LoadUint32(&o.GPIO41_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO41_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO41_CTRL
func (o *IO_BANK0_Type) SetGPIO41_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO41_CTRL.Reg, volatile.LoadUint32(&o.GPIO41_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO41_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO41_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO41_CTRL.Reg, volatile.LoadUint32(&o.GPIO41_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO41_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO41_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO41_CTRL.Reg, volatile.LoadUint32(&o.GPIO41_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO41_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO41_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO41_CTRL.Reg, volatile.LoadUint32(&o.GPIO41_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO41_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO41_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO41_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO41_CTRL.Reg, volatile.LoadUint32(&o.GPIO41_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO41_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO41_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO42_STATUS
func (o *IO_BANK0_Type) SetGPIO42_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO42_STATUS.Reg, volatile.LoadUint32(&o.GPIO42_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO42_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO42_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO42_STATUS.Reg, volatile.LoadUint32(&o.GPIO42_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO42_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO42_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO42_STATUS.Reg, volatile.LoadUint32(&o.GPIO42_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO42_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO42_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO42_STATUS.Reg, volatile.LoadUint32(&o.GPIO42_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO42_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO42_CTRL
func (o *IO_BANK0_Type) SetGPIO42_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO42_CTRL.Reg, volatile.LoadUint32(&o.GPIO42_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO42_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO42_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO42_CTRL.Reg, volatile.LoadUint32(&o.GPIO42_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO42_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO42_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO42_CTRL.Reg, volatile.LoadUint32(&o.GPIO42_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO42_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO42_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO42_CTRL.Reg, volatile.LoadUint32(&o.GPIO42_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO42_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO42_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO42_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO42_CTRL.Reg, volatile.LoadUint32(&o.GPIO42_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO42_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO42_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO43_STATUS
func (o *IO_BANK0_Type) SetGPIO43_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO43_STATUS.Reg, volatile.LoadUint32(&o.GPIO43_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO43_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO43_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO43_STATUS.Reg, volatile.LoadUint32(&o.GPIO43_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO43_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO43_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO43_STATUS.Reg, volatile.LoadUint32(&o.GPIO43_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO43_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO43_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO43_STATUS.Reg, volatile.LoadUint32(&o.GPIO43_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO43_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO43_CTRL
func (o *IO_BANK0_Type) SetGPIO43_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO43_CTRL.Reg, volatile.LoadUint32(&o.GPIO43_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO43_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO43_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO43_CTRL.Reg, volatile.LoadUint32(&o.GPIO43_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO43_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO43_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO43_CTRL.Reg, volatile.LoadUint32(&o.GPIO43_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO43_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO43_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO43_CTRL.Reg, volatile.LoadUint32(&o.GPIO43_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO43_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO43_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO43_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO43_CTRL.Reg, volatile.LoadUint32(&o.GPIO43_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO43_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO43_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO44_STATUS
func (o *IO_BANK0_Type) SetGPIO44_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO44_STATUS.Reg, volatile.LoadUint32(&o.GPIO44_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO44_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO44_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO44_STATUS.Reg, volatile.LoadUint32(&o.GPIO44_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO44_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO44_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO44_STATUS.Reg, volatile.LoadUint32(&o.GPIO44_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO44_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO44_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO44_STATUS.Reg, volatile.LoadUint32(&o.GPIO44_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO44_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO44_CTRL
func (o *IO_BANK0_Type) SetGPIO44_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO44_CTRL.Reg, volatile.LoadUint32(&o.GPIO44_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO44_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO44_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO44_CTRL.Reg, volatile.LoadUint32(&o.GPIO44_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO44_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO44_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO44_CTRL.Reg, volatile.LoadUint32(&o.GPIO44_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO44_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO44_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO44_CTRL.Reg, volatile.LoadUint32(&o.GPIO44_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO44_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO44_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO44_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO44_CTRL.Reg, volatile.LoadUint32(&o.GPIO44_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO44_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO44_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO45_STATUS
func (o *IO_BANK0_Type) SetGPIO45_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO45_STATUS.Reg, volatile.LoadUint32(&o.GPIO45_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO45_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO45_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO45_STATUS.Reg, volatile.LoadUint32(&o.GPIO45_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO45_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO45_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO45_STATUS.Reg, volatile.LoadUint32(&o.GPIO45_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO45_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO45_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO45_STATUS.Reg, volatile.LoadUint32(&o.GPIO45_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO45_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO45_CTRL
func (o *IO_BANK0_Type) SetGPIO45_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO45_CTRL.Reg, volatile.LoadUint32(&o.GPIO45_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO45_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO45_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO45_CTRL.Reg, volatile.LoadUint32(&o.GPIO45_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO45_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO45_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO45_CTRL.Reg, volatile.LoadUint32(&o.GPIO45_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO45_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO45_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO45_CTRL.Reg, volatile.LoadUint32(&o.GPIO45_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO45_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO45_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO45_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO45_CTRL.Reg, volatile.LoadUint32(&o.GPIO45_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO45_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO45_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO46_STATUS
func (o *IO_BANK0_Type) SetGPIO46_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO46_STATUS.Reg, volatile.LoadUint32(&o.GPIO46_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO46_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO46_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO46_STATUS.Reg, volatile.LoadUint32(&o.GPIO46_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO46_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO46_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO46_STATUS.Reg, volatile.LoadUint32(&o.GPIO46_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO46_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO46_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO46_STATUS.Reg, volatile.LoadUint32(&o.GPIO46_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO46_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO46_CTRL
func (o *IO_BANK0_Type) SetGPIO46_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO46_CTRL.Reg, volatile.LoadUint32(&o.GPIO46_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO46_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO46_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO46_CTRL.Reg, volatile.LoadUint32(&o.GPIO46_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO46_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO46_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO46_CTRL.Reg, volatile.LoadUint32(&o.GPIO46_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO46_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO46_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO46_CTRL.Reg, volatile.LoadUint32(&o.GPIO46_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO46_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO46_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO46_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO46_CTRL.Reg, volatile.LoadUint32(&o.GPIO46_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO46_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO46_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO47_STATUS
func (o *IO_BANK0_Type) SetGPIO47_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO47_STATUS.Reg, volatile.LoadUint32(&o.GPIO47_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO47_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO47_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO47_STATUS.Reg, volatile.LoadUint32(&o.GPIO47_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO47_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO47_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO47_STATUS.Reg, volatile.LoadUint32(&o.GPIO47_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO47_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO47_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO47_STATUS.Reg, volatile.LoadUint32(&o.GPIO47_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO47_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_STATUS.Reg) & 0x200) >> 9
}

// IO_BANK0.GPIO47_CTRL
func (o *IO_BANK0_Type) SetGPIO47_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO47_CTRL.Reg, volatile.LoadUint32(&o.GPIO47_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO47_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO47_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO47_CTRL.Reg, volatile.LoadUint32(&o.GPIO47_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO47_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO47_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO47_CTRL.Reg, volatile.LoadUint32(&o.GPIO47_CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *IO_BANK0_Type) GetGPIO47_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_CTRL.Reg) & 0xc000) >> 14
}
func (o *IO_BANK0_Type) SetGPIO47_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO47_CTRL.Reg, volatile.LoadUint32(&o.GPIO47_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO47_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO47_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO47_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO47_CTRL.Reg, volatile.LoadUint32(&o.GPIO47_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO47_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO47_CTRL.Reg) & 0x1f
}

// IO_BANK0.IRQSUMMARY_PROC0_SECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC0_SECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_SECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_SECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_SECURE1.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC0_NONSECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC0_NONSECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC0_NONSECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC0_NONSECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC0_NONSECURE1.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC1_SECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC1_SECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_SECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_SECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_SECURE1.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC1_NONSECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_PROC1_NONSECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_PROC1_NONSECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_PROC1_NONSECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_PROC1_NONSECURE1.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_DORMANT_WAKE_SECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_DORMANT_WAKE_SECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_SECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_SECURE1.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_DORMANT_WAKE_NONSECURE0
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO31(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO31() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO30(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO30() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO29(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO29() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO28(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO28() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO27(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO27() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO26(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO26() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO25(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO25() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO24(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO24() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO23(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO23() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO22(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO22() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO21(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO21() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO20(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO20() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO19(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO19() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO18(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO18() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO17(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO17() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO16(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO16() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO15(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO15() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO14(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO14() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO13(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO13() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO12(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO12() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO11(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO11() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO10(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO10() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO9(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO9() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO8(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO8() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO7(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO6(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO5(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO4(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO3(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO2(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO1(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO0(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE0_GPIO0() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE0.Reg) & 0x1
}

// IO_BANK0.IRQSUMMARY_DORMANT_WAKE_NONSECURE1
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO47(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO47() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO46(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO46() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO45(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO45() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO44(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO44() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO43(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO43() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO42(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO42() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO41(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO41() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO40(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO40() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO39(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO39() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO38(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO38() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO37(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO37() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO36(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO36() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO35(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO35() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO34(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO34() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO33(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO33() uint32 {
	return (volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO32(value uint32) {
	volatile.StoreUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg, volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetIRQSUMMARY_DORMANT_WAKE_NONSECURE1_GPIO32() uint32 {
	return volatile.LoadUint32(&o.IRQSUMMARY_DORMANT_WAKE_NONSECURE1.Reg) & 0x1
}

// IO_BANK0.INTR0: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR0.Reg) & 0x1
}

// IO_BANK0.INTR1: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR1.Reg) & 0x1
}

// IO_BANK0.INTR2: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR2.Reg) & 0x1
}

// IO_BANK0.INTR3: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR3_GPIO31_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO31_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR3_GPIO31_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO31_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR3_GPIO31_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO31_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR3_GPIO31_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO31_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR3_GPIO30_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO30_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR3_GPIO30_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO30_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR3_GPIO30_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO30_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR3_GPIO30_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO30_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR3.Reg) & 0x1
}

// IO_BANK0.INTR4: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR4_GPIO39_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO39_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR4_GPIO39_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO39_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR4_GPIO39_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO39_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR4_GPIO39_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO39_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR4_GPIO38_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO38_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR4_GPIO38_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO38_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR4_GPIO38_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO38_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR4_GPIO38_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO38_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR4_GPIO37_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO37_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR4_GPIO37_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO37_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR4_GPIO37_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO37_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR4_GPIO37_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO37_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR4_GPIO36_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO36_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR4_GPIO36_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO36_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR4_GPIO36_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO36_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR4_GPIO36_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO36_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR4_GPIO35_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO35_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR4_GPIO35_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO35_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR4_GPIO35_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO35_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR4_GPIO35_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO35_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR4_GPIO34_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO34_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR4_GPIO34_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO34_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR4_GPIO34_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO34_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR4_GPIO34_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO34_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR4_GPIO33_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO33_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR4_GPIO33_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO33_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR4_GPIO33_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO33_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR4_GPIO33_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO33_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR4_GPIO32_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO32_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR4_GPIO32_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO32_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR4_GPIO32_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO32_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR4.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR4_GPIO32_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR4.Reg, volatile.LoadUint32(&o.INTR4.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR4_GPIO32_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR4.Reg) & 0x1
}

// IO_BANK0.INTR5: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR5_GPIO47_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO47_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR5_GPIO47_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO47_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR5_GPIO47_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO47_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR5_GPIO47_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO47_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR5_GPIO46_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO46_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR5_GPIO46_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO46_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR5_GPIO46_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO46_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR5_GPIO46_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO46_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR5_GPIO45_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO45_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR5_GPIO45_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO45_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR5_GPIO45_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO45_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR5_GPIO45_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO45_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR5_GPIO44_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO44_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR5_GPIO44_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO44_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR5_GPIO44_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO44_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR5_GPIO44_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO44_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR5_GPIO43_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO43_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR5_GPIO43_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO43_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR5_GPIO43_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO43_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR5_GPIO43_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO43_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR5_GPIO42_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO42_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR5_GPIO42_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO42_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR5_GPIO42_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO42_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR5_GPIO42_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO42_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR5_GPIO41_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO41_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR5_GPIO41_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO41_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR5_GPIO41_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO41_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR5_GPIO41_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO41_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR5_GPIO40_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO40_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR5_GPIO40_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO40_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR5_GPIO40_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO40_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR5.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR5_GPIO40_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR5.Reg, volatile.LoadUint32(&o.INTR5.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR5_GPIO40_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR5.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE0: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE1: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE2: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE3: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO31_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO31_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO31_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO31_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO31_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO31_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO31_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO31_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO30_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO30_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO30_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO30_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO30_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO30_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO30_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO30_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE4: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO39_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO39_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO39_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO39_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO39_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO39_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO39_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO39_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO38_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO38_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO38_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO38_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO38_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO38_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO38_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO38_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO37_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO37_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO37_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO37_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO37_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO37_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO37_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO37_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO36_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO36_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO36_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO36_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO36_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO36_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO36_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO36_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO35_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO35_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO35_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO35_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO35_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO35_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO35_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO35_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO34_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO34_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO34_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO34_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO34_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO34_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO34_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO34_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO33_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO33_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO33_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO33_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO33_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO33_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO33_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO33_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO32_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO32_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO32_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO32_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO32_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO32_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE4_GPIO32_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE4.Reg, volatile.LoadUint32(&o.PROC0_INTE4.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE4_GPIO32_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE4.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE5: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO47_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO47_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO47_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO47_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO47_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO47_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO47_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO47_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO46_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO46_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO46_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO46_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO46_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO46_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO46_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO46_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO45_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO45_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO45_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO45_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO45_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO45_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO45_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO45_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO44_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO44_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO44_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO44_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO44_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO44_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO44_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO44_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO43_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO43_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO43_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO43_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO43_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO43_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO43_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO43_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO42_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO42_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO42_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO42_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO42_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO42_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO42_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO42_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO41_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO41_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO41_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO41_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO41_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO41_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO41_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO41_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO40_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO40_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO40_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO40_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO40_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO40_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE5_GPIO40_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE5.Reg, volatile.LoadUint32(&o.PROC0_INTE5.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE5_GPIO40_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE5.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF0: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF1: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF2: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF3: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO31_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO31_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO31_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO31_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO31_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO31_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO31_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO31_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO30_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO30_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO30_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO30_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO30_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO30_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO30_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO30_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF4: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO39_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO39_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO39_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO39_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO39_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO39_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO39_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO39_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO38_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO38_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO38_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO38_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO38_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO38_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO38_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO38_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO37_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO37_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO37_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO37_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO37_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO37_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO37_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO37_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO36_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO36_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO36_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO36_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO36_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO36_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO36_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO36_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO35_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO35_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO35_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO35_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO35_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO35_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO35_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO35_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO34_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO34_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO34_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO34_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO34_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO34_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO34_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO34_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO33_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO33_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO33_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO33_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO33_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO33_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO33_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO33_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO32_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO32_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO32_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO32_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO32_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO32_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF4_GPIO32_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF4.Reg, volatile.LoadUint32(&o.PROC0_INTF4.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF4_GPIO32_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF4.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF5: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO47_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO47_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO47_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO47_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO47_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO47_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO47_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO47_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO46_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO46_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO46_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO46_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO46_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO46_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO46_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO46_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO45_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO45_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO45_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO45_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO45_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO45_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO45_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO45_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO44_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO44_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO44_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO44_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO44_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO44_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO44_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO44_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO43_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO43_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO43_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO43_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO43_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO43_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO43_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO43_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO42_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO42_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO42_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO42_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO42_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO42_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO42_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO42_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO41_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO41_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO41_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO41_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO41_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO41_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO41_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO41_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO40_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO40_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO40_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO40_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO40_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO40_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF5_GPIO40_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF5.Reg, volatile.LoadUint32(&o.PROC0_INTF5.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF5_GPIO40_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF5.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS0: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS1: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS2: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS3: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO31_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO31_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO31_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO31_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO31_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO31_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO31_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO31_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO30_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO30_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO30_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO30_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO30_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO30_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO30_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO30_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS4: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO39_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO39_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO39_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO39_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO39_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO39_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO39_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO39_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO38_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO38_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO38_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO38_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO38_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO38_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO38_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO38_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO37_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO37_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO37_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO37_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO37_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO37_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO37_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO37_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO36_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO36_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO36_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO36_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO36_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO36_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO36_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO36_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO35_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO35_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO35_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO35_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO35_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO35_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO35_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO35_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO34_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO34_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO34_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO34_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO34_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO34_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO34_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO34_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO33_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO33_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO33_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO33_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO33_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO33_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO33_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO33_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO32_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO32_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO32_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO32_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO32_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO32_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS4_GPIO32_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS4.Reg, volatile.LoadUint32(&o.PROC0_INTS4.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS4_GPIO32_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS4.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS5: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO47_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO47_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO47_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO47_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO47_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO47_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO47_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO47_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO46_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO46_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO46_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO46_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO46_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO46_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO46_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO46_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO45_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO45_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO45_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO45_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO45_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO45_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO45_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO45_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO44_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO44_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO44_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO44_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO44_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO44_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO44_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO44_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO43_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO43_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO43_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO43_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO43_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO43_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO43_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO43_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO42_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO42_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO42_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO42_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO42_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO42_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO42_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO42_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO41_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO41_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO41_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO41_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO41_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO41_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO41_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO41_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO40_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO40_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO40_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO40_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO40_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO40_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS5_GPIO40_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS5.Reg, volatile.LoadUint32(&o.PROC0_INTS5.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS5_GPIO40_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS5.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE0: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE1: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE2: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE3: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO31_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO31_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO31_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO31_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO31_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO31_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO31_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO31_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO30_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO30_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO30_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO30_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO30_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO30_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO30_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO30_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE4: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO39_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO39_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO39_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO39_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO39_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO39_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO39_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO39_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO38_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO38_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO38_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO38_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO38_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO38_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO38_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO38_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO37_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO37_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO37_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO37_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO37_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO37_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO37_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO37_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO36_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO36_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO36_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO36_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO36_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO36_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO36_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO36_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO35_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO35_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO35_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO35_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO35_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO35_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO35_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO35_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO34_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO34_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO34_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO34_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO34_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO34_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO34_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO34_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO33_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO33_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO33_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO33_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO33_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO33_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO33_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO33_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO32_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO32_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO32_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO32_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO32_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO32_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE4_GPIO32_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE4.Reg, volatile.LoadUint32(&o.PROC1_INTE4.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE4_GPIO32_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE4.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE5: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO47_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO47_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO47_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO47_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO47_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO47_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO47_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO47_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO46_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO46_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO46_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO46_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO46_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO46_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO46_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO46_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO45_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO45_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO45_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO45_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO45_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO45_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO45_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO45_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO44_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO44_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO44_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO44_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO44_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO44_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO44_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO44_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO43_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO43_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO43_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO43_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO43_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO43_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO43_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO43_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO42_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO42_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO42_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO42_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO42_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO42_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO42_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO42_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO41_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO41_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO41_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO41_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO41_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO41_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO41_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO41_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO40_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO40_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO40_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO40_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO40_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO40_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE5_GPIO40_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE5.Reg, volatile.LoadUint32(&o.PROC1_INTE5.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE5_GPIO40_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE5.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF0: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF1: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type