
local flags = {
  xsize = 25,
  ysize = 15,
  texture = 'flags25x15.png',
  specs = {
    ["ad"] = {   0,   0,  25,  15, name = "ANDORRA" },
    ["ae"] = {  25,   0,  50,  15, name = "UNITED ARAB EMIRATES" },
    ["af"] = {  50,   0,  75,  15, name = "AFGHANISTAN" },
    ["ag"] = {  75,   0, 100,  15, name = "ANTIGUA AND BARBUDA" },
    ["ai"] = { 100,   0, 125,  15, name = "ANGUILLA" },
    ["al"] = { 125,   0, 150,  15, name = "ALBANIA" },
    ["am"] = { 150,   0, 175,  15, name = "ARMENIA" },
    ["an"] = { 175,   0, 200,  15, name = "NETHERLANDS ANTILLES" },
    ["ao"] = { 200,   0, 225,  15, name = "ANGOLA" },
    ["aq"] = { 225,   0, 250,  15, name = "ANTARCTICA" },
    ["ar"] = { 250,   0, 275,  15, name = "ARGENTINA" },
    ["as"] = { 275,   0, 300,  15, name = "AMERICAN SAMOA" },
    ["at"] = { 300,   0, 325,  15, name = "AUSTRIA" },
    ["au"] = { 325,   0, 350,  15, name = "AUSTRALIA" },
    ["aw"] = { 350,   0, 375,  15, name = "ARUBA" },
    ["az"] = { 375,   0, 400,  15, name = "AZERBAIJAN" },
    ["ba"] = { 400,   0, 425,  15, name = "BOSNIA AND HERZEGOWINA" },
    ["bb"] = { 425,   0, 450,  15, name = "BARBADOS" },
    ["bd"] = { 450,   0, 475,  15, name = "BANGLADESH" },
    ["be"] = { 475,   0, 500,  15, name = "BELGIUM" },
    ["bf"] = {   0,  15,  25,  30, name = "BURKINA FASO" },
    ["bg"] = {  25,  15,  50,  30, name = "BULGARIA" },
    ["bh"] = {  50,  15,  75,  30, name = "BAHRAIN" },
    ["bi"] = {  75,  15, 100,  30, name = "BURUNDI" },
    ["bj"] = { 100,  15, 125,  30, name = "BENIN" },
    ["bm"] = { 125,  15, 150,  30, name = "BERMUDA" },
    ["bn"] = { 150,  15, 175,  30, name = "BRUNEI DARUSSALAM" },
    ["bo"] = { 175,  15, 200,  30, name = "BOLIVIA" },
    ["br"] = { 200,  15, 225,  30, name = "BRAZIL" },
    ["bs"] = { 225,  15, 250,  30, name = "BAHAMAS" },
    ["bt"] = { 250,  15, 275,  30, name = "BHUTAN" },
    ["bv"] = { 275,  15, 300,  30, name = "BOUVET ISLAND" },
    ["bw"] = { 300,  15, 325,  30, name = "BOTSWANA" },
    ["by"] = { 325,  15, 350,  30, name = "BELARUS" },
    ["bz"] = { 350,  15, 375,  30, name = "BELIZE" },
    ["ca"] = { 375,  15, 400,  30, name = "CANADA" },
    ["cc"] = { 400,  15, 425,  30, name = "COCOS (KEELING) ISLANDS" },
    ["cd"] = { 425,  15, 450,  30, name = "CONGO, Democratic Republic of (was Zaire)" },
    ["cf"] = { 450,  15, 475,  30, name = "CENTRAL AFRICAN REPUBLIC" },
    ["cg"] = { 475,  15, 500,  30, name = "CONGO, Peoples Republic of" },
    ["ch"] = {   0,  30,  25,  45, name = "SWITZERLAND" },
    ["ci"] = {  25,  30,  50,  45, name = "COTE D'IVOIRE" },
    ["ck"] = {  50,  30,  75,  45, name = "COOK ISLANDS" },
    ["cl"] = {  75,  30, 100,  45, name = "CHILE" },
    ["cm"] = { 100,  30, 125,  45, name = "CAMEROON" },
    ["cn"] = { 125,  30, 150,  45, name = "CHINA" },
    ["co"] = { 150,  30, 175,  45, name = "COLOMBIA" },
    ["cr"] = { 175,  30, 200,  45, name = "COSTA RICA" },
    ["cu"] = { 200,  30, 225,  45, name = "CUBA" },
    ["cv"] = { 225,  30, 250,  45, name = "CAPE VERDE" },
    ["cx"] = { 250,  30, 275,  45, name = "CHRISTMAS ISLAND" },
    ["cy"] = { 275,  30, 300,  45, name = "CYPRUS" },
    ["cz"] = { 300,  30, 325,  45, name = "CZECH REPUBLIC" },
    ["de"] = { 325,  30, 350,  45, name = "GERMANY" },
    ["dj"] = { 350,  30, 375,  45, name = "DJIBOUTI" },
    ["dk"] = { 375,  30, 400,  45, name = "DENMARK" },
    ["dm"] = { 400,  30, 425,  45, name = "DOMINICA" },
    ["do"] = { 425,  30, 450,  45, name = "DOMINICAN REPUBLIC" },
    ["dz"] = { 450,  30, 475,  45, name = "ALGERIA" },
    ["ec"] = { 475,  30, 500,  45, name = "ECUADOR" },
    ["ee"] = {   0,  45,  25,  60, name = "ESTONIA" },
    ["eg"] = {  25,  45,  50,  60, name = "EGYPT" },
    ["eh"] = {  50,  45,  75,  60, name = "WESTERN SAHARA" },
    ["er"] = {  75,  45, 100,  60, name = "ERITREA" },
    ["es"] = { 100,  45, 125,  60, name = "SPAIN" },
    ["et"] = { 125,  45, 150,  60, name = "ETHIOPIA" },
    ["fi"] = { 150,  45, 175,  60, name = "FINLAND" },
    ["fj"] = { 175,  45, 200,  60, name = "FIJI" },
    ["fk"] = { 200,  45, 225,  60, name = "FALKLAND ISLANDS (MALVINAS)" },
    ["fm"] = { 225,  45, 250,  60, name = "MICRONESIA, FEDERATED STATES OF" },
    ["fo"] = { 250,  45, 275,  60, name = "FAROE ISLANDS" },
    ["fr"] = { 275,  45, 300,  60, name = "FRANCE" },
    ["ga"] = { 300,  45, 325,  60, name = "GABON" },
    ["gb"] = { 325,  45, 350,  60, name = "UNITED KINGDOM" },
    ["gd"] = { 350,  45, 375,  60, name = "GRENADA" },
    ["ge"] = { 375,  45, 400,  60, name = "GEORGIA" },
    ["gf"] = { 400,  45, 425,  60, name = "FRENCH GUIANA" },
    ["gh"] = { 425,  45, 450,  60, name = "GHANA" },
    ["gi"] = { 450,  45, 475,  60, name = "GIBRALTAR" },
    ["gl"] = { 475,  45, 500,  60, name = "GREENLAND" },
    ["gm"] = {   0,  60,  25,  75, name = "GAMBIA" },
    ["gn"] = {  25,  60,  50,  75, name = "GUINEA" },
    ["gp"] = {  50,  60,  75,  75, name = "GUADELOUPE" },
    ["gq"] = {  75,  60, 100,  75, name = "EQUATORIAL GUINEA" },
    ["gr"] = { 100,  60, 125,  75, name = "GREECE" },
    ["gs"] = { 125,  60, 150,  75, name = "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS" },
    ["gt"] = { 150,  60, 175,  75, name = "GUATEMALA" },
    ["gu"] = { 175,  60, 200,  75, name = "GUAM" },
    ["gw"] = { 200,  60, 225,  75, name = "GUINEA-BISSAU" },
    ["gy"] = { 225,  60, 250,  75, name = "GUYANA" },
    ["hk"] = { 250,  60, 275,  75, name = "HONG KONG" },
    ["hm"] = { 275,  60, 300,  75, name = "HEARD AND MC DONALD ISLANDS" },
    ["hn"] = { 300,  60, 325,  75, name = "HONDURAS" },
    ["hr"] = { 325,  60, 350,  75, name = "CROATIA (local name: Hrvatska)" },
    ["ht"] = { 350,  60, 375,  75, name = "HAITI" },
    ["hu"] = { 375,  60, 400,  75, name = "HUNGARY" },
    ["id"] = { 400,  60, 425,  75, name = "INDONESIA" },
    ["ie"] = { 425,  60, 450,  75, name = "IRELAND" },
    ["il"] = { 450,  60, 475,  75, name = "ISRAEL" },
    ["in"] = { 475,  60, 500,  75, name = "INDIA" },
    ["io"] = {   0,  75,  25,  90, name = "BRITISH INDIAN OCEAN TERRITORY" },
    ["iq"] = {  25,  75,  50,  90, name = "IRAQ" },
    ["ir"] = {  50,  75,  75,  90, name = "IRAN (ISLAMIC REPUBLIC OF)" },
    ["is"] = {  75,  75, 100,  90, name = "ICELAND" },
    ["it"] = { 100,  75, 125,  90, name = "ITALY" },
    ["jm"] = { 125,  75, 150,  90, name = "JAMAICA" },
    ["jo"] = { 150,  75, 175,  90, name = "JORDAN" },
    ["jp"] = { 175,  75, 200,  90, name = "JAPAN" },
    ["ke"] = { 200,  75, 225,  90, name = "KENYA" },
    ["kg"] = { 225,  75, 250,  90, name = "KYRGYZSTAN" },
    ["kh"] = { 250,  75, 275,  90, name = "CAMBODIA" },
    ["ki"] = { 275,  75, 300,  90, name = "KIRIBATI" },
    ["km"] = { 300,  75, 325,  90, name = "COMOROS" },
    ["kn"] = { 325,  75, 350,  90, name = "SAINT KITTS AND NEVIS" },
    ["kp"] = { 350,  75, 375,  90, name = "KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF" },
    ["kr"] = { 375,  75, 400,  90, name = "KOREA, REPUBLIC OF" },
    ["kw"] = { 400,  75, 425,  90, name = "KUWAIT" },
    ["ky"] = { 425,  75, 450,  90, name = "CAYMAN ISLANDS" },
    ["kz"] = { 450,  75, 475,  90, name = "KAZAKHSTAN" },
    ["la"] = { 475,  75, 500,  90, name = "LAO PEOPLE'S DEMOCRATIC REPUBLIC" },
    ["lb"] = {   0,  90,  25, 105, name = "LEBANON" },
    ["lc"] = {  25,  90,  50, 105, name = "SAINT LUCIA" },
    ["li"] = {  50,  90,  75, 105, name = "LIECHTENSTEIN" },
    ["lk"] = {  75,  90, 100, 105, name = "SRI LANKA" },
    ["lr"] = { 100,  90, 125, 105, name = "LIBERIA" },
    ["ls"] = { 125,  90, 150, 105, name = "LESOTHO" },
    ["lt"] = { 150,  90, 175, 105, name = "LITHUANIA" },
    ["lu"] = { 175,  90, 200, 105, name = "LUXEMBOURG" },
    ["lv"] = { 200,  90, 225, 105, name = "LATVIA" },
    ["ly"] = { 225,  90, 250, 105, name = "LIBYAN ARAB JAMAHIRIYA" },
    ["ma"] = { 250,  90, 275, 105, name = "MOROCCO" },
    ["mc"] = { 275,  90, 300, 105, name = "MONACO" },
    ["md"] = { 300,  90, 325, 105, name = "MOLDOVA, REPUBLIC OF" },
    ["mg"] = { 325,  90, 350, 105, name = "MADAGASCAR" },
    ["mh"] = { 350,  90, 375, 105, name = "MARSHALL ISLANDS" },
    ["mk"] = { 375,  90, 400, 105, name = "MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF" },
    ["ml"] = { 400,  90, 425, 105, name = "MALI" },
    ["mm"] = { 425,  90, 450, 105, name = "MYANMAR" },
    ["mn"] = { 450,  90, 475, 105, name = "MONGOLIA" },
    ["mo"] = { 475,  90, 500, 105, name = "MACAU" },
    ["mp"] = {   0, 105,  25, 120, name = "NORTHERN MARIANA ISLANDS" },
    ["mq"] = {  25, 105,  50, 120, name = "MARTINIQUE" },
    ["mr"] = {  50, 105,  75, 120, name = "MAURITANIA" },
    ["ms"] = {  75, 105, 100, 120, name = "MONTSERRAT" },
    ["mt"] = { 100, 105, 125, 120, name = "MALTA" },
    ["mu"] = { 125, 105, 150, 120, name = "MAURITIUS" },
    ["mv"] = { 150, 105, 175, 120, name = "MALDIVES" },
    ["mw"] = { 175, 105, 200, 120, name = "MALAWI" },
    ["mx"] = { 200, 105, 225, 120, name = "MEXICO" },
    ["my"] = { 225, 105, 250, 120, name = "MALAYSIA" },
    ["mz"] = { 250, 105, 275, 120, name = "MOZAMBIQUE" },
    ["na"] = { 275, 105, 300, 120, name = "NAMIBIA" },
    ["nc"] = { 300, 105, 325, 120, name = "NEW CALEDONIA" },
    ["ne"] = { 325, 105, 350, 120, name = "NIGER" },
    ["nf"] = { 350, 105, 375, 120, name = "NORFOLK ISLAND" },
    ["ng"] = { 375, 105, 400, 120, name = "NIGERIA" },
    ["ni"] = { 400, 105, 425, 120, name = "NICARAGUA" },
    ["nl"] = { 425, 105, 450, 120, name = "NETHERLANDS" },
    ["no"] = { 450, 105, 475, 120, name = "NORWAY" },
    ["np"] = { 475, 105, 500, 120, name = "NEPAL" },
    ["nr"] = {   0, 120,  25, 135, name = "NAURU" },
    ["nu"] = {  25, 120,  50, 135, name = "NIUE" },
    ["nz"] = {  50, 120,  75, 135, name = "NEW ZEALAND" },
    ["om"] = {  75, 120, 100, 135, name = "OMAN" },
    ["pa"] = { 100, 120, 125, 135, name = "PANAMA" },
    ["pe"] = { 125, 120, 150, 135, name = "PERU" },
    ["pf"] = { 150, 120, 175, 135, name = "FRENCH POLYNESIA" },
    ["pg"] = { 175, 120, 200, 135, name = "PAPUA NEW GUINEA" },
    ["ph"] = { 200, 120, 225, 135, name = "PHILIPPINES" },
    ["pk"] = { 225, 120, 250, 135, name = "PAKISTAN" },
    ["pl"] = { 250, 120, 275, 135, name = "POLAND" },
    ["pm"] = { 275, 120, 300, 135, name = "ST. PIERRE AND MIQUELON" },
    ["pn"] = { 300, 120, 325, 135, name = "PITCAIRN" },
    ["pr"] = { 325, 120, 350, 135, name = "PUERTO RICO" },
    ["ps"] = { 350, 120, 375, 135, name = "PALESTINIAN TERRITORY, Occupied" },
    ["pt"] = { 375, 120, 400, 135, name = "PORTUGAL" },
    ["pw"] = { 400, 120, 425, 135, name = "PALAU" },
    ["py"] = { 425, 120, 450, 135, name = "PARAGUAY" },
    ["qa"] = { 450, 120, 475, 135, name = "QATAR" },
    ["re"] = { 475, 120, 500, 135, name = "REUNION" },
    ["ro"] = {   0, 135,  25, 150, name = "ROMANIA" },
    ["ru"] = {  25, 135,  50, 150, name = "RUSSIAN FEDERATION" },
    ["rw"] = {  50, 135,  75, 150, name = "RWANDA" },
    ["sa"] = {  75, 135, 100, 150, name = "SAUDI ARABIA" },
    ["sb"] = { 100, 135, 125, 150, name = "SOLOMON ISLANDS" },
    ["sc"] = { 125, 135, 150, 150, name = "SEYCHELLES" },
    ["sd"] = { 150, 135, 175, 150, name = "SUDAN" },
    ["se"] = { 175, 135, 200, 150, name = "SWEDEN" },
    ["sg"] = { 200, 135, 225, 150, name = "SINGAPORE" },
    ["sh"] = { 225, 135, 250, 150, name = "ST. HELENA" },
    ["si"] = { 250, 135, 275, 150, name = "SLOVENIA" },
    ["sj"] = { 275, 135, 300, 150, name = "SVALBARD AND JAN MAYEN ISLANDS" },
    ["sk"] = { 300, 135, 325, 150, name = "SLOVAKIA (Slovak Republic)" },
    ["sl"] = { 325, 135, 350, 150, name = "SIERRA LEONE" },
    ["sm"] = { 350, 135, 375, 150, name = "SAN MARINO" },
    ["sn"] = { 375, 135, 400, 150, name = "SENEGAL" },
    ["so"] = { 400, 135, 425, 150, name = "SOMALIA" },
    ["sr"] = { 425, 135, 450, 150, name = "SURINAME" },
    ["st"] = { 450, 135, 475, 150, name = "SAO TOME AND PRINCIPE" },
    ["sv"] = { 475, 135, 500, 150, name = "EL SALVADOR" },
    ["sy"] = {   0, 150,  25, 165, name = "SYRIAN ARAB REPUBLIC" },
    ["sz"] = {  25, 150,  50, 165, name = "SWAZILAND" },
    ["tc"] = {  50, 150,  75, 165, name = "TURKS AND CAICOS ISLANDS" },
    ["td"] = {  75, 150, 100, 165, name = "CHAD" },
    ["tf"] = { 100, 150, 125, 165, name = "FRENCH SOUTHERN TERRITORIES" },
    ["tg"] = { 125, 150, 150, 165, name = "TOGO" },
    ["th"] = { 150, 150, 175, 165, name = "THAILAND" },
    ["tj"] = { 175, 150, 200, 165, name = "TAJIKISTAN" },
    ["tk"] = { 200, 150, 225, 165, name = "TOKELAU" },
    ["tl"] = { 225, 150, 250, 165, name = "EAST TIMOR" },
    ["tm"] = { 250, 150, 275, 165, name = "TURKMENISTAN" },
    ["tn"] = { 275, 150, 300, 165, name = "TUNISIA" },
    ["to"] = { 300, 150, 325, 165, name = "TONGA" },
    ["tr"] = { 325, 150, 350, 165, name = "TURKEY" },
    ["tt"] = { 350, 150, 375, 165, name = "TRINIDAD AND TOBAGO" },
    ["tv"] = { 375, 150, 400, 165, name = "TUVALU" },
    ["tw"] = { 400, 150, 425, 165, name = "TAIWAN" },
    ["tz"] = { 425, 150, 450, 165, name = "TANZANIA, UNITED REPUBLIC OF" },
    ["ua"] = { 450, 150, 475, 165, name = "UKRAINE" },
    ["ug"] = { 475, 150, 500, 165, name = "UGANDA" },
    ["um"] = {   0, 165,  25, 180, name = "UNITED STATES MINOR OUTLYING ISLANDS" },
    ["us"] = {  25, 165,  50, 180, name = "UNITED STATES" },
    ["uy"] = {  50, 165,  75, 180, name = "URUGUAY" },
    ["uz"] = {  75, 165, 100, 180, name = "UZBEKISTAN" },
    ["va"] = { 100, 165, 125, 180, name = "VATICAN CITY STATE (HOLY SEE)" },
    ["vc"] = { 125, 165, 150, 180, name = "SAINT VINCENT AND THE GRENADINES" },
    ["ve"] = { 150, 165, 175, 180, name = "VENEZUELA" },
    ["vg"] = { 175, 165, 200, 180, name = "VIRGIN ISLANDS (BRITISH)" },
    ["vi"] = { 200, 165, 225, 180, name = "VIRGIN ISLANDS (U.S.)" },
    ["vn"] = { 225, 165, 250, 180, name = "VIET NAM" },
    ["vu"] = { 250, 165, 275, 180, name = "VANUATU" },
    ["wf"] = { 275, 165, 300, 180, name = "WALLIS AND FUTUNA ISLANDS" },
    ["ws"] = { 300, 165, 325, 180, name = "SAMOA" },
    ["xx"] = { 325, 165, 350, 180, name = "Unknown country" },
    ["ye"] = { 350, 165, 375, 180, name = "YEMEN" },
    ["yt"] = { 375, 165, 400, 180, name = "MAYOTTE" },
    ["yu"] = { 400, 165, 425, 180, name = "YUGOSLAVIA" },
    ["za"] = { 425, 165, 450, 180, name = "SOUTH AFRICA" },
    ["zm"] = { 450, 165, 475, 180, name = "ZAMBIA" },
    ["zw"] = { 475, 165, 500, 180, name = "ZIMBABWE" },
  }
}

for abbr, tbl in pairs(flags.specs) do
  tbl[1] = tbl[1] / 512
  tbl[2] = 1 - (tbl[2] / 256)
  tbl[3] = tbl[3] / 512
  tbl[4] = 1 - (tbl[4] / 256)
end

return flags
