/*
 * Decompiled with CFR 0.152.
 */
package hughai.controllers.level1;

import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.controllers.level2.ScoutControllerRaider;
import hughai.mapping.LosMap;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitController;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Reconnaissance {
    final float agingfactor = 0.0016666667f;
    PlayerObjects playerObjects;
    LogFile logfile;
    Config config;
    BuildTable buildTable;
    UnitController unitController;
    ScoutControllerRaider scoutcontrollerraider;
    Collection<UnitDef> managedUnitTypes = new HashSet<UnitDef>();
    Collection<Unit> managedunits = new HashSet<Unit>();

    public Reconnaissance(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.logfile = playerObjects.getLogFile();
        this.config = playerObjects.getConfig();
        this.buildTable = playerObjects.getBuildTable();
        this.unitController = playerObjects.getUnitController();
    }

    public void Activate() {
        this.playerObjects.getCSAI().registerGameListener(new GameListener());
        this.unitController.registerListener(new UnitListener());
        List<String> list = this.config.getReconnaissanceunitnames();
        this.managedUnitTypes.clear();
        for (String string : list) {
            UnitDef unitDef = this.buildTable.getUnitDefByName(string);
            this.managedUnitTypes.add(unitDef);
            this.logfile.WriteLine("Allowed unit type for " + this.getClass().getSimpleName() + " " + unitDef.getHumanName());
        }
        this.scoutcontrollerraider = new ScoutControllerRaider(this.playerObjects);
        this.scoutcontrollerraider.Activate();
    }

    void Reappraise(int n) {
        if (n % 150 == 0) {
            this.getLosCoverageStatistic(n);
        }
    }

    float getLosCoverageStatistic(int n) {
        this.logfile.WriteLine("getLosCoverageStatistic running");
        LosMap losMap = this.playerObjects.getMaps().getLosMap();
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < losMap.getLosMapHeight(); ++i) {
            for (int j = 0; j < losMap.getLosMapWidth(); ++j) {
                LosMap.LosMapPos losMapPos = new LosMap.LosMapPos(j, i);
                int n3 = losMap.getLastSeenFrameCount(losMapPos);
                float f2 = 0.0f;
                if (n3 != 0) {
                    int n4 = n - n3;
                    f2 = Math.max(0.0f, 1.0f - (float)n4 * 0.0016666667f);
                }
                f += f2;
                ++n2;
            }
        }
        float f3 = f * 100.0f / (float)n2;
        this.playerObjects.getLogFile().WriteLine("getLosCoverageStatistic:" + f3);
        return f3;
    }

    class UnitListener
    extends UnitController.UnitAdapter {
        UnitListener() {
        }

        @Override
        public void UnitAdded(Unit unit) {
            UnitDef unitDef = unit.getDef();
            if (Reconnaissance.this.managedUnitTypes.contains(unitDef)) {
                Reconnaissance.this.logfile.WriteLine("New reconnaissance unit: " + unit.getUnitId() + " " + unit.getDef().getHumanName());
                Reconnaissance.this.managedunits.add(unit);
                Reconnaissance.this.scoutcontrollerraider.AssignUnits(Arrays.asList(unit));
            }
        }

        @Override
        public void UnitRemoved(Unit unit) {
            UnitDef unitDef = unit.getDef();
            if (Reconnaissance.this.managedUnitTypes.contains(unitDef)) {
                Reconnaissance.this.managedunits.remove(unit);
                Reconnaissance.this.scoutcontrollerraider.RevokeUnits(Arrays.asList(unit));
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            Reconnaissance.this.Reappraise(n);
        }
    }
}

