/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import net.sf.sdedit.util.Utilities;

public class BeanComparator<T>
implements Comparator<T> {
    public static int COMPARABLE = 0;
    public static int TO_STRING = 1;
    public static int FALL_BACK_TO_STRING = 2;
    private Method[] readMethods;
    private boolean[] toStringFlags;

    public BeanComparator(Class<T> beanClass, int mode, String ... properties) {
        if (properties.length == 0) {
            throw new IllegalArgumentException("Cannot create a BeanComparator without properties");
        }
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Illegal BeanComparator mode: " + mode);
        }
        this.readMethods = new Method[properties.length];
        this.toStringFlags = new boolean[properties.length];
        HashMap<String, PropertyDescriptor> propMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor prop : Utilities.getProperties(beanClass)) {
            if (propMap.containsKey(prop.getName().toUpperCase())) {
                throw new IllegalArgumentException("Duplicate property name: " + beanClass.getName() + "#" + prop.getName());
            }
            propMap.put(prop.getName().toUpperCase(), prop);
        }
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor prop = (PropertyDescriptor)propMap.get(properties[i].toUpperCase());
            if (prop == null) {
                throw new IllegalArgumentException("Property not found: " + properties[i]);
            }
            Method readMethod = prop.getReadMethod();
            if (readMethod == null) {
                throw new IllegalArgumentException("Write-only property: " + properties[i]);
            }
            if (!prop.getPropertyType().isPrimitive() && !Comparable.class.isAssignableFrom(prop.getPropertyType())) {
                if (mode == COMPARABLE) {
                    throw new IllegalArgumentException("Property not comparable: " + properties[i]);
                }
                this.toStringFlags[i] = true;
            } else {
                this.toStringFlags[i] = mode == TO_STRING;
            }
            this.readMethods[i] = readMethod;
        }
    }

    @Override
    public int compare(T t1, T t2) {
        int result = 0;
        for (int i = 0; result == 0 && i < this.readMethods.length; ++i) {
            Object o1 = null;
            Object o2 = null;
            Object c1 = null;
            Object c2 = null;
            try {
                o1 = this.readMethods[i].invoke(t1, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                o2 = this.readMethods[i].invoke(t2, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            if (o1 != null && o2 == null) {
                result = 1;
                continue;
            }
            if (o1 == null && o2 != null) {
                result = -1;
                continue;
            }
            if (o1 == null || o2 == null) continue;
            if (this.toStringFlags[i]) {
                c1 = o1.toString();
                c2 = o2.toString();
            } else {
                c1 = (Comparable)Comparable.class.cast(o1);
                c2 = (Comparable)Comparable.class.cast(o2);
            }
            result = c1.compareTo(c2);
        }
        return result;
    }
}

