\name{SquaredDifferenceImageFilter}
\alias{SquaredDifferenceImageFilter}
\title{SquaredDifferenceImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Implements pixel-wise the computation of squared difference.
SquaredDifferenceImageFilter}
\details{
This filter is parameterized over the types of the two input images
and the type of the output image.
Numeric conversions (castings) are done by the C++ defaults.
The filter will walk over all the pixels in the two input images, and
for each one of them it will do the following:
cast the input 1 pixel value to double
cast the input 2 pixel value to double
compute the difference of the two pixel values
compute the square of the difference
cast the double value resulting from sqr() to the pixel type of the
output image
store the casted value into the output image.
 The filter expect all images to have the same dimension (e.g. all 2D,
or all 3D, or all ND)
See:
SquaredDifference for the procedural interface
itk::SquaredDifferenceImageFilter for the Doxygen on the original ITK class.
SquaredDifferenceImageFilter}
%C++ includes: sitkSquaredDifferenceImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{ SquaredDifferenceImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SquaredDifferenceImageFilter():}{
Destructor
}
}
}
