\name{SigmoidImageFilter}
\alias{SigmoidImageFilter}
\title{SigmoidImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the sigmoid function pixel-wise.
SigmoidImageFilter}
\details{
A linear transformation is applied first on the argument of the
sigmoid function. The resulting total transform is given by
 \deqn{ f(x) = (Max-Min) \cdot \frac{1}{\left(1+e^{- \frac{ x - \beta }{\alpha}}\right)} + Min }
Every output pixel is equal to f(x). Where x is the intensity of the
homologous input pixel, and alpha and beta are user-provided
constants.
See:
Sigmoid for the procedural interface
itk::SigmoidImageFilter for the Doxygen on the original ITK class.
SigmoidImageFilter}
%C++ includes: sitkSigmoidImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetAlpha() const:}{}
\item{double GetBeta() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutputMaximum() const:}{}
\item{double GetOutputMinimum() const:}{}
\item{Self SetAlpha(double Alpha):}{}
\item{Self SetBeta(double Beta):}{}
\item{Self SetOutputMaximum(double OutputMaximum):}{}
\item{Self SetOutputMinimum(double OutputMinimum):}{}
\item{ SigmoidImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SigmoidImageFilter():}{
Destructor
}
}
}
