\name{SLICImageFilter}
\alias{SLICImageFilter}
\title{SLICImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Simple Linear Iterative Clustering (SLIC) super-pixel segmentation.
SLICImageFilter}
\details{
The Simple Linear Iterative Clustering (SLIC) algorithm groups pixels
into a set of labeled regions or super-pixels. Super-pixels follow
natural image boundaries, are compact, and are nearly uniform regions
which can be used as a larger primitive for more efficient
computation. The SLIC algorithm can be viewed as a spatially
constrained iterative k-means method.
The original algorithm was designed to cluster on the joint domain of
the images index space and its CIELAB color space. This implementation
works with images of arbitrary dimension as well as scalar, single
channel, images and most multi-component image types including ITK's
arbitrary length VectorImage .
The distance between a pixel and a cluster is the sum of squares of
the difference between their joint range and domains ( index and value
). The computation is done in index space with scales provided by the
SpatialProximityWeight parameters.
The output is a label image with each label representing a superpixel
cluster. Every pixel in the output is labeled, and the starting label
id is zero.
This code was contributed in the Insight Journal paper: "Scalable
Simple Linear Iterative Clustering (SSLIC) Using a Generic and
Parallel Approach" by Lowekamp B. C., Chen D. T., Yaniv Z., Yoo T. S. https://www.insight-journal.org/browse/publication/989
See:
SLIC for the procedural interface
itk::SLICImageFilter for the Doxygen on the original ITK class.
SLICImageFilter}
%C++ includes: sitkSLICImageFilter.h
\section{Methods}{
\describe{
\item{Self EnforceConnectivityOff():}{}
\item{Self EnforceConnectivityOn():}{
Set the value of EnforceConnectivity to true or false respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetAverageResidual() const:}{
Get the current average cluster residual. After each iteration the
residual is computed as the distance between the current clusters and
the previous. This is averaged so that the value is independent of the
number of clusters.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool GetEnforceConnectivity() const:}{}
\item{bool GetInitializationPerturbation() const:}{}
\item{uint32_t GetMaximumNumberOfIterations() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetSpatialProximityWeight() const:}{}
\item{std::vector< unsigned int > GetSuperGridSize() const:}{}
\item{Self InitializationPerturbationOff():}{}
\item{Self InitializationPerturbationOn():}{
Set the value of InitializationPerturbation to true or false
respectfully.
}
\item{Self SetEnforceConnectivity(bool EnforceConnectivity):}{
Post processing step to enforce superpixel morphology. Enable an
additional computation which ensures all label pixels of the same
value are spatially connected. Disconnected labeled components are
assigned a new value if of sufficient size, or are relabeled to the
previously encountered value if small.
}
\item{Self SetInitializationPerturbation(bool InitializationPerturbation):}{
Enable perturbation of initial cluster center location. After grid
based initialization, this option enables moving the initial cluster
center location to the minimum gradient in a small neighborhood. If
the grid size is less than three this is automatically disabled.
}
\item{Self SetMaximumNumberOfIterations(uint32_t MaximumNumberOfIterations):}{
Number of iterations to run. Specify the number of iterations to run
when optimizing the clusters.
}
\item{Self SetSpatialProximityWeight(double SpatialProximityWeight):}{
The spatial weight for the distance function. Increasing this value
makes the superpixel shape more regular, but more varied in image
values. The range of the pixel values and image dimension can effect
the appropriate value.
}
\item{Self SetSuperGridSize(std::vector< unsigned int > SuperGridSize):}{}
\item{ SLICImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SLICImageFilter():}{
Destructor
}
}
}
