\name{InverseFFTImageFilter}
\alias{InverseFFTImageFilter}
\title{InverseFFTImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Base class for inverse Fast Fourier Transform .
InverseFFTImageFilter}
\details{
This is a base class for the "inverse" or "reverse" Discrete
Fourier Transform . This is an abstract base class: the actual implementation is
provided by the best child available on the system when the object is
created via the object factory system.
This class transforms a full complex image with Hermitian symmetry
into its real spatial domain representation. If the input does not
have Hermitian symmetry, the imaginary component is discarded.
See:
ForwardFFTImageFilter , InverseFFTImageFilter
InverseFFT for the procedural interface
itk::InverseFFTImageFilter for the Doxygen on the original ITK class.
InverseFFTImageFilter}
%C++ includes: sitkInverseFFTImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ InverseFFTImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~InverseFFTImageFilter():}{
Destructor
}
}
}
