/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.utilities.TreeTraversal;

public final class SubtreeMatch
extends Pattern {
    private final String _groupName;
    private final boolean _matchMultiple;
    private final INode _target;

    public SubtreeMatch(INode target) {
        this(target, null, false);
    }

    public SubtreeMatch(INode target, boolean matchMultiple) {
        this(target, null, matchMultiple);
    }

    public SubtreeMatch(INode target, String groupName) {
        this(target, groupName, false);
    }

    public SubtreeMatch(INode target, String groupName, boolean matchMultiple) {
        this._matchMultiple = matchMultiple;
        this._groupName = groupName;
        this._target = VerifyArgument.notNull(target, "target");
    }

    public final INode getTarget() {
        return this._target;
    }

    @Override
    public final boolean matches(INode other, final Match match) {
        if (this._matchMultiple) {
            boolean result = false;
            for (INode n : TreeTraversal.preOrder(other, INode.CHILD_ITERATOR)) {
                if (!this._target.matches(n, match)) continue;
                if (this._groupName != null) {
                    match.add(this._groupName, n);
                }
                result = true;
            }
            return result;
        }
        INode n = CollectionUtilities.firstOrDefault(TreeTraversal.preOrder(other, INode.CHILD_ITERATOR), new Predicate<INode>(){

            @Override
            public boolean test(INode n) {
                return SubtreeMatch.this._target.matches(n, match);
            }
        });
        if (n == null) {
            return false;
        }
        if (this._groupName != null) {
            match.add(this._groupName, n);
        }
        return true;
    }
}

