/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FontMeasurer {
    private static final String fontFamilyName = "Dialog";
    private static final boolean DEBUG = false;
    private static final FontMeasurer instance = new FontMeasurer();
    FontRenderContext fakeRenderContext;
    Graphics2D fakeGraphics;

    public int getWidthFor(String str, int pixelHeight) {
        Font font = this.getFontFor(pixelHeight);
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getWidth();
    }

    public int getHeightFor(String str, int pixelHeight) {
        Font font = this.getFontFor(pixelHeight);
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getHeight();
    }

    public int getWidthFor(String str, Font font) {
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getWidth();
    }

    public int getHeightFor(String str, Font font) {
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getHeight();
    }

    public Rectangle2D getBoundsFor(String str, Font font) {
        return font.getStringBounds(str, this.fakeRenderContext);
    }

    public Font getFontFor(int pixelHeight) {
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics2D g2 = image.createGraphics();
        return this.getFontFor(pixelHeight, this.fakeRenderContext);
    }

    public int getAscent(Font font) {
        this.fakeGraphics.setFont(font);
        FontMetrics metrics = this.fakeGraphics.getFontMetrics();
        return metrics.getAscent();
    }

    public int getZHeight(Font font) {
        int height = (int)font.createGlyphVector(this.fakeRenderContext, "Z").getOutline().getBounds().getHeight();
        return height;
    }

    public Font getFontFor(int maxWidth, String string) {
        int direction;
        float size = 12.0f;
        Font currentFont = new Font(fontFamilyName, 1, (int)size);
        int width = this.getWidthFor(string, currentFont);
        if (width > maxWidth) {
            currentFont = currentFont.deriveFont(size - 1.0f);
            size -= 1.0f;
            direction = -1;
        } else {
            currentFont = currentFont.deriveFont(size + 1.0f);
            size += 1.0f;
            direction = 1;
        }
        while (size > 0.0f) {
            currentFont = currentFont.deriveFont(size);
            width = this.getWidthFor(string, currentFont);
            if (direction == 1) {
                if (width > maxWidth) {
                    return currentFont.deriveFont(size -= 1.0f);
                }
                size += 1.0f;
                continue;
            }
            if (width < maxWidth) {
                return currentFont;
            }
            size -= 1.0f;
        }
        return null;
    }

    public Font getFontFor(int pixelHeight, FontRenderContext frc) {
        int direction;
        float size = 12.0f;
        Font currentFont = new Font(fontFamilyName, 1, (int)size);
        int ascent = this.getAscent(currentFont);
        if (ascent > pixelHeight) {
            currentFont = currentFont.deriveFont(size - 1.0f);
            size -= 1.0f;
            direction = -1;
        } else {
            currentFont = currentFont.deriveFont(size + 1.0f);
            size += 1.0f;
            direction = 1;
        }
        while (size > 0.0f) {
            currentFont = currentFont.deriveFont(size);
            ascent = this.getAscent(currentFont);
            if (direction == 1) {
                if (ascent > pixelHeight) {
                    return currentFont.deriveFont(size -= 0.5f);
                }
                size += 0.5f;
                continue;
            }
            if (ascent < pixelHeight) {
                return currentFont;
            }
            size -= 0.5f;
        }
        return null;
    }

    public static FontMeasurer instance() {
        return instance;
    }

    public FontMeasurer() {
        BufferedImage image = new BufferedImage(1, 1, 1);
        this.fakeGraphics = image.createGraphics();
        this.fakeRenderContext = this.fakeGraphics.getFontRenderContext();
    }

    public static void main(String[] args) {
        float size = 12.0f;
        Font currentFont = new Font("Sans", 1, (int)size);
        currentFont = currentFont.deriveFont(size -= 1.0f);
        System.out.println(currentFont.getSize());
        currentFont = currentFont.deriveFont(size -= 1.0f);
        System.out.println(currentFont.getSize());
        currentFont = currentFont.deriveFont(size -= 1.0f);
        System.out.println(currentFont.getSize());
        currentFont = currentFont.deriveFont(size -= 1.0f);
        System.out.println(currentFont.getSize());
        currentFont = currentFont.deriveFont(size -= 1.0f);
        System.out.println(currentFont.getSize());
    }
}

