/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.List;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterWhile;
import net.sourceforge.plantuml.tim.ExecutionContextWhile;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;

public class CodeIteratorWhile
extends AbstractCodeIterator {
    private final TContext context;
    private final TMemory memory;
    private final List<StringLocated> logs;

    public CodeIteratorWhile(CodeIterator source, TContext context, TMemory memory, List<StringLocated> logs) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.logs = logs;
    }

    @Override
    public StringLocated peek() throws EaterException {
        StringLocated result;
        int level = 0;
        while (true) {
            if ((result = this.source.peek()) == null) {
                return null;
            }
            ExecutionContextWhile currentWhile = this.memory.peekWhile();
            if (currentWhile != null && currentWhile.isSkipMe()) {
                if (result.getType() == TLineType.WHILE) {
                    ++level;
                } else if (result.getType() == TLineType.ENDWHILE && --level == -1) {
                    this.memory.pollWhile();
                    level = 0;
                }
                this.next();
                continue;
            }
            if (result.getType() == TLineType.WHILE) {
                this.logs.add(result);
                this.executeWhile(this.memory, result.getTrimmed());
                this.next();
                continue;
            }
            if (result.getType() != TLineType.ENDWHILE) break;
            this.logs.add(result);
            if (currentWhile == null) {
                throw new EaterException("No while related to this endwhile", result);
            }
            TValue value = currentWhile.conditionValue(result, this.context, this.memory);
            if (value.toBoolean()) {
                this.source.jumpToCodePosition(currentWhile.getStartWhile(), result);
            } else {
                this.memory.pollWhile();
            }
            this.next();
        }
        return result;
    }

    private void executeWhile(TMemory memory, StringLocated s) throws EaterException {
        EaterWhile condition = new EaterWhile(s);
        condition.analyze(this.context, memory);
        TokenStack whileExpression = condition.getWhileExpression();
        ExecutionContextWhile theWhile = ExecutionContextWhile.fromValue(whileExpression, this.source.getCodePosition());
        TValue value = theWhile.conditionValue(s, this.context, memory);
        if (!value.toBoolean()) {
            theWhile.skipMe();
        }
        memory.addWhile(theWhile);
    }
}

