/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class FactorySequenceNoteOverSeveralCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^end[%s]?(note|hnote|rnote)$"));

    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteOverSeveralCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf(1, "PARALLEL", "(&[%s]*)?"), new RegexLeaf(1, "VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "STYLE", "(note|hnote|rnote)"), StereotypePattern.optional("STEREO1"), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "P1", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "P2", "([%pLN_.@]+|[%g][^%g]+[%g])"), StereotypePattern.optional("STEREO2"), FactorySequenceNoteOverSeveralCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteOverSeveralCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf(1, "PARALLEL", "(&[%s]*)?"), new RegexLeaf(1, "VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "STYLE", "(note|hnote|rnote)"), StereotypePattern.optional("STEREO1"), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "P1", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(","), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "P2", "([%pLN_.@]+|[%g][^%g]+[%g])"), StereotypePattern.optional("STEREO2"), FactorySequenceNoteOverSeveralCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
                Display display = Display.getWithNewlines(diagram.getPragma(), arg.get("NOTE", 0));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(location, diagram, arg, diagram.manageVariable(display));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH, END){

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1).expandsNewline(false);
                lines = lines.removeEmptyColumns();
                Display display = lines.toDisplay();
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(lines.getLocation(), diagram, line0, diagram.manageVariable(display));
            }
        };
    }

    private CommandExecutionResult executeInternal(LineLocation location, SequenceDiagram diagram, RegexResult line0, Display display) throws NoSuchColorException {
        Participant p1 = diagram.getOrCreateParticipant(location, StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("P1", 0)));
        Participant p2 = diagram.getOrCreateParticipant(location, StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(line0.get("P2", 0)));
        if (display.size() > 0) {
            boolean tryMerge = line0.get("VMERGE", 0) != null;
            boolean parallel = line0.get("PARALLEL", 0) != null;
            Note note = new Note(p1, p2, display, diagram.getSkinParam().getCurrentStyleBuilder());
            Colors colors = FactorySequenceNoteOverSeveralCommand.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
            String stereotypeString = line0.getLazzy("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = Stereotype.build(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setColors(colors);
            note.setNoteStyle(NoteStyle.getNoteStyle(line0.get("STYLE", 0)));
            if (line0.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                Url urlLink = urlBuilder.getUrl(line0.get("URL", 0));
                note.setUrl(urlLink);
            }
            if (parallel) {
                note.goParallel();
            }
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

