/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.Replacement;
import java.util.ArrayList;
import java.util.List;

public class SnippetFormatter {
    private static final int INDENTATION_SIZE = 2;
    private final Formatter formatter = new Formatter();
    private static final CharMatcher NOT_WHITESPACE = CharMatcher.whitespace().negate();

    public String createIndentationString(int indentationLevel) {
        Preconditions.checkArgument((indentationLevel >= 0 ? 1 : 0) != 0, (String)"Indentation level cannot be less than zero. Given: %s", (int)indentationLevel);
        int spaces = indentationLevel * 2;
        StringBuilder buf = new StringBuilder(spaces);
        for (int i = 0; i < spaces; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static Range<Integer> offsetRange(Range<Integer> range, int offset) {
        range = range.canonical(DiscreteDomain.integers());
        return Range.closedOpen((Comparable)Integer.valueOf((Integer)range.lowerEndpoint() + offset), (Comparable)Integer.valueOf((Integer)range.upperEndpoint() + offset));
    }

    private static List<Range<Integer>> offsetRanges(List<Range<Integer>> ranges, int offset) {
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        for (Range<Integer> range : ranges) {
            result.add(SnippetFormatter.offsetRange(range, offset));
        }
        return result;
    }

    public ImmutableList<Replacement> format(SnippetKind kind, String source, List<Range<Integer>> ranges, int initialIndent, boolean includeComments) throws FormatterException {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        for (Range<Integer> range : ranges) {
            rangeSet.add(range);
        }
        if (includeComments) {
            if (kind != SnippetKind.COMPILATION_UNIT) {
                throw new IllegalArgumentException("comment formatting is only supported for compilation units");
            }
            return this.formatter.getFormatReplacements(source, ranges);
        }
        SnippetWrapper wrapper = this.snippetWrapper(kind, source, initialIndent);
        ranges = SnippetFormatter.offsetRanges(ranges, wrapper.offset);
        String replacement = this.formatter.formatSource(wrapper.contents.toString(), ranges);
        replacement = replacement.substring(wrapper.offset, replacement.length() - (wrapper.contents.length() - wrapper.offset - source.length()));
        return (ImmutableList)SnippetFormatter.toReplacements(source, replacement).stream().filter(arg_0 -> SnippetFormatter.lambda$format$0((RangeSet)rangeSet, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static List<Replacement> toReplacements(String source, String replacement) {
        if (!NOT_WHITESPACE.retainFrom((CharSequence)source).equals(NOT_WHITESPACE.retainFrom((CharSequence)replacement))) {
            throw new IllegalArgumentException("source = \"" + source + "\", replacement = \"" + replacement + "\"");
        }
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        int i = NOT_WHITESPACE.indexIn((CharSequence)source);
        int j = NOT_WHITESPACE.indexIn((CharSequence)replacement);
        if (i != 0 || j != 0) {
            replacements.add(Replacement.create(0, i, replacement.substring(0, j)));
        }
        while (i != -1 && j != -1) {
            int i2 = NOT_WHITESPACE.indexIn((CharSequence)source, i + 1);
            int j2 = NOT_WHITESPACE.indexIn((CharSequence)replacement, j + 1);
            if (i2 == -1 || j2 == -1) break;
            if (i2 - i != j2 - j || !source.substring(i + 1, i2).equals(replacement.substring(j + 1, j2))) {
                replacements.add(Replacement.create(i + 1, i2, replacement.substring(j + 1, j2)));
            }
            i = i2;
            j = j2;
        }
        return replacements;
    }

    private SnippetWrapper snippetWrapper(SnippetKind kind, String source, int initialIndent) {
        switch (kind.ordinal()) {
            case 0: {
                SnippetWrapper wrapper = new SnippetWrapper();
                for (int i = 1; i <= initialIndent; ++i) {
                    wrapper.append("class Dummy {\n").append(this.createIndentationString(i));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case 1: {
                SnippetWrapper wrapper = new SnippetWrapper();
                for (int i = 1; i <= initialIndent; ++i) {
                    wrapper.append("class Dummy {\n").append(this.createIndentationString(i));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case 2: {
                SnippetWrapper wrapper = new SnippetWrapper();
                wrapper.append("class Dummy {\n").append(this.createIndentationString(1));
                for (int i = 2; i <= initialIndent; ++i) {
                    wrapper.append("{\n").append(this.createIndentationString(i));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case 3: {
                SnippetWrapper wrapper = new SnippetWrapper();
                wrapper.append("class Dummy {\n").append(this.createIndentationString(1));
                for (int i = 2; i <= initialIndent; ++i) {
                    wrapper.append("{\n").append(this.createIndentationString(i));
                }
                wrapper.append("Object o = ");
                wrapper.appendSource(source);
                wrapper.append(";");
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
        }
        throw new IllegalArgumentException("Unknown snippet kind: " + String.valueOf((Object)kind));
    }

    private static /* synthetic */ boolean lambda$format$0(RangeSet rangeSet, Replacement r) {
        return rangeSet.encloses(r.getReplaceRange());
    }

    public static enum SnippetKind {
        COMPILATION_UNIT,
        CLASS_BODY_DECLARATIONS,
        STATEMENTS,
        EXPRESSION;

    }

    private class SnippetWrapper {
        int offset;
        final StringBuilder contents = new StringBuilder();

        private SnippetWrapper() {
        }

        public SnippetWrapper append(String str) {
            this.contents.append(str);
            return this;
        }

        public SnippetWrapper appendSource(String source) {
            this.offset = this.contents.length();
            this.contents.append(source);
            return this;
        }

        public void closeBraces(int initialIndent) {
            int i = initialIndent;
            while (--i >= 0) {
                this.contents.append("\n").append(SnippetFormatter.this.createIndentationString(i)).append("}");
            }
        }
    }
}

