/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.CredentialContext;

public class SAMLMDCredentialContext
implements CredentialContext {
    @Nullable
    private KeyDescriptor keyDescriptor;
    @Nullable
    private RoleDescriptor role;
    @Nullable
    private List<EncryptionMethod> encMethods;

    public SAMLMDCredentialContext(KeyDescriptor descriptor) {
        this.keyDescriptor = descriptor;
        if (descriptor != null) {
            this.encMethods = CollectionSupport.copyToList(descriptor.getEncryptionMethods());
            this.role = (RoleDescriptor)descriptor.getParent();
        }
    }

    @Nullable
    public KeyDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<EncryptionMethod> getEncryptionMethods() {
        return this.encMethods;
    }

    @Nullable
    public RoleDescriptor getRoleDescriptor() {
        return this.role;
    }
}

