/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;

public abstract class AbstractDecryptAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDecryptAction.class);
    private boolean errorFatal = true;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParamsLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose(new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, Object> messageLookupStrategy = new MessageLookup<Object>(Object.class).compose(new InboundMessageContextLookup());
    @Nonnull
    private Predicate<Pair<ProfileRequestContext, EncryptedElementType>> decryptionPredicate = PredicateSupport.alwaysTrue();
    @Nullable
    private Decrypter decrypter;
    @NonnullBeforeExec
    private SAMLObject message;

    public boolean isErrorFatal() {
        return this.errorFatal;
    }

    public void setErrorFatal(boolean flag) {
        this.checkSetterPreconditions();
        this.errorFatal = flag;
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParamsLookupStrategy = Constraint.isNotNull(strategy, "SecurityParametersContext lookup strategy cannot be null");
    }

    public void setMessageLookupStrategy(@Nonnull Function<ProfileRequestContext, Object> strategy) {
        this.checkSetterPreconditions();
        this.messageLookupStrategy = Constraint.isNotNull(strategy, "Message lookup strategy cannot be null");
    }

    @Nonnull
    public Predicate<Pair<ProfileRequestContext, EncryptedElementType>> getDecryptionPredicate() {
        return this.decryptionPredicate;
    }

    public void setDecryptionPredicate(@Nonnull Predicate<Pair<ProfileRequestContext, EncryptedElementType>> predicate) {
        this.checkSetterPreconditions();
        this.decryptionPredicate = Constraint.isNotNull(predicate, "Decryption predicate cannot be null");
    }

    @Nullable
    public Decrypter getDecrypter() {
        return this.decrypter;
    }

    @NonnullBeforeExec
    public SAMLObject getSAMLObject() {
        return this.message;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        DecryptionParameters params;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Object theMessage = this.messageLookupStrategy.apply(profileRequestContext);
        if (theMessage == null) {
            this.log.debug("{} No message was returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        if (!(theMessage instanceof SAMLObject)) {
            this.log.debug("{} Message was not a SAML construct, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.message = (SAMLObject)theMessage;
        SecurityParametersContext paramsCtx = this.securityParamsLookupStrategy.apply(profileRequestContext);
        DecryptionParameters decryptionParameters = params = paramsCtx != null ? paramsCtx.getDecryptionParameters() : null;
        if (params == null) {
            this.log.debug("{} No security parameter context or decryption parameters", (Object)this.getLogPrefix());
        } else {
            this.decrypter = new Decrypter(params);
        }
        return true;
    }
}

