/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.slf4j.Logger;

public class InResponseToSecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(InResponseToSecurityHandler.class);

    @Override
    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String outboundRequestID = StringSupport.trimOrNull(this.resolveOutboundRequestID(messageContext));
        this.log.debug("Resolved outbound request ID: {}", (Object)outboundRequestID);
        String inboundInResponseTo = StringSupport.trimOrNull(this.resolveInboundInResponseTo(messageContext));
        this.log.debug("Resolved inbound inResponseTo: {}", (Object)inboundInResponseTo);
        if (!Objects.equals(outboundRequestID, inboundInResponseTo)) {
            this.log.warn("Inbound inResponseTo '{}' did not match outbound request ID '{}'", (Object)inboundInResponseTo, (Object)outboundRequestID);
            throw new MessageHandlerException("Inbound inResponseTo did not match outbound request ID");
        }
    }

    @Nullable
    private String resolveOutboundRequestID(@Nonnull MessageContext messageContext) {
        Object object;
        InOutOperationContext inout;
        MessageContext outboundContext;
        BaseContext baseContext = messageContext.getParent();
        if (baseContext instanceof InOutOperationContext && (outboundContext = (inout = (InOutOperationContext)baseContext).getOutboundMessageContext()) != null && (object = outboundContext.getMessage()) instanceof SAMLObject) {
            SAMLObject outboundMessage = (SAMLObject)object;
            if (outboundMessage instanceof org.opensaml.saml.saml2.core.RequestAbstractType) {
                org.opensaml.saml.saml2.core.RequestAbstractType req = (org.opensaml.saml.saml2.core.RequestAbstractType)outboundMessage;
                return req.getID();
            }
            if (outboundMessage instanceof RequestAbstractType) {
                RequestAbstractType req = (RequestAbstractType)outboundMessage;
                return req.getID();
            }
        }
        return null;
    }

    @Nullable
    private String resolveInboundInResponseTo(@Nonnull MessageContext messageContext) {
        Object object;
        InOutOperationContext inout;
        MessageContext inboundContext;
        BaseContext baseContext = messageContext.getParent();
        if (baseContext instanceof InOutOperationContext && (inboundContext = (inout = (InOutOperationContext)baseContext).getInboundMessageContext()) != null && (object = inboundContext.getMessage()) instanceof SAMLObject) {
            SAMLObject inboundMessage = (SAMLObject)object;
            if (inboundMessage instanceof StatusResponseType) {
                StatusResponseType resp = (StatusResponseType)inboundMessage;
                return resp.getInResponseTo();
            }
            if (inboundMessage instanceof ResponseAbstractType) {
                ResponseAbstractType resp = (ResponseAbstractType)inboundMessage;
                return resp.getInResponseTo();
            }
        }
        return null;
    }
}

