/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.DataExpiredException;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.DataSealerKeyStrategy;
import net.shibboleth.shared.security.KeyNotFoundException;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;

public class DataSealer
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String MAGIC_STRING = "PXR5";
    private static final int PREFIX_LEN = 10;
    private static final int CHUNK_SIZE = 60000;
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DataSealer.class);
    private boolean lockedAtStartup;
    @NonnullAfterInit
    private DataSealerKeyStrategy keyStrategy;
    @NonnullAfterInit
    private SecureRandom random;
    @Nonnull
    private BinaryEncoder encoder = new Base64(0, new byte[]{10});
    @Nonnull
    private BinaryDecoder decoder = (Base64)this.encoder;
    @Nullable
    private String nodePrefix;

    public void setLockedAtStartup(boolean flag) {
        this.checkSetterPreconditions();
        this.lockedAtStartup = flag;
    }

    public void setKeyStrategy(@Nonnull DataSealerKeyStrategy strategy) {
        this.checkSetterPreconditions();
        this.keyStrategy = Constraint.isNotNull(strategy, "DataSealerKeyStrategy cannot be null");
    }

    public void setRandom(@Nonnull SecureRandom r) {
        this.checkSetterPreconditions();
        this.random = Constraint.isNotNull(r, "SecureRandom cannot be null");
    }

    public void setEncoder(@Nonnull BinaryEncoder e) {
        this.checkSetterPreconditions();
        this.encoder = Constraint.isNotNull(e, "Encoder cannot be null");
    }

    public void setDecoder(@Nonnull BinaryDecoder d) {
        this.checkSetterPreconditions();
        this.decoder = Constraint.isNotNull(d, "Decoder cannot be null");
    }

    public void setNodePrefix(@Nullable @NotEmpty String prefix) {
        this.checkSetterPreconditions();
        String s = StringSupport.trimOrNull(prefix);
        if (s != null) {
            if (s.length() > 10) {
                throw new ConstraintViolationException("DataSealer nodePrefix cannot be longer than " + Integer.toString(10) + " characters");
            }
            if (s.length() < 10) {
                s = s.concat(new String("X").repeat(10 - s.length()));
            }
        }
        this.nodePrefix = s;
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        try {
            try {
                Constraint.isNotNull(this.keyStrategy, "DataSealerKeyStrategy cannot be null");
            }
            catch (ConstraintViolationException e) {
                throw new ComponentInitializationException(e);
            }
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            if (!this.lockedAtStartup) {
                this.testEncryption(this.keyStrategy.getDefaultKeyRecord().key());
            }
            if (this.nodePrefix != null) {
                this.log.info("DataSealer will attach prefix of {} + {} to wrapped values", (Object)MAGIC_STRING, (Object)this.nodePrefix);
            }
        }
        catch (KeyException e) {
            this.log.error(e.getMessage());
            throw new ComponentInitializationException("Exception loading the keystore", e);
        }
        catch (DataSealerException e) {
            this.log.error(e.getMessage());
            throw new ComponentInitializationException("Exception testing the encryption settings used", e);
        }
    }

    @Nonnull
    public String unwrap(@Nonnull @NotEmpty String wrapped) throws DataSealerException {
        return this.unwrap(wrapped, null);
    }

    @Nonnull
    public String unwrap(@Nonnull @NotEmpty String wrapped, @Nullable StringBuffer keyUsed) throws DataSealerException {
        String string;
        byte[] in;
        this.checkComponentActive();
        int magicLen = MAGIC_STRING.length();
        if (wrapped.startsWith(MAGIC_STRING)) {
            if (this.nodePrefix == null) {
                this.log.warn("Data was prefixed but no node prefix is configured");
            } else if (!wrapped.regionMatches(magicLen, this.nodePrefix, 0, 10)) {
                this.log.warn("Data was prefixed with {} but configured prefix is {}", (Object)wrapped.substring(magicLen, magicLen + 10), (Object)this.nodePrefix);
            }
            in = this.decoder.decode(wrapped.substring(magicLen + 10).getBytes(StandardCharsets.UTF_8));
        } else {
            in = this.decoder.decode(wrapped.getBytes(StandardCharsets.UTF_8));
        }
        DataInputStream inputDataStream = new DataInputStream(new ByteArrayInputStream(in));
        try {
            String keyAlias = inputDataStream.readUTF();
            this.log.trace("Data was encrypted by key named '{}'", (Object)keyAlias);
            if (keyUsed != null) {
                keyUsed.append(keyAlias);
            }
            assert (keyAlias != null);
            SecretKey key = this.keyStrategy.getKey(keyAlias);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            int ivSize = cipher.getBlockSize();
            byte[] iv = new byte[ivSize];
            inputDataStream.readFully(iv);
            GCMParameterSpec params = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)key, params);
            cipher.updateAAD(keyAlias.getBytes());
            byte[] data = new byte[in.length - ivSize];
            int dataSize = inputDataStream.read(data);
            byte[] plaintext = new byte[cipher.getOutputSize(dataSize)];
            int outputLen = cipher.doFinal(data, 0, dataSize, plaintext);
            string = this.extractAndCheckDecryptedData(plaintext, 0, outputLen);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputDataStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KeyNotFoundException e) {
                if (keyUsed != null) {
                    this.log.info("Data was wrapped with a key ({}) no longer available", (Object)keyUsed.toString());
                } else {
                    this.log.info("Data was wrapped with a key no longer available");
                }
                throw new DataExpiredException("Data wrapped with expired key");
            }
            catch (KeyException e) {
                this.log.error(e.getMessage());
                throw new DataSealerException("Exception loading key", e);
            }
            catch (IOException | IllegalArgumentException | GeneralSecurityException | DecoderException e) {
                this.log.error("Exception unwrapping data: {}", e.getMessage() != null ? e.getMessage() : e.getClass());
                throw new DataSealerException("Exception unwrapping data", (Exception)e);
            }
        }
        inputDataStream.close();
        return string;
    }

    @Nonnull
    private String extractAndCheckDecryptedData(@Nonnull @NotEmpty byte[] decryptedBytes, int decryptedOffset, int decryptedLen) throws DataSealerException {
        DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(decryptedBytes, decryptedOffset, decryptedLen)));
        try {
            long decodedExpirationTime = dataInputStream.readLong();
            if (decodedExpirationTime > 0L && System.currentTimeMillis() > decodedExpirationTime) {
                this.log.debug("Unwrapped data has expired");
                throw new DataExpiredException("Unwrapped data has expired");
            }
            StringBuffer accumulator = new StringBuffer();
            int count = 0;
            try {
                while (true) {
                    String decodedData = dataInputStream.readUTF();
                    accumulator.append(decodedData);
                    this.log.trace("Read chunk #{} from output stream", (Object)(++count));
                }
            }
            catch (EOFException e) {
                this.log.trace("Unwrapped data verified");
                String result = accumulator.toString();
                assert (result != null);
                String string = result;
                dataInputStream.close();
                return string;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.log.error(e.getMessage());
                throw new DataSealerException("Caught IOException unwrapping data", e);
            }
        }
    }

    @Nonnull
    public String wrap(@Nonnull @NotEmpty String data) throws DataSealerException {
        return this.wrap(data, null);
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public String wrap(@Nonnull @NotEmpty String data, @Nullable Instant exp) throws DataSealerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void testEncryption(@Nullable SecretKey key) throws DataSealerException {
        String decrypted;
        if (key == null) {
            throw new DataSealerException("Secret key was null");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[cipher.getBlockSize()];
            this.random.nextBytes(iv);
            GCMParameterSpec params = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)key, params);
            cipher.updateAAD("aad".getBytes(StandardCharsets.UTF_8));
            byte[] plaintext = "test".getBytes(StandardCharsets.UTF_8);
            byte[] encryptedData = new byte[cipher.getOutputSize(plaintext.length)];
            int outputLen = cipher.doFinal(plaintext, 0, plaintext.length, encryptedData);
            cipher.init(2, (Key)key, params);
            cipher.updateAAD("aad".getBytes(StandardCharsets.UTF_8));
            plaintext = new byte[cipher.getOutputSize(encryptedData.length)];
            outputLen = cipher.doFinal(encryptedData, 0, encryptedData.length, plaintext);
            decrypted = new String(plaintext, 0, outputLen, StandardCharsets.UTF_8);
        }
        catch (IllegalStateException | GeneralSecurityException e) {
            this.log.error("Round trip encryption/decryption test unsuccessful: {}", (Object)e.getMessage());
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful", e);
        }
        if (decrypted == null || !"test".equals(decrypted)) {
            this.log.error("Round trip encryption/decryption test unsuccessful. Decrypted text did not match");
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful");
        }
    }
}

