/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.scripting;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedRunnable
extends AbstractIdentifiableInitializableComponent
implements Runnable,
UnmodifiableComponent {
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private RunnableScriptEvaluator scriptEvaluator;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedRunnable.class);
    @Nullable
    private Object customObject;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException("No script has been provided");
        }
        assert (this.script != null);
        this.scriptEvaluator = new RunnableScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        StringBuilder builder = new StringBuilder("ScriptedRunnable '").append(this.getId()).append("':");
        this.scriptEvaluator.setLogPrefix(builder.toString());
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript matcherScript) {
        this.checkSetterPreconditions();
        this.script = Constraint.isNotNull(matcherScript, "Attribute value matching script cannot be null");
    }

    @Override
    public void run() {
        this.checkComponentActive();
        this.scriptEvaluator.execute();
    }

    private class RunnableScriptEvaluator
    extends AbstractScriptEvaluator {
        public RunnableScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Override
        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        }

        public void execute() {
            ScriptedRunnable.this.log.debug("{}: running script", (Object)this.getLogPrefix());
            this.evaluate(null);
        }
    }
}

