/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.OpenSearchRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityResponse;

public class OpenSearchRequestChannel
extends OpenSearchRequest
implements SecurityRequestChannel {
    private final AtomicReference<SecurityResponse> responseRef = new AtomicReference<Object>(null);
    private final RestChannel underlyingChannel;

    OpenSearchRequestChannel(RestRequest request, RestChannel channel) {
        super(request);
        this.underlyingChannel = channel;
    }

    public RestChannel breakEncapsulationForChannel() {
        return this.underlyingChannel;
    }

    @Override
    public void queueForSending(SecurityResponse response) {
        if (this.underlyingChannel == null) {
            throw new UnsupportedOperationException("Channel was not defined");
        }
        if (this.getQueuedResponse().isPresent()) {
            throw new UnsupportedOperationException("Another response was already queued");
        }
        this.responseRef.set(response);
    }

    @Override
    public Optional<SecurityResponse> getQueuedResponse() {
        return Optional.ofNullable(this.responseRef.get());
    }
}

