/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.jwt.keybyoidc;

import java.nio.file.Path;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.http.jwt.AbstractHTTPJwtAuthenticator;
import org.opensearch.security.auth.http.jwt.keybyoidc.KeyProvider;
import org.opensearch.security.auth.http.jwt.keybyoidc.KeySetRetriever;
import org.opensearch.security.auth.http.jwt.keybyoidc.SelfRefreshingKeySet;
import org.opensearch.security.util.SettingsBasedSSLConfigurator;

public class HTTPJwtKeyByOpenIdConnectAuthenticator
extends AbstractHTTPJwtAuthenticator {
    public HTTPJwtKeyByOpenIdConnectAuthenticator(Settings settings, Path configPath) {
        super(settings, configPath);
    }

    @Override
    protected KeyProvider initKeyProvider(Settings settings, Path configPath) throws Exception {
        int idpRequestTimeoutMs = settings.getAsInt("idp_request_timeout_ms", Integer.valueOf(5000));
        int idpQueuedThreadTimeoutMs = settings.getAsInt("idp_queued_thread_timeout_ms", Integer.valueOf(2500));
        int refreshRateLimitTimeWindowMs = settings.getAsInt("refresh_rate_limit_time_window_ms", Integer.valueOf(10000));
        int refreshRateLimitCount = settings.getAsInt("refresh_rate_limit_count", Integer.valueOf(10));
        String jwksUri = settings.get("jwks_uri");
        KeySetRetriever keySetRetriever = jwksUri != null && !jwksUri.isBlank() ? new KeySetRetriever(HTTPJwtKeyByOpenIdConnectAuthenticator.getSSLConfig(settings, configPath), settings.getAsBoolean("cache_jwks_endpoint", Boolean.valueOf(false)), jwksUri) : new KeySetRetriever(settings.get("openid_connect_url"), HTTPJwtKeyByOpenIdConnectAuthenticator.getSSLConfig(settings, configPath), settings.getAsBoolean("cache_jwks_endpoint", Boolean.valueOf(false)));
        keySetRetriever.setRequestTimeoutMs(idpRequestTimeoutMs);
        SelfRefreshingKeySet selfRefreshingKeySet = new SelfRefreshingKeySet(keySetRetriever);
        selfRefreshingKeySet.setRequestTimeoutMs(idpRequestTimeoutMs);
        selfRefreshingKeySet.setQueuedThreadTimeoutMs(idpQueuedThreadTimeoutMs);
        selfRefreshingKeySet.setRefreshRateLimitTimeWindowMs(refreshRateLimitTimeWindowMs);
        selfRefreshingKeySet.setRefreshRateLimitCount(refreshRateLimitCount);
        return selfRefreshingKeySet;
    }

    private static SettingsBasedSSLConfigurator.SSLConfig getSSLConfig(Settings settings, Path configPath) throws Exception {
        return new SettingsBasedSSLConfigurator(settings, configPath, "openid_connect_idp").buildSSLConfig();
    }

    @Override
    public String getType() {
        return "jwt-key-by-oidc";
    }
}

