/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.BadParametersException;
import com.password4j.PropertyReader;
import java.security.SecureRandom;

public class SaltGenerator {
    private SaltGenerator() {
    }

    public static byte[] generate(int length) {
        if (length < 0) {
            throw new BadParametersException("Salt length cannot be negative");
        }
        byte[] salt = new byte[length];
        SecureRandom sr = AlgorithmFinder.getSecureRandom();
        sr.nextBytes(salt);
        return salt;
    }

    public static byte[] generate() {
        return SaltGenerator.generate(SaltGenerator.get());
    }

    public static int get() {
        return PropertyReader.readInt("global.salt.length", 64, "Global salt length is not defined in properties file");
    }
}

