/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.jaas;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.ldaptive.LdapUtils;

public class LdapGroup
implements Group,
Serializable {
    private static final int HASH_CODE_SEED = 431;
    private static final long serialVersionUID = 2075424472884533862L;
    private final String roleName;
    private final Set<Principal> members = new HashSet<Principal>();

    public LdapGroup(String name) {
        this.roleName = name;
    }

    public String getName() {
        return this.roleName;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public boolean isMember(Principal member) {
        for (Principal p : this.members) {
            if (p.getName() == null || !p.getName().equals(member.getName())) continue;
            return true;
        }
        return false;
    }

    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    public Set<Principal> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LdapGroup) {
            LdapGroup v = (LdapGroup)o;
            return LdapUtils.areEqual(this.roleName, v.roleName) && LdapUtils.areEqual(this.members, v.members);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(431, this.roleName, this.members);
    }

    public String toString() {
        return String.format("[%s@%d::%s%s]", this.getClass().getName(), this.hashCode(), this.roleName, this.members);
    }
}

